/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class RemoveGlobalDUnitTest
extends DistributedTestCase {
    static Cache cache;
    static Properties props;
    static Properties propsWork;
    static DistributedSystem ds;
    static Region region;
    static boolean lockedForRemove;
    static VM vm0;
    static VM vm1;

    public RemoveGlobalDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        vm0 = host.getVM(0);
        vm1 = host.getVM(1);
        vm0.invoke(RemoveGlobalDUnitTest.class, "createCache");
        vm1.invoke(RemoveGlobalDUnitTest.class, "createCache");
    }

    @Override
    public void tearDown2() {
        vm0.invoke(RemoveGlobalDUnitTest.class, "resetFlag");
        vm1.invoke(RemoveGlobalDUnitTest.class, "resetFlag");
        vm0.invoke(RemoveGlobalDUnitTest.class, "closeCache");
        vm1.invoke(RemoveGlobalDUnitTest.class, "closeCache");
    }

    public static void resetFlag() {
        lockedForRemove = false;
    }

    public static void createCache() {
        try {
            ds = new RemoveGlobalDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            cache.close();
            ds.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testRemoveGlobalSingleVM() throws Throwable {
        CacheSerializableRunnable createRegionWithWriter = new CacheSerializableRunnable("create region with cache writer"){

            @Override
            public void run2() throws CacheException {
                cache.setLockTimeout(5);
                CacheWriterCallBack cacheWriter = new CacheWriterCallBack();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.GLOBAL);
                factory.setCacheWriter((CacheWriter)cacheWriter);
                region = cache.createRegion("map", factory.create());
            }
        };
        vm0.invoke(createRegionWithWriter);
        AsyncInvocation async = vm0.invokeAsync(new CacheSerializableRunnable("put object"){

            @Override
            public void run2() throws CacheException {
                for (int i = 1; i < 5; ++i) {
                    region.put((Object)new Integer(i), (Object)Integer.toString(i));
                }
                region.remove((Object)new Integer(2));
            }
        });
        vm0.invoke(new CacheSerializableRunnable("verify locking"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Class<RemoveGlobalDUnitTest> clazz = RemoveGlobalDUnitTest.class;
                synchronized (RemoveGlobalDUnitTest.class) {
                    if (!lockedForRemove) {
                        try {
                            RemoveGlobalDUnitTest.class.wait();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    try {
                        region.put((Object)new Integer(2), (Object)"newEntry");
                        TestCase.fail((String)"Should have thrown TimeoutException");
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    return;
                }
            }
        });
        DistributedTestCase.join(async, 30000L, RemoveGlobalDUnitTest.getLogWriter());
        if (async.exceptionOccurred()) {
            throw async.getException();
        }
    }

    public void testRemoveGlobalMultiVM() throws Throwable {
        CacheSerializableRunnable createSimpleRegion = new CacheSerializableRunnable("create region with cache writer"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.GLOBAL);
                region = cache.createRegion("map", factory.create());
            }
        };
        CacheSerializableRunnable createRegionWithWriter = new CacheSerializableRunnable("create region with capacity controller"){

            @Override
            public void run2() throws CacheException {
                CacheWriterCallBack cw = new CacheWriterCallBack();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.GLOBAL);
                factory.setCacheWriter((CacheWriter)cw);
                region = cache.createRegion("map", factory.create());
            }
        };
        vm0.invoke(createSimpleRegion);
        vm1.invoke(createRegionWithWriter);
        vm0.invoke(new CacheSerializableRunnable("put object"){

            @Override
            public void run2() throws CacheException {
                for (int i = 1; i < 5; ++i) {
                    region.put((Object)new Integer(i), (Object)Integer.toString(i));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("get object"){

            @Override
            public void run2() throws CacheException {
                for (int i = 1; i < 5; ++i) {
                    region.get((Object)new Integer(i));
                }
            }
        });
        AsyncInvocation async = vm0.invokeAsync(new CacheSerializableRunnable("remove object"){

            @Override
            public void run2() throws CacheException {
                region.remove((Object)new Integer(2));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("verify locking"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                cache.setLockTimeout(5);
                Class<RemoveGlobalDUnitTest> clazz = RemoveGlobalDUnitTest.class;
                synchronized (RemoveGlobalDUnitTest.class) {
                    if (!lockedForRemove) {
                        try {
                            RemoveGlobalDUnitTest.class.wait();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    try {
                        region.put((Object)new Integer(2), (Object)"newEntry");
                        TestCase.fail((String)"Should have thrown TimeoutException");
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    return;
                }
            }
        });
        DistributedTestCase.join(async, 30000L, RemoveGlobalDUnitTest.getLogWriter());
        if (async.exceptionOccurred()) {
            throw async.getException();
        }
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
        lockedForRemove = false;
        vm0 = null;
        vm1 = null;
    }

    static class CacheWriterCallBack
    extends CacheWriterAdapter {
        CacheWriterCallBack() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDestroy(EntryEvent event) {
            Class<RemoveGlobalDUnitTest> clazz = RemoveGlobalDUnitTest.class;
            synchronized (RemoveGlobalDUnitTest.class) {
                lockedForRemove = true;
                RemoveGlobalDUnitTest.class.notify();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException ex) {
                    TestCase.fail((String)"interrupted");
                }
                DistributedTestCase.getLogWriter().fine("quitingfromcachewriter");
                return;
            }
        }
    }
}

