/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;

public class PutAllGlobalDUnitTest
extends DistributedTestCase {
    static final int TIMEOUT_PERIOD = 1000;
    private static ServerSocket serverSocket;
    static Cache cache;
    static Properties props;
    static Properties propsWork;
    static DistributedSystem ds;
    static Region region;
    static CacheTransactionManager cacheTxnMgr;
    static int beforeCreateputAllcounter;
    static boolean flag;

    public PutAllGlobalDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(PutAllGlobalDUnitTest.class, "createCacheForVM0");
        vm1.invoke(PutAllGlobalDUnitTest.class, "createCacheForVM1");
        PutAllGlobalDUnitTest.getLogWriter().fine("Cache created successfully");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(PutAllGlobalDUnitTest.class, "closeCache");
        vm1.invoke(PutAllGlobalDUnitTest.class, "closeCache");
        cache = null;
        PutAllGlobalDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public static void createCacheForVM0() {
        try {
            ds = new PutAllGlobalDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.GLOBAL);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createCacheForVM1() {
        try {
            BeforeCreateCallback aWriter = new BeforeCreateCallback();
            ds = new PutAllGlobalDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            cache.setLockTimeout(1);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.GLOBAL);
            factory.setCacheWriter((CacheWriter)aWriter);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            cache.close();
            ds.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int openSocket() throws IOException {
        serverSocket = new ServerSocket(0, 10, InetAddress.getLocalHost());
        return serverSocket.getLocalPort();
    }

    public void testputAllGlobalRemoteVM() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final int socketPort = vm0.invokeInt(this.getClass(), "openSocket");
        AsyncInvocation async1 = vm0.invokeAsync(this.getClass(), "putAllMethod");
        AsyncInvocation async2 = vm1.invokeAsync(new CacheSerializableRunnable("put from another vm"){

            @Override
            public void run2() throws CacheException {
                long endTime = System.currentTimeMillis() + 5000L;
                boolean connected = false;
                while (!connected && System.currentTimeMillis() < endTime) {
                    try {
                        Socket sock = new Socket(InetAddress.getLocalHost(), socketPort);
                        connected = true;
                        sock.close();
                    }
                    catch (IOException ioe) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ie) {
                            TestCase.fail((String)"Interrupted while waiting for async1 invocation");
                        }
                    }
                }
                if (!connected) {
                    TestCase.fail((String)"unable to connect to async1 invocation");
                }
                long startTime = 0L;
                try {
                    Thread.sleep(500L);
                    DistributedTestCase.getLogWriter().info("async2 proceeding with put operation");
                    startTime = System.currentTimeMillis();
                    region.put((Object)new Integer(1), (Object)"mapVal");
                    DistributedTestCase.getLogWriter().info("async2 done with put operation");
                    TestCase.fail((String)"Should have thrown TimeoutException");
                }
                catch (TimeoutException Tx) {
                    DistributedTestCase.getLogWriter().info("PASS: As expected Caught TimeoutException ");
                    if (startTime + 1000L + 60000L < System.currentTimeMillis()) {
                        DistributedTestCase.getLogWriter().warning("though this test passed, the put() timed out in " + (System.currentTimeMillis() - startTime) + " instead of the expected " + 1000 + " milliseconds");
                    }
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("async2 threw unexpected exception", ex);
                }
            }
        });
        DistributedTestCase.join(async2, 30000L, PutAllGlobalDUnitTest.getLogWriter());
        if (async2.exceptionOccurred()) {
            DistributedTestCase.join(async1, 30000L, PutAllGlobalDUnitTest.getLogWriter());
            PutAllGlobalDUnitTest.fail("async2 failed", async2.getException());
        }
        DistributedTestCase.join(async1, 30000L, PutAllGlobalDUnitTest.getLogWriter());
        if (async1.exceptionOccurred()) {
            PutAllGlobalDUnitTest.fail("async1 failed", async1.getException());
        }
    }

    public static void putAllMethod() throws Exception {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        serverSocket.accept();
        PutAllGlobalDUnitTest.getLogWriter().info("async1 connection received - continuing with putAll operation");
        serverSocket.close();
        try {
            for (int i = 1; i < 2; ++i) {
                m.put(new Integer(i), String.valueOf(i));
            }
            region.putAll(m);
            PutAllGlobalDUnitTest.getLogWriter().info("async1 done with putAll operation");
        }
        catch (Exception ex) {
            PutAllGlobalDUnitTest.fail("Failed while region.putAll", ex);
        }
    }

    public static Object getMethod(Object ob) {
        Object obj = null;
        try {
            obj = region.get(ob);
        }
        catch (Exception ex) {
            PutAllGlobalDUnitTest.fail((String)"Failed while region.get");
        }
        return obj;
    }

    public static boolean containsValueMethod(Object ob) {
        boolean result = false;
        try {
            result = region.containsValue(ob);
        }
        catch (Exception ex) {
            PutAllGlobalDUnitTest.fail((String)"Failed while region.containsValueMethod");
        }
        return result;
    }

    public static int sizeMethod() {
        int i = 0;
        try {
            i = region.size();
        }
        catch (Exception ex) {
            PutAllGlobalDUnitTest.fail((String)"Failed while region.size");
        }
        return i;
    }

    public static void clearMethod() {
        try {
            region.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
        beforeCreateputAllcounter = 0;
        flag = false;
    }

    static class BeforeCreateCallback
    extends CacheWriterAdapter {
        BeforeCreateCallback() {
        }

        public void beforeCreate(EntryEvent event) {
            DistributedTestCase.getLogWriter().info("beforeCreate invoked for " + event.getKey());
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                TestCase.fail((String)"interrupted");
            }
            DistributedTestCase.getLogWriter().info("beforeCreate done for " + event.getKey());
        }
    }
}

