/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import junit.framework.TestCase;

public class PartitionedRegionInvalidateDUnitTest
extends CacheTestCase {
    public PartitionedRegionInvalidateDUnitTest(String name) {
        super(name);
    }

    void createRegion(String name, boolean accessor, int redundantCopies, CacheWriter<?, ?> cw) {
        AttributesFactory af = new AttributesFactory();
        af.setPartitionAttributes(new PartitionAttributesFactory().setLocalMaxMemory(accessor ? 0 : 12).setRedundantCopies(redundantCopies).create());
        af.setCacheWriter(cw);
        this.getCache().createRegion(name, af.create());
    }

    public void testSingleVMInvalidate() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        final String rName = this.getUniqueName();
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegionInvalidateDUnitTest.this.createRegion(rName, false, 0, null);
                Region r = PartitionedRegionInvalidateDUnitTest.this.getCache().getRegion(rName);
                InvalidatePRListener l = new InvalidatePRListener();
                r.getAttributesMutator().addCacheListener((CacheListener)l);
                for (int i = 0; i <= 113; ++i) {
                    r.put((Object)i, (Object)("value" + i));
                }
                PartitionedRegion pr = (PartitionedRegion)r;
                TestCase.assertTrue((pr.getDataStore().getAllLocalBuckets().size() == 113 ? 1 : 0) != 0);
                for (Object v : pr.values()) {
                    TestCase.assertNotNull(v);
                }
                r.invalidateRegion();
                TestCase.assertTrue((boolean)l.afterRegionInvalidateCalled);
                l.afterRegionInvalidateCalled = false;
                for (int i = 0; i <= 113; ++i) {
                    r.put((Object)i, (Object)("value" + i));
                }
                String callbackArg = "CallBACK";
                l.callbackArg = callbackArg;
                r.invalidateRegion((Object)callbackArg);
                TestCase.assertTrue((boolean)l.afterRegionInvalidateCalled);
                l.afterRegionInvalidateCalled = false;
                return null;
            }
        });
    }

    public void testMultiVMInvalidate() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final String rName = this.getUniqueName();
        class CreateRegion
        extends SerializableCallable {
            boolean originRemote;

            public CreateRegion(boolean originRemote) {
                this.originRemote = originRemote;
            }

            public Object call() throws Exception {
                PartitionedRegionInvalidateDUnitTest.this.createRegion(rName, false, 1, (CacheWriter<?, ?>)new InvalidatePRWriter());
                Region r = PartitionedRegionInvalidateDUnitTest.this.getCache().getRegion(rName);
                InvalidatePRListener l = new InvalidatePRListener();
                l.originRemote = this.originRemote;
                r.getAttributesMutator().addCacheListener((CacheListener)l);
                return null;
            }
        }
        vm0.invoke(new CreateRegion(true));
        vm1.invoke(new CreateRegion(false));
        vm2.invoke(new CreateRegion(true));
        vm3.invoke(new CreateRegion(true));
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                int i;
                Region r = PartitionedRegionInvalidateDUnitTest.this.getCache().getRegion(rName);
                for (i = 0; i <= 113; ++i) {
                    r.put((Object)i, (Object)("value" + i));
                }
                for (i = 0; i <= 113; ++i) {
                    TestCase.assertNotNull((Object)r.get((Object)i));
                }
                r.invalidateRegion();
                return null;
            }
        });
        SerializableCallable validateCallbacks = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PartitionedRegionInvalidateDUnitTest.this.getCache().getRegion(rName);
                InvalidatePRListener l = (InvalidatePRListener)r.getAttributes().getCacheListeners()[0];
                TestCase.assertTrue((boolean)l.afterRegionInvalidateCalled);
                l.afterRegionInvalidateCalled = false;
                l.callbackArg = "CallBACK";
                return null;
            }
        };
        vm0.invoke(validateCallbacks);
        vm1.invoke(validateCallbacks);
        vm2.invoke(validateCallbacks);
        vm3.invoke(validateCallbacks);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PartitionedRegionInvalidateDUnitTest.this.getCache().getRegion(rName);
                InvalidatePRListener l = (InvalidatePRListener)r.getAttributes().getCacheListeners()[0];
                for (int i = 0; i <= 113; ++i) {
                    r.put((Object)i, (Object)("value" + i));
                }
                String callbackArg = "CallBACK";
                l.callbackArg = callbackArg;
                r.invalidateRegion((Object)callbackArg);
                return null;
            }
        });
        vm0.invoke(validateCallbacks);
        vm1.invoke(validateCallbacks);
        vm2.invoke(validateCallbacks);
        vm3.invoke(validateCallbacks);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = PartitionedRegionInvalidateDUnitTest.this.getCache().getRegion(rName);
                for (int i = 0; i <= 113; ++i) {
                    TestCase.assertNull((String)("Expected null but was " + r.get((Object)i)), (Object)r.get((Object)i));
                }
                return null;
            }
        });
    }

    class InvalidatePRWriter
    extends CacheWriterAdapter {
        InvalidatePRWriter() {
        }

        public void beforeRegionDestroy(RegionEvent event) throws CacheWriterException {
            TestCase.fail((String)"writer should not have been called");
        }

        public void beforeRegionClear(RegionEvent event) throws CacheWriterException {
            TestCase.fail((String)"writer should not have been called");
        }
    }

    class InvalidatePRListener
    extends CacheListenerAdapter {
        Object callbackArg;
        boolean originRemote;
        boolean afterRegionInvalidateCalled;

        InvalidatePRListener() {
        }

        public void afterInvalidate(EntryEvent event) {
            TestCase.fail((String)"After invalidate should not be called for individual entry");
        }

        public void afterRegionInvalidate(RegionEvent event) {
            this.afterRegionInvalidateCalled = true;
            TestCase.assertTrue((boolean)event.getOperation().isRegionInvalidate());
            TestCase.assertEquals((boolean)this.originRemote, (boolean)event.isOriginRemote());
            if (this.callbackArg != null) {
                TestCase.assertTrue((boolean)event.isCallbackArgumentAvailable());
                TestCase.assertEquals((Object)this.callbackArg, (Object)event.getCallbackArgument());
            }
        }
    }
}

