/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.CertifiableTestCacheListener;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Node;
import com.gemstone.gemfire.internal.cache.PartitionRegionConfig;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.PartitionedRegionStats;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class PartitionedRegionHAFailureAndRecoveryDUnitTest
extends PartitionedRegionDUnitTestCase {
    VM[] vmArr = new VM[4];
    private static final String WAIT_PROPERTY = "PartitionedRegionHAFailureAndRecoveryDUnitTest.maxWaitTime";
    private static final int WAIT_DEFAULT = 10000;

    public PartitionedRegionHAFailureAndRecoveryDUnitTest(String name) {
        super(name);
    }

    public void testMetaDataCleanupOnSinglePRNodeFail() throws Throwable {
        this.createVMs();
        boolean startIndexForRegion = false;
        int endIndexForRegion = 4;
        int localMaxMemory = 200;
        boolean redundancy = true;
        this.createPartitionRegionAsynch("testMetaDataCleanupOnSinglePRNodeFail_", 0, 4, 200, 1, -1);
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("testMetaDataCleanupOnSinglePRNodeFail() - PartitionedRegion's created at all VM nodes");
        this.addConfigListeners();
        DistributedMember dsMember = (DistributedMember)this.vmArr[0].invoke(this, "disconnectMethod");
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("testMetaDataCleanupOnSinglePRNodeFail() - VM = " + dsMember + " disconnected from the distributed system ");
        this.vmArr[1].invoke(this.validateNodeFailMetaDataCleanUp(dsMember));
        this.vmArr[2].invoke(this.validateNodeFailMetaDataCleanUp(dsMember));
        this.vmArr[3].invoke(this.validateNodeFailMetaDataCleanUp(dsMember));
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("testMetaDataCleanupOnSinglePRNodeFail() - Validation of Failed node config metadata complete");
        this.vmArr[1].invoke(this.validateNodeFailbucket2NodeCleanUp(dsMember));
        this.vmArr[2].invoke(this.validateNodeFailbucket2NodeCleanUp(dsMember));
        this.vmArr[3].invoke(this.validateNodeFailbucket2NodeCleanUp(dsMember));
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("testMetaDataCleanupOnSinglePRNodeFail() - Validation of Failed node bucket2Node Region metadata complete");
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("testMetaDataCleanupOnSinglePRNodeFail() Completed Successfuly ..........");
    }

    private void addConfigListeners() {
        SerializableRunnable addListener = new SerializableRunnable("add PRConfig listener"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() {
                Cache c = PartitionedRegionHAFailureAndRecoveryDUnitTest.this.getCache();
                LocalRegion rootReg = PartitionedRegionHelper.getPRRoot((Cache)c);
                rootReg.getAttributesMutator().addCacheListener((CacheListener)new CertifiableTestCacheListener(DistributedTestCase.getLogWriter()));
            }
        };
        for (int count = 0; count < this.vmArr.length; ++count) {
            VM vm = this.vmArr[count];
            vm.invoke(addListener);
        }
    }

    private void clearConfigListenerState(VM[] vmsToClear) {
        SerializableRunnable clearListener = new SerializableRunnable("clear the listener state"){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() {
                try {
                    Cache c = PartitionedRegionHAFailureAndRecoveryDUnitTest.this.getCache();
                    LocalRegion rootReg = PartitionedRegionHelper.getPRRoot((Cache)c);
                    CacheListener[] cls = rootReg.getAttributes().getCacheListeners();
                    TestCase.assertEquals((int)2, (int)cls.length);
                    CertifiableTestCacheListener ctcl = (CertifiableTestCacheListener)cls[1];
                    ctcl.clearState();
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
            }
        };
        for (int count = 0; count < vmsToClear.length; ++count) {
            VM vm = vmsToClear[count];
            vm.invoke(clearListener);
        }
    }

    public void testMetaDataCleanupOnMultiplePRNodeFail() throws Throwable {
        this.createVMs();
        boolean startIndexForRegion = false;
        int endIndexForRegion = 4;
        int localMaxMemory = 200;
        boolean redundancy = true;
        this.createPartitionRegionAsynch("testMetaDataCleanupOnMultiplePRNodeFail_", 0, 4, 200, 1, -1);
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("testMetaDataCleanupOnMultiplePRNodeFail() - PartitionedRegion's created at all VM nodes");
        this.addConfigListeners();
        DistributedMember dsMember = (DistributedMember)this.vmArr[0].invoke(this, "disconnectMethod");
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("testMetaDataCleanupOnMultiplePRNodeFail() - VM = " + dsMember + " disconnected from the distributed system ");
        this.vmArr[1].invoke(this.validateNodeFailMetaDataCleanUp(dsMember));
        this.vmArr[2].invoke(this.validateNodeFailMetaDataCleanUp(dsMember));
        this.vmArr[3].invoke(this.validateNodeFailMetaDataCleanUp(dsMember));
        this.vmArr[1].invoke(this.validateNodeFailbucket2NodeCleanUp(dsMember));
        this.vmArr[2].invoke(this.validateNodeFailbucket2NodeCleanUp(dsMember));
        this.vmArr[3].invoke(this.validateNodeFailbucket2NodeCleanUp(dsMember));
        VM[] vmsToClear = new VM[]{this.vmArr[1], this.vmArr[2], this.vmArr[3]};
        this.clearConfigListenerState(vmsToClear);
        DistributedMember dsMember2 = (DistributedMember)this.vmArr[1].invoke(this, "disconnectMethod");
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("testMetaDataCleanupOnMultiplePRNodeFail() - VM = " + dsMember2 + " disconnected from the distributed system ");
        this.vmArr[2].invoke(this.validateNodeFailMetaDataCleanUp(dsMember));
        this.vmArr[3].invoke(this.validateNodeFailMetaDataCleanUp(dsMember));
        this.vmArr[2].invoke(this.validateNodeFailMetaDataCleanUp(dsMember2));
        this.vmArr[3].invoke(this.validateNodeFailMetaDataCleanUp(dsMember2));
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("testMetaDataCleanupOnMultiplePRNodeFail() - Validation of Failed nodes config metadata complete");
        this.vmArr[2].invoke(this.validateNodeFailbucket2NodeCleanUp(dsMember2));
        this.vmArr[3].invoke(this.validateNodeFailbucket2NodeCleanUp(dsMember2));
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("testMetaDataCleanupOnMultiplePRNodeFail() - Validation of Failed nodes bucket2Node Region metadata complete");
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("testMetaDataCleanupOnMultiplePRNodeFail() Completed Successfuly ..........");
    }

    public CacheSerializableRunnable validateNodeFailMetaDataCleanUp(final DistributedMember dsMember) {
        CacheSerializableRunnable validator = new CacheSerializableRunnable("validateNodeFailMetaDataCleanUp"){

            @Override
            public void run2() throws CacheException {
                Iterator itrator;
                Cache cache = PartitionedRegionHAFailureAndRecoveryDUnitTest.this.getCache();
                LocalRegion rootReg = PartitionedRegionHelper.getPRRoot((Cache)cache);
                CacheListener[] cls = rootReg.getAttributes().getCacheListeners();
                TestCase.assertEquals((int)2, (int)cls.length);
                CertifiableTestCacheListener ctcl = (CertifiableTestCacheListener)cls[1];
                DistributedTestCase.getLogWriter().info("Listener update (" + ctcl.updates.size() + "): " + ctcl.updates);
                DistributedTestCase.getLogWriter().info("Listener destroy: (" + ctcl.destroys.size() + "): " + ctcl.destroys);
                Iterator itr = itrator = rootReg.keySet().iterator();
                while (itr.hasNext()) {
                    String prName = (String)itr.next();
                    ctcl.waitForUpdated(prName);
                    Object obj = rootReg.get((Object)prName);
                    if (obj == null) continue;
                    PartitionRegionConfig prConf = (PartitionRegionConfig)obj;
                    Set nodeList = prConf.getNodes();
                    Iterator itr2 = nodeList.iterator();
                    while (itr2.hasNext()) {
                        InternalDistributedMember member = ((Node)itr2.next()).getMemberId();
                        if (!member.equals(dsMember)) continue;
                        TestCase.fail((String)("Failed DistributedMember's = " + member + " global meta data not cleared. For PR Region = " + prName));
                    }
                }
            }
        };
        return validator;
    }

    public CacheSerializableRunnable validateNodeFailbucket2NodeCleanUp(final DistributedMember dsMember) {
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("validateNodeFailbucket2NodeCleanUp"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegionHAFailureAndRecoveryDUnitTest.this.getCache();
                PartitionedRegion.PRIdMap prIDmap = PartitionedRegion.prIdToPR;
                for (Object o : prIDmap.values()) {
                    if (o == "Partitioned Region Destroyed") continue;
                    PartitionedRegion prRegion = (PartitionedRegion)o;
                    for (Integer bucketId : prRegion.getRegionAdvisor().getBucketSet()) {
                        Set bucketOwners = prRegion.getRegionAdvisor().getBucketOwners(bucketId.intValue());
                        if (!bucketOwners.contains(dsMember)) continue;
                        TestCase.fail((String)("Failed DistributedMember's = " + dsMember + " bucket [" + prRegion.bucketStringForLogs(bucketId.intValue()) + "] meta-data not cleared for partitioned region " + prRegion));
                    }
                }
            }
        };
        return createPRs;
    }

    private void createVMs() {
        Host host = Host.getHost(0);
        for (int i = 0; i < 4; ++i) {
            this.vmArr[i] = host.getVM(i);
        }
    }

    public DistributedMember disconnectMethod() {
        InternalDistributedMember dsMember = ((InternalDistributedSystem)this.getCache().getDistributedSystem()).getDistributionManager().getId();
        this.getCache().getDistributedSystem().disconnect();
        PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter().info("disconnectMethod() completed ..");
        return dsMember;
    }

    private void createPartitionRegionAsynch(String regionPrefix, int startIndexForRegion, int endIndexForRegion, int localMaxMemory, int redundancy, int recoveryDelay) throws Throwable {
        int count2;
        AsyncInvocation[] async = new AsyncInvocation[this.vmArr.length];
        for (int count = 0; count < this.vmArr.length; ++count) {
            VM vm = this.vmArr[count];
            async[count] = vm.invokeAsync(this.getCreateMultiplePRregion(regionPrefix, endIndexForRegion, redundancy, localMaxMemory, recoveryDelay));
        }
        for (count2 = 0; count2 < async.length; ++count2) {
            DistributedTestCase.join(async[count2], 30000L, PartitionedRegionHAFailureAndRecoveryDUnitTest.getLogWriter());
        }
        for (count2 = 0; count2 < async.length; ++count2) {
            if (!async[count2].exceptionOccurred()) continue;
            PartitionedRegionHAFailureAndRecoveryDUnitTest.fail("exception during " + count2, async[count2].getException());
        }
    }

    public void testRecoveryOfSingleMemberFailure() throws Throwable {
        VM vm;
        int count;
        final String uniqName = this.getUniqueName();
        this.createVMs();
        int redundantCopies = 2;
        boolean numRegions = true;
        this.createPartitionRegionAsynch(uniqName, 0, 1, 20, 2, 0);
        final DistributedMember bucketHost = (DistributedMember)this.vmArr[0].invoke(new SerializableCallable("Populate PR-" + this.getUniqueName()){

            public Object call() throws Exception {
                PartitionedRegion r = (PartitionedRegion)PartitionedRegionHAFailureAndRecoveryDUnitTest.this.getCache().getRegion(uniqName + "0");
                int i = 0;
                int bucketTarget = 2;
                while (r.getRegionAdvisor().getBucketSet().size() < 2) {
                    if (i > r.getTotalNumberOfBuckets()) {
                        TestCase.fail((String)("Expected there to be 2 buckets after " + i + " iterations"));
                    }
                    Integer k = new Integer(i++);
                    r.put((Object)k, (Object)((Object)k).toString());
                }
                Integer bucketId = (Integer)r.getRegionAdvisor().getBucketSet().iterator().next();
                TestCase.assertNotNull((Object)bucketId);
                Set bucketOwners = r.getRegionAdvisor().getBucketOwners(bucketId.intValue());
                TestCase.assertEquals((int)bucketOwners.size(), (int)3);
                DistributedMember bucketOwner = (DistributedMember)bucketOwners.iterator().next();
                TestCase.assertNotNull((Object)bucketOwner);
                DistributedTestCase.getLogWriter().info("Selected distributed member " + bucketOwner + " to disconnect because it hosts bucketId " + bucketId);
                return bucketOwner;
            }
        });
        PartitionedRegionHAFailureAndRecoveryDUnitTest.assertNotNull((Object)bucketHost);
        Map stillHasDS = PartitionedRegionHAFailureAndRecoveryDUnitTest.invokeInEveryVM(new SerializableCallable("Disconnect provided bucketHost"){

            public Object call() throws Exception {
                if (PartitionedRegionHAFailureAndRecoveryDUnitTest.this.getSystem().getDistributedMember().equals((Object)bucketHost)) {
                    DistributedTestCase.getLogWriter().info("Disconnecting distributed member " + PartitionedRegionHAFailureAndRecoveryDUnitTest.this.getSystem().getDistributedMember());
                    CacheTestCase.disconnectFromDS();
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        int MAX_SECONDS_TO_WAIT = 120;
        for (count = 0; count < this.vmArr.length; ++count) {
            vm = this.vmArr[count];
            if (!((Boolean)stillHasDS.get(vm)).booleanValue()) continue;
            vm.invoke(new SerializableRunnable("Wait for PR region recovery"){

                @Override
                public void run() {
                    for (int i = 0; i < 1; ++i) {
                        Region r = PartitionedRegionHAFailureAndRecoveryDUnitTest.this.getCache().getRegion(uniqName + i);
                        TestCase.assertTrue((boolean)(r instanceof PartitionedRegion));
                        PartitionedRegion pr = (PartitionedRegion)r;
                        PartitionedRegionStats prs = pr.getPrStats();
                        long start = NanoTimer.getTime();
                        while (prs.getLowRedundancyBucketCount() != 0) {
                            if (TimeUnit.NANOSECONDS.toSeconds(NanoTimer.getTime() - start) > 120L) {
                                TestCase.fail((String)"Test waited more than 120 seconds for redundancy recover");
                            }
                            try {
                                TimeUnit.MILLISECONDS.sleep(250L);
                            }
                            catch (InterruptedException e) {
                                DistributedTestCase.fail("Interrupted, ah!", e);
                            }
                        }
                    }
                }
            });
        }
        for (count = 0; count < this.vmArr.length; ++count) {
            vm = this.vmArr[count];
            if (!((Boolean)stillHasDS.get(vm)).booleanValue()) continue;
            vm.invoke(new SerializableRunnable("Validate all bucket redundancy"){

                @Override
                public void run() {
                    for (int i = 0; i < 1; ++i) {
                        PartitionedRegion pr = (PartitionedRegion)PartitionedRegionHAFailureAndRecoveryDUnitTest.this.getCache().getRegion(uniqName + i);
                        Iterator bucketIdsWithStorage = pr.getRegionAdvisor().getBucketSet().iterator();
                        block3: while (bucketIdsWithStorage.hasNext()) {
                            int bucketId = (Integer)bucketIdsWithStorage.next();
                            while (true) {
                                try {
                                    List owners = pr.getBucketOwnersForValidation(bucketId);
                                    TestCase.assertEquals((int)(pr.getRedundantCopies() + 1), (int)owners.size());
                                    continue block3;
                                }
                                catch (ForceReattemptException retryIt) {
                                    DistributedTestCase.getLogWriter().info("Need to retry validation for bucket in PR " + pr, (Throwable)retryIt);
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                }
            });
        }
    }
}

