/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import junit.framework.TestCase;

public class PartitionedRegionDestroyDUnitTest
extends PartitionedRegionDUnitTestCase {
    public static final String PR_PREFIX = "PR";
    static final int MAX_REGIONS = 2;
    final int totalNumBuckets = 5;
    VM vm0;
    VM vm1;
    VM vm2;
    VM vm3;

    public PartitionedRegionDestroyDUnitTest(String name) {
        super(name);
    }

    public void testDestroyRegion() throws Exception, Throwable {
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        this.vm3 = host.getVM(3);
        AsyncInvocation async1 = null;
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("createPrRegions"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionDestroyDUnitTest.this.getCache();
                for (int i = 0; i < 2; ++i) {
                    cache.createRegion(PartitionedRegionDestroyDUnitTest.PR_PREFIX + i, PartitionedRegionDestroyDUnitTest.this.createRegionAttrsForPR(0, 200));
                }
                DistributedTestCase.getLogWriter().info("Successfully created 2 PartitionedRegions.");
            }
        };
        this.vm0.invoke(createPRs);
        this.vm1.invoke(createPRs);
        this.vm2.invoke(createPRs);
        this.vm3.invoke(createPRs);
        this.vm1.invoke(new CacheSerializableRunnable("doPutOperations-1"){

            @Override
            public void run2() {
                String expectedExistsException = RegionDestroyedException.class.getName();
                PartitionedRegionDestroyDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExistsException + "</ExpectedException>");
                try {
                    Cache cache = PartitionedRegionDestroyDUnitTest.this.getCache();
                    for (int j = 0; j < 2; ++j) {
                        PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR" + j);
                        TestCase.assertNotNull((Object)pr);
                        int totalEntries = pr.getTotalNumberOfBuckets() * 2;
                        for (int k = 0; k < totalEntries; ++k) {
                            pr.put((Object)new Integer(k), (Object)(PartitionedRegionDestroyDUnitTest.PR_PREFIX + k));
                        }
                    }
                }
                catch (RegionDestroyedException regionDestroyedException) {
                    // empty catch block
                }
                PartitionedRegionDestroyDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExistsException + "</ExpectedException>");
            }
        });
        async1 = this.vm2.invokeAsync(new CacheSerializableRunnable("doPutOperations-2"){

            @Override
            public void run2() throws CacheException {
                int j = 0;
                String expectedException = RegionDestroyedException.class.getName();
                PartitionedRegionDestroyDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedException + "</ExpectedException>");
                try {
                    Cache cache = PartitionedRegionDestroyDUnitTest.this.getCache();
                    PartitionedRegion[] prs = new PartitionedRegion[2];
                    for (j = 0; j < 2; ++j) {
                        prs[j] = (PartitionedRegion)cache.getRegion("/PR" + j);
                        if (prs[j] != null) continue;
                        TestCase.fail((String)"Region was destroyed before putter could find it");
                    }
                    for (j = 0; j < 2; ++j) {
                        PartitionedRegion pr = prs[j];
                        TestCase.assertNotNull((Object)pr);
                        int startEntries = pr.getTotalNumberOfBuckets() * 20;
                        int endEntries = startEntries + pr.getTotalNumberOfBuckets();
                        for (int k = startEntries; k < endEntries; ++k) {
                            pr.put((Object)new Integer(k), (Object)(PartitionedRegionDestroyDUnitTest.PR_PREFIX + k));
                        }
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                }
                catch (RegionDestroyedException e) {
                    DistributedTestCase.getLogWriter().info("RegionDestroyedException occured for Region = PR" + j);
                }
                PartitionedRegionDestroyDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedException + "</ExpectedException>");
            }
        });
        DistributedTestCase.join(async1, 30000L, PartitionedRegionDestroyDUnitTest.getLogWriter());
        if (async1.exceptionOccurred()) {
            PartitionedRegionDestroyDUnitTest.fail("async1 failed", async1.getException());
        }
        String expectedExceptions = "com.gemstone.gemfire.distributed.internal.ReplyException";
        this.addExceptionTag("com.gemstone.gemfire.distributed.internal.ReplyException");
        PartitionedRegionDestroyDUnitTest.pause(1000);
        this.vm0.invoke(new CacheSerializableRunnable("destroyPRRegions"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionDestroyDUnitTest.this.getCache();
                for (int i = 0; i < 2; ++i) {
                    Region pr = cache.getRegion("/PR" + i);
                    TestCase.assertNotNull((Object)pr);
                    pr.destroyRegion();
                    TestCase.assertTrue((boolean)pr.isDestroyed());
                    Region prDes = cache.getRegion("/PR" + i);
                    TestCase.assertNull((Object)prDes);
                }
            }
        });
        this.addExceptionTag("com.gemstone.gemfire.distributed.internal.ReplyException");
        CacheSerializableRunnable validateMetaDataAfterDestroy = new CacheSerializableRunnable("validateMetaDataAfterDestroy"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionDestroyDUnitTest.this.getCache();
                LocalRegion rootRegion = PartitionedRegionHelper.getPRRoot((Cache)cache);
                for (int trial = 0; trial < 10 && cache.rootRegions().size() > 1; ++trial) {
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        TestCase.fail((String)"interrupted");
                    }
                }
                if (cache.rootRegions().size() > 1) {
                    TestCase.fail((String)("All Regions Not destroyed. # OF Regions Not Destroyed = " + (cache.rootRegions().size() - 1)));
                }
                TestCase.assertEquals((int)0, (int)rootRegion.size());
                DistributedTestCase.getLogWriter().info("allPartitionedRegions size() =" + rootRegion.size());
                TestCase.assertEquals((String)("ThePrIdToPR Map size is:" + PartitionedRegion.prIdToPR.size() + " instead of 0"), (int)2, (int)PartitionedRegion.prIdToPR.size());
                DistributedTestCase.getLogWriter().info("PartitionedRegion.prIdToPR.size() =" + PartitionedRegion.prIdToPR.size());
                DistributedTestCase.getLogWriter().info("# of Subregions of root Region after destroy call = " + rootRegion.subregions(false).size());
                for (Region rg : rootRegion.subregions(false)) {
                    DistributedTestCase.getLogWriter().info("Root Region SubRegionName = " + rg.getName());
                    TestCase.assertEquals((String)("regionFound that should be gone!:" + rg.getName()), (int)-1, (int)rg.getName().indexOf("_B_"));
                }
            }
        };
        this.vm0.invoke(validateMetaDataAfterDestroy);
        this.vm1.invoke(validateMetaDataAfterDestroy);
        this.vm2.invoke(validateMetaDataAfterDestroy);
        this.vm3.invoke(validateMetaDataAfterDestroy);
        this.vm0.invoke(createPRs);
        this.vm1.invoke(createPRs);
        this.vm2.invoke(createPRs);
        this.vm3.invoke(createPRs);
    }

    protected RegionAttributes createRegionAttrsForPR(int red, int localMaxMem) {
        AttributesFactory attr = new AttributesFactory();
        attr.setDataPolicy(DataPolicy.PARTITION);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(red).setLocalMaxMemory(localMaxMem).setTotalNumBuckets(5).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }

    private void addExceptionTag(final String expectedException) {
        CacheSerializableRunnable addExceptionTag = new CacheSerializableRunnable("addExceptionTag"){

            @Override
            public void run2() {
                PartitionedRegionDestroyDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedException + "</ExpectedException>");
            }
        };
        this.vm0.invoke(addExceptionTag);
        this.vm1.invoke(addExceptionTag);
        this.vm2.invoke(addExceptionTag);
        this.vm3.invoke(addExceptionTag);
    }

    private void removeExceptionTag(final String expectedException) {
        CacheSerializableRunnable removeExceptionTag = new CacheSerializableRunnable("removeExceptionTag"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegionDestroyDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedException + "</ExpectedException>");
            }
        };
        this.vm0.invoke(removeExceptionTag);
        this.vm1.invoke(removeExceptionTag);
        this.vm2.invoke(removeExceptionTag);
        this.vm3.invoke(removeExceptionTag);
    }
}

