/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Node;
import com.gemstone.gemfire.internal.cache.PartitionRegionConfig;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionException;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import mapregion.MapBB;

public class PartitionedRegionCloseDUnitTest
extends PartitionedRegionDUnitTestCase {
    public static final String PR_PREFIX = "PR";
    static final int MAX_REGIONS = 1;
    final int totalNumBuckets = 5;
    final int numPut = 200;

    public PartitionedRegionCloseDUnitTest(String name) {
        super(name);
    }

    public void testClose() throws Throwable {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("createPrRegions"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    try {
                        cache.createRegion(PartitionedRegionCloseDUnitTest.PR_PREFIX + i, PartitionedRegionCloseDUnitTest.this.createRegionAttributesForPR(1, 20));
                        continue;
                    }
                    catch (RegionExistsException ree) {
                        TestCase.fail((String)"Unexpected Region Exists Exception is thrown");
                    }
                }
            }
        };
        CacheSerializableRunnable createAccessor = new CacheSerializableRunnable("createAccessor"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    cache.createRegion(PartitionedRegionCloseDUnitTest.PR_PREFIX + i, PartitionedRegionCloseDUnitTest.this.createRegionAttributesForPR(1, 0));
                }
            }
        };
        accessor.invoke(createAccessor);
        datastore1.invoke(createPRs);
        datastore2.invoke(createPRs);
        datastore3.invoke(createPRs);
        accessor.invoke(new CacheSerializableRunnable("doPutOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PR" + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = 0; k < 200; ++k) {
                        Integer key = new Integer(k);
                        String value = j + PartitionedRegionCloseDUnitTest.PR_PREFIX + k;
                        pr.put((Object)key, (Object)value);
                    }
                    DistributedTestCase.getLogWriter().info("VM0 Done put successfully for PR = PR" + j);
                }
            }
        });
        CacheSerializableRunnable closePRs = new CacheSerializableRunnable("closePRs"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR" + i);
                    MapBB.getBB().getSharedMap().put(PartitionedRegionCloseDUnitTest.PR_PREFIX + i, pr.getNode());
                    pr.close();
                }
            }
        };
        datastore1.invoke(closePRs);
        datastore2.invoke(new CacheSerializableRunnable("validateCloseAPI"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR" + j);
                    TestCase.assertNotNull((Object)pr);
                    Node targetNode = (Node)MapBB.getBB().getSharedMap().get(pr.getName());
                    PartitionedRegionCloseDUnitTest.checkBucketMetadataCleanup(pr, targetNode.getMemberId());
                    LocalRegion root = PartitionedRegionHelper.getPRRoot((Cache)cache);
                    PartitionRegionConfig prConfig = (PartitionRegionConfig)root.get((Object)pr.getRegionIdentifier());
                    DistributedTestCase.getLogWriter().info("prConfig = " + prConfig);
                    if (prConfig.containsNode(targetNode)) {
                        TestCase.fail((String)"Close clean up did not remove node from allPartitionedRegions");
                    }
                    DistributedTestCase.getLogWriter().info("datastore2 validated closing of PR = PR" + j + " on datastore 1");
                }
            }
        });
        accessor.invoke(new CacheSerializableRunnable("doGetOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PR" + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = 0; k < 200; ++k) {
                        String value = j + PartitionedRegionCloseDUnitTest.PR_PREFIX + k;
                        TestCase.assertEquals((Object)value, (Object)pr.get((Object)new Integer(k)));
                    }
                    DistributedTestCase.getLogWriter().info("VM0 Done put successfully for PR = PR" + j);
                }
            }
        });
        datastore1.invoke(createPRs);
    }

    public void testLocalDestroyRegion() throws Throwable {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("createPrRegions"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    cache.createRegion(PartitionedRegionCloseDUnitTest.PR_PREFIX + i, PartitionedRegionCloseDUnitTest.this.createRegionAttributesForPR(1, 20));
                }
            }
        };
        CacheSerializableRunnable createAccessor = new CacheSerializableRunnable("createAccessor"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    cache.createRegion(PartitionedRegionCloseDUnitTest.PR_PREFIX + i, PartitionedRegionCloseDUnitTest.this.createRegionAttributesForPR(1, 0));
                }
            }
        };
        accessor.invoke(createAccessor);
        datastore1.invoke(createPRs);
        datastore2.invoke(createPRs);
        datastore3.invoke(createPRs);
        accessor.invoke(new CacheSerializableRunnable("doPutOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PR" + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = 0; k < 200; ++k) {
                        Integer key = new Integer(k);
                        String value = j + PartitionedRegionCloseDUnitTest.PR_PREFIX + k;
                        pr.put((Object)key, (Object)value);
                    }
                    DistributedTestCase.getLogWriter().info("VM0 Done put successfully for PR = PR" + j);
                }
            }
        });
        CacheSerializableRunnable locallyDestroyPRs = new CacheSerializableRunnable("localDestroyRegion"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR" + i);
                    MapBB.getBB().getSharedMap().put(PartitionedRegionCloseDUnitTest.PR_PREFIX + i, pr.getNode());
                    pr.localDestroyRegion();
                }
            }
        };
        datastore1.invoke(locallyDestroyPRs);
        datastore2.invoke(new CacheSerializableRunnable("validateCloseAPI"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR" + j);
                    TestCase.assertNotNull((Object)pr);
                    Node targetNode = (Node)MapBB.getBB().getSharedMap().get(pr.getName());
                    PartitionedRegionCloseDUnitTest.checkBucketMetadataCleanup(pr, targetNode.getMemberId());
                    LocalRegion root = PartitionedRegionHelper.getPRRoot((Cache)cache);
                    PartitionRegionConfig prConfig = (PartitionRegionConfig)root.get((Object)pr.getRegionIdentifier());
                    DistributedTestCase.getLogWriter().info("prConfig = " + prConfig);
                    if (prConfig.containsNode(targetNode)) {
                        TestCase.fail((String)"Close clean up did not remove node from allPartitionedRegions");
                    }
                    DistributedTestCase.getLogWriter().info("datastore2 validated closing of PR = PR" + j + " on datastore 1");
                }
            }
        });
        accessor.invoke(new CacheSerializableRunnable("doGetOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    Region pr = cache.getRegion("/PR" + j);
                    TestCase.assertNotNull((Object)pr);
                    Object getVal = null;
                    for (int k = 0; k < 200; ++k) {
                        Integer key = new Integer(k);
                        String value = j + PartitionedRegionCloseDUnitTest.PR_PREFIX + k;
                        getVal = pr.get((Object)key, (Object)value);
                        TestCase.assertEquals((Object)getVal, (Object)value);
                    }
                    DistributedTestCase.getLogWriter().info("VM0 Done put successfully for PR = PR" + j);
                }
            }
        });
        datastore1.invoke(createPRs);
    }

    protected RegionAttributes createRegionAttributesForPR(int redundancy, int localMaxMem) {
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).setLocalMaxMemory(localMaxMem).setTotalNumBuckets(5).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCloseRecreate() throws Throwable {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("createPrRegions"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    try {
                        cache.createRegion(PartitionedRegionCloseDUnitTest.PR_PREFIX + i, PartitionedRegionCloseDUnitTest.this.createRegionAttributesForPR(1, 20));
                        continue;
                    }
                    catch (RegionExistsException ree) {
                        TestCase.fail((String)"Unexpected Region Exists Exception is thrown");
                        continue;
                    }
                    catch (PartitionedRegionException pre) {
                        TestCase.fail((String)"Unexpected Region Exists Exception is thrown");
                    }
                }
            }
        };
        CacheSerializableRunnable createAccessor = new CacheSerializableRunnable("createAccessor"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    cache.createRegion(PartitionedRegionCloseDUnitTest.PR_PREFIX + i, PartitionedRegionCloseDUnitTest.this.createRegionAttributesForPR(1, 0));
                }
            }
        };
        accessor.invoke(createAccessor);
        datastore1.invoke(createPRs);
        datastore2.invoke(createPRs);
        datastore3.invoke(createPRs);
        accessor.invoke(new CacheSerializableRunnable("doPutOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR" + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = 0; k < 200; ++k) {
                        Integer key = new Integer(k);
                        String value = j + PartitionedRegionCloseDUnitTest.PR_PREFIX + k;
                        pr.put((Object)key, (Object)value);
                        int bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, null, (Object)key, null, null);
                        TestCase.assertEquals((int)2, (int)pr.getRegionAdvisor().getBucketOwners(bucketId).size());
                    }
                    DistributedTestCase.getLogWriter().info("VM0 Done put successfully for PR = PR" + j);
                }
            }
        });
        CacheSerializableRunnable closePRs = new CacheSerializableRunnable("closePRs"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() {
                Cache cache = PartitionedRegionCloseDUnitTest.this.getCache();
                DistributedTestCase.ExpectedException ee = null;
                try {
                    ee = DistributedTestCase.addExpectedException(RegionDestroyedException.class.getName());
                    for (int i = 0; i < 1; ++i) {
                        PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PR" + i);
                        MapBB.getBB().getSharedMap().put(PartitionedRegionCloseDUnitTest.PR_PREFIX + i, pr.getNode());
                        pr.close();
                    }
                }
                finally {
                    if (ee != null) {
                        ee.remove();
                    }
                }
            }
        };
        DistributedTestCase.ExpectedException ee = null;
        try {
            ee = PartitionedRegionCloseDUnitTest.addExpectedException(RegionDestroyedException.class.getName());
            datastore1.invoke(closePRs);
            datastore2.invoke(closePRs);
            datastore3.invoke(closePRs);
            accessor.invoke(closePRs);
        }
        finally {
            if (ee != null) {
                ee.remove();
            }
        }
        accessor.invoke(createAccessor);
        datastore1.invoke(createPRs);
        datastore2.invoke(createPRs);
        datastore3.invoke(createPRs);
    }

    protected static void checkBucketMetadataCleanup(PartitionedRegion pr, InternalDistributedMember memberId) {
        Iterator itr = pr.getRegionAdvisor().getBucketSet().iterator();
        try {
            while (itr.hasNext()) {
                Integer bucketId = (Integer)itr.next();
                PartitionedRegionCloseDUnitTest.assertTrue((String)("CLeanup did not remove member from bucket meta-data, member=" + memberId + " from bucket=" + pr.bucketStringForLogs(bucketId.intValue())), (!pr.getRegionAdvisor().getBucketOwners(bucketId.intValue()).contains(memberId) ? 1 : 0) != 0);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

