/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionRegionConfig;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Set;
import junit.framework.TestCase;

public class PartitionedRegionCacheCloseDUnitTest
extends PartitionedRegionDUnitTestCase {
    static final int MAX_REGIONS = 1;
    final int totalNumBuckets = 5;

    public PartitionedRegionCacheCloseDUnitTest(String name) {
        super(name);
    }

    public void testCacheClose() throws Exception, Throwable {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("createPrRegions"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionCacheCloseDUnitTest.this.getCache();
                for (int i = 0; i < 1; ++i) {
                    cache.createRegion(rName + i, PartitionedRegionCacheCloseDUnitTest.this.createRegionAttributesForPR(1, 20));
                }
            }
        };
        vm0.invoke(createPRs);
        vm1.invoke(createPRs);
        AsyncInvocation async0 = vm0.invokeAsync(new CacheSerializableRunnable("doPutOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCacheCloseDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + rName + j);
                    TestCase.assertNotNull((Object)pr);
                    int numBuckets = pr.getTotalNumberOfBuckets();
                    for (int k = 0; k < numBuckets; ++k) {
                        Integer key = new Integer(k);
                        pr.put((Object)key, (Object)(rName + k));
                    }
                    DistributedTestCase.getLogWriter().info("VM0 Done put successfully for PR = " + rName + j);
                }
            }
        });
        AsyncInvocation async1 = vm1.invokeAsync(new CacheSerializableRunnable("doPutOperations"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCacheCloseDUnitTest.this.getCache();
                for (int j = 0; j < 1; ++j) {
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/" + rName + j);
                    TestCase.assertNotNull((Object)pr);
                    int numBuckets = pr.getTotalNumberOfBuckets();
                    int max = numBuckets * 2;
                    for (int k = numBuckets; k < max; ++k) {
                        Integer key = new Integer(k);
                        pr.put((Object)key, (Object)(rName + k));
                    }
                    DistributedTestCase.getLogWriter().info("VM1 Done put successfully for PR = " + rName + j);
                }
            }
        });
        DistributedTestCase.join(async0, 30000L, PartitionedRegionCacheCloseDUnitTest.getLogWriter());
        DistributedTestCase.join(async1, 30000L, PartitionedRegionCacheCloseDUnitTest.getLogWriter());
        if (async0.exceptionOccurred()) {
            PartitionedRegionCacheCloseDUnitTest.fail("Exception during async0", async0.getException());
        }
        CacheSerializableRunnable closeCache = new CacheSerializableRunnable("closeCache"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCacheCloseDUnitTest.this.getCache();
                cache.close();
            }
        };
        CacheSerializableRunnable validateCacheCloseCleanUp = new CacheSerializableRunnable("validateCacheCloseCleanUp"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionCacheCloseDUnitTest.this.getCache();
                LogWriter logger = cache.getLogger();
                LocalRegion root = PartitionedRegionHelper.getPRRoot((Cache)cache);
                for (int j = 0; j < 1; ++j) {
                    String regionName = "#" + rName + j;
                    PartitionRegionConfig prConf = (PartitionRegionConfig)root.get((Object)regionName);
                    Set nodes = prConf.getNodes();
                    logger.info("Size of nodeList in prConf for region = " + regionName + " = " + nodes.size());
                    TestCase.assertEquals((String)("Nodes: " + nodes), (int)1, (int)nodes.size());
                }
            }
        };
        vm0.invoke(closeCache);
        vm1.invoke(validateCacheCloseCleanUp);
    }

    protected RegionAttributes createRegionAttributesForPR(int redundancy, int localMaxMem) {
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).setLocalMaxMemory(localMaxMem).setTotalNumBuckets(5).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }
}

