/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.TestCacheLoader;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class PartitionedRegionAPIDUnitTest
extends PartitionedRegionDUnitTestCase {
    Properties props = new Properties();
    VM vm0 = null;
    VM vm1 = null;
    VM vm2 = null;
    VM vm3 = null;
    final int putRange_1Start = 1;
    final int putRange_1End = 5;
    final int putRange_2Start = 6;
    final int putRange_2End = 10;
    final int putRange_3Start = 11;
    final int putRange_3End = 15;
    final int putRange_4Start = 16;
    final int putRange_4End = 20;
    final int removeRange_1Start = 2;
    final int removeRange_1End = 4;
    final int removeRange_2Start = 7;
    final int removeRange_2End = 9;
    final int createRange_1Start = 21;
    final int createRange_1End = 25;
    final int createRange_2Start = 26;
    final int createRange_2End = 30;
    final int createRange_3Start = 31;
    final int createRange_3End = 35;
    final int createRange_4Start = 36;
    final int createRange_4End = 40;
    final int invalidateRange_1Start = 41;
    final int invalidateRange_1End = 45;
    final int invalidateRange_2Start = 46;
    final int invalidateRange_2End = 50;
    final int invalidateRange_3Start = 51;
    final int invalidateRange_3End = 55;
    final int invalidateRange_4Start = 56;
    final int invalidateRange_4End = 60;
    final int sizeRange_1Start = 61;
    final int sizeRange_1End = 65;
    final int sizeRange_2Start = 66;
    final int sizeRange_2End = 70;
    static final int totalNumBuckets = 5;
    SerializableRunnable createPrRegionWithDS_DACK = new CacheSerializableRunnable("createPrRegionWithDS"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
            AttributesFactory attr = new AttributesFactory();
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            paf.setTotalNumBuckets(5);
            PartitionAttributes prAttr = paf.create();
            attr.setPartitionAttributes(prAttr);
            RegionAttributes regionAttribs = attr.create();
            cache.createRegion("PR1", regionAttribs);
        }
    };
    SerializableRunnable createPrRegionOnlyAccessor_DACK = new CacheSerializableRunnable("createPrRegionOnlyAccessor"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
            AttributesFactory attr = new AttributesFactory();
            PartitionAttributesFactory paf = new PartitionAttributesFactory();
            PartitionAttributes prAttr = paf.setLocalMaxMemory(0).setTotalNumBuckets(5).create();
            attr.setPartitionAttributes(prAttr);
            RegionAttributes regionAttribs = attr.create();
            cache.createRegion("PR1", regionAttribs);
            DistributedTestCase.getLogWriter().info("Region created in VM1.");
        }
    };

    public PartitionedRegionAPIDUnitTest(String name) {
        super(name);
    }

    public static boolean searchForKey(PartitionedRegion par, Object key) {
        boolean foundIt = false;
        int numBucks = par.getTotalNumberOfBuckets();
        for (int b = 0; b < numBucks; ++b) {
            if (!par.getBucketKeys(b).contains(key)) continue;
            foundIt = true;
            PartitionedRegionAPIDUnitTest.getLogWriter().severe("Key " + key + " found in bucket " + b);
            break;
        }
        if (!foundIt) {
            PartitionedRegionAPIDUnitTest.getLogWriter().severe("Key " + key + " not found in any bucket");
        }
        return foundIt;
    }

    public void partitionedRegionTestAfterDestroyRegion(final String prName) {
        this.vm0.invoke(new CacheSerializableRunnable("doPutCreateInvalidateOperations1"){

            @Override
            public void run2() throws CacheException {
                String key;
                String val;
                int i;
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                String exceptionStr = "";
                Region pr = cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)"PR not created");
                }
                for (i = 1; i <= 5; ++i) {
                    pr.put((Object)("" + i), (Object)("" + i));
                }
                for (i = 21; i <= 25; ++i) {
                    val = null;
                    key = "" + i;
                    if (i % 2 == 0) {
                        val = "" + i;
                    }
                    pr.create((Object)key, (Object)val);
                }
                for (i = 21; i <= 25; ++i) {
                    val = null;
                    key = "" + i;
                    if (i % 2 == 0) {
                        val = "" + i;
                    }
                    String expectedExceptions = EntryExistsException.class.getName();
                    PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions + "</ExpectedException>");
                    exceptionStr = ReplyException.class.getName() + ":" + expectedExceptions;
                    PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                    try {
                        pr.create((Object)key, (Object)val);
                        TestCase.fail((String)"EntryExistsException is not thrown");
                    }
                    catch (EntryExistsException entryExistsException) {
                        // empty catch block
                    }
                    PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                    PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions + "</ExpectedException>");
                }
                for (i = 41; i <= 45; ++i) {
                    val = Integer.toString(i);
                    key = Integer.toString(i);
                    String entryNotFoundException = EntryNotFoundException.class.getName();
                    PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + entryNotFoundException + "</ExpectedException>");
                    exceptionStr = ReplyException.class.getName() + "||" + entryNotFoundException;
                    PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                    try {
                        pr.invalidate((Object)key);
                        TestCase.fail((String)("EntryNotFoundException is not thrown for key which does not exists in the system = " + key));
                    }
                    catch (EntryNotFoundException entryNotFoundException2) {
                        // empty catch block
                    }
                    PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                    PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                    PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + entryNotFoundException + "</ExpectedException>");
                    pr.create((Object)key, (Object)val);
                    TestCase.assertTrue((String)("containsValueForKey key=" + key), (boolean)pr.containsValueForKey((Object)key));
                    TestCase.assertEquals((Object)val, (Object)pr.get((Object)key));
                    pr.invalidate((Object)key);
                    TestCase.assertFalse((boolean)pr.containsValueForKey((Object)key));
                    TestCase.assertNull((Object)pr.get((Object)key));
                }
                for (i = 41; i <= 45; ++i) {
                    String key2 = Integer.toString(i);
                    pr.destroy((Object)key2);
                }
                String entryNotFoundException = EntryNotFoundException.class.getName();
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + entryNotFoundException + "</ExpectedException>");
                exceptionStr = ReplyException.class.getName() + "||" + entryNotFoundException;
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                for (int i2 = 41; i2 <= 45; ++i2) {
                    key = "" + i2;
                    try {
                        pr.invalidate((Object)key);
                        TestCase.fail((String)("EntryNotFoundException is not thrown for key which does not exists in the system = " + key));
                        continue;
                    }
                    catch (EntryNotFoundException entryNotFoundException3) {
                        // empty catch block
                    }
                }
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + entryNotFoundException + "</ExpectedException>");
                DistributedTestCase.getLogWriter().fine("Out of doPutOperations1");
                DistributedTestCase.getLogWriter().fine("All the puts done successfully for vm0.");
            }
        });
        this.vm1.invoke(new CacheSerializableRunnable("doPutCreateInvalidateOperations2"){

            @Override
            public void run2() throws CacheException {
                String key;
                String val;
                int i;
                String key2;
                int i2;
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                String exceptionStr = "";
                Region pr = cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)"PR not created");
                }
                for (i2 = 6; i2 <= 10; ++i2) {
                    pr.put((Object)("" + i2), (Object)("" + i2));
                }
                for (i2 = 26; i2 <= 30; ++i2) {
                    String val2 = null;
                    String key3 = "" + i2;
                    if (i2 % 2 == 0) {
                        val2 = "" + i2;
                    }
                    pr.create((Object)key3, val2);
                }
                String entryExistsException = EntryExistsException.class.getName();
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + entryExistsException + "</ExpectedException>");
                exceptionStr = ReplyException.class.getName() + "||" + entryExistsException;
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                for (int i3 = 26; i3 <= 30; ++i3) {
                    String val3 = null;
                    key2 = "" + i3;
                    if (i3 % 2 == 0) {
                        val3 = "" + i3;
                    }
                    try {
                        pr.create((Object)key2, val3);
                        TestCase.fail((String)"EntryExistsException is not thrown");
                        continue;
                    }
                    catch (EntryExistsException entryExistsException2) {
                        // empty catch block
                    }
                }
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + entryExistsException + "</ExpectedException>");
                String entryNotFoundException = EntryNotFoundException.class.getName();
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + entryNotFoundException + "</ExpectedException>");
                exceptionStr = ReplyException.class.getName() + "||" + entryNotFoundException;
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                for (i = 46; i <= 50; ++i) {
                    val = Integer.toString(i);
                    key = Integer.toString(i);
                    try {
                        pr.invalidate((Object)key);
                        TestCase.fail((String)("EntryNotFoundException is not thrown for key which does not exists in the system = " + key));
                    }
                    catch (EntryNotFoundException entryNotFoundException2) {
                        // empty catch block
                    }
                    pr.create((Object)key, (Object)val);
                }
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + entryNotFoundException + "</ExpectedException>");
                for (i = 46; i <= 50; ++i) {
                    val = Integer.toString(i);
                    key = Integer.toString(i);
                    TestCase.assertEquals((Object)val, (Object)pr.get((Object)key));
                    TestCase.assertTrue((boolean)pr.containsValueForKey((Object)key));
                    pr.invalidate((Object)key);
                }
                for (i = 46; i <= 50; ++i) {
                    key2 = Integer.toString(i);
                    Object shouldBeNull = pr.get((Object)key2);
                    TestCase.assertNull((String)("Key " + key2 + " should report val null, however it has " + shouldBeNull), (Object)shouldBeNull);
                    TestCase.assertFalse((String)("Key " + key2 + " should report False for containsValueForKey"), (boolean)pr.containsValueForKey((Object)key2));
                }
                for (i = 46; i <= 50; ++i) {
                    key2 = Integer.toString(i);
                    pr.destroy((Object)key2);
                }
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + entryNotFoundException + "</ExpectedException>");
                exceptionStr = ReplyException.class.getName() + "||" + entryNotFoundException;
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                for (i = 46; i <= 50; ++i) {
                    key2 = Integer.toString(i);
                    try {
                        pr.invalidate((Object)key2);
                        TestCase.fail((String)("EntryNotFoundException is not thrown for key which does not exists in the system = " + key2));
                        continue;
                    }
                    catch (EntryNotFoundException entryNotFoundException3) {
                        // empty catch block
                    }
                }
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + entryNotFoundException + "</ExpectedException>");
                DistributedTestCase.getLogWriter().fine("Out of doPutOperations2");
                DistributedTestCase.getLogWriter().fine("All the puts done successfully for vm1.");
            }
        });
    }

    public void partitionedRegionTest(final String prName) {
        this.vm0.invoke(new CacheSerializableRunnable("doPutCreateInvalidateOperations1"){

            @Override
            public void run2() throws CacheException {
                int i;
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                Region pr = cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)(prName + " not created"));
                }
                int size = 0;
                size = pr.size();
                TestCase.assertEquals((String)"Size doesnt return expected value", (int)0, (int)size);
                TestCase.assertEquals((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)true, (boolean)pr.isEmpty());
                TestCase.assertEquals((int)0, (int)pr.keySet().size());
                TestCase.assertEquals((int)0, (int)pr.keys().size());
                for (int i2 = 1; i2 <= 5; ++i2) {
                    pr.put((Object)Integer.toString(i2), (Object)Integer.toString(i2));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertEquals((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)false, (boolean)pr.isEmpty());
                TestCase.assertEquals((int)5, (int)pr.keySet().size());
                TestCase.assertEquals((int)5, (int)pr.keys().size());
                Set ks = pr.keySet();
                Iterator ksI = ks.iterator();
                while (ksI.hasNext()) {
                    try {
                        ksI.remove();
                        TestCase.fail((String)"Expected key set iterator to be read only");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Object key = ksI.next();
                    TestCase.assertEquals(String.class, key.getClass());
                    Integer.parseInt((String)key);
                }
                try {
                    ksI.remove();
                    TestCase.fail((String)"Expected key set iterator to be read only");
                }
                catch (Exception key) {
                    // empty catch block
                }
                TestCase.assertFalse((boolean)ksI.hasNext());
                try {
                    ksI.next();
                    TestCase.fail((String)"Expected no such element exception");
                }
                catch (NoSuchElementException expected) {
                    TestCase.assertFalse((boolean)ksI.hasNext());
                }
                String exceptionStr = ReplyException.class.getName() + "||" + EntryNotFoundException.class.getName();
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                for (i = 1; i <= 5; ++i) {
                    try {
                        pr.destroy((Object)Integer.toString(i));
                        continue;
                    }
                    catch (EntryNotFoundException enfe) {
                        PartitionedRegionAPIDUnitTest.searchForKey((PartitionedRegion)pr, Integer.toString(i));
                        throw enfe;
                    }
                }
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                size = pr.size();
                TestCase.assertEquals((String)("Size doesnt return expected value = 0 instead it returns" + size), (int)size, (int)0);
                TestCase.assertEquals((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty(), (boolean)true);
                for (i = 1; i <= 5; ++i) {
                    pr.put((Object)Integer.toString(i), (Object)Integer.toString(i));
                }
                for (i = 21; i <= 25; ++i) {
                    String val = null;
                    String key = Integer.toString(i);
                    if (i % 2 == 0) {
                        val = Integer.toString(i);
                    }
                    pr.create((Object)key, (Object)val);
                }
                String expectedExceptions = EntryExistsException.class.getName();
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions + "</ExpectedException>");
                exceptionStr = ReplyException.class.getName() + "||" + expectedExceptions;
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                for (int i3 = 21; i3 <= 25; ++i3) {
                    String val = null;
                    String key = Integer.toString(i3);
                    if (i3 % 2 == 0) {
                        val = Integer.toString(i3);
                    }
                    try {
                        pr.create((Object)key, (Object)val);
                        TestCase.fail((String)"EntryExistsException is not thrown");
                        continue;
                    }
                    catch (EntryExistsException entryExistsException) {
                        // empty catch block
                    }
                }
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions + "</ExpectedException>");
                size = pr.size();
                TestCase.assertEquals((String)"Size doesnt return expected value", (int)size, (int)10);
                DistributedTestCase.getLogWriter().fine("All the puts done successfully for vm0.");
                PartitionedRegion ppr = (PartitionedRegion)pr;
                try {
                    ppr.dumpAllBuckets(true, DistributedTestCase.getLogWriter().convertToLogWriterI18n());
                }
                catch (ReplyException re) {
                    TestCase.fail();
                }
            }
        });
        this.vm1.invoke(new CacheSerializableRunnable("doPutCreateInvalidateOperations2"){

            @Override
            public void run2() throws CacheException {
                int i;
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                Region pr = cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)"PR not created");
                }
                for (i = 6; i <= 10; ++i) {
                    pr.put((Object)Integer.toString(i), (Object)Integer.toString(i));
                }
                for (i = 26; i <= 30; ++i) {
                    String val = null;
                    String key = Integer.toString(i);
                    if (i % 2 == 0) {
                        val = Integer.toString(i);
                    }
                    pr.create((Object)key, (Object)val);
                }
                String entryExistsException = EntryExistsException.class.getName();
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + entryExistsException + "</ExpectedException>");
                String exceptionStr = ReplyException.class.getName() + ":" + entryExistsException;
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                for (int i2 = 26; i2 <= 30; ++i2) {
                    String val = null;
                    String key = Integer.toString(i2);
                    if (i2 % 2 == 0) {
                        val = Integer.toString(i2);
                    }
                    try {
                        pr.create((Object)key, (Object)val);
                        TestCase.fail((String)"EntryExistsException is not thrown");
                        continue;
                    }
                    catch (EntryExistsException entryExistsException2) {
                        // empty catch block
                    }
                }
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + entryExistsException + "</ExpectedException>");
                cache.getLogger().fine("All the puts done successfully for vm1.");
            }
        });
        this.vm1.invoke(new CacheSerializableRunnable("doRemoveOperations1"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                Region pr = cache.getRegion(prName);
                if (pr == null) {
                    TestCase.fail((String)"PR not created");
                }
                for (int i = 2; i <= 4; ++i) {
                    String key = Integer.toString(i);
                    try {
                        pr.destroy((Object)key);
                        continue;
                    }
                    catch (EntryNotFoundException enfe) {
                        PartitionedRegionAPIDUnitTest.searchForKey((PartitionedRegion)pr, key);
                        throw enfe;
                    }
                }
                String entryNotFoundException = EntryNotFoundException.class.getName();
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + entryNotFoundException + "</ExpectedException>");
                String exceptionStr = ReplyException.class.getName() + "||" + entryNotFoundException;
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                for (int i = 2; i <= 4; ++i) {
                    String key = Integer.toString(i);
                    try {
                        pr.destroy((Object)key);
                        TestCase.fail((String)("EntryNotFoundException is not thrown in destroy operation for key = " + i));
                        continue;
                    }
                    catch (EntryNotFoundException entryNotFoundException2) {
                        // empty catch block
                    }
                }
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + entryNotFoundException + "</ExpectedException>");
                DistributedTestCase.getLogWriter().fine("All the remove done successfully for vm0.");
            }
        });
        this.vm2.invoke(new CacheSerializableRunnable("doPutCreateInvalidateOperations3"){

            @Override
            public void run2() throws CacheException {
                int i;
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                Region pr = cache.getRegion(prName);
                TestCase.assertNotNull((String)"PR not created", (Object)pr);
                for (i = 11; i <= 15; ++i) {
                    pr.put((Object)Integer.toString(i), (Object)Integer.toString(i));
                }
                for (i = 31; i <= 35; ++i) {
                    String val = null;
                    String key = Integer.toString(i);
                    if (i % 2 == 0) {
                        val = Integer.toString(i);
                    }
                    pr.create((Object)key, (Object)val);
                }
                String entryExistsException = EntryExistsException.class.getName();
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + entryExistsException + "</ExpectedException>");
                String exceptionStr = ReplyException.class.getName() + "||" + entryExistsException;
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                for (int i2 = 31; i2 <= 35; ++i2) {
                    String val = null;
                    String key = Integer.toString(i2);
                    if (i2 % 2 == 0) {
                        val = Integer.toString(i2);
                    }
                    try {
                        pr.create((Object)key, (Object)val);
                        TestCase.fail((String)"EntryExistsException is not thrown");
                        continue;
                    }
                    catch (EntryExistsException entryExistsException2) {
                        // empty catch block
                    }
                }
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + entryExistsException + "</ExpectedException>");
            }
        });
        this.vm2.invoke(new CacheSerializableRunnable("doRemoveOperations2"){

            @Override
            public void run2() throws CacheException {
                int i = 0;
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                Region pr = cache.getRegion(prName);
                TestCase.assertNotNull((String)"PR not created", (Object)pr);
                if (pr == null) {
                    TestCase.fail((String)"PR not created");
                }
                for (i = 7; i <= 9; ++i) {
                    String key = Integer.toString(i);
                    try {
                        pr.destroy((Object)key);
                        continue;
                    }
                    catch (EntryNotFoundException enfe) {
                        PartitionedRegionAPIDUnitTest.searchForKey((PartitionedRegion)pr, key);
                        throw enfe;
                    }
                }
                String entryNotFound = EntryNotFoundException.class.getName();
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + entryNotFound + "</ExpectedException>");
                String exceptionStr = ReplyException.class.getName() + "||" + entryNotFound;
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                for (i = 7; i <= 9; ++i) {
                    try {
                        pr.destroy((Object)Integer.toString(i));
                        TestCase.fail((String)("EntryNotFoundException is not thrown in destroy operation for key = " + Integer.toString(i)));
                        continue;
                    }
                    catch (EntryNotFoundException entryNotFoundException) {
                        // empty catch block
                    }
                }
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm3.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + entryNotFound + "</ExpectedException>");
            }
        });
        this.vm3.invoke(new CacheSerializableRunnable("doPutCreateInvalidateOperations4"){

            @Override
            public void run2() throws CacheException {
                int i;
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                Region pr = cache.getRegion(prName);
                TestCase.assertNotNull((String)"PR not created", (Object)pr);
                for (i = 16; i <= 20; ++i) {
                    pr.put((Object)Integer.toString(i), (Object)Integer.toString(i));
                }
                for (i = 36; i <= 40; ++i) {
                    String val = null;
                    String key = Integer.toString(i);
                    if (i % 2 == 0) {
                        val = Integer.toString(i);
                    }
                    pr.create((Object)key, (Object)val);
                }
                String entryExistsException = EntryExistsException.class.getName();
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + entryExistsException + "</ExpectedException>");
                String exceptionStr = ReplyException.class.getName() + "||" + entryExistsException;
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.addExceptionTag1(exceptionStr);
                for (int i2 = 36; i2 <= 40; ++i2) {
                    String val = null;
                    String key = Integer.toString(i2);
                    if (i2 % 2 == 0) {
                        val = Integer.toString(i2);
                    }
                    try {
                        pr.create((Object)key, (Object)val);
                        TestCase.fail((String)"EntryExistsException is not thrown");
                        continue;
                    }
                    catch (EntryExistsException entryExistsException2) {
                        // empty catch block
                    }
                }
                PartitionedRegionAPIDUnitTest.this.vm0.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm1.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.vm2.invoke(PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr));
                PartitionedRegionAPIDUnitTest.this.removeExceptionTag1(exceptionStr);
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + entryExistsException + "</ExpectedException>");
            }
        });
        CacheSerializableRunnable validateRegionAPIs = new CacheSerializableRunnable("validateInserts"){

            @Override
            public void run2() {
                int i;
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                Region pr = cache.getRegion(prName);
                TestCase.assertNotNull((String)"PR not created", (Object)pr);
                for (i = 1; i <= 20; ++i) {
                    Object val = pr.get((Object)Integer.toString(i));
                    if (i >= 2 && i <= 4 || i >= 7 && i <= 9) {
                        TestCase.assertNull((String)("Remove validation failed for key " + i), (Object)val);
                        continue;
                    }
                    TestCase.assertNotNull((String)("put() not done for key " + i), (Object)val);
                }
                for (i = 1; i <= 20; ++i) {
                    boolean conKey = pr.containsKey((Object)Integer.toString(i));
                    if (i >= 2 && i <= 4 || i >= 7 && i <= 9) {
                        TestCase.assertFalse((String)("containsKey() remove validation failed for key = " + i), (boolean)conKey);
                    } else {
                        TestCase.assertTrue((String)("containsKey() Validation failed for key = " + i), (boolean)conKey);
                    }
                    DistributedTestCase.getLogWriter().fine("containsKey() Validated entry for key = " + i);
                }
                for (i = 1; i <= 20; ++i) {
                    boolean conKey = pr.containsValueForKey((Object)Integer.toString(i));
                    if (i >= 2 && i <= 4 || i >= 7 && i <= 9) {
                        TestCase.assertFalse((String)("containsValueForKey() remove validation failed for key = " + i), (boolean)conKey);
                    } else {
                        TestCase.assertTrue((String)("containsValueForKey() Validation failed for key = " + i), (boolean)conKey);
                    }
                    DistributedTestCase.getLogWriter().fine("containsValueForKey() Validated entry for key = " + i);
                }
            }
        };
        this.vm0.invoke(validateRegionAPIs);
        this.vm1.invoke(validateRegionAPIs);
        this.vm2.invoke(validateRegionAPIs);
        this.vm3.invoke(validateRegionAPIs);
        this.vm0.invoke(new CacheSerializableRunnable("destroyRegionOp"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                Region pr = cache.getRegion(prName);
                TestCase.assertNotNull((String)"Region already destroyed.", (Object)pr);
                pr.destroyRegion();
                TestCase.assertTrue((String)"Region isDestroyed false", (boolean)pr.isDestroyed());
                TestCase.assertNull((String)"Region not destroyed.", (Object)cache.getRegion(prName));
            }
        });
        CacheSerializableRunnable validateAfterRegionDestroy = new CacheSerializableRunnable("validateInsertsAfterRegionDestroy"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                Region pr = null;
                pr = cache.getRegion(prName);
                TestCase.assertNull((String)"Region not destroyed.", (Object)pr);
                Region rootRegion = cache.getRegion("/__PR");
                Object configObj = rootRegion.get((Object)prName.substring(1));
                if (configObj != null) {
                    TestCase.fail((String)"PRConfig found in allPartitionedRegion Metadata for this PR.");
                }
                Set subreg = rootRegion.subregions(false);
                for (Region reg : subreg) {
                    String name = reg.getName();
                    if (name.indexOf("_B_") == -1) continue;
                    TestCase.fail((String)("Bucket exists. Bucket = " + name));
                }
                boolean con = PartitionedRegion.prIdToPR.containsKey((Object)"PR1");
                if (con) {
                    TestCase.fail((String)"prIdToPR contains pr reference ");
                }
            }
        };
        this.vm0.invoke(validateAfterRegionDestroy);
        this.vm1.invoke(validateAfterRegionDestroy);
        this.vm2.invoke(validateAfterRegionDestroy);
        this.vm3.invoke(validateAfterRegionDestroy);
    }

    public void partitionedRegionConcurrentMapTest(final String prName) {
        this.vm0.invoke(new CacheSerializableRunnable("doConcurrentMapOperations"){

            @Override
            public void run2() throws CacheException {
                int i;
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                PartitionedRegion pr = (PartitionedRegion)cache.getRegion(prName);
                TestCase.assertNotNull((String)(prName + " not created"), (Object)pr);
                for (int i2 = 1; i2 <= 5; ++i2) {
                    Object putResult = pr.putIfAbsent((Object)Integer.toString(i2), (Object)Integer.toString(i2));
                    TestCase.assertNull((String)("Expected null, but got " + putResult + "for key " + i2), (Object)putResult);
                }
                int size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                for (i = 1; i <= 5; ++i) {
                    Object putResult = pr.putIfAbsent((Object)Integer.toString(i), (Object)Integer.toString(i + 1));
                    TestCase.assertEquals((String)("for i=" + i), (Object)Integer.toString(i), (Object)putResult);
                    TestCase.assertEquals((String)("for i=" + i), (Object)Integer.toString(i), (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                for (i = 1; i <= 5; ++i) {
                    boolean replaceSucceeded = pr.replace((Object)Integer.toString(i), (Object)Integer.toString(i), (Object)("replaced" + i));
                    TestCase.assertTrue((String)("for i=" + i), (boolean)replaceSucceeded);
                    TestCase.assertEquals((String)("for i=" + i), (Object)("replaced" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                for (i = 1; i <= 10; ++i) {
                    boolean replaceSucceeded = pr.replace((Object)Integer.toString(i), (Object)Integer.toString(i), (Object)("not" + i));
                    TestCase.assertFalse((String)("for i=" + i), (boolean)replaceSucceeded);
                    TestCase.assertEquals((String)("for i=" + i), i <= 5 ? "replaced" + i : null, (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                for (i = 1; i <= 5; ++i) {
                    Object replaceResult = pr.replace((Object)Integer.toString(i), (Object)("twice replaced" + i));
                    TestCase.assertEquals((String)("for i=" + i), (Object)("replaced" + i), (Object)replaceResult);
                    TestCase.assertEquals((String)("for i=" + i), (Object)("twice replaced" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                for (i = 6; i <= 10; ++i) {
                    Object replaceResult = pr.replace((Object)Integer.toString(i), (Object)("thrice replaced" + i));
                    TestCase.assertNull((String)("for i=" + i), (Object)replaceResult);
                    TestCase.assertNull((String)("for i=" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                for (i = 1; i <= 10; ++i) {
                    boolean removeResult = pr.remove((Object)Integer.toString(i), (Object)Integer.toString(-i));
                    TestCase.assertFalse((String)("for i=" + i), (boolean)removeResult);
                    TestCase.assertEquals((String)("for i=" + i), i <= 5 ? "twice replaced" + i : null, (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
                for (i = 1; i <= 5; ++i) {
                    boolean removeResult = pr.remove((Object)Integer.toString(i), (Object)("twice replaced" + i));
                    TestCase.assertTrue((String)("for i=" + i), (boolean)removeResult);
                    TestCase.assertEquals((String)("for i=" + i), null, (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)0, (int)size);
                TestCase.assertTrue((String)"isEmpty doesnt return proper state of the PartitionedRegion", (boolean)pr.isEmpty());
            }
        });
        this.vm0.invoke(new CacheSerializableRunnable("destroyRegionOp"){

            @Override
            public void run2() {
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                Region pr = cache.getRegion(prName);
                TestCase.assertNotNull((String)"Region already destroyed.", (Object)pr);
                pr.destroyRegion();
                TestCase.assertTrue((String)"Region isDestroyed false", (boolean)pr.isDestroyed());
                TestCase.assertNull((String)"Region not destroyed.", (Object)cache.getRegion(prName));
            }
        });
    }

    public void testPartitionedRegionOperationsScopeDistAck() throws Exception {
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        VM accessor = this.vm3 = host.getVM(3);
        this.vm0.invoke(this.createPrRegionWithDS_DACK);
        this.vm1.invoke(this.createPrRegionOnlyAccessor_DACK);
        this.vm2.invoke(this.createPrRegionWithDS_DACK);
        accessor.invoke(this.createPrRegionOnlyAccessor_DACK);
        this.partitionedRegionTest("/PR1");
        this.vm0.invoke(this.createPrRegionWithDS_DACK);
        this.vm1.invoke(this.createPrRegionOnlyAccessor_DACK);
        this.vm2.invoke(this.createPrRegionWithDS_DACK);
        accessor.invoke(this.createPrRegionOnlyAccessor_DACK);
        this.partitionedRegionTestAfterDestroyRegion("/PR1");
        this.destroyTheRegion("/PR1");
    }

    public void testPartitionedRegionConcurrentOperations() throws Exception {
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        VM accessor = this.vm3 = host.getVM(3);
        this.vm0.invoke(this.createPrRegionWithDS_DACK);
        this.vm1.invoke(this.createPrRegionOnlyAccessor_DACK);
        this.vm2.invoke(this.createPrRegionWithDS_DACK);
        accessor.invoke(this.createPrRegionOnlyAccessor_DACK);
        this.partitionedRegionConcurrentMapTest("/PR1");
    }

    public void testPartitionedRegionsOperationsScopeDistEarlyAck() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        this.vm3 = host.getVM(3);
        CacheSerializableRunnable create = new CacheSerializableRunnable("createPRWithEarlyAck"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setEarlyAck(true);
                attr.setPartitionAttributes(new PartitionAttributesFactory().create());
                RegionAttributes regionAttribs = attr.create();
                Region partitionedregion = cache.createRegion(rName, regionAttribs);
                TestCase.assertNotNull((Object)partitionedregion);
                TestCase.assertNotNull((Object)cache.getRegion(rName));
            }
        };
        CacheSerializableRunnable createAccessor = new CacheSerializableRunnable("createPRAccessorWithEarlyAck"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setEarlyAck(true);
                PartitionAttributes prAttr = new PartitionAttributesFactory().setLocalMaxMemory(0).create();
                attr.setPartitionAttributes(prAttr);
                RegionAttributes regionAttribs = attr.create();
                Region partitionedregion = cache.createRegion(rName, regionAttribs);
                TestCase.assertNotNull((Object)partitionedregion);
                TestCase.assertNotNull((Object)cache.getRegion(rName));
            }
        };
        this.vm0.invoke(create);
        this.vm1.invoke(createAccessor);
        this.vm2.invoke(create);
        this.vm3.invoke(createAccessor);
        this.partitionedRegionTest(rName);
        this.vm0.invoke(create);
        this.vm1.invoke(createAccessor);
        this.vm2.invoke(create);
        this.vm3.invoke(createAccessor);
        this.partitionedRegionTestAfterDestroyRegion(rName);
        this.destroyTheRegion(rName);
    }

    public void testBug36685() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        this.vm3 = host.getVM(3);
        CacheSerializableRunnable create = new CacheSerializableRunnable("createPR"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                AttributesFactory attr = new AttributesFactory();
                attr.setDataPolicy(DataPolicy.PARTITION);
                RegionAttributes regionAttribs = attr.create();
                Region partitionedregion = cache.createRegion(rName, regionAttribs);
                TestCase.assertNotNull((Object)partitionedregion);
                TestCase.assertNotNull((Object)cache.getRegion(rName));
                PartitionAttributes p = regionAttribs.getPartitionAttributes();
                int maxMem = p.getLocalMaxMemory();
                TestCase.assertTrue((String)"LocalMaxMemory is zero", (maxMem != 0 ? 1 : 0) != 0);
            }
        };
        this.vm0.invoke(create);
        this.destroyTheRegion(rName);
    }

    public void destroyTheRegion(final String name) {
        this.vm0.invoke(new CacheSerializableRunnable("destroyRegionOp"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionAPIDUnitTest.this.getCache();
                Region pr = cache.getRegion(name);
                if (pr == null) {
                    TestCase.fail((String)(name + " not created"));
                }
                pr.destroyRegion();
            }
        });
    }

    @Override
    protected CacheSerializableRunnable addExceptionTag1(final String expectedException) {
        CacheSerializableRunnable addExceptionTag = new CacheSerializableRunnable("addExceptionTag"){

            @Override
            public void run2() {
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedException + "</ExpectedException>");
            }
        };
        return addExceptionTag;
    }

    @Override
    protected CacheSerializableRunnable removeExceptionTag1(final String expectedException) {
        CacheSerializableRunnable removeExceptionTag = new CacheSerializableRunnable("removeExceptionTag"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegionAPIDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedException + "</ExpectedException>");
            }
        };
        return removeExceptionTag;
    }

    public void testCacherLoaderHelper() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        int localMaxMemory = 10;
        String key1 = "key1";
        String arg = "loaderArg";
        CacheSerializableRunnable createLoaderPR = new CacheSerializableRunnable("createLoaderPR"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegionAPIDUnitTest.this.getCache();
                TestCacheLoader cl = new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        TestCase.assertNotNull((Object)helper);
                        TestCase.assertEquals((Object)"key1", (Object)helper.getKey());
                        TestCase.assertEquals((String)rName, (String)helper.getRegion().getName());
                        TestCase.assertEquals((Object)"loaderArg", (Object)helper.getArgument());
                        return helper.getArgument();
                    }
                };
                PartitionedRegion pr = (PartitionedRegion)new RegionFactory().setCacheLoader((CacheLoader)cl).setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(10).create()).create(rName);
                TestCase.assertSame((Object)cl, (Object)pr.getDataStore().getCacheLoader());
            }
        };
        vm2.invoke(createLoaderPR);
        vm3.invoke(createLoaderPR);
        this.getCache();
        Region pr = new RegionFactory().setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).setLocalMaxMemory(0).create()).create(rName);
        PartitionedRegionAPIDUnitTest.assertEquals((Object)"loaderArg", (Object)pr.get((Object)"key1", (Object)"loaderArg"));
    }
}

