/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;

public class MapClearGIITest
extends CacheTestCase {
    protected static boolean wasGIIInProgressDuringClear = false;
    static volatile Region region;

    public MapClearGIITest(String name) {
        super(name);
    }

    public static boolean checkImageStateFlag() throws Exception {
        Region rgn = new MapClearGIITest("dumb object to get cache").getCache().getRegion("/map");
        if (rgn == null) {
            MapClearGIITest.fail((String)"Map region not yet created");
        }
        if (((LocalRegion)rgn).getImageState().getClearRegionFlag()) {
            MapClearGIITest.fail((String)("The image state clear region flag should have been cleared (region size=" + rgn.size() + "). Hence failing"));
        }
        if (!wasGIIInProgressDuringClear) {
            MapClearGIITest.fail((String)("The clear operation invoked from VM1 reached VM0 after the GII completed, or it reached VM0 even before the region in  VM0 got inserted in the subregion Map (region size=" + rgn.size() + "). Hence failing"));
        }
        if (rgn.size() != 0) {
            MapClearGIITest.fail((String)("The clear operation invoked from VM1 should have made the size of region zero. Hence failing. Size = " + rgn.size()));
        }
        return true;
    }

    public static void createRegionInVm0() throws Exception {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setConcurrencyChecksEnabled(true);
        RegionAttributes attr = factory.create();
        region = new MapClearGIITest("dumb object to get cache").getCache().createRegion("map", attr);
        MapClearGIITest.getLogWriter().info("Region in VM0 created ");
    }

    public static void clearRegionInVm1() {
        final CacheDistributionAdvisor adv = ((DistributedRegion)region).getCacheDistributionAdvisor();
        boolean expectedProfiles = true;
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                int numProfiles = adv.adviseReplicates().size();
                return numProfiles == 1;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        region.clear();
        MapClearGIITest.assertEquals((int)0, (int)region.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClearImageStateFlag() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("createCacheVM0"){

            @Override
            public void run2() throws CacheException {
                InitialImageOperation.slowImageProcessing = 10;
                InitialImageOperation.slowImageSleeps = 0;
                Properties mprops = new Properties();
                MapClearGIITest.this.getSystem(mprops);
                MapClearGIITest.this.getCache();
                CacheObserverImpl observer = new CacheObserverImpl();
                CacheObserverHolder.setInstance((CacheObserver)observer);
                LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
            }
        });
        vm1.invoke(new CacheSerializableRunnable("createCacheVM1"){

            @Override
            public void run2() throws CacheException {
                Properties mprops = new Properties();
                MapClearGIITest.this.getSystem(mprops);
                MapClearGIITest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.REPLICATE);
                factory.setConcurrencyChecksEnabled(true);
                RegionAttributes attr = factory.create();
                region = MapClearGIITest.this.createRootRegion("map", attr);
                for (int i = 0; i < 10000; ++i) {
                    region.put((Object)("" + i), (Object)("" + i));
                }
            }
        });
        MapClearGIITest.getLogWriter().info("Cache created in VM1 successfully");
        try {
            AsyncInvocation asyncGII = vm0.invokeAsync(MapClearGIITest.class, "createRegionInVm0");
            vm0.invoke(new CacheSerializableRunnable("wait for sleeps"){

                @Override
                public void run2() throws CacheException {
                    DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return InitialImageOperation.slowImageSleeps >= 20;
                        }

                        @Override
                        public String description() {
                            return null;
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 30000L, 200L, true);
                }
            });
            vm1.invoke(MapClearGIITest.class, "clearRegionInVm1");
            DistributedTestCase.join(asyncGII, 30000L, MapClearGIITest.getLogWriter());
            if (asyncGII.exceptionOccurred()) {
                Throwable t = asyncGII.getException();
                MapClearGIITest.fail("createRegionInVM0 failed", t);
            }
            MapClearGIITest.assertTrue((boolean)vm0.invokeBoolean(MapClearGIITest.class, "checkImageStateFlag"));
            if (asyncGII.exceptionOccurred()) {
                MapClearGIITest.fail("asyncGII failed", asyncGII.getException());
            }
            vm0.invoke(new SerializableRunnable("Set fast image processing"){

                @Override
                public void run() {
                    InitialImageOperation.slowImageProcessing = 0;
                    InitialImageOperation.slowImageSleeps = 0;
                }
            });
        }
        catch (Exception e) {
            try {
                MapClearGIITest.fail("Test failed", e);
                vm0.invoke(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Throwable throwable) {
                vm0.invoke(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }

    public static class CacheObserverImpl
    extends CacheObserverAdapter {
        public void afterRegionClear(RegionEvent event) {
            DistributedTestCase.getLogWriter().info("**********Received clear event in VM0 . ");
            Region rgn = event.getRegion();
            wasGIIInProgressDuringClear = ((LocalRegion)rgn).getImageState().wasRegionClearedDuringGII();
            InitialImageOperation.slowImageProcessing = 0;
            InitialImageOperation.slowImageSleeps = 0;
            DistributedTestCase.getLogWriter().info("wasGIIInProgressDuringClear when clear event was received= " + wasGIIInProgressDuringClear);
        }
    }
}

