/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.ArrayList;
import java.util.Properties;
import junit.framework.TestCase;

public class HABug36773DUnitTest
extends DistributedTestCase {
    VM server1 = null;
    VM server2 = null;
    VM client1 = null;
    VM client2 = null;
    private static int PORT1;
    private static int PORT2;
    private static final String REGION_NAME = "HABug36773DUnitTest_region";
    static final String KEY1 = "key1";
    static final String KEY2 = "key2";
    static final String VALUE1 = "newVal1";
    static final String VALUE2 = "newVal2";
    static volatile boolean waitFlag;
    protected static Cache cache;

    public HABug36773DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        HABug36773DUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        this.server2 = host.getVM(1);
        this.client1 = host.getVM(2);
        this.client2 = host.getVM(3);
        PORT1 = (Integer)this.server1.invoke(HABug36773DUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.server2.invoke(HABug36773DUnitTest.class, "createServerCache");
        this.client1.invoke(HABug36773DUnitTest.class, "disableShufflingOfEndpoints");
        this.client2.invoke(HABug36773DUnitTest.class, "disableShufflingOfEndpoints");
        this.client1.invoke(HABug36773DUnitTest.class, "createClientCache", new Object[]{new Integer(PORT1), new Integer(PORT2)});
        this.client2.invoke(HABug36773DUnitTest.class, "createClientCache", new Object[]{new Integer(PORT1), new Integer(PORT2)});
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        HABug36773DUnitTest.assertNotNull((Object)cache);
    }

    public static void disableShufflingOfEndpoints() {
        System.setProperty("gemfire.bridge.disableShufflingOfEndpoints", "true");
    }

    public void _testBug36773() throws Exception {
        this.client1.invoke(HABug36773DUnitTest.class, "createEntriesK1andK2");
        this.client2.invoke(HABug36773DUnitTest.class, "createEntriesK1andK2");
        this.client1.invoke(HABug36773DUnitTest.class, "registerKeysK1andK2");
        this.client2.invoke(HABug36773DUnitTest.class, "registerKeysK1andK2");
        this.server1.invoke(this.checkSizeRegion(2));
        this.server2.invoke(this.checkSizeRegion(2));
        this.client1.invoke(this.checkSizeRegion(2));
        this.client2.invoke(this.checkSizeRegion(2));
        this.server1.invoke(HABug36773DUnitTest.class, "waitOnTheKeyEntry");
        this.client1.invoke(HABug36773DUnitTest.class, "acquireConnectionsAndPut", new Object[]{new Integer(PORT2)});
        this.client1.invoke(HABug36773DUnitTest.class, "acquireConnectionsAndPut", new Object[]{new Integer(PORT1)});
        this.client2.invoke(HABug36773DUnitTest.class, "verifyEntries", new Object[]{new String(KEY2), new String(VALUE2)});
        this.server1.invoke(HABug36773DUnitTest.class, "notfiyThread");
        this.client2.invoke(HABug36773DUnitTest.class, "verifyEntries", new Object[]{new String(KEY1), new String(VALUE1)});
    }

    public void testDummyForBug36773() {
        Log.getLogWriter().info(" This is the dummy test for the Bug 36773");
    }

    private CacheSerializableRunnable checkSizeRegion(final int size) {
        CacheSerializableRunnable checkRegion = new CacheSerializableRunnable("checkSize"){

            @Override
            public void run2() throws CacheException {
                Region region = cache.getRegion("/HABug36773DUnitTest_region");
                TestCase.assertNotNull((Object)region);
                Log.getLogWriter().info("Size of the region " + region.size());
                TestCase.assertEquals((int)size, (int)region.size());
            }
        };
        return checkRegion;
    }

    public static void acquireConnectionsAndPut(Integer portNumber) {
        try {
            int port = portNumber;
            Region r1 = cache.getRegion("/HABug36773DUnitTest_region");
            HABug36773DUnitTest.assertNotNull((Object)r1);
            PoolImpl pool = (PoolImpl)PoolManager.find((String)r1.getAttributes().getPoolName());
            HABug36773DUnitTest.assertNotNull((Object)pool);
            Connection conn = pool.acquireConnection();
            ServerRegionProxy srp = new ServerRegionProxy("/HABug36773DUnitTest_region", pool);
            Connection conn1 = conn.getServer().getPort() != port ? pool.acquireConnection() : conn;
            HABug36773DUnitTest.assertNotNull((Object)conn1);
            if (port == PORT2) {
                HABug36773DUnitTest.assertEquals((int)PORT2, (int)conn1.getServer().getPort());
                srp.putOnForTestsOnly(conn1, (Object)KEY1, (Object)VALUE1, new EventID(new byte[]{1}, 2L, 1L), null);
            } else if (port == PORT1) {
                HABug36773DUnitTest.assertEquals((int)PORT1, (int)conn1.getServer().getPort());
                srp.putOnForTestsOnly(conn1, (Object)KEY2, (Object)VALUE2, new EventID(new byte[]{1}, 2L, 2L), null);
            } else {
                HABug36773DUnitTest.fail((String)"Invalid ports ");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HABug36773DUnitTest.fail((String)("while setting acquireConnections  " + ex));
        }
    }

    public static void verifyEntries(String KEY, String VALUE) {
        Region r1 = cache.getRegion("/HABug36773DUnitTest_region");
        HABug36773DUnitTest.assertNotNull((Object)r1);
        long maxWaitTime = 120000L;
        try {
            long start = System.currentTimeMillis();
            while (!r1.getEntry((Object)KEY).getValue().equals(VALUE)) {
                HABug36773DUnitTest.assertTrue((String)("Waited over " + maxWaitTime + "entry to get updated"), (System.currentTimeMillis() - start < maxWaitTime ? 1 : 0) != 0);
                try {
                    Thread.yield();
                    Thread.sleep(700L);
                }
                catch (InterruptedException ie) {
                    HABug36773DUnitTest.fail("Interrupted while waiting ", ie);
                }
            }
        }
        catch (Exception e) {
            HABug36773DUnitTest.fail((String)("Exception in trying to get due to " + e));
        }
    }

    public static void createEntriesK1andK2() {
        try {
            Region r1 = cache.getRegion("/HABug36773DUnitTest_region");
            HABug36773DUnitTest.assertNotNull((Object)r1);
            if (!r1.containsKey((Object)KEY1)) {
                r1.create((Object)KEY1, (Object)"key-1");
            }
            if (!r1.containsKey((Object)KEY2)) {
                r1.create((Object)KEY2, (Object)"key-2");
            }
            HABug36773DUnitTest.assertEquals((Object)r1.getEntry((Object)KEY1).getValue(), (Object)"key-1");
            HABug36773DUnitTest.assertEquals((Object)r1.getEntry((Object)KEY2).getValue(), (Object)"key-2");
        }
        catch (Exception ex) {
            HABug36773DUnitTest.fail("failed while createEntriesK1andK2()", ex);
        }
    }

    public static void notfiyThread() {
        waitFlag = false;
    }

    public static void createClientCache(Integer port1, Integer port2) throws Exception {
        PORT1 = port1;
        PORT2 = port2;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new HABug36773DUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        BridgeTestCase.configureConnectionPool(factory, DistributedTestCase.getIPLiteral(), new int[]{PORT1, PORT2}, true, -1, 2, null);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static Integer createServerCache() throws Exception {
        new HABug36773DUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setEarlyAck(true);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server = cache.addBridgeServer();
        HABug36773DUnitTest.assertNotNull((Object)server);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void registerKeysK1andK2() {
        try {
            Region r = cache.getRegion("/HABug36773DUnitTest_region");
            HABug36773DUnitTest.assertNotNull((Object)r);
            ArrayList<String> list = new ArrayList<String>();
            list.add(KEY1);
            list.add(KEY2);
            r.registerInterest(list);
        }
        catch (Exception ex) {
            HABug36773DUnitTest.fail("failed while registering interest", ex);
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void waitOnTheKeyEntry() {
        Thread thrd = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RegionEntry regionEntry;
                LocalRegion region = (LocalRegion)cache.getRegion("/HABug36773DUnitTest_region");
                RegionEntry regionEntry2 = regionEntry = region.basicGetEntry((Object)HABug36773DUnitTest.KEY1);
                synchronized (regionEntry2) {
                    while (waitFlag) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                    }
                }
            }
        };
        thrd.start();
    }

    @Override
    public void tearDown2() throws Exception {
        this.client1.invoke(HABug36773DUnitTest.class, "closeCache");
        this.client2.invoke(HABug36773DUnitTest.class, "closeCache");
        this.server1.invoke(HABug36773DUnitTest.class, "closeCache");
        this.server2.invoke(HABug36773DUnitTest.class, "closeCache");
    }

    static {
        waitFlag = true;
        cache = null;
    }
}

