/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.DestroyOperation;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TombstoneService;
import com.gemstone.gemfire.internal.cache.UpdateOperation;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreID;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.shared.Version;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;

public class GIIDeltaDUnitTest
extends CacheTestCase {
    VM P;
    VM R;
    private static final long MAX_WAIT = 30000L;
    protected static String REGION_NAME = "_Region";
    final String expectedExceptions = GemFireIOException.class.getName();
    protected DistributedTestCase.ExpectedException expectedEx;
    static Object giiSyncObject = new Object();

    public GIIDeltaDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GIIDeltaDUnitTest.invokeInEveryVM(GIIDeltaDUnitTest.class, "setRegionName", new Object[]{this.getUniqueName()});
        GIIDeltaDUnitTest.setRegionName(this.getUniqueName());
    }

    public static void setRegionName(String testName) {
        REGION_NAME = testName + "_Region";
    }

    @Override
    public void tearDown2() throws Exception {
        this.P.invoke(GIIDeltaDUnitTest.class, "resetSlowGII");
        this.R.invoke(GIIDeltaDUnitTest.class, "resetSlowGII");
        this.P.invoke(InitialImageOperation.class, "resetAllGIITestHooks");
        this.R.invoke(InitialImageOperation.class, "resetAllGIITestHooks");
        this.changeUnfinishedOperationLimit(this.R, 10000);
        this.changeForceFullGII(this.R, false, false);
        this.changeForceFullGII(this.P, false, false);
        this.P = null;
        this.R = null;
        super.tearDown2();
        DistributedCacheOperation.SLOW_DISTRIBUTION_MS = 0L;
        if (this.expectedEx != null) {
            this.expectedEx.remove();
        }
    }

    protected void prepareForEachTest() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createDistributedRegion(vm0);
        this.createDistributedRegion(vm1);
        this.assignVMsToPandR(vm0, vm1);
        this.expectedEx = GIIDeltaDUnitTest.addExpectedException(this.expectedExceptions);
    }

    private void prepareCommonTestData(int p_version) {
        this.assertDeltaGIICountBeZero(this.P);
        this.assertDeltaGIICountBeZero(this.R);
        this.doOnePut(this.P, 1L, "key1");
        this.doOnePut(this.R, 1L, "key2");
        this.doOnePut(this.R, 2L, "key5");
        this.createConflictOperationsP2R3();
        block6: for (int i = 3; i <= p_version; ++i) {
            switch (i) {
                case 3: {
                    this.doOneDestroy(this.P, 3L, "key1");
                    continue block6;
                }
                case 4: {
                    this.doOneDestroy(this.P, 4L, "key2");
                    continue block6;
                }
                case 5: {
                    this.doOnePut(this.P, 5L, "key1");
                    continue block6;
                }
                case 6: {
                    this.doOnePut(this.P, 6L, "key3");
                }
            }
        }
    }

    private void createConflictOperationsP2R3() {
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] blocklist = new long[]{2L, 3L};
        this.P.invoke(GIIDeltaDUnitTest.class, "slowGII", new Object[]{blocklist});
        this.R.invoke(GIIDeltaDUnitTest.class, "slowGII", new Object[]{blocklist});
        AsyncInvocation async1 = this.doOnePutAsync(this.P, 2L, "key1");
        AsyncInvocation async2 = this.doOnePutAsync(this.R, 3L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 2L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 2L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 1L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 3L, null, 0L);
        this.P.invoke(GIIDeltaDUnitTest.class, "resetSlowGII");
        this.R.invoke(GIIDeltaDUnitTest.class, "resetSlowGII");
        this.checkAsyncCall(async1);
        this.checkAsyncCall(async2);
        this.waitForToVerifyRVV(this.P, memberP, 2L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 2L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 3L, null, 0L);
        this.waitToVerifyKey(this.P, "key1", this.generateValue(this.P));
        this.waitToVerifyKey(this.R, "key1", this.generateValue(this.P));
    }

    private void createUnfinishedOperationsR4R5() {
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        this.R.invoke(GIIDeltaDUnitTest.class, "slowGII", new Object[]{exceptionlist});
        AsyncInvocation async1 = this.doOnePutAsync(this.R, 4L, "key4");
        this.waitForToVerifyRVV(this.R, memberR, 4L, null, 0L);
        AsyncInvocation async2 = this.doOneDestroyAsync(this.R, 5L, "key5");
        this.waitForToVerifyRVV(this.R, memberR, 5L, null, 0L);
        this.doOnePut(this.R, 6L, "key1");
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
    }

    public void testDeltaGIIWithSameRVV() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.forceGC(this.P, 2);
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        this.doOnePut(this.R, 4L, "key4");
        this.doOneDestroy(this.R, 5L, "key5");
        this.doOnePut(this.R, 6L, "key1");
        this.doOnePut(this.P, 7L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 0, 1);
    }

    public void testDeltaGIIWithExceptionList() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        VersionTag expect_tag = this.getVersionTag(this.R, "key5");
        this.forceGC(this.P, 2);
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        this.createUnfinishedOperationsR4R5();
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.doOnePut(this.P, 7L, "key1");
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, exceptionlist, 0L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 2, 1);
        this.waitToVerifyKey(this.R, "key5", this.generateValue(this.R));
        VersionTag tag = this.getVersionTag(this.R, "key5");
        GIIDeltaDUnitTest.assertTrue((boolean)expect_tag.equals((Object)tag));
        this.closeCache(this.P);
        this.createDistributedRegion(this.P);
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.verifyDeltaSizeFromStats(this.P, 0, 1);
    }

    public void testDeltaGIIWithOnlyUnfinishedOp() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        VersionTag expect_tag = this.getVersionTag(this.R, "key5");
        this.forceGC(this.P, 2);
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        this.createUnfinishedOperationsR4R5();
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 6L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, exceptionlist, 0L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 1, 1);
        this.waitToVerifyKey(this.R, "key5", this.generateValue(this.R));
        VersionTag tag = this.getVersionTag(this.R, "key5");
        GIIDeltaDUnitTest.assertTrue((boolean)expect_tag.equals((Object)tag));
        this.closeCache(this.P);
        this.createDistributedRegion(this.P);
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.verifyDeltaSizeFromStats(this.P, 0, 1);
        this.forceGC(this.R, 1);
        this.closeCache(this.R);
        this.createDistributedRegion(this.R);
        this.verifyDeltaSizeFromStats(this.R, 0, 1);
        this.waitToVerifyKey(this.R, "key5", this.generateValue(this.R));
        tag = this.getVersionTag(this.R, "key5");
        GIIDeltaDUnitTest.assertTrue((boolean)expect_tag.equals((Object)tag));
    }

    public void testDeltaGIIWithOnlyUnfinishedOp_GCAtR() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        VersionTag expect_tag = this.getVersionTag(this.R, "key5");
        this.forceGC(this.P, 2);
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        this.createUnfinishedOperationsR4R5();
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterRequestRVV = new Mycallback(InitialImageOperation.GIITestHookType.AfterRequestRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterRequestRVV);
            }
        });
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        AsyncInvocation async3 = this.createDistributedRegionAsync(this.R);
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterRequestRVV);
        this.forceGC(this.R, 1);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterRequestRVV, true});
        async3.join(30000L);
        this.waitToVerifyKey(this.R, "key5", this.generateValue(this.R));
        VersionTag tag = this.getVersionTag(this.R, "key5");
        GIIDeltaDUnitTest.assertTrue((boolean)expect_tag.equals((Object)tag));
        this.verifyTombstoneExist(this.R, "key5", false, false);
        this.verifyDeltaSizeFromStats(this.R, 3, 0);
    }

    public void testDeltaGIIWithDifferentRVVGC() throws Throwable {
        String testcase = "testDeltaGIIWithExceptionList";
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 0L);
        VersionTag expect_tag = this.getVersionTag(this.R, "key5");
        this.createUnfinishedOperationsR4R5();
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.changeTombstoneTimout(this.R, 30000L);
        this.changeTombstoneTimout(this.P, 30000L);
        GIIDeltaDUnitTest.pause(30000);
        this.forceGC(this.P, 2);
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 4L);
        this.doOnePut(this.P, 7L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 4L);
        this.verifyTombstoneExist(this.P, "key2", false, false);
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, exceptionlist, 0L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 2, 1);
        this.waitToVerifyKey(this.R, "key5", this.generateValue(this.R));
        VersionTag tag = this.getVersionTag(this.R, "key5");
        GIIDeltaDUnitTest.assertTrue((boolean)expect_tag.equals((Object)tag));
        this.verifyTombstoneExist(this.R, "key2", true, true);
        this.verifyTombstoneExist(this.P, "key2", false, false);
    }

    public void testFullGIITriggeredByHigherRVVGC() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(3);
        this.waitForToVerifyRVV(this.P, memberP, 3L, null, 0L);
        this.createUnfinishedOperationsR4R5();
        this.waitForToVerifyRVV(this.R, memberP, 3L, null, 0L);
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.doOneDestroy(this.P, 4L, "key2");
        this.doOnePut(this.P, 5L, "key1");
        this.doOnePut(this.P, 6L, "key3");
        this.doOnePut(this.P, 7L, "key1");
        this.P.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterReceivedRequestImage = new Mycallback(InitialImageOperation.GIITestHookType.AfterReceivedRequestImage, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterReceivedRequestImage);
            }
        });
        AsyncInvocation async3 = this.createDistributedRegionAsync(this.R);
        this.waitForCallbackStarted(this.P, InitialImageOperation.GIITestHookType.AfterReceivedRequestImage);
        this.forceGC(this.P, 2);
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, true);
        this.P.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterReceivedRequestImage, true});
        async3.join(30000L);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, exceptionlist, 0L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 3, 0);
    }

    public void testSavingRVVGC() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        Host host = Host.getHost(0);
        VM T = host.getVM(2);
        this.createDistributedRegion(T);
        DiskStoreID memberT = this.getMemberID(T);
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(3);
        this.waitForToVerifyRVV(this.P, memberP, 3L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 3L, null, 0L);
        this.waitForToVerifyRVV(T, memberP, 3L, null, 0L);
        this.closeCache(T);
        this.closeCache(this.R);
        this.doOneDestroy(this.P, 4L, "key2");
        this.doOnePut(this.P, 5L, "key1");
        this.doOnePut(this.P, 6L, "key3");
        this.doOnePut(this.P, 7L, "key1");
        this.forceGC(this.P, 2);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 3L, null, 0L);
        this.verifyDeltaSizeFromStats(this.R, 3, 0);
        this.verifyTombstoneExist(this.P, "key2", false, false);
        this.verifyTombstoneExist(this.R, "key2", false, false);
        this.closeCache(this.P);
        this.closeCache(this.R);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 3L, null, 0L);
        this.verifyTombstoneExist(this.R, "key2", false, false);
        this.createDistributedRegion(T);
        this.waitForToVerifyRVV(T, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(T, memberR, 3L, null, 0L);
        this.verifyDeltaSizeFromStats(T, 3, 0);
        this.verifyTombstoneExist(T, "key2", false, false);
    }

    public void testDeltaGIIWithoutRVVGC() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        VersionTag expect_tag = this.getVersionTag(this.R, "key5");
        this.createUnfinishedOperationsR4R5();
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.doOnePut(this.P, 7L, "key1");
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, exceptionlist, 0L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 2, 1);
        this.waitToVerifyKey(this.R, "key5", this.generateValue(this.R));
        VersionTag tag = this.getVersionTag(this.R, "key5");
        GIIDeltaDUnitTest.assertTrue((boolean)expect_tag.equals((Object)tag));
    }

    public void testFullGIINotDorminatedByProviderRVVGC() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(3);
        this.createUnfinishedOperationsR4R5();
        this.waitForToVerifyRVV(this.P, memberP, 3L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 3L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        this.doOneDestroy(this.P, 4L, "key2");
        this.doOnePut(this.P, 5L, "key1");
        this.doOnePut(this.P, 6L, "key3");
        this.doOnePut(this.P, 7L, "key1");
        long[] exceptionlist2 = new long[]{8L};
        this.P.invoke(GIIDeltaDUnitTest.class, "slowGII", new Object[]{exceptionlist2});
        AsyncInvocation async1 = this.doOneDestroyAsync(this.P, 8L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 8L, null, 0L);
        this.doOnePut(this.P, 9L, "key3");
        this.waitForToVerifyRVV(this.P, memberP, 9L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 9L, exceptionlist2, 0L);
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.forceGC(this.P, 3);
        this.waitForToVerifyRVV(this.P, memberP, 9L, null, 8L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, true);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.R, memberP, 9L, null, 8L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, exceptionlist, 0L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 2, 0);
    }

    public void testUnfinishedOpsWithoutExceptionList() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        VersionTag expect_tag = this.getVersionTag(this.R, "key5");
        long[] exceptionlist = new long[]{4L, 5L};
        this.R.invoke(GIIDeltaDUnitTest.class, "slowGII", new Object[]{exceptionlist});
        AsyncInvocation async1 = this.doOnePutAsync(this.R, 4L, "key4");
        this.waitForToVerifyRVV(this.R, memberR, 4L, null, 0L);
        AsyncInvocation async2 = this.doOneDestroyAsync(this.R, 5L, "key5");
        this.waitForToVerifyRVV(this.R, memberR, 5L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        this.doOnePut(this.P, 7L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 5L, null, 0L);
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 3L, exceptionlist, 0L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 1, 1);
        this.waitToVerifyKey(this.R, "key5", this.generateValue(this.R));
        VersionTag tag = this.getVersionTag(this.R, "key5");
        GIIDeltaDUnitTest.assertTrue((boolean)expect_tag.equals((Object)tag));
        this.closeCache(this.R);
        this.createDistributedRegion(this.R);
        this.doOnePut(this.R, 6L, "key1");
        this.waitForToVerifyRVV(this.R, memberR, 6L, exceptionlist, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
    }

    public void testFillSpecialException() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        this.doOnePut(this.P, 1L, "key1");
        this.doOnePut(this.P, 2L, "key2");
        this.doOneDestroy(this.P, 3L, "key1");
        this.changeForceFullGII(this.R, false, true);
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myBeforeSavedReceivedRVV = new Mycallback(InitialImageOperation.GIITestHookType.BeforeSavedReceivedRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myBeforeSavedReceivedRVV);
            }
        });
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterSavedReceivedRVV = new Mycallback(InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterSavedReceivedRVV);
            }
        });
        this.closeCache(this.R);
        this.changeForceFullGII(this.R, true, false);
        AsyncInvocation async3 = this.createDistributedRegionAsync(this.R);
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.BeforeSavedReceivedRVV);
        this.doOneDestroy(this.P, 4L, "key2");
        this.doOnePut(this.P, 5L, "key1");
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.BeforeSavedReceivedRVV, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, true});
        async3.join(30000L);
        this.waitForToVerifyRVV(this.R, memberP, 5L, null, 0L);
        this.changeForceFullGII(this.R, true, true);
        this.changeForceFullGII(this.P, false, true);
        this.verifyDeltaSizeFromStats(this.R, 2, 0);
    }

    public void testFillSpecialException2() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        this.doOnePut(this.P, 1L, "key1");
        this.doOnePut(this.P, 2L, "key2");
        this.doOneDestroy(this.P, 3L, "key1");
        this.changeForceFullGII(this.R, false, true);
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterCalculatedUnfinishedOps = new Mycallback(InitialImageOperation.GIITestHookType.AfterCalculatedUnfinishedOps, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterCalculatedUnfinishedOps);
            }
        });
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterSavedReceivedRVV = new Mycallback(InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterSavedReceivedRVV);
            }
        });
        this.closeCache(this.R);
        AsyncInvocation async3 = this.createDistributedRegionAsync(this.R);
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterCalculatedUnfinishedOps);
        this.doOneDestroy(this.P, 4L, "key2");
        this.doOnePut(this.P, 5L, "key1");
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterCalculatedUnfinishedOps, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, true});
        async3.join(30000L);
        this.waitForToVerifyRVV(this.R, memberP, 5L, null, 0L);
        this.verifyDeltaSizeFromStats(this.R, 2, 1);
        this.changeForceFullGII(this.R, false, true);
        this.changeForceFullGII(this.P, false, true);
    }

    public void testHooks() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        VersionTag expect_tag = this.getVersionTag(this.R, "key5");
        long[] exceptionlist = new long[]{4L, 5L};
        this.R.invoke(GIIDeltaDUnitTest.class, "slowGII", new Object[]{exceptionlist});
        AsyncInvocation async1 = this.doOnePutAsync(this.R, 4L, "key4");
        this.waitForToVerifyRVV(this.R, memberR, 4L, null, 0L);
        AsyncInvocation async2 = this.doOneDestroyAsync(this.R, 5L, "key5");
        this.waitForToVerifyRVV(this.R, memberR, 5L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myBeforeRequestRVV = new Mycallback(InitialImageOperation.GIITestHookType.BeforeRequestRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myBeforeRequestRVV);
            }
        });
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterRequestRVV = new Mycallback(InitialImageOperation.GIITestHookType.AfterRequestRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterRequestRVV);
            }
        });
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterCalculatedUnfinishedOps = new Mycallback(InitialImageOperation.GIITestHookType.AfterCalculatedUnfinishedOps, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterCalculatedUnfinishedOps);
            }
        });
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myBeforeSavedReceivedRVV = new Mycallback(InitialImageOperation.GIITestHookType.BeforeSavedReceivedRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myBeforeSavedReceivedRVV);
            }
        });
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterSavedReceivedRVV = new Mycallback(InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterSavedReceivedRVV);
            }
        });
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterSentRequestImage = new Mycallback(InitialImageOperation.GIITestHookType.AfterSentRequestImage, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterSentRequestImage);
            }
        });
        this.P.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterReceivedRequestImage = new Mycallback(InitialImageOperation.GIITestHookType.AfterReceivedRequestImage, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterReceivedRequestImage);
            }
        });
        this.P.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myDuringPackingImage = new Mycallback(InitialImageOperation.GIITestHookType.DuringPackingImage, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myDuringPackingImage);
            }
        });
        this.P.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterSentImageReply = new Mycallback(InitialImageOperation.GIITestHookType.AfterSentImageReply, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterSentImageReply);
            }
        });
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterReceivedImageReply = new Mycallback(InitialImageOperation.GIITestHookType.AfterReceivedImageReply, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterReceivedImageReply);
            }
        });
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myDuringApplyDelta = new Mycallback(InitialImageOperation.GIITestHookType.DuringApplyDelta, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myDuringApplyDelta);
            }
        });
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myBeforeCleanExpiredTombstones = new Mycallback(InitialImageOperation.GIITestHookType.BeforeCleanExpiredTombstones, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myBeforeCleanExpiredTombstones);
            }
        });
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterSavedRVVEnd = new Mycallback(InitialImageOperation.GIITestHookType.AfterSavedRVVEnd, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterSavedRVVEnd);
            }
        });
        this.waitForToVerifyRVV(this.R, memberP, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 5L, null, 0L);
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.doOnePut(this.P, 7L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        AsyncInvocation async3 = this.createDistributedRegionAsync(this.R);
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.BeforeRequestRVV);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.BeforeRequestRVV, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterRequestRVV);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterRequestRVV, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterCalculatedUnfinishedOps);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterCalculatedUnfinishedOps, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.BeforeSavedReceivedRVV);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.BeforeSavedReceivedRVV, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterSentRequestImage);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterSentRequestImage, true});
        this.waitForCallbackStarted(this.P, InitialImageOperation.GIITestHookType.AfterReceivedRequestImage);
        this.P.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterReceivedRequestImage, true});
        this.waitForCallbackStarted(this.P, InitialImageOperation.GIITestHookType.DuringPackingImage);
        this.P.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.DuringPackingImage, true});
        this.waitForCallbackStarted(this.P, InitialImageOperation.GIITestHookType.AfterSentImageReply);
        this.P.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterSentImageReply, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterReceivedImageReply);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterReceivedImageReply, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.DuringApplyDelta);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.DuringApplyDelta, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.BeforeCleanExpiredTombstones);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.BeforeCleanExpiredTombstones, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterSavedRVVEnd);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterSavedRVVEnd, true});
        async3.join(30000L);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 3L, exceptionlist, 0L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 2, 1);
        this.waitToVerifyKey(this.R, "key5", this.generateValue(this.R));
        VersionTag tag = this.getVersionTag(this.R, "key5");
        GIIDeltaDUnitTest.assertTrue((boolean)expect_tag.equals((Object)tag));
        this.doOnePut(this.R, 6L, "key1");
        this.waitForToVerifyRVV(this.R, memberR, 6L, exceptionlist, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.P.invoke(InitialImageOperation.class, "resetAllGIITestHooks");
    }

    public void testTombstoneGCInMiddleOfGII() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        Host host = Host.getHost(0);
        VM T = host.getVM(2);
        this.createDistributedRegion(T);
        DiskStoreID memberT = this.getMemberID(T);
        this.closeCache(T);
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(3);
        this.waitForToVerifyRVV(this.P, memberP, 3L, null, 0L);
        VersionTag expect_tag = this.getVersionTag(this.R, "key5");
        this.createUnfinishedOperationsR4R5();
        this.waitForToVerifyRVV(this.R, memberP, 3L, null, 0L);
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.doOneDestroy(this.P, 4L, "key2");
        this.doOnePut(this.P, 5L, "key1");
        this.doOnePut(this.P, 6L, "key3");
        this.doOnePut(this.P, 7L, "key1");
        this.P.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myDuringPackingImage = new Mycallback(InitialImageOperation.GIITestHookType.DuringPackingImage, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myDuringPackingImage);
            }
        });
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        AsyncInvocation async3 = this.createDistributedRegionAsync(this.R);
        AsyncInvocation async4 = this.createDistributedRegionAsync(T);
        this.waitForCallbackStarted(this.P, InitialImageOperation.GIITestHookType.DuringPackingImage);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                int count = GIIDeltaDUnitTest.this.getDeltaGIICount(GIIDeltaDUnitTest.this.P);
                return count == 2;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 30000L, 200L, true);
        int count = this.getDeltaGIICount(this.P);
        GIIDeltaDUnitTest.assertEquals((int)2, (int)count);
        this.changeTombstoneTimout(this.R, 30000L);
        this.changeTombstoneTimout(this.P, 30000L);
        this.changeTombstoneTimout(T, 30000L);
        GIIDeltaDUnitTest.pause(30000);
        this.forceGC(this.P, 2);
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 0L);
        this.P.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.DuringPackingImage, false});
        this.P.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.DuringPackingImage, true});
        DistributedTestCase.WaitCriterion ev2 = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                int count = GIIDeltaDUnitTest.this.getDeltaGIICount(GIIDeltaDUnitTest.this.P);
                return count == 0;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev2, 30000L, 200L, true);
        count = this.getDeltaGIICount(this.P);
        GIIDeltaDUnitTest.assertEquals((int)0, (int)count);
        this.verifyTombstoneExist(this.P, "key2", true, true);
        this.verifyTombstoneExist(this.R, "key2", true, true);
        this.verifyTombstoneExist(T, "key2", true, true);
        this.forceGC(this.P, 1);
        async3.join(30000L);
        async4.join(30000L);
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, exceptionlist, 0L);
        this.verifyTombstoneExist(this.P, "key2", false, true);
        this.verifyTombstoneExist(this.R, "key2", false, true);
        this.verifyTombstoneExist(T, "key2", false, true);
        this.doOnePut(T, 1L, "key1");
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        RegionVersionVector t_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.assertSameRVV(t_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 4, 1);
        this.waitToVerifyKey(this.R, "key5", this.generateValue(this.R));
        VersionTag tag = this.getVersionTag(this.R, "key5");
        GIIDeltaDUnitTest.assertTrue((boolean)expect_tag.equals((Object)tag));
    }

    public void testExpiredTombstoneSkippedAtProviderOnly() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.doOnePut(this.R, 4L, "key4");
        this.doOneDestroy(this.R, 5L, "key5");
        this.doOnePut(this.R, 6L, "key1");
        this.waitForToVerifyRVV(this.R, memberP, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.doOnePut(this.P, 7L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
        this.P.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myDuringPackingImage = new Mycallback(InitialImageOperation.GIITestHookType.DuringPackingImage, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myDuringPackingImage);
            }
        });
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        AsyncInvocation async3 = this.createDistributedRegionAsync(this.R);
        this.waitForCallbackStarted(this.P, InitialImageOperation.GIITestHookType.DuringPackingImage);
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                int count = GIIDeltaDUnitTest.this.getDeltaGIICount(GIIDeltaDUnitTest.this.P);
                return count == 1;
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 30000L, 200L, true);
        int count = this.getDeltaGIICount(this.P);
        GIIDeltaDUnitTest.assertEquals((int)1, (int)count);
        this.changeTombstoneTimout(this.R, 30000L);
        this.changeTombstoneTimout(this.P, 30000L);
        GIIDeltaDUnitTest.pause(30000);
        this.forceGC(this.R, 3);
        this.forceGC(this.P, 3);
        this.P.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.DuringPackingImage, true});
        async3.join(60000L);
        count = this.getDeltaGIICount(this.P);
        GIIDeltaDUnitTest.assertEquals((int)0, (int)count);
        this.verifyDeltaSizeFromStats(this.R, 1, 1);
        this.verifyTombstoneExist(this.R, "key2", false, false);
        this.verifyTombstoneExist(this.R, "key5", false, false);
        this.verifyTombstoneExist(this.P, "key2", true, true);
        this.verifyTombstoneExist(this.P, "key5", true, true);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        System.out.println("GGG:p_rvv=" + p_rvv.fullToString() + ":r_rvv=" + r_rvv.fullToString());
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 5L);
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
    }

    public void testRequesterHasHigherRVVGC() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.doOnePut(this.R, 4L, "key4");
        this.doOneDestroy(this.R, 5L, "key5");
        this.doOnePut(this.R, 6L, "key1");
        this.forceAddGIICount(this.P);
        this.changeTombstoneTimout(this.R, 30000L);
        this.changeTombstoneTimout(this.P, 30000L);
        GIIDeltaDUnitTest.pause(30000);
        this.forceGC(this.R, 3);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 6L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 5L);
        this.verifyTombstoneExist(this.R, "key5", false, false);
        this.verifyTombstoneExist(this.P, "key5", true, true);
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.doOnePut(this.P, 7L, "key1");
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 4L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 5L);
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
        this.verifyDeltaSizeFromStats(this.R, 1, 1);
        this.verifyTombstoneExist(this.R, "key5", false, false);
        this.verifyTombstoneExist(this.P, "key5", true, true);
    }

    public void testDeltaGIIAfterClear() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.doOnePut(this.R, 4L, "key4");
        this.doOneDestroy(this.R, 5L, "key5");
        this.doOnePut(this.R, 6L, "key1");
        this.doOnePut(this.P, 7L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        this.doOneClear(this.P, 8L);
        this.waitForToVerifyRVV(this.P, memberP, 8L, null, 8L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 6L);
        this.waitForToVerifyRVV(this.R, memberP, 8L, null, 8L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 6L);
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.doOnePut(this.P, 9L, "key3");
        this.waitForToVerifyRVV(this.P, memberP, 9L, null, 8L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 6L);
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        this.closeCache(this.P);
        this.createDistributedRegion(this.P);
        this.waitForToVerifyRVV(this.P, memberP, 9L, null, 8L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 6L);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.R, memberP, 9L, null, 8L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 6L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 1, 1);
    }

    public void testClearAfterChunkEntries() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.doOnePut(this.R, 4L, "key4");
        this.doOneDestroy(this.R, 5L, "key5");
        this.doOnePut(this.R, 6L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterReceivedImageReply = new Mycallback(InitialImageOperation.GIITestHookType.AfterReceivedImageReply, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterReceivedImageReply);
            }
        });
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.doOnePut(this.P, 7L, "key1");
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, false);
        AsyncInvocation async3 = this.createDistributedRegionAsync(this.R);
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterReceivedImageReply);
        this.doOneClear(this.P, 8L);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterReceivedImageReply, true});
        async3.join(30000L);
        this.waitForToVerifyRVV(this.P, memberP, 8L, null, 8L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 6L);
        this.closeCache(this.R);
        this.createDistributedRegion(this.R);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.waitForToVerifyRVV(this.R, memberP, 8L, null, 8L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 6L);
        this.waitToVerifyKey(this.P, "key1", null);
        this.waitToVerifyKey(this.R, "key1", null);
        this.verifyDeltaSizeFromStats(this.R, 0, 0);
    }

    public void testClearAfterSavedRVV() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.doOnePut(this.R, 4L, "key4");
        this.doOneDestroy(this.R, 5L, "key5");
        this.doOnePut(this.R, 6L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterSavedReceivedRVV = new Mycallback(InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterSavedReceivedRVV);
            }
        });
        this.closeCache(this.R);
        this.doOnePut(this.P, 7L, "key1");
        AsyncInvocation async3 = this.createDistributedRegionAsync(this.R);
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV);
        this.doOneClear(this.P, 8L);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, true});
        async3.join(30000L);
        this.waitForToVerifyRVV(this.P, memberP, 8L, null, 8L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 6L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.waitForToVerifyRVV(this.R, memberP, 8L, null, 8L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 6L);
        this.waitToVerifyKey(this.P, "key1", null);
        this.waitToVerifyKey(this.R, "key1", null);
        this.verifyDeltaSizeFromStats(this.R, 0, 0);
    }

    public void testFullGIIAfterClear() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.createUnfinishedOperationsR4R5();
        this.doOnePut(this.P, 7L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, exceptionlist, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        byte[] R_rvv_bytes = this.getRVVByteArray(this.R, REGION_NAME);
        this.closeCache(this.R);
        this.doOneClear(this.P, 8L);
        this.waitForToVerifyRVV(this.P, memberP, 8L, null, 8L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 6L);
        this.doOnePut(this.P, 9L, "key3");
        this.waitForToVerifyRVV(this.P, memberP, 9L, null, 8L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 6L);
        this.checkIfFullGII(this.P, REGION_NAME, R_rvv_bytes, true);
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.R, memberP, 9L, null, 8L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 6L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.verifyDeltaSizeFromStats(this.R, 1, 0);
    }

    public void testFullGIITriggeredByTooManyUnfinishedOps() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.forceGC(this.P, 2);
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 4L);
        this.waitForToVerifyRVV(this.P, memberR, 3L, null, 0L);
        this.createUnfinishedOperationsR4R5();
        this.closeCache(this.R);
        this.doOnePut(this.P, 7L, "key1");
        this.changeUnfinishedOperationLimit(this.R, 1);
        this.createDistributedRegion(this.R);
        this.verifyDeltaSizeFromStats(this.R, 3, 0);
    }

    public void testRestartWithOnlyGIIBegion() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        long[] exceptionlist = new long[]{4L, 5L};
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.doOnePut(this.R, 4L, "key4");
        this.doOneDestroy(this.R, 5L, "key5");
        this.doOnePut(this.R, 6L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myAfterSavedReceivedRVV = new Mycallback(InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterSavedReceivedRVV);
            }
        });
        this.closeCache(this.R);
        this.doOnePut(this.P, 7L, "key1");
        AsyncInvocation async3 = this.createDistributedRegionAsync(this.R);
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV);
        this.closeCache(this.R);
        async3.join(30000L);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, true});
        this.createDistributedRegion(this.R);
        this.waitForToVerifyRVV(this.P, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
        RegionVersionVector p_rvv = this.getRVV(this.P);
        RegionVersionVector r_rvv = this.getRVV(this.R);
        this.assertSameRVV(p_rvv, r_rvv);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        this.verifyDeltaSizeFromStats(this.R, 5, 0);
    }

    public void testRecoverFromUntrustedRVV() throws Throwable {
        this.prepareForEachTest();
        DiskStoreID memberP = this.getMemberID(this.P);
        DiskStoreID memberR = this.getMemberID(this.R);
        GIIDeltaDUnitTest.assertEquals((long)0L, (long)DistributedCacheOperation.SLOW_DISTRIBUTION_MS);
        this.prepareCommonTestData(6);
        this.doOnePut(this.R, 4L, "key4");
        this.doOneDestroy(this.R, 5L, "key5");
        this.doOnePut(this.R, 6L, "key1");
        this.waitForToVerifyRVV(this.P, memberP, 6L, null, 0L);
        this.waitForToVerifyRVV(this.P, memberR, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberP, 6L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
        this.R.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Mycallback myBeforeSavedReceivedRVV = new Mycallback(InitialImageOperation.GIITestHookType.BeforeSavedReceivedRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myBeforeSavedReceivedRVV);
                Mycallback myAfterSavedReceivedRVV = new Mycallback(InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, REGION_NAME);
                InitialImageOperation.setGIITestHook((InitialImageOperation.GIITestHook)myAfterSavedReceivedRVV);
            }
        });
        this.closeCache(this.R);
        AsyncInvocation async3 = this.createDistributedRegionAsync(this.R);
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.BeforeSavedReceivedRVV);
        this.doOnePut(this.P, 7L, "key1");
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.BeforeSavedReceivedRVV, true});
        this.waitForCallbackStarted(this.R, InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV);
        this.destroyRegion(this.P);
        this.R.invoke(InitialImageOperation.class, "resetGIITestHook", new Object[]{InitialImageOperation.GIITestHookType.AfterSavedReceivedRVV, true});
        async3.join(30000L);
        this.waitForToVerifyRVV(this.R, memberP, 7L, null, 0L);
        this.waitForToVerifyRVV(this.R, memberR, 6L, null, 0L);
    }

    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        factory.setConcurrencyChecksEnabled(true);
        return factory.create();
    }

    protected void createDistributedRegion(VM vm) {
        AsyncInvocation future = this.createDistributedRegionAsync(vm);
        try {
            future.join(30000L);
        }
        catch (InterruptedException e) {
            GIIDeltaDUnitTest.fail("Create region is interrupted", e);
        }
        if (future.isAlive()) {
            GIIDeltaDUnitTest.fail((String)"Region not created within30000");
        }
        if (future.exceptionOccurred()) {
            throw new RuntimeException(future.getException());
        }
    }

    protected AsyncInvocation createDistributedRegionAsync(VM vm) {
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    String value = System.getProperty("gemfire.no-flush-on-close");
                    TestCase.assertNull((Object)value);
                    RegionFactory f = GIIDeltaDUnitTest.this.getCache().createRegionFactory(GIIDeltaDUnitTest.this.getRegionAttributes());
                    LocalRegion lr = (LocalRegion)f.create(REGION_NAME);
                    DistributedTestCase.getLogWriter().info("In createDistributedRegion, using hydra.Log.getLogWriter()");
                    lr.getLogWriterI18n().info(LocalizedStrings.DEBUG, (Object)"In createDistributedRegion, using region.getLogWriterI18n()");
                    lr.getLogWriterI18n().fine("Unfinished Op limit=" + InitialImageOperation.MAXIMUM_UNFINISHED_OPERATIONS);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        return vm.invokeAsync(createRegion);
    }

    protected void closeCache(VM vm) {
        SerializableRunnable close = new SerializableRunnable(){

            @Override
            public void run() {
                try {
                    Cache cache = GIIDeltaDUnitTest.this.getCache();
                    System.setProperty("gemfire.no-flush-on-close", "true");
                    cache.close();
                }
                finally {
                    System.getProperties().remove("gemfire.no-flush-on-close");
                }
            }
        };
        vm.invoke(close);
    }

    protected void destroyRegion(VM vm) {
        SerializableRunnable destroy = new SerializableRunnable(){

            @Override
            public void run() {
                LocalRegion lr = (LocalRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME);
                lr.localDestroyRegion();
            }
        };
        vm.invoke(destroy);
    }

    protected void changeUnfinishedOperationLimit(VM vm, final int value) {
        SerializableRunnable change = new SerializableRunnable(){

            @Override
            public void run() {
                InitialImageOperation.MAXIMUM_UNFINISHED_OPERATIONS = value;
            }
        };
        vm.invoke(change);
    }

    protected void changeTombstoneTimout(VM vm, final long value) {
        SerializableRunnable change = new SerializableRunnable(){

            @Override
            public void run() {
                TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT = value;
            }
        };
        vm.invoke(change);
    }

    protected void changeForceFullGII(VM vm, final boolean value, final boolean checkOnly) {
        SerializableRunnable change = new SerializableRunnable(){

            @Override
            public void run() {
                if (checkOnly) {
                    TestCase.assertEquals((boolean)value, (boolean)InitialImageOperation.FORCE_FULL_GII);
                } else {
                    InitialImageOperation.FORCE_FULL_GII = value;
                }
            }
        };
        vm.invoke(change);
    }

    protected void removeSystemPropertiesInVM(VM vm, final String prop) {
        SerializableRunnable change = new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("Current prop setting: " + prop + "=" + System.getProperty(prop));
                System.getProperties().remove(prop);
                DistributedTestCase.getLogWriter().info(prop + "=" + System.getProperty(prop));
            }
        };
        vm.invoke(change);
    }

    protected void verifyDeltaSizeFromStats(VM vm, final int expectedKeyNum, final int expectedDeltaGIINum) {
        SerializableRunnable verify = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = GIIDeltaDUnitTest.this.getCache();
                LocalRegion lr = (LocalRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME);
                CachePerfStats stats = lr.getRegionPerfStats();
                int size = stats.getGetInitialImageKeysReceived();
                cache.getLogger().info("Delta contains: " + size + " keys");
                TestCase.assertEquals((int)expectedKeyNum, (int)size);
                int num = stats.getDeltaGetInitialImagesCompleted();
                cache.getLogger().info("Delta GII completed: " + num + " times");
                TestCase.assertEquals((int)expectedDeltaGIINum, (int)num);
            }
        };
        vm.invoke(verify);
    }

    protected void assignVMsToPandR(VM vm0, VM vm1) {
        DiskStoreID dsid0 = this.getMemberID(vm0);
        DiskStoreID dsid1 = this.getMemberID(vm1);
        int compare = dsid0.compareTo(dsid1);
        GIIDeltaDUnitTest.getLogWriter().info("Before assignVMsToPandR, dsid0 is " + dsid0 + ",dsid1 is " + dsid1 + ",compare=" + compare);
        if (compare > 0) {
            this.P = vm0;
            this.R = vm1;
        } else {
            this.P = vm1;
            this.R = vm0;
        }
        GIIDeltaDUnitTest.getLogWriter().info("After assignVMsToPandR, P is " + this.P.getPid() + "; R is " + this.R.getPid() + " for region " + REGION_NAME);
    }

    private DiskStoreID getMemberID(VM vm) {
        SerializableCallable getDiskStoreID = new SerializableCallable("get DiskStoreID as member id"){

            public Object call() {
                LocalRegion lr = (LocalRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME);
                TestCase.assertTrue((lr != null && lr.getDiskStore() != null ? 1 : 0) != 0);
                DiskStoreID dsid = lr.getDiskStore().getDiskStoreID();
                return dsid;
            }
        };
        return (DiskStoreID)vm.invoke(getDiskStoreID);
    }

    private void forceGC(VM vm, final int count) {
        vm.invoke(new SerializableCallable("force GC"){

            public Object call() throws Exception {
                ((GemFireCacheImpl)GIIDeltaDUnitTest.this.getCache()).getTombstoneService().forceBatchExpirationForTests(count);
                return null;
            }
        });
    }

    private void forceAddGIICount(VM vm) {
        vm.invoke(new SerializableCallable("force to add gii count"){

            public Object call() throws Exception {
                ((GemFireCacheImpl)GIIDeltaDUnitTest.this.getCache()).getTombstoneService().incrementGCBlockCount();
                return null;
            }
        });
    }

    private void assertDeltaGIICountBeZero(VM vm) {
        vm.invoke(new SerializableCallable("assert progressingDeltaGIICount == 0"){

            public Object call() throws Exception {
                int count = ((GemFireCacheImpl)GIIDeltaDUnitTest.this.getCache()).getTombstoneService().getGCBlockCount();
                TestCase.assertEquals((int)0, (int)count);
                return null;
            }
        });
    }

    public void waitForToVerifyRVV(VM vm, final DiskStoreID member, final long expectedRegionVersion, final long[] exceptionList, final long expectedGCVersion) {
        SerializableRunnable waitForVerifyRVV = new SerializableRunnable(){

            private boolean verifyExceptionList(DiskStoreID member2, long regionversion, RegionVersionVector rvv, long[] exceptionList2) {
                boolean exceptionListVerified = true;
                if (exceptionList2 != null) {
                    for (long i : exceptionList2) {
                        boolean bl = exceptionListVerified = !rvv.contains((VersionSource)member2, i);
                        if (exceptionListVerified) continue;
                        DistributedTestCase.getLogWriter().finer("DeltaGII:missing exception " + i + ":" + rvv);
                        break;
                    }
                } else {
                    for (long i = 1L; i <= regionversion; ++i) {
                        if (rvv.contains((VersionSource)member2, i)) continue;
                        exceptionListVerified = false;
                        DistributedTestCase.getLogWriter().finer("DeltaGII:unexpected exception " + i);
                        break;
                    }
                }
                return exceptionListVerified;
            }

            @Override
            public void run() {
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        RegionVersionVector rvv = ((LocalRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME)).getVersionVector().getCloneForTransmission();
                        long regionversion = GIIDeltaDUnitTest.this.getRegionVersionForMember(rvv, member, false);
                        long gcversion = GIIDeltaDUnitTest.this.getRegionVersionForMember(rvv, member, true);
                        boolean exceptionListVerified = this.verifyExceptionList(member, regionversion, rvv, exceptionList);
                        DistributedTestCase.getLogWriter().info("DeltaGII:expected:" + expectedRegionVersion + ":" + expectedGCVersion);
                        DistributedTestCase.getLogWriter().info("DeltaGII:actual:" + regionversion + ":" + gcversion + ":" + exceptionListVerified + ":" + rvv);
                        boolean match = true;
                        if (expectedRegionVersion != -1L) {
                            boolean bl = match = match && regionversion == expectedRegionVersion;
                        }
                        if (expectedGCVersion != -1L) {
                            match = match && gcversion == expectedGCVersion;
                        }
                        return match && exceptionListVerified;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                RegionVersionVector rvv = ((LocalRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME)).getVersionVector().getCloneForTransmission();
                long regionversion = GIIDeltaDUnitTest.this.getRegionVersionForMember(rvv, member, false);
                long gcversion = GIIDeltaDUnitTest.this.getRegionVersionForMember(rvv, member, true);
                if (expectedRegionVersion != -1L) {
                    TestCase.assertEquals((long)expectedRegionVersion, (long)regionversion);
                }
                if (expectedGCVersion != -1L) {
                    TestCase.assertEquals((long)expectedGCVersion, (long)gcversion);
                }
                boolean exceptionListVerified = this.verifyExceptionList(member, regionversion, rvv, exceptionList);
                TestCase.assertTrue((boolean)exceptionListVerified);
            }
        };
        vm.invoke(waitForVerifyRVV);
    }

    public void waitForCallbackStarted(VM vm, final InitialImageOperation.GIITestHookType callbacktype) {
        SerializableRunnable waitForCallbackStarted = new SerializableRunnable(){

            @Override
            public void run() {
                final InitialImageOperation.GIITestHook callback = InitialImageOperation.getGIITestHookForCheckingPurpose((InitialImageOperation.GIITestHookType)callbacktype);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return callback != null && callback.isRunning;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 30000L, 200L, true);
                if (callback == null || !callback.isRunning) {
                    TestCase.fail((String)"GII tesk hook is not started yet");
                }
            }
        };
        vm.invoke(waitForCallbackStarted);
    }

    private VersionTag getVersionTag(VM vm, final String key) {
        SerializableCallable getVersionTag = new SerializableCallable("get version tag"){

            public Object call() {
                VersionTag tag = ((LocalRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME)).getVersionTag((Object)key);
                return tag;
            }
        };
        return (VersionTag)vm.invoke(getVersionTag);
    }

    public void waitToVerifyKey(VM vm, final String key, final String expect_value) {
        SerializableRunnable waitToVerifyKey = new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        String value = (String)((LocalRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME)).get((Object)key);
                        if (expect_value == null && value == null) {
                            return true;
                        }
                        return value != null && value.equals(expect_value);
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                String value = (String)((LocalRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME)).get((Object)key);
                TestCase.assertEquals((String)expect_value, (String)value);
            }
        };
        vm.invoke(waitToVerifyKey);
    }

    protected byte[] getRVVByteArray(VM vm, final String regionName) throws IOException, ClassNotFoundException {
        SerializableCallable getRVVByteArray = new SerializableCallable("getRVVByteArray"){

            public Object call() throws Exception {
                Cache cache = GIIDeltaDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(regionName);
                RegionVersionVector rvv = region.getVersionVector();
                rvv = rvv.getCloneForTransmission();
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                DataSerializer.writeObject((Object)rvv, (DataOutput)hdos);
                return hdos.toByteArray();
            }
        };
        byte[] result = (byte[])vm.invoke(getRVVByteArray);
        return result;
    }

    protected RegionVersionVector getRVV(VM vm) throws IOException, ClassNotFoundException {
        byte[] result = this.getRVVByteArray(vm, REGION_NAME);
        ByteArrayInputStream bais = new ByteArrayInputStream(result);
        return (RegionVersionVector)DataSerializer.readObject((DataInput)new DataInputStream(bais));
    }

    protected RegionVersionVector getDiskRVV(VM vm) throws IOException, ClassNotFoundException {
        SerializableCallable createData = new SerializableCallable("getRVV"){

            public Object call() throws Exception {
                Cache cache = GIIDeltaDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(REGION_NAME);
                RegionVersionVector rvv = region.getDiskRegion().getRegionVersionVector();
                rvv = rvv.getCloneForTransmission();
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                DataSerializer.writeObject((Object)rvv, (DataOutput)hdos);
                return hdos.toByteArray();
            }
        };
        byte[] result = (byte[])vm.invoke(createData);
        ByteArrayInputStream bais = new ByteArrayInputStream(result);
        return (RegionVersionVector)DataSerializer.readObject((DataInput)new DataInputStream(bais));
    }

    private void checkIfFullGII(VM vm, final String regionName, final byte[] remote_rvv_bytearray, final boolean expectFullGII) {
        SerializableRunnable checkIfFullGII = new SerializableRunnable("check if full gii"){

            @Override
            public void run() {
                DistributedRegion rr = (DistributedRegion)GIIDeltaDUnitTest.this.getCache().getRegion(regionName);
                ByteArrayInputStream bais = new ByteArrayInputStream(remote_rvv_bytearray);
                RegionVersionVector remote_rvv = null;
                try {
                    remote_rvv = (RegionVersionVector)DataSerializer.readObject((DataInput)new DataInputStream(bais));
                }
                catch (IOException e) {
                    DistributedTestCase.fail("Unexpected exception", e);
                }
                catch (ClassNotFoundException e) {
                    DistributedTestCase.fail("Unexpected exception", e);
                }
                InitialImageOperation.RequestImageMessage rim = new InitialImageOperation.RequestImageMessage();
                boolean isFullGII = rim.goWithFullGII(rr, remote_rvv);
                TestCase.assertEquals((boolean)expectFullGII, (boolean)isFullGII);
            }
        };
        vm.invoke(checkIfFullGII);
    }

    private void doOneClear(VM vm, long regionVersionForThisOp) {
        SerializableRunnable clearOp = this.oneClearOp(regionVersionForThisOp, this.getMemberID(vm));
        vm.invoke(clearOp);
    }

    private SerializableRunnable oneClearOp(final long regionVersionForThisOp, final DiskStoreID memberID) {
        SerializableRunnable clearOp = new SerializableRunnable("clear now"){

            @Override
            public void run() {
                DistributedRegion rr = (DistributedRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME);
                rr.clear();
                long region_version = GIIDeltaDUnitTest.this.getRegionVersionForMember(rr.getVersionVector(), memberID, false);
                long region_gc_version = GIIDeltaDUnitTest.this.getRegionVersionForMember(rr.getVersionVector(), memberID, true);
                TestCase.assertEquals((long)regionVersionForThisOp, (long)region_version);
                TestCase.assertEquals((long)region_version, (long)region_gc_version);
            }
        };
        return clearOp;
    }

    private SerializableRunnable onePutOp(final String key, final String value, final long regionVersionForThisOp, final DiskStoreID memberID) {
        SerializableRunnable putOp = new SerializableRunnable("put " + key){

            @Override
            public void run() {
                LocalRegion lr = (LocalRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME);
                lr.put((Object)key, (Object)value);
                long region_version = GIIDeltaDUnitTest.this.getRegionVersionForMember(lr.getVersionVector(), memberID, false);
                TestCase.assertEquals((long)regionVersionForThisOp, (long)region_version);
            }
        };
        return putOp;
    }

    private void doOnePut(VM vm, long regionVersionForThisOp, String key) {
        SerializableRunnable putOp = this.onePutOp(key, this.generateValue(vm), regionVersionForThisOp, this.getMemberID(vm));
        vm.invoke(putOp);
    }

    private AsyncInvocation doOnePutAsync(VM vm, long regionVersionForThisOp, String key) {
        SerializableRunnable putOp = this.onePutOp(key, this.generateValue(vm), regionVersionForThisOp, this.getMemberID(vm));
        AsyncInvocation async = vm.invokeAsync(putOp);
        return async;
    }

    private String generateValue(VM vm) {
        return "VALUE from vm" + vm.getPid();
    }

    private SerializableRunnable oneDestroyOp(final String key, String value, final long regionVersionForThisOp, final DiskStoreID memberID) {
        SerializableRunnable destroyOp = new SerializableRunnable("destroy " + key){

            @Override
            public void run() {
                LocalRegion lr = (LocalRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME);
                lr.destroy((Object)key);
                long region_version = GIIDeltaDUnitTest.this.getRegionVersionForMember(lr.getVersionVector(), memberID, false);
                TestCase.assertEquals((long)regionVersionForThisOp, (long)region_version);
            }
        };
        return destroyOp;
    }

    private void doOneDestroy(VM vm, long regionVersionForThisOp, String key) {
        SerializableRunnable destroyOp = this.oneDestroyOp(key, this.generateValue(vm), regionVersionForThisOp, this.getMemberID(vm));
        vm.invoke(destroyOp);
    }

    private AsyncInvocation doOneDestroyAsync(VM vm, long regionVersionForThisOp, String key) {
        SerializableRunnable destroyOp = this.oneDestroyOp(key, this.generateValue(vm), regionVersionForThisOp, this.getMemberID(vm));
        AsyncInvocation async = vm.invokeAsync(destroyOp);
        return async;
    }

    private long getRegionVersionForMember(RegionVersionVector rvv, DiskStoreID member, boolean isRVVGC) {
        long ret = 0L;
        ret = isRVVGC ? rvv.getGCVersion((VersionSource)member) : rvv.getVersionForMember((VersionSource)member);
        return ret == -1L ? 0L : ret;
    }

    private void assertSameRVV(RegionVersionVector rvv1, RegionVersionVector rvv2) {
        if (!rvv1.sameAs(rvv2)) {
            GIIDeltaDUnitTest.fail((String)("Expected " + rvv1 + " but was " + rvv2));
        }
    }

    protected void verifyTombstoneExist(VM vm, final String key, final boolean expectExist, final boolean expectExpired) {
        SerializableRunnable verify = new SerializableRunnable(){

            private boolean doneVerify() {
                Cache cache = GIIDeltaDUnitTest.this.getCache();
                LocalRegion lr = (LocalRegion)GIIDeltaDUnitTest.this.getCache().getRegion(REGION_NAME);
                LocalRegion.NonTXEntry entry = (LocalRegion.NonTXEntry)lr.getEntry((Object)key, true);
                if (expectExist) {
                    TestCase.assertTrue((entry != null && entry.getRegionEntry().isTombstone() ? 1 : 0) != 0);
                }
                System.out.println("GGG:new timeout=" + TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT);
                if (entry == null || !entry.getRegionEntry().isTombstone()) {
                    return false == expectExist;
                }
                long ts = entry.getRegionEntry().getVersionStamp().getVersionTimeStamp();
                if (expectExpired) {
                    return ts + TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT <= ((GemFireCacheImpl)cache).cacheTimeMillis();
                }
                return true == expectExist;
            }

            @Override
            public void run() {
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return this.doneVerify();
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                TestCase.assertTrue((boolean)this.doneVerify());
            }
        };
        vm.invoke(verify);
    }

    protected int getDeltaGIICount(VM vm) {
        SerializableCallable getDelGIICount = new SerializableCallable("getDelGIICount"){

            public Object call() throws Exception {
                GemFireCacheImpl gfc = (GemFireCacheImpl)GIIDeltaDUnitTest.this.getCache();
                return gfc.getTombstoneService().getGCBlockCount();
            }
        };
        int result = (Integer)vm.invoke(getDelGIICount);
        return result;
    }

    private void checkAsyncCall(AsyncInvocation async) {
        try {
            async.join(30000L);
            if (async.exceptionOccurred()) {
                GIIDeltaDUnitTest.fail("Test failed", async.getException());
            }
        }
        catch (InterruptedException e1) {
            GIIDeltaDUnitTest.fail("Test failed", e1);
        }
    }

    public static void slowGII(long[] versionsToBlock) {
        DistributionMessageObserver.setInstance((DistributionMessageObserver)new BlockMessageObserver(versionsToBlock));
    }

    public static void resetSlowGII() {
        BlockMessageObserver observer = (BlockMessageObserver)DistributionMessageObserver.setInstance(null);
        if (observer != null) {
            observer.cdl.countDown();
        }
    }

    private class Mycallback
    extends InitialImageOperation.GIITestHook {
        private Object lockObject;

        public Mycallback(InitialImageOperation.GIITestHookType type, String region_name) {
            super(type, region_name);
            this.lockObject = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.lockObject;
            synchronized (object) {
                this.lockObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.lockObject;
            synchronized (object) {
                try {
                    this.isRunning = true;
                    this.lockObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static class BlockMessageObserver
    extends DistributionMessageObserver {
        private long[] versionsToBlock;
        CountDownLatch cdl = new CountDownLatch(1);

        BlockMessageObserver(long[] versionsToBlock) {
            this.versionsToBlock = versionsToBlock;
        }

        public void beforeSendMessage(DistributionManager dm, DistributionMessage message) {
            UpdateOperation.UpdateMessage um;
            VersionTag tag = null;
            if (message instanceof UpdateOperation.UpdateMessage) {
                um = (UpdateOperation.UpdateMessage)message;
                tag = um.getVersionTag();
            } else if (message instanceof DestroyOperation.DestroyMessage) {
                um = (DestroyOperation.DestroyMessage)message;
                tag = um.getVersionTag();
            } else {
                return;
            }
            try {
                boolean toBlock = false;
                for (long blockversion : this.versionsToBlock) {
                    if (tag.getRegionVersion() != blockversion) continue;
                    toBlock = true;
                    break;
                }
                if (toBlock) {
                    this.cdl.await();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

