/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache.util.ObjectSizerImpl;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.HeapMemoryMonitor;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import junit.framework.TestCase;

public class EvictionStatsDUnitTest
extends CacheTestCase {
    protected static Cache cache = null;
    protected static VM dataStore1 = null;
    protected static VM dataStore2 = null;
    protected static Region region = null;
    static int maxEnteries = 20;
    static int maxSizeInMb = 20;
    static int totalNoOfBuckets = 2;

    public EvictionStatsDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        dataStore1 = host.getVM(0);
        dataStore2 = host.getVM(1);
    }

    public void testEntryLruLimitNDestroyLimit() {
        DistributedTestCase.ExpectedException expectedEx = EvictionStatsDUnitTest.addExpectedException(RejectedExecutionException.class.getName());
        this.prepareScenario(EvictionAlgorithm.LRU_ENTRY);
        EvictionStatsDUnitTest.putData("PR1", 100);
        EvictionStatsDUnitTest.putData("PR2", 60);
        dataStore1.invoke(new CacheSerializableRunnable("testlimit"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr1 = (PartitionedRegion)cache.getRegion("PR1");
                PartitionedRegion pr2 = (PartitionedRegion)cache.getRegion("PR2");
                TestCase.assertEquals((long)maxEnteries, (long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getLimit());
                TestCase.assertEquals((long)maxEnteries, (long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getLimit());
                TestCase.assertEquals((long)1000L, (long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getDestroysLimit());
                TestCase.assertEquals((long)1000L, (long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getDestroysLimit());
            }
        });
        dataStore2.invoke(new CacheSerializableRunnable("testlimit"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr1 = (PartitionedRegion)cache.getRegion("PR1");
                PartitionedRegion pr2 = (PartitionedRegion)cache.getRegion("PR2");
                TestCase.assertEquals((long)maxEnteries, (long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getLimit());
                TestCase.assertEquals((long)maxEnteries, (long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getLimit());
                TestCase.assertEquals((long)1000L, (long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getDestroysLimit());
                TestCase.assertEquals((long)1000L, (long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getDestroysLimit());
            }
        });
        expectedEx.remove();
    }

    public void testMemLruLimitNDestroyLimit() {
        DistributedTestCase.ExpectedException expectedEx = EvictionStatsDUnitTest.addExpectedException(RejectedExecutionException.class.getName());
        this.prepareScenario(EvictionAlgorithm.LRU_MEMORY);
        EvictionStatsDUnitTest.putData("PR1", 100);
        EvictionStatsDUnitTest.putData("PR2", 60);
        dataStore1.invoke(new CacheSerializableRunnable("testlimit"){

            @Override
            public void run2() throws CacheException {
                long ONE_MEG = 0x100000L;
                PartitionedRegion pr1 = (PartitionedRegion)cache.getRegion("PR1");
                PartitionedRegion pr2 = (PartitionedRegion)cache.getRegion("PR2");
                TestCase.assertEquals((long)pr1.getLocalMaxMemory(), (long)(((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getLimit() / 0x100000L));
                TestCase.assertEquals((long)pr2.getLocalMaxMemory(), (long)(((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getLimit() / 0x100000L));
                TestCase.assertEquals((long)1000L, (long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getDestroysLimit());
                TestCase.assertEquals((long)1000L, (long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getDestroysLimit());
            }
        });
        dataStore2.invoke(new CacheSerializableRunnable("testlimit"){

            @Override
            public void run2() throws CacheException {
                long ONE_MEG = 0x100000L;
                PartitionedRegion pr1 = (PartitionedRegion)cache.getRegion("PR1");
                PartitionedRegion pr2 = (PartitionedRegion)cache.getRegion("PR2");
                TestCase.assertEquals((long)pr1.getLocalMaxMemory(), (long)(((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getLimit() / 0x100000L));
                TestCase.assertEquals((long)pr2.getLocalMaxMemory(), (long)(((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getLimit() / 0x100000L));
                TestCase.assertEquals((long)1000L, (long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getDestroysLimit());
                TestCase.assertEquals((long)1000L, (long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getDestroysLimit());
            }
        });
        expectedEx.remove();
    }

    public void testEntryLruCounter() {
        DistributedTestCase.ExpectedException expectedEx = EvictionStatsDUnitTest.addExpectedException(RejectedExecutionException.class.getName());
        this.prepareScenario(EvictionAlgorithm.LRU_ENTRY);
        EvictionStatsDUnitTest.putData("PR1", 10);
        EvictionStatsDUnitTest.putData("PR2", 16);
        long sizeOfPr1 = this.getPRCounter("PR1");
        long sizeOfPr2 = this.getPRCounter("PR2");
        long totalBucketSizeForPR1 = this.getCounterForBucketsOfPR("PR1");
        long totalBucketSizeForPR2 = this.getCounterForBucketsOfPR("PR2");
        EvictionStatsDUnitTest.assertEquals((long)sizeOfPr1, (long)totalBucketSizeForPR1);
        EvictionStatsDUnitTest.assertEquals((long)sizeOfPr2, (long)totalBucketSizeForPR2);
        expectedEx.remove();
    }

    public void testMemLruCounter() {
        DistributedTestCase.ExpectedException expectedEx = EvictionStatsDUnitTest.addExpectedException(RejectedExecutionException.class.getName());
        this.prepareScenario(EvictionAlgorithm.LRU_MEMORY);
        EvictionStatsDUnitTest.putData("PR1", 10);
        EvictionStatsDUnitTest.putData("PR2", 16);
        long sizeOfPr1 = this.getPRCounter("PR1");
        long sizeOfPr2 = this.getPRCounter("PR2");
        long totalBucketSizeForPR1 = this.getCounterForBucketsOfPR("PR1");
        long totalBucketSizeForPR2 = this.getCounterForBucketsOfPR("PR2");
        EvictionStatsDUnitTest.assertEquals((long)sizeOfPr1, (long)totalBucketSizeForPR1);
        EvictionStatsDUnitTest.assertEquals((long)sizeOfPr2, (long)totalBucketSizeForPR2);
        expectedEx.remove();
    }

    public void testHeapLruCounter() {
        DistributedTestCase.ExpectedException expectedEx = EvictionStatsDUnitTest.addExpectedException(RejectedExecutionException.class.getName());
        this.prepareScenario(EvictionAlgorithm.LRU_HEAP);
        System.setProperty("gemfire.topUpHeapEvictionPercentage", Float.toString(0.0f));
        EvictionStatsDUnitTest.putData("PR1", 20);
        EvictionStatsDUnitTest.putData("PR2", 20);
        long sizeOfPr1 = this.getPRCounter("PR1");
        long sizeOfPr2 = this.getPRCounter("PR2");
        long totalBucketSizeForPR1 = this.getCounterForBucketsOfPR("PR1");
        long totalBucketSizeForPR2 = this.getCounterForBucketsOfPR("PR2");
        expectedEx.remove();
    }

    public void testEntryLruAllCounterMethods() {
        BucketRegion bucketRegion;
        DistributedTestCase.ExpectedException expectedEx = EvictionStatsDUnitTest.addExpectedException(RejectedExecutionException.class.getName());
        long ONE_MEG = 0x100000L;
        this.createCache();
        this.createPartitionedRegion(true, EvictionAlgorithm.LRU_ENTRY, "PR1", 2, 1, 10000);
        for (int counter = 1; counter <= maxEnteries; ++counter) {
            region.put((Object)new Integer(counter), (Object)new byte[1048574]);
        }
        long sizeOfPRegion = ((AbstractLRURegionMap)((PartitionedRegion)EvictionStatsDUnitTest.region).entries)._getLruList().stats().getCounter();
        EvictionStatsDUnitTest.assertEquals((long)sizeOfPRegion, (long)20L);
        long bucketSize = 0L;
        for (Map.Entry entry : ((PartitionedRegion)region).getDataStore().getAllLocalBuckets()) {
            BucketRegion bucketRegion2 = (BucketRegion)entry.getValue();
            if (bucketRegion2 == null) continue;
            EvictionStatsDUnitTest.assertEquals((long)bucketRegion2.getCounter(), (long)10L);
            bucketSize += bucketRegion2.getCounter();
        }
        EvictionStatsDUnitTest.assertEquals((long)sizeOfPRegion, (long)bucketSize);
        bucketSize = 0L;
        int extraEnteries = 4;
        for (int counter = 1; counter <= 4; ++counter) {
            region.put((Object)new Integer(counter), (Object)new byte[1048574]);
        }
        sizeOfPRegion = ((AbstractLRURegionMap)((PartitionedRegion)EvictionStatsDUnitTest.region).entries)._getLruList().stats().getCounter();
        EvictionStatsDUnitTest.assertEquals((long)sizeOfPRegion, (long)20L);
        for (Map.Entry entry : ((PartitionedRegion)region).getDataStore().getAllLocalBuckets()) {
            bucketRegion = (BucketRegion)entry.getValue();
            if (bucketRegion == null) continue;
            EvictionStatsDUnitTest.assertEquals((long)bucketRegion.getCounter(), (long)10L);
            bucketSize += bucketRegion.getCounter();
        }
        EvictionStatsDUnitTest.assertEquals((long)sizeOfPRegion, (long)bucketSize);
        for (Map.Entry entry : ((PartitionedRegion)region).getDataStore().getAllLocalBuckets()) {
            bucketRegion = (BucketRegion)entry.getValue();
            if (bucketRegion == null) continue;
            for (Object key : bucketRegion.keySet()) {
                region.destroy(key);
            }
            EvictionStatsDUnitTest.assertEquals((long)bucketRegion.getCounter(), (long)0L);
            break;
        }
        sizeOfPRegion = ((AbstractLRURegionMap)((PartitionedRegion)EvictionStatsDUnitTest.region).entries)._getLruList().stats().getCounter();
        EvictionStatsDUnitTest.assertEquals((long)sizeOfPRegion, (long)10L);
        expectedEx.remove();
    }

    public void testEntryLRUEvictionNDestroyNNumOverflowOnDiskCount() {
        DistributedTestCase.ExpectedException expectedEx = EvictionStatsDUnitTest.addExpectedException(RejectedExecutionException.class.getName());
        int extraEnteries = 24;
        this.prepareScenario(EvictionAlgorithm.LRU_ENTRY);
        EvictionStatsDUnitTest.putData("PR1", maxEnteries + 24);
        EvictionStatsDUnitTest.putData("PR2", maxEnteries + 24);
        dataStore1.invoke(new CacheSerializableRunnable("testEntryLRUEvictionNDestroyNNumOverflowOnDiskCount"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr1 = (PartitionedRegion)cache.getRegion("PR1");
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getEvictions(), (long)((24 - maxEnteries) / 2));
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getDestroys(), (long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getEvictions());
                PartitionedRegion pr2 = (PartitionedRegion)cache.getRegion("PR2");
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getEvictions(), (long)((24 - maxEnteries) / 2));
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getDestroys(), (long)0L);
                TestCase.assertEquals((long)pr2.getDiskRegionStats().getNumOverflowOnDisk(), (long)((24 - maxEnteries) / 2));
            }
        });
        dataStore2.invoke(new CacheSerializableRunnable("testEntryLRUEvictionNDestroyNNumOverflowOnDiskCount"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr1 = (PartitionedRegion)cache.getRegion("PR1");
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getEvictions(), (long)((24 - maxEnteries) / 2));
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getDestroys(), (long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getEvictions());
                PartitionedRegion pr2 = (PartitionedRegion)cache.getRegion("PR2");
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getEvictions(), (long)((24 - maxEnteries) / 2));
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getDestroys(), (long)0L);
                TestCase.assertEquals((long)pr2.getDiskRegionStats().getNumOverflowOnDisk(), (long)((24 - maxEnteries) / 2));
            }
        });
        expectedEx.remove();
    }

    public void testMemLRUEvictionNDestroyNNumOverflowOnDiskCount() {
        DistributedTestCase.ExpectedException expectedEx = EvictionStatsDUnitTest.addExpectedException(RejectedExecutionException.class.getName());
        int localMaxMem = 50;
        int extraEntries = 6;
        this.prepareScenario(EvictionAlgorithm.LRU_MEMORY);
        EvictionStatsDUnitTest.putData("PR1", 2 * localMaxMem + 6);
        EvictionStatsDUnitTest.putData("PR2", 2 * localMaxMem + 6);
        dataStore1.invoke(new CacheSerializableRunnable("testEvictionCount"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr1 = (PartitionedRegion)cache.getRegion("PR1");
                DistributedTestCase.getLogWriter().info("dddd  local" + pr1.getLocalMaxMemory());
                DistributedTestCase.getLogWriter().info("dddd  local evi" + ((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getEvictions());
                DistributedTestCase.getLogWriter().info("dddd  local entries" + ((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getCounter() / 0x100000L);
                HeapMemoryMonitor hmm = ((InternalResourceManager)cache.getResourceManager()).getHeapMonitor();
                long memused = hmm.getBytesUsed() / 0x100000L;
                DistributedTestCase.getLogWriter().info("dddd  local memused= " + memused);
                TestCase.assertTrue((((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getEvictions() >= 3L ? 1 : 0) != 0);
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getDestroys(), (long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getEvictions());
                PartitionedRegion pr2 = (PartitionedRegion)cache.getRegion("PR2");
                TestCase.assertTrue((((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getEvictions() >= 3L ? 1 : 0) != 0);
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getDestroys(), (long)0L);
                TestCase.assertTrue((pr2.getDiskRegionStats().getNumOverflowOnDisk() >= 3L ? 1 : 0) != 0);
            }
        });
        dataStore2.invoke(new CacheSerializableRunnable("testEvictionCount"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegion pr1 = (PartitionedRegion)cache.getRegion("PR1");
                TestCase.assertTrue((((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getEvictions() >= 3L ? 1 : 0) != 0);
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getDestroys(), (long)((AbstractLRURegionMap)pr1.entries)._getLruList().stats().getEvictions());
                PartitionedRegion pr2 = (PartitionedRegion)cache.getRegion("PR2");
                TestCase.assertTrue((((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getEvictions() >= 3L ? 1 : 0) != 0);
                TestCase.assertEquals((long)((AbstractLRURegionMap)pr2.entries)._getLruList().stats().getDestroys(), (long)0L);
                TestCase.assertTrue((pr2.getDiskRegionStats().getNumOverflowOnDisk() >= 3L ? 1 : 0) != 0);
            }
        });
        expectedEx.remove();
    }

    public void prepareScenario(EvictionAlgorithm evictionAlgorithm) {
        this.createCacheInAllVms();
        this.createPartitionedRegionInAllVMS(true, evictionAlgorithm, "PR1", totalNoOfBuckets, 1, 10000);
        this.createPartitionedRegionInAllVMS(true, evictionAlgorithm, "PR2", totalNoOfBuckets, 2, 10000);
    }

    public void createCacheInAllVms() {
        this.createCache();
        dataStore1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionStatsDUnitTest.this.createCache();
            }
        });
        dataStore2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionStatsDUnitTest.this.createCache();
            }
        });
    }

    public static void createCacheInVm() {
        new EvictionStatsDUnitTest("temp").createCache();
    }

    public void createCache() {
        try {
            Properties props = new Properties();
            InternalDistributedSystem ds = this.getSystem(props);
            EvictionStatsDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            EvictionStatsDUnitTest.assertNotNull((Object)cache);
            EvictionStatsDUnitTest.getLogWriter().info("cache= " + cache);
            EvictionStatsDUnitTest.getLogWriter().info("cache closed= " + cache.isClosed());
            cache.getResourceManager().setEvictionHeapPercentage(20.0f);
        }
        catch (Exception e) {
            EvictionStatsDUnitTest.fail("Failed while creating the cache", e);
        }
    }

    private void createPartitionedRegionInAllVMS(final boolean setEvictionOn, final EvictionAlgorithm evictionAlgorithm, final String regionName, final int totalNoOfBuckets, final int evictionAction, final int evictorInterval) {
        dataStore1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionStatsDUnitTest.this.createPartitionedRegion(setEvictionOn, evictionAlgorithm, regionName, totalNoOfBuckets, evictionAction, evictorInterval);
            }
        });
        dataStore2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                EvictionStatsDUnitTest.this.createPartitionedRegion(setEvictionOn, evictionAlgorithm, regionName, totalNoOfBuckets, evictionAction, evictorInterval);
            }
        });
    }

    public void createPartitionedRegion(boolean setEvictionOn, EvictionAlgorithm evictionAlgorithm, String regionName, int totalNoOfBuckets, int evictionAction, int evictorInterval) {
        AttributesFactory factory = new AttributesFactory();
        factory.setEnableOffHeapMemory(this.isOffHeapEnabled());
        PartitionAttributesFactory partitionAttributesFactory = new PartitionAttributesFactory().setRedundantCopies(0).setTotalNumBuckets(totalNoOfBuckets).setLocalMaxMemory(50);
        factory.setPartitionAttributes(partitionAttributesFactory.create());
        if (setEvictionOn) {
            if (evictionAlgorithm.isLRUHeap()) {
                factory.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)(evictionAction == 1 ? EvictionAction.LOCAL_DESTROY : EvictionAction.OVERFLOW_TO_DISK)));
            } else if (evictionAlgorithm.isLRUMemory()) {
                factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)maxSizeInMb, (ObjectSizer)new ObjectSizerImpl(), (EvictionAction)(evictionAction == 1 ? EvictionAction.LOCAL_DESTROY : EvictionAction.OVERFLOW_TO_DISK)));
            } else {
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)maxEnteries, (EvictionAction)(evictionAction == 1 ? EvictionAction.LOCAL_DESTROY : EvictionAction.OVERFLOW_TO_DISK)));
            }
            if (evictionAction == 2) {
                File[] diskDirs = new File[]{new File("Partitioned_Region_EvictionStats/LogFile_" + OSProcess.getId())};
                diskDirs[0].mkdirs();
                factory.setDiskSynchronous(true);
                factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(diskDirs).create("EvictionStatsDUnitTest").getName());
            }
        }
        region = cache.createRegion(regionName, factory.create());
        EvictionStatsDUnitTest.assertNotNull((Object)region);
        EvictionStatsDUnitTest.getLogWriter().info("Partitioned Region created Successfully :" + region);
    }

    public static void putData(final String regionName, final int noOfElememts) {
        dataStore1.invoke(new CacheSerializableRunnable("putData"){

            @Override
            public void run2() throws CacheException {
                Region pr = cache.getRegion(regionName);
                for (int counter = 1; counter <= noOfElememts; ++counter) {
                    pr.put((Object)new Integer(counter), (Object)new byte[0x100000]);
                }
            }
        });
    }

    private long getPRCounter(String prRegionName) {
        long ONE_MEG = 0x100000L;
        long sizeOfPR = 0L;
        sizeOfPR += ((Long)dataStore1.invoke(EvictionStatsDUnitTest.class, "getPartionRegionCounter", new Object[]{prRegionName})).longValue();
        return (sizeOfPR += ((Long)dataStore2.invoke(EvictionStatsDUnitTest.class, "getPartionRegionCounter", new Object[]{prRegionName})).longValue()) / 0x100000L;
    }

    public static long getPartionRegionCounter(String prRegionName) {
        PartitionedRegion pr = (PartitionedRegion)cache.getRegion(prRegionName);
        return ((AbstractLRURegionMap)pr.entries)._getLruList().stats().getCounter();
    }

    private long getCounterForBucketsOfPR(String prRegionName) {
        long ONE_MEG = 0x100000L;
        long totalBucketSize = 0L;
        totalBucketSize += ((Long)dataStore1.invoke(EvictionStatsDUnitTest.class, "getCounterForBuckets", new Object[]{prRegionName})).longValue();
        return (totalBucketSize += ((Long)dataStore2.invoke(EvictionStatsDUnitTest.class, "getCounterForBuckets", new Object[]{prRegionName})).longValue()) / 0x100000L;
    }

    public static long getCounterForBuckets(String prRegionName) {
        long bucketSize = 0L;
        PartitionedRegion pr = (PartitionedRegion)cache.getRegion(prRegionName);
        for (Map.Entry entry : pr.getDataStore().getAllLocalBuckets()) {
            BucketRegion bucketRegion = (BucketRegion)entry.getValue();
            if (bucketRegion == null) continue;
            EvictionStatsDUnitTest.getLogWriter().info("Size of bucket " + bucketRegion.getName() + "of Pr " + prRegionName + " = " + bucketRegion.getCounter() / 1000000L);
            bucketSize += bucketRegion.getCounter();
        }
        return bucketSize;
    }

    public boolean isOffHeapEnabled() {
        return false;
    }
}

