/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EventTracker;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import junit.framework.TestCase;

public class EventTrackerDUnitTest
extends CacheTestCase {
    private static int cacheServerPort;
    private static final String MESSAGE_TRACKING_TIMEOUT = "5000";

    public EventTrackerDUnitTest(String name) {
        super(name);
    }

    public static void caseSetUp() throws Exception {
        EventTrackerDUnitTest.disconnectAllFromDS();
    }

    public static void caseTearDown() throws Exception {
        EventTrackerDUnitTest.disconnectAllFromDS();
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            super.tearDown2();
        }
        finally {
            EventTrackerDUnitTest.disconnectAllFromDS();
        }
    }

    public void testEventTrackerCreateDestroy() throws CacheException {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        EventTracker.ExpiryTask expiryTask = cache.getEventTrackerTask();
        EventTrackerDUnitTest.assertNotNull((Object)expiryTask);
        int EXPECTED_TRACKERS = 3;
        EventTrackerDUnitTest.assertEquals((int)3, (int)expiryTask.getNumberOfTrackers());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        LocalRegion region = (LocalRegion)this.createRegion(this.getName(), factory.create());
        EventTracker eventTracker = region.getEventTracker();
        EventTrackerDUnitTest.assertNotNull((Object)eventTracker);
        Map eventState = region.getEventState();
        EventTrackerDUnitTest.assertNotNull((Object)eventState);
        EventTrackerDUnitTest.assertEquals((int)0, (int)eventState.size());
        EventTrackerDUnitTest.assertEquals((int)5, (int)expiryTask.getNumberOfTrackers());
        region.destroyRegion();
        EventTrackerDUnitTest.assertEquals((int)4, (int)expiryTask.getNumberOfTrackers());
    }

    public void testEventTrackerAddThreadIdentifier() throws CacheException {
        Host host = Host.getHost(0);
        VM serverVM = host.getVM(0);
        VM clientVM = host.getVM(1);
        final String regionName = this.getName();
        serverVM.invoke(new CacheSerializableRunnable("Create server"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                LocalRegion region = (LocalRegion)EventTrackerDUnitTest.this.createRegion(regionName, factory.create());
                EventTracker eventTracker = region.getEventTracker();
                TestCase.assertNotNull((Object)eventTracker);
                try {
                    EventTrackerDUnitTest.this.startCacheServer();
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        serverVM.invoke(new CacheSerializableRunnable("Do puts"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)EventTrackerDUnitTest.this.getRootRegion().getSubregion(regionName);
                Map eventState = region.getEventState();
                TestCase.assertEquals((int)0, (int)eventState.size());
            }
        });
        final int port = serverVM.invokeInt(EventTrackerDUnitTest.class, "getCacheServerPort");
        final String hostName = EventTrackerDUnitTest.getServerHostName(host);
        clientVM.invoke(new CacheSerializableRunnable("Create client"){

            @Override
            public void run2() throws CacheException {
                EventTrackerDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, hostName, port, -1, false, -1, -1, null);
                EventTrackerDUnitTest.this.createRegion(regionName, factory.create());
            }
        });
        clientVM.invoke(new CacheSerializableRunnable("Do puts"){

            @Override
            public void run2() throws CacheException {
                Region region = EventTrackerDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)i, (Object)i);
                }
            }
        });
        serverVM.invoke(new CacheSerializableRunnable("Do puts"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)EventTrackerDUnitTest.this.getRootRegion().getSubregion(regionName);
                Map eventState = region.getEventState();
                TestCase.assertEquals((int)1, (int)eventState.size());
            }
        });
    }

    public void testEventTrackerAddRemoveThreadIdentifier() throws CacheException {
        Host host = Host.getHost(0);
        VM serverVM = host.getVM(0);
        VM clientVM = host.getVM(1);
        final String regionName = this.getName();
        serverVM.invoke(new CacheSerializableRunnable("Create server"){

            @Override
            public void run2() throws CacheException {
                System.setProperty("gemfire.messageTrackingTimeout", EventTrackerDUnitTest.MESSAGE_TRACKING_TIMEOUT);
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                LocalRegion region = (LocalRegion)EventTrackerDUnitTest.this.createRegion(regionName, factory.create());
                EventTracker eventTracker = region.getEventTracker();
                TestCase.assertNotNull((Object)eventTracker);
                try {
                    EventTrackerDUnitTest.this.startCacheServer();
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        });
        serverVM.invoke(new CacheSerializableRunnable("Do puts"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)EventTrackerDUnitTest.this.getRootRegion().getSubregion(regionName);
                Map eventState = region.getEventState();
                TestCase.assertEquals((int)0, (int)eventState.size());
            }
        });
        final int port = serverVM.invokeInt(EventTrackerDUnitTest.class, "getCacheServerPort");
        final String hostName = EventTrackerDUnitTest.getServerHostName(host);
        clientVM.invoke(new CacheSerializableRunnable("Create client"){

            @Override
            public void run2() throws CacheException {
                EventTrackerDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, hostName, port, -1, false, -1, -1, null);
                EventTrackerDUnitTest.this.createRegion(regionName, factory.create());
            }
        });
        clientVM.invoke(new CacheSerializableRunnable("Do puts"){

            @Override
            public void run2() throws CacheException {
                Region region = EventTrackerDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)i, (Object)i);
                }
            }
        });
        serverVM.invoke(new CacheSerializableRunnable("Do puts"){

            @Override
            public void run2() throws CacheException {
                LocalRegion region = (LocalRegion)EventTrackerDUnitTest.this.getRootRegion().getSubregion(regionName);
                Map eventState = region.getEventState();
                TestCase.assertEquals((int)1, (int)eventState.size());
                int waitTime = Integer.parseInt(EventTrackerDUnitTest.MESSAGE_TRACKING_TIMEOUT) * 3;
                DistributedTestCase.pause(waitTime);
                eventState = region.getEventState();
                TestCase.assertEquals((int)0, (int)eventState.size());
            }
        });
    }

    public void testPutAllHoldersInEventTracker() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = EventTrackerDUnitTest.this.getCache();
                RegionFactory rf = cache.createRegionFactory(RegionShortcut.PARTITION_REDUNDANT);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setTotalNumBuckets(3);
                rf.setPartitionAttributes(paf.create());
                rf.setConcurrencyChecksEnabled(true);
                rf.create("partitioned");
                rf = cache.createRegionFactory(RegionShortcut.REPLICATE);
                rf.setConcurrencyChecksEnabled(true);
                rf.create("replicate");
                try {
                    EventTrackerDUnitTest.this.startCacheServer();
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        final int port = vm0.invokeInt(EventTrackerDUnitTest.class, "getCacheServerPort");
        final String hostName = EventTrackerDUnitTest.getServerHostName(host);
        vm2.invoke(new CacheSerializableRunnable("Create client"){

            @Override
            public void run2() throws CacheException {
                EventTrackerDUnitTest.this.getCache();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(factory, hostName, port, -1, false, -1, -1, null);
                EventTrackerDUnitTest.this.createRootRegion("partitioned", factory.create());
                EventTrackerDUnitTest.this.createRootRegion("replicate", factory.create());
            }
        });
        this.doTwoPutAlls(vm2, "partitioned");
        this.doTwoPutAlls(vm2, "replicate");
        this.checkBucketEventTracker(vm0, 0, 3);
        this.checkBucketEventTracker(vm1, 0, 3);
        this.checkBucketEventTracker(vm0, 1, 3);
        this.checkBucketEventTracker(vm1, 1, 3);
        this.checkBucketEventTracker(vm0, 2, 3);
        this.checkBucketEventTracker(vm1, 2, 3);
        this.checkReplicateEventTracker(vm0, 9);
        this.checkReplicateEventTracker(vm1, 9);
    }

    private void doTwoPutAlls(VM vm, final String regionName) {
        SerializableRunnable createData = new SerializableRunnable("putAlls"){

            @Override
            public void run() {
                int i;
                Cache cache = EventTrackerDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                HashMap<Integer, Integer> putAllMap = new HashMap<Integer, Integer>();
                for (i = 0; i < 9; ++i) {
                    putAllMap.put(i, i);
                }
                region.putAll(putAllMap);
                putAllMap.clear();
                for (i = 10; i < 19; ++i) {
                    putAllMap.put(i, i);
                }
                region.putAll(putAllMap);
            }
        };
        vm.invoke(createData);
    }

    private SerializableRunnable checkReplicateEventTracker(VM vm, final int expectedEntryCount) {
        SerializableRunnable checkEventTracker = new SerializableRunnable("checkEventTracker"){

            @Override
            public void run() {
                Cache cache = EventTrackerDUnitTest.this.getCache();
                DistributedRegion region = (DistributedRegion)cache.getRegion("replicate");
                EventTrackerDUnitTest.this.checkEventTracker((LocalRegion)region, expectedEntryCount);
            }
        };
        vm.invoke(checkEventTracker);
        return checkEventTracker;
    }

    private SerializableRunnable checkBucketEventTracker(VM vm, final int bucketNumber, final int expectedEntryCount) {
        SerializableRunnable checkEventTracker = new SerializableRunnable("checkEventTracker"){

            @Override
            public void run() {
                Cache cache = EventTrackerDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("partitioned");
                BucketRegion br = region.getBucketRegion((Object)bucketNumber);
                EventTrackerDUnitTest.this.checkEventTracker((LocalRegion)br, expectedEntryCount);
            }
        };
        vm.invoke(checkEventTracker);
        return checkEventTracker;
    }

    private void checkEventTracker(LocalRegion region, int numberOfEvents) {
        EventTracker tracker = region.getEventTracker();
        ConcurrentMap memberToTags = tracker.getRecordedPutAllVersionTags();
        EventTrackerDUnitTest.assertEquals((String)("memberToTags=" + memberToTags), (int)1, (int)memberToTags.size());
        EventTracker.PutAllHolder holder = (EventTracker.PutAllHolder)memberToTags.values().iterator().next();
        EventTrackerDUnitTest.assertEquals((String)("entryToVersionTags=" + holder.entryVersionTags), (int)numberOfEvents, (int)holder.entryVersionTags.size());
    }

    protected void startCacheServer() throws IOException {
        CacheServer cacheServer = this.getCache().addCacheServer();
        cacheServer.setPort(0);
        cacheServer.start();
        cacheServerPort = cacheServer.getPort();
    }

    protected static int getCacheServerPort() {
        return cacheServerPort;
    }
}

