/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache30.CacheTestCase;

public class Bug40632DUnitTest
extends CacheTestCase {
    public Bug40632DUnitTest(String name) {
        super(name);
    }

    public void testLocalDestroyIdleTimeout() {
        Cache cache = this.getCache();
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setRecoveryDelay(-1L);
        paf.setStartupRecoveryDelay(-1L);
        PartitionAttributes prAttr = paf.create();
        attr.setStatisticsEnabled(true);
        attr.setEntryIdleTimeout(new ExpirationAttributes(1000, ExpirationAction.LOCAL_DESTROY));
        attr.setPartitionAttributes(prAttr);
        try {
            cache.createRegion("region1", attr.create());
            Bug40632DUnitTest.fail((String)"We should not have been able to create the region");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testLocalDestroyTimeToLive() {
        Cache cache = this.getCache();
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setRecoveryDelay(-1L);
        paf.setStartupRecoveryDelay(-1L);
        PartitionAttributes prAttr = paf.create();
        attr.setStatisticsEnabled(true);
        attr.setEntryTimeToLive(new ExpirationAttributes(1000, ExpirationAction.LOCAL_DESTROY));
        attr.setPartitionAttributes(prAttr);
        try {
            cache.createRegion("region1", attr.create());
            Bug40632DUnitTest.fail((String)"We should not have been able to create the region");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testLocalInvalidateIdleTimeout() {
        Cache cache = this.getCache();
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setRecoveryDelay(-1L);
        paf.setStartupRecoveryDelay(-1L);
        PartitionAttributes prAttr = paf.create();
        attr.setStatisticsEnabled(true);
        attr.setEntryIdleTimeout(new ExpirationAttributes(1000, ExpirationAction.LOCAL_INVALIDATE));
        attr.setPartitionAttributes(prAttr);
        try {
            cache.createRegion("region1", attr.create());
            Bug40632DUnitTest.fail((String)"We should not have been able to create the region");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testLocalInvalidateTimeToLive() {
        Cache cache = this.getCache();
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(1);
        paf.setRecoveryDelay(-1L);
        paf.setStartupRecoveryDelay(-1L);
        PartitionAttributes prAttr = paf.create();
        attr.setStatisticsEnabled(true);
        attr.setEntryTimeToLive(new ExpirationAttributes(1000, ExpirationAction.LOCAL_INVALIDATE));
        attr.setPartitionAttributes(prAttr);
        try {
            cache.createRegion("region1", attr.create());
            Bug40632DUnitTest.fail((String)"We should not have been able to create the region");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

