/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class Bug33359DUnitTest
extends DistributedTestCase {
    static Cache cache;
    static Properties props;
    static Properties propsWork;
    static DistributedSystem ds;
    static Region region;
    static Region paperWork;
    static CacheTransactionManager cacheTxnMgr;
    static boolean IsAfterClear;
    static boolean flag;

    public Bug33359DUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(Bug33359DUnitTest.class, "createCacheVM0");
        vm1.invoke(Bug33359DUnitTest.class, "createCacheVM1");
        Bug33359DUnitTest.getLogWriter().fine("Cache created in successfully");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(Bug33359DUnitTest.class, "closeCache");
        vm1.invoke(Bug33359DUnitTest.class, "closeCache");
    }

    public static void createCacheVM0() {
        try {
            ds = new Bug33359DUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            factory.setEarlyAck(true);
            DistributedSystem.setThreadsSocketPolicy((boolean)false);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
            paperWork = cache.createRegion("paperWork", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createCacheVM1() {
        try {
            ds = new Bug33359DUnitTest("temp").getSystem(props);
            DistributedSystem.setThreadsSocketPolicy((boolean)false);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setDataPolicy(DataPolicy.REPLICATE);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
            paperWork = cache.createRegion("paperWork", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeCache() {
        try {
            cache.close();
            ds.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testClearMultiVM() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(new CacheSerializableRunnable("put initial data"){

            @Override
            public void run2() throws CacheException {
                for (int i = 0; i < 10; ++i) {
                    region.put((Object)new Integer(i), (Object)Integer.toString(i));
                }
                DistributedTestCase.getLogWriter().fine("Did all puts successfully");
            }
        });
        vm0.invoke(new CacheSerializableRunnable("perform clear on region"){

            @Override
            public void run2() throws CacheException {
                region.clear();
                DistributedTestCase.getLogWriter().fine("region is cleared");
            }
        });
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
        IsAfterClear = false;
        flag = false;
    }
}

