/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

public class LongBuffer {
    private long[] data;
    public int length;

    LongBuffer(int size) {
        this.data = new long[size];
        this.length = 0;
    }

    LongBuffer(long[] someIds) {
        this.data = someIds;
        this.length = someIds.length;
    }

    private void changeSize(int newSize) {
        if (newSize >= this.length) {
            long[] oldData = this.data;
            int oldLength = this.length;
            this.data = new long[newSize];
            this.length = 0;
            this.add(oldData, oldLength);
        }
    }

    public synchronized void add(long id) {
        if (this.length >= this.data.length) {
            if (this.length > 10000) {
                this.changeSize(this.length + 2000);
            } else {
                this.changeSize(this.length * 2);
            }
        }
        this.data[this.length++] = id;
    }

    public synchronized void add(long[] argIds, int argLength) {
        if (this.length + argLength > this.data.length) {
            long[] oldData = this.data;
            this.data = new long[argLength + this.length];
            System.arraycopy(oldData, 0, this.data, 0, oldData.length);
        }
        System.arraycopy(argIds, 0, this.data, this.length, argLength);
        this.length += argLength;
    }

    public synchronized void add(long[] argIds) {
        this.add(argIds, argIds.length);
    }

    public synchronized void add(LongBuffer argBuf) {
        this.add(argBuf.data, argBuf.length);
    }

    public synchronized long get(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException(" index " + index + " length " + this.length);
        }
        return this.data[index];
    }

    public synchronized long getAndStore(int index, int newValue) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException(" index " + index + " length " + this.length);
        }
        long result = this.data[index];
        this.data[index] = newValue;
        return result;
    }

    public synchronized void clear() {
        this.length = 0;
    }
}

