/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.internal.AvailablePort;
import dunit.VM;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class AvailablePortHelper {
    public static int[] getRandomAvailableTCPPorts(int count) {
        List<AvailablePort.Keeper> list = AvailablePortHelper.getRandomAvailableTCPPortKeepers(count);
        int[] ports = new int[list.size()];
        int i = 0;
        for (AvailablePort.Keeper k : list) {
            ports[i] = k.getPort();
            k.release();
            ++i;
        }
        return ports;
    }

    public static List<AvailablePort.Keeper> getRandomAvailableTCPPortKeepers(int count) {
        ArrayList<AvailablePort.Keeper> result = new ArrayList<AvailablePort.Keeper>();
        while (result.size() < count) {
            result.add(AvailablePort.getRandomAvailablePortKeeper((int)0));
        }
        return result;
    }

    public static int[] getRandomAvailableTCPPortsForDUnitSite(int count) {
        int site = 1;
        String hostName = System.getProperty("hostName");
        if (hostName.startsWith("host") && hostName.length() > 4) {
            site = Integer.parseInt(hostName.substring(4));
        }
        HashSet<Integer> set = new HashSet<Integer>();
        while (set.size() < count) {
            int port = AvailablePort.getRandomAvailablePortWithMod((int)0, (int)site);
            set.add(new Integer(port));
        }
        int[] ports = new int[set.size()];
        int i = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ports[i] = (Integer)iter.next();
            ++i;
        }
        return ports;
    }

    public static int getRandomAvailablePortForDUnitSite() {
        int site = 1;
        String hostName = System.getProperty("hostName");
        if (hostName != null && hostName.startsWith("host") && hostName.length() > 4) {
            site = Integer.parseInt(hostName.substring(4));
        }
        int port = AvailablePort.getRandomAvailablePortWithMod((int)0, (int)site);
        return port;
    }

    public static int getRandomAvailableTCPPort() {
        return AvailablePortHelper.getRandomAvailableTCPPorts(1)[0];
    }

    public static int getRandomAvailableTCPPortOnVM(VM vm) {
        return vm.invokeInt(AvailablePortHelper.class, "getRandomAvailableTCPPort");
    }

    public static int[] getRandomAvailableUDPPorts(int count) {
        HashSet<Integer> set = new HashSet<Integer>();
        while (set.size() < count) {
            int port = AvailablePort.getRandomAvailablePort((int)1);
            set.add(new Integer(port));
        }
        int[] ports = new int[set.size()];
        int i = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            ports[i] = (Integer)iter.next();
            ++i;
        }
        return ports;
    }

    public static int getRandomAvailableUDPPort() {
        return AvailablePortHelper.getRandomAvailableUDPPorts(1)[0];
    }

    public static int getRandomAvailableUDPPortOnVM(VM vm) {
        return vm.invokeInt(AvailablePortHelper.class, "getRandomAvailableUDPPort");
    }
}

