/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.protocols.GemFireTimeSync;
import com.gemstone.org.jgroups.stack.Protocol;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.Map;

public class DistributionManagerTimeDUnitTest
extends DistributedTestCase {
    public final int SKEDNESS = 10;

    public DistributionManagerTimeDUnitTest(String name) {
        super(name);
    }

    public void testDistributionManagerTimeSync() {
        DistributionManagerTimeDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        long vmtime0 = (Long)vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem system = DistributionManagerTimeDUnitTest.this.getSystem();
                DistributionManager dm = (DistributionManager)system.getDistributionManager();
                long timeOffset = dm.getCacheTimeOffset();
                return timeOffset;
            }
        });
        long vmtime1 = (Long)vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem system = DistributionManagerTimeDUnitTest.this.getSystem();
                DistributionManager dm = (DistributionManager)system.getDistributionManager();
                long timeOffset = dm.getCacheTimeOffset();
                return timeOffset;
            }
        });
        long vmtime2 = (Long)vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem system = DistributionManagerTimeDUnitTest.this.getSystem();
                DistributionManager dm = (DistributionManager)system.getDistributionManager();
                long timeOffset = dm.getCacheTimeOffset();
                return timeOffset;
            }
        });
        DistributionManagerTimeDUnitTest.getLogWriter().info("Offsets for VM0: " + vmtime0 + " VM1: " + vmtime1 + " and VM2: " + vmtime2);
        int diff1 = (int)(vmtime0 - vmtime1);
        int diff2 = (int)(vmtime1 - vmtime2);
        int diff3 = (int)(vmtime2 - vmtime0);
        if (diff1 > 10 || diff1 < -10 || diff2 > 10 || diff2 < -10 || diff3 > 10 || diff3 < -10) {
            DistributionManagerTimeDUnitTest.fail((String)"Clocks are skewed by more than 10 ms");
        }
    }

    public void testDistributionManagerTimeSyncAfterJoinDone() {
        DistributionManagerTimeDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Starting vm0"){

            @Override
            public void run2() {
                DistributionManagerTimeDUnitTest.this.getSystem();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Starting vm1"){

            @Override
            public void run2() {
                DistributionManagerTimeDUnitTest.this.getSystem();
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Starting vm2"){

            @Override
            public void run2() {
                DistributionManagerTimeDUnitTest.this.getSystem();
            }
        });
        long vmtime0 = (Long)this.getTimeOffset(vm0);
        long vmtime1 = (Long)this.getTimeOffset(vm1);
        long vmtime2 = (Long)this.getTimeOffset(vm2);
        DistributionManagerTimeDUnitTest.getLogWriter().info("Offsets for VM0: " + vmtime0 + " VM1: " + vmtime1 + " and VM2: " + vmtime2);
        int diff1 = (int)(vmtime0 - vmtime1);
        int diff2 = (int)(vmtime1 - vmtime2);
        int diff3 = (int)(vmtime2 - vmtime0);
        if (diff1 > 10 || diff1 < -10 || diff2 > 10 || diff2 < -10 || diff3 > 10 || diff3 < -10) {
            DistributionManagerTimeDUnitTest.fail((String)"Clocks are skewed by more than 10 ms");
        }
    }

    public Object getTimeOffset(VM vm) {
        return vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem system = DistributionManagerTimeDUnitTest.this.getSystem();
                JChannel jchannel = MembershipManagerHelper.getJChannel((DistributedSystem)system);
                final UnitTestHook gftsTestHook = new UnitTestHook();
                Protocol prot = jchannel.getProtocolStack().findProtocol("GemFireTimeSync");
                GemFireTimeSync gts = (GemFireTimeSync)prot;
                gts.setTestHook((GemFireTimeSync.TestHook)gftsTestHook);
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return gftsTestHook.getBarrier() == 1;
                    }

                    @Override
                    public String description() {
                        return "Waiting for this node to get time offsets from co-ordinator";
                    }
                }, 500L, 50L, false);
                DistributionManager dm = (DistributionManager)system.getDistributionManager();
                long timeOffset = dm.getCacheTimeOffset();
                gts.setTestHook(null);
                return timeOffset;
            }
        });
    }

    public class UnitTestHook
    implements GemFireTimeSync.TestHook {
        private int barrier = -1;

        public void hook(int barr) {
            this.barrier = barr;
        }

        public void setResponses(Map<Address, GemFireTimeSync.GFTimeSyncHeader> responses, long currentTime) {
        }

        public Map<Address, GemFireTimeSync.GFTimeSyncHeader> getResponses() {
            return null;
        }

        public long getCurTime() {
            return 0L;
        }

        public int getBarrier() {
            return this.barrier;
        }
    }
}

