/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DistributionAdvisorTest
extends DistributedTestCase {
    private transient DistributionAdvisor.Profile[] profiles;
    protected transient DistributionAdvisor advisor;

    public DistributionAdvisorTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        DistributionAdvisorTest.invokeInEveryVM(new SerializableRunnable("DistributionAdvisorTest: SetUp"){

            @Override
            public void run() {
                DistributionAdvisorTest.this.getSystem();
            }
        });
        this.advisor = DistributionAdvisor.createDistributionAdvisor((DistributionAdvisee)new DistributionAdvisee(){

            public DistributionAdvisee getParentAdvisee() {
                return null;
            }

            public InternalDistributedSystem getSystem() {
                return DistributionAdvisorTest.this.getSystem();
            }

            public String getName() {
                return "DistributionAdvisorTest";
            }

            public String getFullPath() {
                return this.getName();
            }

            public DM getDistributionManager() {
                return this.getSystem().getDistributionManager();
            }

            public DistributionAdvisor getDistributionAdvisor() {
                return DistributionAdvisorTest.this.advisor;
            }

            public DistributionAdvisor.Profile getProfile() {
                return null;
            }

            public void fillInProfile(DistributionAdvisor.Profile profile) {
            }

            public int getSerialNumber() {
                return 0;
            }

            public CancelCriterion getCancelCriterion() {
                return DistributionAdvisorTest.this.getSystem().getCancelCriterion();
            }
        });
        Set ids = this.getSystem().getDistributionManager().getOtherNormalDistributionManagerIds();
        DistributionAdvisorTest.assertEquals((int)4, (int)ids.size());
        ArrayList<DistributionAdvisor.Profile> profileList = new ArrayList<DistributionAdvisor.Profile>();
        int i = 0;
        for (InternalDistributedMember id : ids) {
            DistributionAdvisor.Profile profile = new DistributionAdvisor.Profile(id, 0);
            this.advisor.putProfile(profile);
            profileList.add(profile);
            ++i;
        }
        this.profiles = profileList.toArray(new DistributionAdvisor.Profile[profileList.size()]);
    }

    @Override
    public void tearDown2() throws Exception {
        this.advisor.close();
        super.tearDown2();
    }

    public void testGenericAdvice() {
        HashSet<InternalDistributedMember> expected = new HashSet<InternalDistributedMember>();
        for (int i = 0; i < this.profiles.length; ++i) {
            expected.add(this.profiles[i].getDistributedMember());
        }
        DistributionAdvisorTest.assertEquals(expected, (Object)this.advisor.adviseGeneric());
    }
}

