/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalRole;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class RoleTest
extends DistributedTestCase {
    public RoleTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRolesInLonerVM() {
        String rolesProp = "A,B,C,D,E,F,G";
        String[] rolesArray = new String[]{"A", "B", "C", "D", "E", "F", "G"};
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        config.setProperty("roles", "A,B,C,D,E,F,G");
        InternalDistributedSystem system = this.getSystem(config);
        try {
            DM dm = system.getDistributionManager();
            Set allRoles = dm.getAllRoles();
            RoleTest.assertEquals((int)rolesArray.length, (int)allRoles.size());
            InternalDistributedMember member = dm.getDistributionManagerId();
            Set roles = member.getRoles();
            RoleTest.assertEquals((int)rolesArray.length, (int)roles.size());
            InternalRole roleA = InternalRole.getRole((String)"roleA");
            RoleTest.assertEquals((boolean)false, (boolean)roleA.isPresent());
            RoleTest.assertEquals((int)0, (int)roleA.getCount());
            for (Role role : roles) {
                RoleTest.assertEquals((boolean)true, (boolean)role.isPresent());
                RoleTest.assertEquals((int)1, (int)role.getCount());
            }
        }
        finally {
            system.disconnect();
        }
    }

    public void testRolesInDistributedVMs() {
        int vm;
        final String[] vmRoleNames = new String[]{"VM_A", "BAR", "Foo,BAR", "Bip,BAM"};
        String[][] vmRoles = new String[][]{{"VM_A"}, {"BAR"}, {"Foo", "BAR"}, {"Bip", "BAM"}};
        final Object[][] roleCounts = new Object[][]{{"VM_A", new Integer(1)}, {"BAR", new Integer(2)}, {"Foo", new Integer(1)}, {"Bip", new Integer(1)}, {"BAM", new Integer(1)}};
        int i = 0;
        while (i < vmRoles.length) {
            vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributedTestCase.disconnectFromDS();
                    Properties config = new Properties();
                    config.setProperty("roles", vmRoleNames[vm]);
                    RoleTest.this.getSystem(config);
                }
            });
        }
        i = 0;
        while (i < vmRoles.length) {
            vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    InternalDistributedSystem sys = RoleTest.this.getSystem();
                    DM dm = sys.getDistributionManager();
                    Set allRoles = dm.getAllRoles();
                    TestCase.assertEquals((String)("allRoles is " + allRoles.size() + " but roleCounts should be " + roleCounts.length), (int)roleCounts.length, (int)allRoles.size());
                    for (Role role : allRoles) {
                        for (int j = 0; j < roleCounts.length; ++j) {
                            if (!role.getName().equals(roleCounts[j][0])) continue;
                            int count = (Integer)roleCounts[j][1];
                            TestCase.assertEquals((String)("count for role " + role + " is wrong"), (int)count, (int)dm.getRoleCount(role));
                            TestCase.assertEquals((String)("isRolePresent for role " + role + " should be true"), (boolean)true, (boolean)dm.isRolePresent(role));
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDuplicateRoleNames() {
        String rolesProp = "A,A";
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        config.setProperty("roles", "A,A");
        InternalDistributedSystem system = this.getSystem(config);
        try {
            DM dm = system.getDistributionManager();
            InternalDistributedMember member = dm.getDistributionManagerId();
            Set roles = member.getRoles();
            RoleTest.assertEquals((int)1, (int)roles.size());
            Role role = (Role)roles.iterator().next();
            RoleTest.assertEquals((boolean)true, (boolean)role.isPresent());
            RoleTest.assertEquals((int)1, (int)role.getCount());
        }
        finally {
            system.disconnect();
        }
    }
}

