/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.distributed.LocatorLauncher;
import com.gemstone.gemfire.distributed.LocatorLauncherRemoteDUnitTest;
import com.gemstone.gemfire.internal.process.ProcessControllerFactory;
import com.gemstone.gemfire.internal.process.ProcessStreamReader;
import com.gemstone.gemfire.internal.process.ProcessType;
import com.gemstone.gemfire.lang.AttachAPINotFoundException;
import dunit.SerializableRunnable;
import java.io.File;
import java.util.ArrayList;
import junit.framework.TestCase;

public class LocatorLauncherRemoteFileDUnitTest
extends LocatorLauncherRemoteDUnitTest {
    public LocatorLauncherRemoteFileDUnitTest(String name) {
        super(name);
    }

    @Override
    protected void subSetUp2() throws Exception {
        LocatorLauncherRemoteFileDUnitTest.disableAttachApi();
        LocatorLauncherRemoteFileDUnitTest.invokeInEveryVM(new SerializableRunnable("disableAttachApi"){

            @Override
            public void run() {
                LocatorLauncherRemoteFileDUnitTest.disableAttachApi();
            }
        });
    }

    @Override
    protected void subTearDown2() throws Exception {
        LocatorLauncherRemoteFileDUnitTest.enableAttachApi();
        LocatorLauncherRemoteFileDUnitTest.invokeInEveryVM(new SerializableRunnable("enableAttachApi"){

            @Override
            public void run() {
                LocatorLauncherRemoteFileDUnitTest.enableAttachApi();
            }
        });
    }

    @Override
    public void testIsAttachAPIFound() throws Exception {
        ProcessControllerFactory factory = new ProcessControllerFactory();
        LocatorLauncherRemoteFileDUnitTest.assertFalse((boolean)factory.isAttachAPIFound());
        LocatorLauncherRemoteFileDUnitTest.invokeInEveryVM(new SerializableRunnable("isAttachAPIFound"){

            @Override
            public void run() {
                ProcessControllerFactory factory = new ProcessControllerFactory();
                TestCase.assertFalse((boolean)factory.isAttachAPIFound());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testStatusUsingPid() throws Throwable {
        LocatorLauncher dirLauncher;
        int pid;
        Throwable failure;
        block12: {
            this.workingDirectory = new File(this.getUniqueName());
            this.workingDirectory.mkdir();
            LocatorLauncherRemoteFileDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
            ArrayList<String> jvmArguments = new ArrayList<String>();
            jvmArguments.add("-D" + this.getUniqueName() + "=true");
            jvmArguments.add("-Dgemfire.log-level=config");
            ArrayList<String> command = new ArrayList<String>();
            command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
            for (String jvmArgument : jvmArguments) {
                command.add(jvmArgument);
            }
            command.add("-cp");
            command.add(System.getProperty("java.class.path"));
            command.add(LocatorLauncher.class.getName());
            command.add(LocatorLauncher.Command.START.getName());
            command.add(this.getUniqueName());
            command.add("--port=" + this.locatorPort);
            command.add("--redirect-output");
            this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
            this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
            this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
            failure = null;
            pid = 0;
            LocatorLauncher pidLauncher = null;
            dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
            try {
                this.waitForLocatorToStart(dirLauncher);
                File pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
                LocatorLauncherRemoteFileDUnitTest.assertTrue((boolean)pidFile.exists());
                pid = this.readPid(pidFile);
                LocatorLauncherRemoteFileDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                LocatorLauncherRemoteFileDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                String logFileName = this.getUniqueName() + ".log";
                LocatorLauncherRemoteFileDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                pidLauncher = new LocatorLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                LocatorLauncherRemoteFileDUnitTest.assertNotNull((Object)pidLauncher);
                LocatorLauncherRemoteFileDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                try {
                    pidLauncher.status();
                    LocatorLauncherRemoteFileDUnitTest.fail((String)"FileProcessController should have thrown AttachAPINotFoundException");
                }
                catch (AttachAPINotFoundException attachAPINotFoundException) {}
            }
            catch (Throwable e) {
                LocatorLauncherRemoteFileDUnitTest.getLogWriter().error(e);
                if (failure != null) break block12;
                failure = e;
            }
        }
        try {
            LocatorLauncherRemoteFileDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)dirLauncher.stop().getStatus());
            this.waitForPidToStop(pid, true);
            this.waitForFileToDelete(this.pidFile);
        }
        catch (Throwable e) {
            LocatorLauncherRemoteFileDUnitTest.getLogWriter().error(e);
            if (failure == null) {
                failure = e;
            }
        }
        finally {
            new File(ProcessType.LOCATOR.getStatusRequestFileName()).delete();
        }
        if (failure != null) {
            throw failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testStopUsingPid() throws Throwable {
        LocatorLauncher dirLauncher;
        File pidFile;
        int pid;
        Throwable failure;
        block12: {
            this.workingDirectory = new File(this.getUniqueName());
            this.workingDirectory.mkdir();
            LocatorLauncherRemoteFileDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
            ArrayList<String> jvmArguments = new ArrayList<String>();
            jvmArguments.add("-D" + this.getUniqueName() + "=true");
            jvmArguments.add("-Dgemfire.log-level=config");
            ArrayList<String> command = new ArrayList<String>();
            command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
            for (String jvmArgument : jvmArguments) {
                command.add(jvmArgument);
            }
            command.add("-cp");
            command.add(System.getProperty("java.class.path"));
            command.add(LocatorLauncher.class.getName());
            command.add(LocatorLauncher.Command.START.getName());
            command.add(this.getUniqueName());
            command.add("--port=" + this.locatorPort);
            command.add("--redirect-output");
            this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
            this.processOutReader = new ProcessStreamReader(this.process.getInputStream(), this.createLoggingListener("sysout", this.getUniqueName() + "#sysout")).start();
            this.processErrReader = new ProcessStreamReader(this.process.getErrorStream(), this.createLoggingListener("syserr", this.getUniqueName() + "#syserr")).start();
            failure = null;
            pid = 0;
            pidFile = null;
            LocatorLauncher pidLauncher = null;
            dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
            try {
                this.waitForLocatorToStart(dirLauncher);
                pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
                LocatorLauncherRemoteFileDUnitTest.assertTrue((boolean)pidFile.exists());
                pid = this.readPid(pidFile);
                LocatorLauncherRemoteFileDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                LocatorLauncherRemoteFileDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                String logFileName = this.getUniqueName() + ".log";
                LocatorLauncherRemoteFileDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                pidLauncher = new LocatorLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                LocatorLauncherRemoteFileDUnitTest.assertNotNull((Object)pidLauncher);
                LocatorLauncherRemoteFileDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                try {
                    pidLauncher.stop();
                    LocatorLauncherRemoteFileDUnitTest.fail((String)"FileProcessController should have thrown AttachAPINotFoundException");
                }
                catch (AttachAPINotFoundException attachAPINotFoundException) {}
            }
            catch (Throwable e) {
                LocatorLauncherRemoteFileDUnitTest.getLogWriter().error(e);
                if (failure != null) break block12;
                failure = e;
            }
        }
        try {
            LocatorLauncherRemoteFileDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)dirLauncher.stop().getStatus());
            this.waitForPidToStop(pid);
            this.waitForFileToDelete(pidFile);
        }
        catch (Throwable e) {
            LocatorLauncherRemoteFileDUnitTest.getLogWriter().error(e);
            if (failure == null) {
                failure = e;
            }
        }
        finally {
            new File(ProcessType.LOCATOR.getStopRequestFileName()).delete();
        }
        if (failure != null) {
            throw failure;
        }
    }

    private static void disableAttachApi() {
        System.setProperty("gemfire.test.ProcessControllerFactory.DisableAttachApi", "true");
    }

    private static void enableAttachApi() {
        System.clearProperty("gemfire.test.ProcessControllerFactory.DisableAttachApi");
    }
}

