/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.distributed.AbstractLocatorLauncherDUnitTestCase;
import com.gemstone.gemfire.distributed.LocatorLauncher;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.process.ProcessControllerFactory;
import com.gemstone.gemfire.internal.process.ProcessStreamReader;
import com.gemstone.gemfire.internal.process.ProcessType;
import com.gemstone.gemfire.internal.process.ProcessUtils;
import com.gemstone.org.jgroups.util.GFLogWriter;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;

public class LocatorLauncherRemoteDUnitTest
extends AbstractLocatorLauncherDUnitTestCase {
    protected volatile transient Process process;
    protected volatile transient ProcessStreamReader processOutReader;
    protected volatile transient ProcessStreamReader processErrReader;
    protected volatile transient File workingDirectory = null;

    public LocatorLauncherRemoteDUnitTest(String name) {
        super(name);
    }

    @Override
    protected void subSetUp1() throws Exception {
        this.subSetUp2();
    }

    @Override
    protected void subTearDown1() throws Exception {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        if (this.processOutReader != null && this.processOutReader.isRunning()) {
            this.processOutReader.stop();
        }
        if (this.processErrReader != null && this.processErrReader.isRunning()) {
            this.processErrReader.stop();
        }
        if (this.workingDirectory != null) {
            this.workingDirectory = null;
        }
        this.subTearDown2();
    }

    protected void subSetUp2() throws Exception {
    }

    protected void subTearDown2() throws Exception {
    }

    protected AbstractLauncher.Status getExpectedStopStatusForNotRunning() {
        return AbstractLauncher.Status.NOT_RESPONDING;
    }

    public void testIsAttachAPIFound() throws Exception {
        ProcessControllerFactory factory = new ProcessControllerFactory();
        LocatorLauncherRemoteDUnitTest.assertTrue((boolean)factory.isAttachAPIFound());
        LocatorLauncherRemoteDUnitTest.invokeInEveryVM(new SerializableRunnable("isAttachAPIFound"){

            @Override
            public void run() {
                ProcessControllerFactory factory = new ProcessControllerFactory();
                TestCase.assertTrue((boolean)factory.isAttachAPIFound());
            }
        });
    }

    public void testRunningLocatorOutlivesForkingProcess() throws InterruptedException, IOException {
        this.workingDirectory = new File(this.getUniqueName());
        this.workingDirectory.mkdir();
        LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
        ArrayList<String> command = new ArrayList<String>();
        command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
        command.add("-cp");
        command.add(System.getProperty("java.class.path"));
        command.add(LocatorLauncherRemoteDUnitTest.class.getName().concat("$").concat(LocatorLauncherForkingProcess.class.getSimpleName()));
        command.add(String.valueOf(this.locatorPort));
        this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
        this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
        this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
        Thread waiting = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestCase.assertEquals((int)0, (int)LocatorLauncherRemoteDUnitTest.this.process.waitFor());
                }
                catch (InterruptedException ignore) {
                    DistributedTestCase.getLogWriter().error("Interrupted while waiting for process!", (Throwable)ignore);
                }
            }
        });
        try {
            waiting.start();
            waiting.join(300000L);
            LocatorLauncherRemoteDUnitTest.assertFalse((String)"Process took too long and timed out!", (boolean)waiting.isAlive());
        }
        finally {
            if (waiting.isAlive()) {
                waiting.interrupt();
            }
        }
        LocatorLauncher locatorLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
        LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)locatorLauncher.status().getStatus());
        LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)locatorLauncher.stop().getStatus());
    }

    public void testStartCreatesPidFile() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(LocatorLauncher.class.getName());
                command.add(LocatorLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--port=" + this.locatorPort);
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForLocatorToStart(this.launcher);
                    this.pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    LocatorLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    LocatorLauncher.LocatorState locatorState = this.launcher.status();
                    LocatorLauncherRemoteDUnitTest.assertNotNull((Object)locatorState);
                    LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)locatorState.getStatus());
                }
                catch (Throwable e) {
                    LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartDeletesStaleControlFiles() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                this.stopRequestFile = new File(this.workingDirectory, ProcessType.LOCATOR.getStopRequestFileName());
                this.stopRequestFile.createNewFile();
                LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.stopRequestFile.exists());
                this.statusRequestFile = new File(this.workingDirectory, ProcessType.LOCATOR.getStatusRequestFileName());
                this.statusRequestFile.createNewFile();
                LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.statusRequestFile.exists());
                this.statusFile = new File(this.workingDirectory, ProcessType.LOCATOR.getStatusFileName());
                this.statusFile.createNewFile();
                LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.statusFile.exists());
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(LocatorLauncher.class.getName());
                command.add(LocatorLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--port=" + this.locatorPort);
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForLocatorToStart(this.launcher);
                    this.pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    LocatorLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    this.waitForFileToDelete(this.stopRequestFile);
                    this.waitForFileToDelete(this.statusRequestFile);
                    this.waitForFileToDelete(this.statusFile);
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartOverwritesStalePidFile() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                LocatorLauncherRemoteDUnitTest.assertTrue((String)(this.getUniqueName() + " is broken if PID == Integer.MAX_VALUE"), (ProcessUtils.identifyPid() != Integer.MAX_VALUE ? 1 : 0) != 0);
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                this.pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
                this.writePid(this.pidFile, Integer.MAX_VALUE);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(LocatorLauncher.class.getName());
                command.add(LocatorLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--port=" + this.locatorPort);
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForLocatorToStart(this.launcher);
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    LocatorLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    LocatorLauncherRemoteDUnitTest.assertFalse((pid == Integer.MAX_VALUE ? 1 : 0) != 0);
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingForceOverwritesExistingPidFile() throws Throwable {
        Throwable failure;
        block7: {
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                this.pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
                int otherPid = LocatorLauncherRemoteDUnitTest.getPid();
                LocatorLauncherRemoteDUnitTest.assertTrue((String)("Pid " + otherPid + " should be alive"), (boolean)this.isPidAlive(otherPid));
                this.writePid(this.pidFile, otherPid);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(LocatorLauncher.class.getName());
                command.add(LocatorLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--port=" + this.locatorPort);
                command.add("--redirect-output");
                command.add("--force");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                this.launcher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForLocatorToStart(this.launcher);
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    LocatorLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    LocatorLauncherRemoteDUnitTest.assertTrue((pid != otherPid ? 1 : 0) != 0);
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingPortInUseFails() throws Throwable {
        Throwable failure;
        block12: {
            LocatorLauncher dirLauncher;
            AtomicBoolean outputContainedExpectedString;
            block11: {
                block10: {
                    this.workingDirectory = new File(this.getUniqueName());
                    this.workingDirectory.mkdir();
                    LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                    this.socket = SocketCreator.getDefaultInstance().createServerSocket(this.locatorPort, 50, null, (GFLogWriter)LocatorLauncherRemoteDUnitTest.getLogWriter().convertToLogWriterI18n(), -1);
                    ArrayList<String> jvmArguments = new ArrayList<String>();
                    jvmArguments.add("-D" + this.getUniqueName() + "=true");
                    jvmArguments.add("-Dgemfire.log-level=config");
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                    for (String jvmArgument : jvmArguments) {
                        command.add(jvmArgument);
                    }
                    command.add("-cp");
                    command.add(System.getProperty("java.class.path"));
                    command.add(LocatorLauncher.class.getName());
                    command.add(LocatorLauncher.Command.START.getName());
                    command.add(this.getUniqueName());
                    command.add("--redirect-output");
                    command.add("--port=" + this.locatorPort);
                    String expectedString = "java.net.BindException";
                    outputContainedExpectedString = new AtomicBoolean();
                    this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                    this.processOutReader = new ProcessStreamReader(this.process.getInputStream(), this.createExpectedListener("sysout", this.getUniqueName() + "#sysout", expectedString, outputContainedExpectedString)).start();
                    this.processErrReader = new ProcessStreamReader(this.process.getErrorStream(), this.createExpectedListener("syserr", this.getUniqueName() + "#syserr", expectedString, outputContainedExpectedString)).start();
                    failure = null;
                    dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                    try {
                        int code = this.process.waitFor();
                        LocatorLauncherRemoteDUnitTest.assertEquals((String)("Expected exit code 1 but was " + code), (int)1, (int)code);
                    }
                    catch (Throwable e) {
                        LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block10;
                        failure = e;
                    }
                }
                try {
                    LocatorLauncher.LocatorState locatorState = dirLauncher.status();
                    LocatorLauncherRemoteDUnitTest.assertNotNull((Object)locatorState);
                    LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.NOT_RESPONDING, (Object)locatorState.getStatus());
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherRemoteDUnitTest.assertFalse((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block11;
                    failure = e;
                }
            }
            LocatorLauncherRemoteDUnitTest.assertTrue((boolean)outputContainedExpectedString.get());
            LocatorLauncher.LocatorState status = null;
            try {
                status = dirLauncher.stop();
            }
            catch (Throwable logFileName) {
                // empty catch block
            }
            try {
                LocatorLauncherRemoteDUnitTest.assertEquals((Object)this.getExpectedStopStatusForNotRunning(), (Object)status.getStatus());
            }
            catch (Throwable e) {
                LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block12;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartWithDefaultPortInUseFails() throws Throwable {
        Throwable failure;
        block12: {
            LocatorLauncher dirLauncher;
            AtomicBoolean outputContainedExpectedString;
            block11: {
                block10: {
                    this.workingDirectory = new File(this.getUniqueName());
                    this.workingDirectory.mkdir();
                    LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                    String expectedString = "java.net.BindException";
                    outputContainedExpectedString = new AtomicBoolean();
                    this.socket = SocketCreator.getDefaultInstance().createServerSocket(this.locatorPort, 50, null, (GFLogWriter)LocatorLauncherRemoteDUnitTest.getLogWriter().convertToLogWriterI18n(), -1);
                    LocatorLauncherRemoteDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.locatorPort, (int)0));
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.socket.isBound());
                    LocatorLauncherRemoteDUnitTest.assertFalse((boolean)this.socket.isClosed());
                    ArrayList<String> jvmArguments = new ArrayList<String>();
                    jvmArguments.add("-Dgemfire.test.DistributionLocator.OVERRIDE_DEFAULT_PORT=" + this.locatorPort);
                    jvmArguments.add("-D" + this.getUniqueName() + "=true");
                    jvmArguments.add("-Dgemfire.log-level=config");
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                    for (String jvmArgument : jvmArguments) {
                        command.add(jvmArgument);
                    }
                    command.add("-cp");
                    command.add(System.getProperty("java.class.path"));
                    command.add(LocatorLauncher.class.getName());
                    command.add(LocatorLauncher.Command.START.getName());
                    command.add(this.getUniqueName());
                    command.add("--redirect-output");
                    this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                    this.processOutReader = new ProcessStreamReader(this.process.getInputStream(), this.createExpectedListener("sysout", this.getUniqueName() + "#sysout", expectedString, outputContainedExpectedString)).start();
                    this.processErrReader = new ProcessStreamReader(this.process.getErrorStream(), this.createExpectedListener("syserr", this.getUniqueName() + "#syserr", expectedString, outputContainedExpectedString)).start();
                    failure = null;
                    dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                    try {
                        int code = this.process.waitFor();
                        LocatorLauncherRemoteDUnitTest.assertEquals((String)("Expected exit code 1 but was " + code), (int)1, (int)code);
                    }
                    catch (Throwable e) {
                        LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block10;
                        failure = e;
                    }
                }
                try {
                    LocatorLauncher.LocatorState locatorState = dirLauncher.status();
                    LocatorLauncherRemoteDUnitTest.assertNotNull((Object)locatorState);
                    LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.NOT_RESPONDING, (Object)locatorState.getStatus());
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherRemoteDUnitTest.assertFalse((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block11;
                    failure = e;
                }
            }
            LocatorLauncherRemoteDUnitTest.assertTrue((boolean)outputContainedExpectedString.get());
            LocatorLauncher.LocatorState status = null;
            try {
                status = dirLauncher.stop();
            }
            catch (Throwable logFileName) {
                // empty catch block
            }
            try {
                LocatorLauncherRemoteDUnitTest.assertEquals((Object)this.getExpectedStopStatusForNotRunning(), (Object)status.getStatus());
            }
            catch (Throwable e) {
                LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block12;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartWithExistingPidFileFails() throws Throwable {
        Throwable failure;
        block10: {
            LocatorLauncher dirLauncher;
            block9: {
                block8: {
                    this.workingDirectory = new File(this.getUniqueName());
                    this.workingDirectory.mkdir();
                    LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                    this.pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
                    int realPid = Host.getHost(0).getVM(3).invokeInt(ProcessUtils.class, "identifyPid");
                    LocatorLauncherRemoteDUnitTest.assertFalse((String)("Remote pid shouldn't be the same as local pid " + realPid), (realPid == ProcessUtils.identifyPid() ? 1 : 0) != 0);
                    this.writePid(this.pidFile, realPid);
                    ArrayList<String> jvmArguments = new ArrayList<String>();
                    jvmArguments.add("-D" + this.getUniqueName() + "=true");
                    jvmArguments.add("-Dgemfire.log-level=config");
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                    for (String jvmArgument : jvmArguments) {
                        command.add(jvmArgument);
                    }
                    command.add("-cp");
                    command.add(System.getProperty("java.class.path"));
                    command.add(LocatorLauncher.class.getName());
                    command.add(LocatorLauncher.Command.START.getName());
                    command.add(this.getUniqueName());
                    command.add("--port=" + this.locatorPort);
                    command.add("--redirect-output");
                    this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                    this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                    this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                    failure = null;
                    dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                    try {
                        this.waitForLocatorToStart(dirLauncher, 10000L, false);
                    }
                    catch (Throwable e) {
                        LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block8;
                        failure = e;
                    }
                }
                try {
                    LocatorLauncher.LocatorState locatorState = dirLauncher.status();
                    LocatorLauncherRemoteDUnitTest.assertNotNull((Object)locatorState);
                    LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.NOT_RESPONDING, (Object)locatorState.getStatus());
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherRemoteDUnitTest.assertFalse((String)("Log file should not exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block9;
                    failure = e;
                }
            }
            try {
                LocatorLauncher.LocatorState status = dirLauncher.stop();
                AbstractLauncher.Status theStatus = status.getStatus();
                LocatorLauncherRemoteDUnitTest.assertFalse((theStatus == AbstractLauncher.Status.STARTING ? 1 : 0) != 0);
                LocatorLauncherRemoteDUnitTest.assertFalse((theStatus == AbstractLauncher.Status.ONLINE ? 1 : 0) != 0);
            }
            catch (Throwable e) {
                LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block10;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStatusUsingPid() throws Throwable {
        Throwable failure;
        block9: {
            LocatorLauncher dirLauncher;
            LocatorLauncher pidLauncher;
            int pid;
            block8: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(LocatorLauncher.class.getName());
                command.add(LocatorLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--port=" + this.locatorPort);
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                pidLauncher = null;
                dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForLocatorToStart(dirLauncher);
                    this.pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    LocatorLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    pidLauncher = new LocatorLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                    LocatorLauncherRemoteDUnitTest.assertNotNull((Object)pidLauncher);
                    LocatorLauncherRemoteDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                    LocatorLauncher.LocatorState actualStatus = pidLauncher.status();
                    LocatorLauncherRemoteDUnitTest.assertNotNull((Object)actualStatus);
                    LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)actualStatus.getStatus());
                    LocatorLauncherRemoteDUnitTest.assertEquals((int)pid, (int)actualStatus.getPid());
                    LocatorLauncherRemoteDUnitTest.assertTrue((actualStatus.getUptime() > 0L ? 1 : 0) != 0);
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)this.workingDirectory.getCanonicalPath(), (String)actualStatus.getWorkingDirectory());
                    LocatorLauncherRemoteDUnitTest.assertEquals(jvmArguments, (Object)actualStatus.getJvmArguments());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)ManagementFactory.getRuntimeMXBean().getClassPath(), (String)actualStatus.getClasspath());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)GemFireVersion.getGemFireVersion(), (String)actualStatus.getGemFireVersion());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)System.getProperty("java.version"), (String)actualStatus.getJavaVersion());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)(this.workingDirectory.getCanonicalPath() + File.separator + this.getUniqueName() + ".log"), (String)actualStatus.getLogFile());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)SocketCreator.getLocalHost().getCanonicalHostName(), (String)actualStatus.getHost());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)this.getUniqueName(), (String)actualStatus.getMemberName());
                }
                catch (Throwable e) {
                    LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block8;
                    failure = e;
                }
            }
            try {
                if (pidLauncher == null) {
                    LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)dirLauncher.stop().getStatus());
                } else {
                    LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)pidLauncher.stop().getStatus());
                }
                this.waitForPidToStop(pid);
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block9;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStatusUsingWorkingDirectory() throws Throwable {
        Throwable failure;
        block7: {
            LocatorLauncher dirLauncher;
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(LocatorLauncher.class.getName());
                command.add(LocatorLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--port=" + this.locatorPort);
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForLocatorToStart(dirLauncher);
                    this.pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    LocatorLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    LocatorLauncherRemoteDUnitTest.assertNotNull((Object)dirLauncher);
                    LocatorLauncherRemoteDUnitTest.assertFalse((boolean)dirLauncher.isRunning());
                    LocatorLauncher.LocatorState actualStatus = dirLauncher.status();
                    LocatorLauncherRemoteDUnitTest.assertNotNull((Object)actualStatus);
                    LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)actualStatus.getStatus());
                    LocatorLauncherRemoteDUnitTest.assertEquals((int)pid, (int)actualStatus.getPid());
                    LocatorLauncherRemoteDUnitTest.assertTrue((actualStatus.getUptime() > 0L ? 1 : 0) != 0);
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)this.workingDirectory.getCanonicalPath(), (String)actualStatus.getWorkingDirectory());
                    LocatorLauncherRemoteDUnitTest.assertEquals(jvmArguments, (Object)actualStatus.getJvmArguments());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)ManagementFactory.getRuntimeMXBean().getClassPath(), (String)actualStatus.getClasspath());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)GemFireVersion.getGemFireVersion(), (String)actualStatus.getGemFireVersion());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)System.getProperty("java.version"), (String)actualStatus.getJavaVersion());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)(this.workingDirectory.getCanonicalPath() + File.separator + this.getUniqueName() + ".log"), (String)actualStatus.getLogFile());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)SocketCreator.getLocalHost().getCanonicalHostName(), (String)actualStatus.getHost());
                    LocatorLauncherRemoteDUnitTest.assertEquals((String)this.getUniqueName(), (String)actualStatus.getMemberName());
                }
                catch (Throwable e) {
                    LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)dirLauncher.stop().getStatus());
                this.waitForPidToStop(pid);
            }
            catch (Throwable e) {
                LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStatusWithEmptyPidFile() throws Exception {
        this.workingDirectory = new File(this.getUniqueName());
        this.workingDirectory.mkdir();
        LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
        this.pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
        LocatorLauncherRemoteDUnitTest.assertTrue((String)(this.pidFile + " already exists"), (boolean)this.pidFile.createNewFile());
        LocatorLauncher dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
        try {
            dirLauncher.status();
            LocatorLauncherRemoteDUnitTest.fail((String)"Status should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            String expected = "Invalid pid 'null' found in " + this.pidFile.getCanonicalPath();
            LocatorLauncherRemoteDUnitTest.assertEquals((String)("Message was " + e.getMessage() + " instead of " + expected), (String)expected, (String)e.getMessage());
        }
    }

    public void testStatusWithNoPidFile() throws Exception {
        this.workingDirectory = new File(this.getUniqueName());
        this.workingDirectory.mkdir();
        LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
        LocatorLauncher dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
        LocatorLauncher.LocatorState locatorState = dirLauncher.status();
        LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.NOT_RESPONDING, (Object)locatorState.getStatus());
    }

    public void testStatusWithStalePidFile() throws Exception {
        this.workingDirectory = new File(this.getUniqueName());
        this.workingDirectory.mkdir();
        LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
        this.pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
        boolean pid = false;
        LocatorLauncherRemoteDUnitTest.assertFalse((boolean)ProcessUtils.isProcessAlive((int)0));
        this.writePid(this.pidFile, 0);
        LocatorLauncher dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
        try {
            dirLauncher.status();
            LocatorLauncherRemoteDUnitTest.fail((String)"Status should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            String expected = "Invalid pid '0' found in " + this.pidFile.getCanonicalPath();
            LocatorLauncherRemoteDUnitTest.assertEquals((String)("Message was " + e.getMessage() + " instead of " + expected), (String)expected, (String)e.getMessage());
        }
    }

    public void testStopUsingPid() throws Throwable {
        Throwable failure;
        block9: {
            LocatorLauncher dirLauncher;
            LocatorLauncher pidLauncher;
            int pid;
            block8: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(LocatorLauncher.class.getName());
                command.add(LocatorLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--port=" + this.locatorPort);
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream(), this.createLoggingListener("sysout", this.getUniqueName() + "#sysout")).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream(), this.createLoggingListener("syserr", this.getUniqueName() + "#syserr")).start();
                failure = null;
                pid = 0;
                pidLauncher = null;
                dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForLocatorToStart(dirLauncher);
                    this.pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    LocatorLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                    pidLauncher = new LocatorLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                    LocatorLauncherRemoteDUnitTest.assertNotNull((Object)pidLauncher);
                    LocatorLauncherRemoteDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                    LocatorLauncher.LocatorState status = pidLauncher.status();
                    LocatorLauncherRemoteDUnitTest.assertNotNull((Object)status);
                    LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)status.getStatus());
                    LocatorLauncherRemoteDUnitTest.assertEquals((int)pid, (int)status.getPid());
                }
                catch (Throwable e) {
                    LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block8;
                    failure = e;
                }
            }
            try {
                if (pidLauncher == null) {
                    LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)dirLauncher.stop().getStatus());
                } else {
                    LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)pidLauncher.stop().getStatus());
                }
                this.waitForPidToStop(pid);
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block9;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStopUsingWorkingDirectory() throws Throwable {
        Throwable failure;
        block7: {
            LocatorLauncher dirLauncher;
            int pid;
            block6: {
                this.workingDirectory = new File(this.getUniqueName());
                this.workingDirectory.mkdir();
                LocatorLauncherRemoteDUnitTest.assertTrue((this.workingDirectory.isDirectory() && this.workingDirectory.canWrite() ? 1 : 0) != 0);
                ArrayList<String> jvmArguments = new ArrayList<String>();
                jvmArguments.add("-D" + this.getUniqueName() + "=true");
                jvmArguments.add("-Dgemfire.log-level=config");
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getCanonicalPath());
                for (String jvmArgument : jvmArguments) {
                    command.add(jvmArgument);
                }
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add(LocatorLauncher.class.getName());
                command.add(LocatorLauncher.Command.START.getName());
                command.add(this.getUniqueName());
                command.add("--port=" + this.locatorPort);
                command.add("--redirect-output");
                this.process = new ProcessBuilder(command).directory(this.workingDirectory).start();
                this.processOutReader = new ProcessStreamReader(this.process.getInputStream()).start();
                this.processErrReader = new ProcessStreamReader(this.process.getErrorStream()).start();
                failure = null;
                pid = 0;
                dirLauncher = new LocatorLauncher.Builder().setWorkingDirectory(this.workingDirectory.getCanonicalPath()).build();
                try {
                    this.waitForLocatorToStart(dirLauncher);
                    this.pidFile = new File(this.workingDirectory, ProcessType.LOCATOR.getPidFileName());
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    LocatorLauncherRemoteDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    LocatorLauncherRemoteDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    String logFileName = this.getUniqueName() + ".log";
                    LocatorLauncherRemoteDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(this.workingDirectory, logFileName).exists());
                }
                catch (Throwable e) {
                    LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block6;
                    failure = e;
                }
            }
            try {
                LocatorLauncherRemoteDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)dirLauncher.stop().getStatus());
                this.waitForPidToStop(pid);
                LocatorLauncherRemoteDUnitTest.assertFalse((String)"PID file still exists!", (boolean)this.pidFile.exists());
            }
            catch (Throwable e) {
                LocatorLauncherRemoteDUnitTest.getLogWriter().error(e);
                if (failure != null) break block7;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public static class LocatorLauncherForkingProcess {
        public static void main(String ... args) throws FileNotFoundException {
            File file = new File(System.getProperty("user.dir"), LocatorLauncherForkingProcess.class.getSimpleName().concat(".log"));
            LocalLogWriter logWriter = new LocalLogWriter(Integer.MIN_VALUE, new PrintStream(new FileOutputStream(file, true)));
            try {
                int port = Integer.parseInt(args[0]);
                ArrayList<String> command = new ArrayList<String>();
                command.add(new File(new File(System.getProperty("java.home"), "bin"), "java").getAbsolutePath());
                command.add("-cp");
                command.add(System.getProperty("java.class.path"));
                command.add("-Dgemfire.mcast-port=0");
                command.add(LocatorLauncher.class.getName());
                command.add(LocatorLauncher.Command.START.getName());
                command.add(LocatorLauncherForkingProcess.class.getSimpleName() + "_Locator");
                command.add("--port=" + port);
                command.add("--redirect-output");
                logWriter.info(LocatorLauncherForkingProcess.class.getSimpleName() + "#main command: " + command);
                logWriter.info(LocatorLauncherForkingProcess.class.getSimpleName() + "#main starting...");
                Process forkedProcess = new ProcessBuilder(command).start();
                ProcessStreamReader processOutReader = new ProcessStreamReader(forkedProcess.getInputStream()).start();
                ProcessStreamReader processErrReader = new ProcessStreamReader(forkedProcess.getErrorStream()).start();
                logWriter.info(LocatorLauncherForkingProcess.class.getSimpleName() + "#main waiting for locator to start...");
                AbstractLocatorLauncherDUnitTestCase.waitForLocatorToStart(port, 300000L, 10L, true);
                logWriter.info(LocatorLauncherForkingProcess.class.getSimpleName() + "#main exiting...");
                System.exit(0);
            }
            catch (Throwable t) {
                logWriter.info(LocatorLauncherForkingProcess.class.getSimpleName() + "#main error: " + t, t);
                System.exit(-1);
            }
        }
    }
}

