/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.distributed.internal.SizeableRunnable;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.org.jgroups.protocols.pbcast.ClientGmsImpl;
import com.gemstone.org.jgroups.util.ExternalStrings;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public class DistributedSystemTest
extends DistributedTestCase {
    static volatile String problem;

    public DistributedSystemTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        DistributedSystemTest.disconnectAllFromDS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWaitForDeparture() throws Exception {
        DistributedSystemTest.disconnectAllFromDS();
        Properties p = this.getDistributedSystemProperties();
        p.put("locators", "");
        p.put("mcast-port", "" + AvailablePort.getRandomAvailablePort((int)1));
        p.put("disable-tcp", "true");
        InternalDistributedSystem ds = (InternalDistributedSystem)DistributedSystem.connect((Properties)p);
        try {
            InternalDistributedMember mbr = new InternalDistributedMember("localhost", 12345, "", "");
            final DistributionManager mgr = (DistributionManager)ds.getDistributionManager();
            final FakeMessage msg = new FakeMessage(null);
            mgr.getExecutor(74, mbr).execute((Runnable)new SizeableRunnable(100){

                public void run() {
                    msg.doAction(mgr, false);
                }

                public String toString() {
                    return "Processing fake message";
                }
            });
            try {
                DistributedSystemTest.assertTrue((String)"expected the serial queue to be flushed", (boolean)mgr.getMembershipManager().waitForDeparture((DistributedMember)mbr));
            }
            catch (InterruptedException e) {
                DistributedSystemTest.fail((String)"interrupted");
            }
            catch (TimeoutException e) {
                DistributedSystemTest.fail((String)"timed out - increase this test's member-timeout setting");
            }
        }
        finally {
            ds.disconnect();
        }
    }

    public void testGetSameSystemTwice() {
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        config.setProperty("mcast-flow-control", "3000000,0.20,3000");
        DistributedSystem system1 = DistributedSystem.connect((Properties)config);
        DistributedSystem system2 = DistributedSystem.connect((Properties)config);
        DistributedSystemTest.assertSame((Object)system1, (Object)system2);
        system1.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDifferentSystem() {
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        config.setProperty("mcast-flow-control", "3000000,0.20,3000");
        DistributedSystem system1 = DistributedSystem.connect((Properties)config);
        config.setProperty("mcast-address", "224.0.0.1");
        try {
            DistributedSystem.connect((Properties)config);
            if (System.getProperty("gemfire.mcast-address") == null) {
                DistributedSystemTest.fail((String)"Should have thrown an IllegalStateException");
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            system1.disconnect();
        }
    }

    public void testGetDifferentSystemAfterClose() {
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        DistributedSystem system1 = DistributedSystem.connect((Properties)config);
        system1.disconnect();
        int time = 32;
        config.put("ack-wait-threshold", String.valueOf(time));
        DistributedSystem system2 = DistributedSystem.connect((Properties)config);
        system2.disconnect();
    }

    public void testGetProperties() {
        Properties config = new Properties();
        int unusedPort = 0;
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        DistributedSystem system1 = DistributedSystem.connect((Properties)config);
        DistributedSystemTest.assertTrue((config != system1.getProperties() ? 1 : 0) != 0);
        DistributedSystemTest.assertEquals((int)unusedPort, (int)Integer.parseInt(system1.getProperties().getProperty("mcast-port")));
        system1.disconnect();
        DistributedSystemTest.assertTrue((config != system1.getProperties() ? 1 : 0) != 0);
        DistributedSystemTest.assertEquals((int)unusedPort, (int)Integer.parseInt(system1.getProperties().getProperty("mcast-port")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsolatedDistributedSystem() throws Exception {
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
        try {
            Cache cache = CacheFactory.create((DistributedSystem)this.getSystem());
            Region r = cache.createRegion(this.getUniqueName(), new AttributesFactory().create());
            r.put((Object)"test", (Object)"value");
            DistributedSystemTest.assertEquals((Object)"value", (Object)r.get((Object)"test"));
        }
        finally {
            this.getSystem().disconnect();
        }
    }

    public void testSpecificTcpPort() throws Exception {
        Properties config = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int tcpPort = AvailablePort.getRandomAvailablePort((int)0);
        config.setProperty("mcast-port", String.valueOf(mcastPort));
        config.setProperty("locators", "");
        config.setProperty("tcp-port", String.valueOf(tcpPort));
        system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
        DistributionManager dm = (DistributionManager)system.getDistributionManager();
        JGroupMembershipManager mgr = (JGroupMembershipManager)dm.getMembershipManager();
        int actualPort = mgr.getDirectChannelPort();
        system.disconnect();
        DistributedSystemTest.assertEquals((int)tcpPort, (int)actualPort);
    }

    public void DISABLED_BUG_51467_testLoopbackNotAllowed() throws Exception {
        InetAddress loopback = null;
        Enumeration<NetworkInterface> it = NetworkInterface.getNetworkInterfaces();
        block2: while (it.hasMoreElements()) {
            NetworkInterface nif = it.nextElement();
            Enumeration<InetAddress> ait = nif.getInetAddresses();
            while (ait.hasMoreElements()) {
                InetAddress a = ait.nextElement();
                if (!a.isLoopbackAddress()) continue;
                loopback = a;
                if (a instanceof Inet6Address) continue;
                continue block2;
            }
        }
        if (loopback != null) {
            Properties config = new Properties();
            config.put("mcast-port", "0");
            String locators = InetAddress.getLocalHost().getHostName() + ":" + DistributedSystemTest.getDUnitLocatorPort();
            config.put("locators", locators);
            config.setProperty("bind-address", loopback.getHostAddress());
            DistributedSystemTest.getLogWriter().info("attempting to connect with " + loopback + " and locators=" + locators);
            try {
                system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
                system.disconnect();
                DistributedSystemTest.fail((String)"expected a configuration exception disallowing use of loopback address");
            }
            catch (DistributionException distributionException) {
                // empty catch block
            }
        }
    }

    public void testBug43652() throws Exception {
        InternalDistributedSystem sys = this.getSystem();
        JGroupMembershipManager mgr = MembershipManagerHelper.getMembershipManager((DistributedSystem)sys);
        boolean result = mgr.getNakAck().testRetransmitLargeMessage(new byte[75000]);
        DistributedSystemTest.assertTrue((boolean)result);
        sys.disconnect();
    }

    public void testUDPPortRange() throws Exception {
        Properties config = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int unicastPort = AvailablePort.getRandomAvailablePort((int)0);
        config.setProperty("mcast-port", String.valueOf(mcastPort));
        config.setProperty("locators", "");
        config.setProperty("membership-port-range", "" + unicastPort + "-" + (unicastPort + 2));
        system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
        DistributionManager dm = (DistributionManager)system.getDistributionManager();
        InternalDistributedMember idm = dm.getDistributionManagerId();
        system.disconnect();
        DistributedSystemTest.assertTrue((unicastPort <= idm.getPort() && idm.getPort() <= unicastPort + 2 ? 1 : 0) != 0);
        DistributedSystemTest.assertTrue((unicastPort <= idm.getPort() && idm.getDirectChannelPort() <= unicastPort + 2 ? 1 : 0) != 0);
    }

    public void testMembershipPortRange() throws Exception {
        Properties config = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int unicastPort = AvailablePort.getRandomAvailablePort((int)0);
        config.setProperty("mcast-port", String.valueOf(mcastPort));
        config.setProperty("locators", "");
        config.setProperty("membership-port-range", "" + unicastPort + "-" + (unicastPort + 1));
        try {
            system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
        }
        catch (Exception e) {
            DistributedSystemTest.assertTrue((String)"The exception must be IllegalArgumentException", (boolean)(e instanceof IllegalArgumentException));
            return;
        }
        DistributedSystemTest.fail((String)("IllegalArgumentException must have been thrown by DistributedSystem.connect() as port-range: " + config.getProperty("membership-port-range") + " must have at least 3 values in range"));
    }

    public void testMembershipPortRangeWithExactThreeValues() throws Exception {
        Properties config = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        config.setProperty("mcast-port", String.valueOf(mcastPort));
        config.setProperty("locators", "");
        config.setProperty("membership-port-range", "" + (DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[1] - 2) + "-" + DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[1]);
        system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
        Cache cache = CacheFactory.create((DistributedSystem)system);
        cache.addCacheServer();
        DistributionManager dm = (DistributionManager)system.getDistributionManager();
        InternalDistributedMember idm = dm.getDistributionManagerId();
        system.disconnect();
        DistributedSystemTest.assertTrue((idm.getPort() <= DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[1] ? 1 : 0) != 0);
        DistributedSystemTest.assertTrue((idm.getPort() >= DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[0] ? 1 : 0) != 0);
        DistributedSystemTest.assertTrue((idm.getDirectChannelPort() <= DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[1] ? 1 : 0) != 0);
        DistributedSystemTest.assertTrue((idm.getDirectChannelPort() >= DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[0] ? 1 : 0) != 0);
    }

    public void testConflictingUDPPort() throws Exception {
        final Properties config = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        int unicastPort = AvailablePort.getRandomAvailablePort((int)0);
        config.setProperty("mcast-port", String.valueOf(mcastPort));
        config.setProperty("locators", "");
        config.setProperty("membership-port-range", "" + unicastPort + "-" + (unicastPort + 2));
        system = (InternalDistributedSystem)DistributedSystem.connect((Properties)config);
        DistributionManager dm = (DistributionManager)system.getDistributionManager();
        InternalDistributedMember idm = dm.getDistributionManagerId();
        VM vm = Host.getHost(0).getVM(1);
        vm.invoke(new CacheSerializableRunnable("start conflicting system"){

            @Override
            public void run2() {
                try {
                    DistributedSystem system = DistributedSystem.connect((Properties)config);
                    system.disconnect();
                }
                catch (SystemConnectException e) {
                    return;
                }
                TestCase.fail((String)"expected a SystemConnectException but didn't get one");
            }
        });
        system.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyCacheXmlFile() throws Exception {
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        config.setProperty("cache-xml-file", "");
        DistributedSystem sys = DistributedSystem.connect((Properties)config);
        try {
            try {
                CacheFactory.getInstance((DistributedSystem)sys);
                DistributedSystemTest.fail((String)"Should have thrown a CancelException");
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
            CacheFactory.create((DistributedSystem)sys);
        }
        finally {
            sys.disconnect();
        }
    }

    public void testInterruptedWhileConnecting() throws Exception {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ClientGmsImpl.SLOW_JOIN_LOCK = new Object();
                ClientGmsImpl.SLOW_JOIN = true;
                try {
                    TestCase.assertTrue((String)"should be disconnected at this point", (InternalDistributedSystem.getConnectedInstance() == null ? 1 : 0) != 0);
                    DistributedSystemTest.this.getSystem();
                    problem = "a connection to the distributed system was established but it should have failed";
                }
                catch (SystemConnectException e) {
                    if (!e.getMessage().endsWith(ExternalStrings.ClientGmsImpl_JOIN_INTERRUPTED.getRawText())) {
                        problem = "got a system connect exception but it was for the wrong reason";
                        DistributedTestCase.getLogWriter().info("wrong exception thrown: '" + e.getMessage() + "' (wanted '" + ExternalStrings.ClientGmsImpl_JOIN_INTERRUPTED.getRawText() + "')", (Throwable)e);
                    }
                }
                finally {
                    ClientGmsImpl.SLOW_JOIN = false;
                    ClientGmsImpl.SLOW_JOIN_LOCK = null;
                }
            }
        };
        Thread connectThread = new Thread(r, "testInterruptedWhileConnecting connect thread");
        ClientGmsImpl.SLOW_JOIN = false;
        connectThread.start();
        while (!ClientGmsImpl.SLOW_JOIN) {
            DistributedSystemTest.pause(1000);
        }
        DistributedSystemTest.pause(5000);
        connectThread.interrupt();
        connectThread.join(60000L);
        DistributedSystemTest.getLogWriter().info("done waiting for connectThread.  Thread is " + (connectThread.isAlive() ? "still alive" : "stopped"));
        if (ClientGmsImpl.SLOW_JOIN) {
            problem = "failed to either connect or get an exception - one of these should have happened";
            DistributedSystemTest.dumpMyThreads(DistributedSystemTest.getLogWriter());
        }
        if (problem != null) {
            DistributedSystemTest.fail((String)problem);
        }
    }

    static class FakeMessage
    extends SerialDistributionMessage {
        volatile boolean[] blocked;
        volatile boolean processed;

        FakeMessage(boolean[] blocked) {
            this.blocked = blocked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void doAction(DistributionManager dm, boolean block) {
            this.processed = true;
            if (!block) return;
            boolean[] blArray = this.blocked;
            synchronized (this.blocked) {
                this.blocked[0] = true;
                this.blocked.notify();
                try {
                    this.blocked.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
        }

        public int getDSFID() {
            return 0;
        }

        protected void process(DistributionManager dm) {
        }

        public String toString() {
            return "FakeMessage(blocking=" + (this.blocked != null) + ")";
        }
    }
}

