/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.LogWriterImpl;
import java.io.File;
import java.util.Properties;

public class TestHeapLRU {
    public static void main(String[] args) throws Exception {
        DistributedSystem system = DistributedSystem.connect((Properties)new Properties());
        Cache cache = CacheFactory.create((DistributedSystem)system);
        AttributesFactory factory = new AttributesFactory();
        factory.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        factory.setDiskSynchronous(true);
        factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(new File[]{new File(System.getProperty("user.dir"))}).create("TestHeapLRU").getName());
        Region region = cache.createRegion("TestDiskRegion", factory.create());
        LogWriterImpl.LoggingThreadGroup tg = LogWriterImpl.createThreadGroup((String)"Annoying threads", (LogWriterI18n)null);
        Thread thread = new Thread((ThreadGroup)tg, "Annoying thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        System.out.println("Annoy...");
                        Object[] array = new Object[10];
                        for (int i = 0; i < array.length; ++i) {
                            array[i] = new byte[1024];
                            Thread.sleep(10L);
                        }
                        System.out.println("SYSTEM GC");
                        System.gc();
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException ex) {
                    System.err.println("Interrupted");
                    return;
                }
            }
        };
        thread.setDaemon(true);
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (i % 1000 == 0) {
                // empty if block
            }
            Integer key = new Integer(i % 10000);
            long[] value = new long[2000];
            region.put((Object)key, (Object)value);
        }
    }
}

