/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.CacheCallback;
import dunit.DistributedTestCase;

public abstract class TestCacheCallback
implements CacheCallback {
    private volatile boolean isClosed = false;
    volatile boolean invoked = false;
    protected volatile Throwable callbackError = null;

    public boolean wasInvoked() {
        this.checkForError();
        boolean value = this.invoked;
        this.invoked = false;
        return value;
    }

    public boolean waitForInvocation(int timeoutMs) {
        if (!this.invoked) {
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return TestCacheCallback.this.invoked;
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, timeoutMs, 200L, true);
        }
        return this.wasInvoked();
    }

    public boolean isClosed() {
        this.checkForError();
        return this.isClosed;
    }

    public final void close() {
        this.isClosed = true;
        this.close2();
    }

    public void close2() {
    }

    private void checkForError() {
        if (this.callbackError != null) {
            AssertionError error = new AssertionError((Object)"Exception occurred in callback");
            ((Throwable)((Object)error)).initCause(this.callbackError);
            throw error;
        }
    }
}

