/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.util.Properties;
import junit.framework.AssertionFailedError;

public class RolePerformanceTest
extends CacheTestCase {
    protected static transient long timing = -1L;

    public RolePerformanceTest(String name) {
        super(name);
    }

    public void testRolePerformance() {
        int maxAttempts = 10;
        for (int i = 1; i <= maxAttempts; ++i) {
            try {
                if (i > 1) {
                    this.closeCaches();
                }
                this.doTestRolePerformance();
                break;
            }
            catch (AssertionFailedError e) {
                if (i == maxAttempts) {
                    throw e;
                }
                RolePerformanceTest.getLogWriter().info("testRolePerformance attempt #" + i + " failed -- reattempting up to 10x", (Throwable)e);
                continue;
            }
        }
    }

    private void doTestRolePerformance() {
        String name = this.getUniqueName();
        this.createConnections(name, false);
        this.createRegions(name);
        this.executeOperations(name);
        this.closeCaches();
        this.createConnections(name, false);
        this.createRegions(name);
        long millisNoRoles = this.executeOperations(name);
        this.closeCaches();
        this.createConnections(name, true);
        this.createRegions(name);
        long millisWithRoles = this.executeOperations(name);
        long deviation = (long)((double)millisNoRoles * 0.05);
        long ceiling = millisNoRoles + deviation;
        String data = name + " results: millisNoRoles=" + millisNoRoles + ", millisWithRoles=" + millisWithRoles + ", deviation=" + deviation + ", ceiling=" + ceiling;
        RolePerformanceTest.getLogWriter().info(data);
        RolePerformanceTest.assertTrue((String)("millisWithRoles is greater than allowable deviation: " + data), (millisWithRoles <= ceiling ? 1 : 0) != 0);
    }

    private void createConnections(String name, final boolean assignRoles) {
        final String[][] vmRoles = new String[][]{{name + "-A"}, {name + "-B"}, {name + "-C"}, {name + "-D"}};
        int i = 0;
        while (i < vmRoles.length) {
            final int vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable("Connect"){

                @Override
                public void run() {
                    Properties config = new Properties();
                    if (assignRoles) {
                        config.setProperty("roles", vmRoles[vm][0]);
                    }
                    RolePerformanceTest.this.getSystem(config);
                }
            });
        }
    }

    private void closeCaches() {
        int i = 0;
        while (i < Host.getHost(0).getVMCount()) {
            int vm = i++;
            Host.getHost(0).getVM(vm).invoke(new CacheSerializableRunnable("Close Cache"){

                @Override
                public void run2() throws CacheException {
                    CacheTestCase.closeCache();
                }
            });
        }
    }

    private void createRegions(final String name) {
        int i = 0;
        while (i < Host.getHost(0).getVMCount()) {
            int vm = i++;
            Host.getHost(0).getVM(vm).invoke(new CacheSerializableRunnable("Create Region"){

                @Override
                public void run2() throws CacheException {
                    AttributesFactory fac = new AttributesFactory();
                    fac.setScope(Scope.DISTRIBUTED_ACK);
                    fac.setDataPolicy(DataPolicy.REPLICATE);
                    RegionAttributes attr = fac.create();
                    RolePerformanceTest.this.createRootRegion(name, attr);
                }
            });
        }
    }

    private long executeOperations(final String name) {
        Host.getHost(0).getVM(0).invoke(new CacheSerializableRunnable("Operations"){

            @Override
            public void run2() throws CacheException {
                Region region = RolePerformanceTest.this.getRootRegion(name);
                long begin = System.currentTimeMillis();
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)("KEY-" + i), (Object)("VAL-" + i));
                }
                long finish = System.currentTimeMillis();
                timing = finish - begin;
            }
        });
        Long timing = (Long)Host.getHost(0).getVM(0).invoke(RolePerformanceTest.class, "getTiming", new Object[0]);
        return timing;
    }

    private static Long getTiming() {
        return new Long(timing);
    }
}

