/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RequiredRoles;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.ReliabilityTestCase;
import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.membership.InternalRole;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class RequiredRolesTest
extends ReliabilityTestCase {
    protected volatile transient boolean startTestWaitForRequiredRoles = false;
    protected volatile transient boolean finishTestWaitForRequiredRoles = false;
    protected volatile transient boolean failTestWaitForRequiredRoles = false;
    protected transient Set rolesTestWaitForRequiredRoles = new HashSet();
    private final transient ThreadGroup group = new ThreadGroup("RequiredRolesTest Threads"){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof VirtualMachineError) {
                SystemFailure.setFailure((Error)((VirtualMachineError)e));
            }
            String s = "Uncaught exception in thread " + t;
            DistributedTestCase.getLogWriter().error(s, e);
            TestCase.fail((String)s);
        }
    };

    public RequiredRolesTest(String name) {
        super(name);
    }

    public void testRequiredRolesInLoss() throws Exception {
        String name = this.getUniqueName();
        String roleA = name + "-A";
        String roleC = name + "-C";
        String roleD = name + "-D";
        String[] requiredRoles = new String[]{roleA, roleC, roleD};
        HashSet<InternalRole> requiredRolesSet = new HashSet<InternalRole>();
        for (int i = 0; i < requiredRoles.length; ++i) {
            requiredRolesSet.add(InternalRole.getRole((String)requiredRoles[i]));
        }
        RequiredRolesTest.assertEquals((int)requiredRoles.length, (int)requiredRolesSet.size());
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.FULL_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        RegionAttributes rattr = region.getAttributes();
        RequiredRolesTest.assertEquals((boolean)true, (boolean)rattr.getMembershipAttributes().hasRequiredRoles());
        Set roles = rattr.getMembershipAttributes().getRequiredRoles();
        RequiredRolesTest.assertNotNull((Object)roles);
        RequiredRolesTest.assertEquals((boolean)false, (boolean)roles.isEmpty());
        RequiredRolesTest.assertEquals((int)requiredRolesSet.size(), (int)roles.size());
        RequiredRolesTest.assertEquals((boolean)true, (boolean)roles.containsAll(requiredRolesSet));
        this.waitForMemberTimeout();
        Set missingRoles = RequiredRoles.checkForRequiredRoles((Region)region);
        RequiredRolesTest.assertNotNull((Object)missingRoles);
        RequiredRolesTest.assertEquals((int)requiredRolesSet.size(), (int)missingRoles.size());
        RequiredRolesTest.assertEquals((boolean)true, (boolean)missingRoles.containsAll(requiredRolesSet));
        for (Role role : missingRoles) {
            RequiredRolesTest.assertEquals((boolean)false, (boolean)role.isPresent());
        }
    }

    public void testWaitForRequiredRoles() throws Exception {
        final String name = this.getUniqueName();
        boolean vm0 = false;
        boolean vm1 = true;
        int vm2 = 2;
        int vm3 = 3;
        String roleA = name + "-A";
        String roleC = name + "-C";
        String roleD = name + "-D";
        String[] requiredRoles = new String[]{roleA, roleC, roleD};
        final String[] rolesProp = new String[]{"", roleA, roleA, roleC + "," + roleD};
        String[][] vmRoles = new String[][]{new String[0], {roleA}, {roleA}, {roleC, roleD}};
        int i = 0;
        while (i < vmRoles.length) {
            final int vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Properties config = new Properties();
                    config.setProperty("roles", rolesProp[vm]);
                    RequiredRolesTest.this.getSystem(config);
                }
            });
        }
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.FULL_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        RegionAttributes attr = fac.create();
        final Region region = this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        this.assertMissingRoles(name, requiredRoles);
        Runnable runWaitForRequiredRoles = new Runnable(){

            @Override
            public void run() {
                RequiredRolesTest.this.startTestWaitForRequiredRoles = true;
                try {
                    RequiredRolesTest.this.rolesTestWaitForRequiredRoles = RequiredRoles.waitForRequiredRoles((Region)region, (long)-1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    RequiredRolesTest.this.failTestWaitForRequiredRoles = true;
                }
                RequiredRolesTest.this.finishTestWaitForRequiredRoles = true;
            }
        };
        Thread threadA = new Thread(this.group, runWaitForRequiredRoles);
        threadA.start();
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return RequiredRolesTest.this.startTestWaitForRequiredRoles;
            }

            @Override
            public String description() {
                return "waiting for test start";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        RequiredRolesTest.assertTrue((boolean)this.startTestWaitForRequiredRoles);
        RequiredRolesTest.assertFalse((boolean)this.finishTestWaitForRequiredRoles);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(Scope.DISTRIBUTED_ACK);
                RegionAttributes attr = fac.create();
                RequiredRolesTest.this.createRootRegion(name, attr);
            }
        };
        Host.getHost(0).getVM(0).invoke(create);
        RequiredRolesTest.assertFalse((boolean)this.finishTestWaitForRequiredRoles);
        Host.getHost(0).getVM(1).invoke(create);
        RequiredRolesTest.assertFalse((boolean)this.finishTestWaitForRequiredRoles);
        Host.getHost(0).getVM(2).invoke(create);
        RequiredRolesTest.assertFalse((boolean)this.finishTestWaitForRequiredRoles);
        Host.getHost(0).getVM(3).invoke(create);
        DistributedTestCase.join(threadA, 30000L, RequiredRolesTest.getLogWriter());
        RequiredRolesTest.assertTrue((boolean)this.finishTestWaitForRequiredRoles);
        RequiredRolesTest.assertTrue((boolean)this.rolesTestWaitForRequiredRoles.isEmpty());
        CacheSerializableRunnable destroy = new CacheSerializableRunnable("Destroy Region"){

            @Override
            public void run2() throws CacheException {
                Region region = RequiredRolesTest.this.getRootRegion(name);
                region.localDestroyRegion();
            }
        };
        Host.getHost(0).getVM(0).invoke(destroy);
        this.startTestWaitForRequiredRoles = false;
        this.finishTestWaitForRequiredRoles = false;
        threadA = new Thread(this.group, runWaitForRequiredRoles);
        threadA.start();
        DistributedTestCase.join(threadA, 30000L, RequiredRolesTest.getLogWriter());
        RequiredRolesTest.assertTrue((boolean)this.startTestWaitForRequiredRoles);
        RequiredRolesTest.assertTrue((boolean)this.finishTestWaitForRequiredRoles);
        RequiredRolesTest.assertTrue((boolean)this.rolesTestWaitForRequiredRoles.isEmpty());
        Host.getHost(0).getVM(1).invoke(destroy);
        this.startTestWaitForRequiredRoles = false;
        this.finishTestWaitForRequiredRoles = false;
        threadA = new Thread(this.group, runWaitForRequiredRoles);
        threadA.start();
        DistributedTestCase.join(threadA, 30000L, RequiredRolesTest.getLogWriter());
        RequiredRolesTest.assertTrue((boolean)this.startTestWaitForRequiredRoles);
        RequiredRolesTest.assertTrue((boolean)this.finishTestWaitForRequiredRoles);
        RequiredRolesTest.assertTrue((boolean)this.rolesTestWaitForRequiredRoles.isEmpty());
        Host.getHost(0).getVM(2).invoke(destroy);
        this.startTestWaitForRequiredRoles = false;
        this.finishTestWaitForRequiredRoles = false;
        threadA = new Thread(this.group, runWaitForRequiredRoles);
        threadA.start();
        ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return RequiredRolesTest.this.startTestWaitForRequiredRoles;
            }

            @Override
            public String description() {
                return "waiting for test start";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
        RequiredRolesTest.assertTrue((boolean)this.startTestWaitForRequiredRoles);
        RequiredRolesTest.assertFalse((boolean)this.finishTestWaitForRequiredRoles);
        this.assertMissingRoles(name, vmRoles[2]);
        Host.getHost(0).getVM(2).invoke(create);
        DistributedTestCase.join(threadA, 30000L, RequiredRolesTest.getLogWriter());
        RequiredRolesTest.assertTrue((boolean)this.startTestWaitForRequiredRoles);
        RequiredRolesTest.assertTrue((boolean)this.finishTestWaitForRequiredRoles);
        RequiredRolesTest.assertTrue((boolean)this.rolesTestWaitForRequiredRoles.isEmpty());
        this.assertMissingRoles(name, new String[0]);
        RequiredRolesTest.assertFalse((boolean)this.failTestWaitForRequiredRoles);
    }

    public void testIsRoleInRegionMembership() throws Exception {
        int i;
        Role role3;
        final String name = this.getUniqueName();
        boolean vm0 = false;
        boolean vm1 = true;
        int vm2 = 2;
        int vm3 = 3;
        String roleA = name + "-A";
        String roleC = name + "-C";
        String roleD = name + "-D";
        String[] requiredRoles = new String[]{roleA, roleC, roleD};
        final String[] rolesProp = new String[]{"", roleA, roleA, roleC + "," + roleD};
        String[][] vmRoles = new String[][]{new String[0], {roleA}, {roleA}, {roleC, roleD}};
        int i2 = 0;
        while (i2 < vmRoles.length) {
            final int vm = i2++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Properties config = new Properties();
                    config.setProperty("roles", rolesProp[vm]);
                    RequiredRolesTest.this.getSystem(config);
                }
            });
        }
        Properties config = new Properties();
        config.setProperty("roles", "");
        this.getSystem(config);
        MembershipAttributes ra = new MembershipAttributes(requiredRoles, LossAction.FULL_ACCESS, ResumptionAction.NONE);
        AttributesFactory fac = new AttributesFactory();
        fac.setMembershipAttributes(ra);
        fac.setScope(Scope.DISTRIBUTED_ACK);
        RegionAttributes attr = fac.create();
        Region region = this.createRootRegion(name, attr);
        this.waitForMemberTimeout();
        Set requiredRolesSet = region.getAttributes().getMembershipAttributes().getRequiredRoles();
        for (Role role2 : requiredRolesSet) {
            RequiredRolesTest.assertFalse((boolean)RequiredRoles.isRoleInRegionMembership((Region)region, (Role)role2));
        }
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory fac = new AttributesFactory();
                fac.setScope(Scope.DISTRIBUTED_ACK);
                RegionAttributes attr = fac.create();
                RequiredRolesTest.this.createRootRegion(name, attr);
            }
        };
        Host.getHost(0).getVM(0).invoke(create);
        for (Role role3 : requiredRolesSet) {
            RequiredRolesTest.assertFalse((boolean)RequiredRoles.isRoleInRegionMembership((Region)region, (Role)role3));
        }
        Host.getHost(0).getVM(1).invoke(create);
        for (i = 0; i < vmRoles[1].length; ++i) {
            role3 = InternalRole.getRole((String)vmRoles[1][i]);
            RequiredRolesTest.assertTrue((boolean)RequiredRoles.isRoleInRegionMembership((Region)region, (Role)role3));
        }
        Host.getHost(0).getVM(2).invoke(create);
        for (i = 0; i < vmRoles[2].length; ++i) {
            role3 = InternalRole.getRole((String)vmRoles[2][i]);
            RequiredRolesTest.assertTrue((boolean)RequiredRoles.isRoleInRegionMembership((Region)region, (Role)role3));
        }
        Host.getHost(0).getVM(3).invoke(create);
        for (i = 0; i < vmRoles[3].length; ++i) {
            role3 = InternalRole.getRole((String)vmRoles[3][i]);
            RequiredRolesTest.assertTrue((boolean)RequiredRoles.isRoleInRegionMembership((Region)region, (Role)role3));
        }
        CacheSerializableRunnable destroy = new CacheSerializableRunnable("Destroy Region"){

            @Override
            public void run2() throws CacheException {
                Region region = RequiredRolesTest.this.getRootRegion(name);
                region.localDestroyRegion();
            }
        };
        Host.getHost(0).getVM(0).invoke(destroy);
        for (Role role4 : requiredRolesSet) {
            RequiredRolesTest.assertTrue((boolean)RequiredRoles.isRoleInRegionMembership((Region)region, (Role)role4));
        }
        Host.getHost(0).getVM(1).invoke(destroy);
        for (Role role4 : requiredRolesSet) {
            RequiredRolesTest.assertTrue((boolean)RequiredRoles.isRoleInRegionMembership((Region)region, (Role)role4));
        }
        Host.getHost(0).getVM(2).invoke(destroy);
        for (int i3 = 0; i3 < vmRoles[2].length; ++i3) {
            Role role4;
            role4 = InternalRole.getRole((String)vmRoles[2][i3]);
            RequiredRolesTest.assertFalse((boolean)RequiredRoles.isRoleInRegionMembership((Region)region, (Role)role4));
        }
        Host.getHost(0).getVM(3).invoke(destroy);
        for (Role role4 : requiredRolesSet) {
            RequiredRolesTest.assertFalse((boolean)RequiredRoles.isRoleInRegionMembership((Region)region, (Role)role4));
        }
    }
}

