/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import junit.framework.TestCase;

public class RegionExpirationTest
extends CacheTestCase {
    public RegionExpirationTest(String name) {
        super(name);
    }

    public void testRegionTTLLocalDestroy() throws CacheException, InterruptedException {
        this._testRegionTTL(this.getUniqueName(), ExpirationAction.LOCAL_DESTROY);
    }

    public void testRegionTTLDestroy() throws CacheException, InterruptedException {
        this._testRegionTTL(this.getUniqueName(), ExpirationAction.DESTROY);
    }

    public void testRegionTTLLocalInvalidate() throws CacheException, InterruptedException {
        this._testRegionTTL(this.getUniqueName(), ExpirationAction.LOCAL_INVALIDATE);
    }

    public void testRegionTTLInvalidate() throws CacheException, InterruptedException {
        this._testRegionTTL(this.getUniqueName(), ExpirationAction.INVALIDATE);
    }

    public void testRegionTTLAfterMutating() throws InterruptedException, CacheException {
        String regionName = this.getUniqueName();
        int firstTimeout = 2;
        int secondTimeout = 6;
        this.createWithExpiration(regionName, new ExpirationAttributes(firstTimeout, ExpirationAction.DESTROY), null);
        long startTime = System.currentTimeMillis();
        final Region region = this.getOrCreateRootRegion().getSubregion(regionName);
        region.getAttributesMutator().setRegionTimeToLive(new ExpirationAttributes(secondTimeout, ExpirationAction.DESTROY));
        Thread.sleep(firstTimeout * 1000 + 100);
        if (region.isDestroyed()) {
            RegionExpirationTest.assertTrue((System.currentTimeMillis() >= startTime + (long)(secondTimeout * 1000) ? 1 : 0) != 0);
        }
        Thread.sleep((secondTimeout - firstTimeout) * 1000 + 100);
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return region.isDestroyed();
            }

            @Override
            public String description() {
                return "region never destroyed";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
    }

    public void testWhenBothTtlAndIdleAreSet() throws InterruptedException, CacheException {
        String regionName = this.getUniqueName();
        int ttlTimeout = 4;
        int idleTimeout = 3;
        this.createWithExpiration(regionName, new ExpirationAttributes(ttlTimeout, ExpirationAction.DESTROY), new ExpirationAttributes(idleTimeout, ExpirationAction.INVALIDATE));
        Region region = this.getOrCreateRootRegion().getSubregion(regionName);
        region.create((Object)"key", (Object)"val");
        Thread.sleep(idleTimeout * 1000 + 200);
        RegionExpirationTest.assertFalse((boolean)region.isDestroyed());
        RegionExpirationTest.assertNull((Object)region.get((Object)"key"));
        Thread.sleep((ttlTimeout - idleTimeout) * 1000 + 5000);
        RegionExpirationTest.assertTrue((boolean)region.isDestroyed());
    }

    private void _testRegionTTL(final String regionName, final ExpirationAction action) throws InterruptedException {
        int timeoutSecs = 10;
        final String key = "key";
        final String originalValue = "original value";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        RegionExpirationTest.getLogWriter().info("vm0 is " + vm0.getPid() + ", vm1 is " + vm1);
        RegionExpirationTest.getLogWriter().info("2: " + regionName + " action is " + action);
        final long tilt = System.currentTimeMillis() + 10000L;
        vm0.invoke(new CacheSerializableRunnable("Create Region & Key"){

            @Override
            public void run2() throws CacheException {
                RegionExpirationTest.this.createWithExpiration(regionName, new ExpirationAttributes(10, action), null);
                Region region = RegionExpirationTest.this.getOrCreateRootRegion().getSubregion(regionName);
                region.put(key, originalValue);
                TestCase.assertEquals((Object)originalValue, (Object)region.get(key));
                TestCase.assertTrue((boolean)region.containsValueForKey(key));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create Region & Key"){

            @Override
            public void run2() throws CacheException {
                RegionExpirationTest.this.createWithExpiration(regionName, null, null);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = RegionExpirationTest.this.getOrCreateRootRegion().getSubregion(regionName);
                Object newVal = region.get(key);
                if (!originalValue.equals(newVal)) {
                    TestCase.assertTrue((String)("expected original value but got " + newVal), (System.currentTimeMillis() + 1000L >= tilt ? 1 : 0) != 0);
                }
                if (!region.containsValueForKey(key)) {
                    TestCase.assertTrue((String)"Region doesn't hold key", (System.currentTimeMillis() + 1000L >= tilt ? 1 : 0) != 0);
                }
            }
        });
        Thread.sleep(12000L);
        vm0.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = RegionExpirationTest.this.getRootRegion().getSubregion(regionName);
                DistributedTestCase.getLogWriter().info("3: " + regionName + ", " + region + ", action is " + action);
                if (action.isInvalidate() || action.isLocalInvalidate()) {
                    TestCase.assertTrue((!region.containsValueForKey(key) ? 1 : 0) != 0);
                } else {
                    TestCase.assertTrue((region == null ? 1 : 0) != 0);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = RegionExpirationTest.this.getRootRegion().getSubregion(regionName);
                if (action.isInvalidate()) {
                    TestCase.assertTrue((boolean)region.containsKey(key));
                    TestCase.assertTrue((!region.containsValueForKey(key) ? 1 : 0) != 0);
                } else if (action.isDestroy()) {
                    TestCase.assertTrue((region == null ? 1 : 0) != 0);
                } else {
                    TestCase.assertTrue((boolean)region.containsValueForKey(key));
                    TestCase.assertEquals((Object)originalValue, (Object)region.get(key));
                }
            }
        });
    }

    protected void createWithExpiration(String regionName, ExpirationAttributes ttl, ExpirationAttributes idle) throws CacheException {
        AttributesFactory factory = new AttributesFactory();
        factory.setStatisticsEnabled(true);
        if (ttl != null) {
            factory.setRegionTimeToLive(ttl);
        }
        if (idle != null) {
            factory.setRegionIdleTimeout(idle);
        }
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEarlyAck(false);
        RegionAttributes attrs = factory.create();
        RegionExpirationTest.getLogWriter().info("4: " + regionName + " ttl action is " + ttl);
        this.getOrCreateRootRegion().createSubregion(regionName, attrs);
    }

    protected Region getOrCreateRootRegion() throws CacheException {
        Region root = this.getRootRegion();
        if (root == null) {
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setEarlyAck(false);
            factory.setStatisticsEnabled(true);
            root = this.createRootRegion(factory.create());
        }
        return root;
    }
}

