/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;

public class PutAllCallBkSingleVMDUnitTest
extends DistributedTestCase {
    static volatile Cache cache;
    static Properties props;
    static Properties propsWork;
    static volatile DistributedSystem ds;
    static volatile Region region;
    static boolean afterCreate;
    static boolean afterUpdate;
    static int putAllcounter;
    static int afterUpdateputAllcounter;
    static boolean beforeCreate;
    static boolean beforeUpdate;
    static int beforeCreateputAllcounter;
    static int beforeUpdateputAllcounter;

    public PutAllCallBkSingleVMDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(PutAllCallBkSingleVMDUnitTest.class, "createCache");
        vm1.invoke(PutAllCallBkSingleVMDUnitTest.class, "createCache");
        PutAllCallBkSingleVMDUnitTest.getLogWriter().fine("Cache created in successfully");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(PutAllCallBkSingleVMDUnitTest.class, "closeCache");
        vm1.invoke(PutAllCallBkSingleVMDUnitTest.class, "closeCache");
    }

    public static synchronized void createCache() {
        try {
            AfterCreateCallback aListener = new AfterCreateCallback();
            BeforeCreateCallback aWriter = new BeforeCreateCallback();
            ds = new PutAllCallBkSingleVMDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.DISTRIBUTED_ACK);
            factory.setCacheWriter((CacheWriter)aWriter);
            factory.setCacheListener((CacheListener)aListener);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized void closeCache() {
        region = null;
        if (cache != null) {
            cache.close();
            cache = null;
        }
        if (ds != null) {
            ds.disconnect();
            ds = null;
        }
    }

    public void testputAllSingleVM() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        Object[] objArr = new Object[1];
        for (int i = 0; i < 5; ++i) {
            objArr[0] = "" + i;
            vm0.invoke(PutAllCallBkSingleVMDUnitTest.class, "putMethod", objArr);
        }
        vm0.invoke(PutAllCallBkSingleVMDUnitTest.class, "putAllMethod");
        vm0.invoke(new CacheSerializableRunnable("temp1"){

            @Override
            public void run2() throws CacheException {
                if (!afterCreate) {
                    TestCase.fail((String)"FAILED in aftercreate call back");
                }
                TestCase.assertEquals((int)region.size(), (int)putAllcounter);
                TestCase.assertEquals((int)region.size(), (int)beforeCreateputAllcounter);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("abc"){

            @Override
            public void run2() throws CacheException {
                AfterUpdateCallback bListener = new AfterUpdateCallback();
                BeforeUpdateCallback bWriter = new BeforeUpdateCallback();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setCacheWriter((CacheWriter)bWriter);
                factory.setCacheListener((CacheListener)bListener);
                RegionAttributes attr = factory.create();
                Region tempRegion = cache.createRegion("temp", attr);
                for (int i = 0; i < 5; ++i) {
                    tempRegion.put((Object)new Integer(i), (Object)new String("region" + i));
                }
                HashMap<Integer, String> m = new HashMap<Integer, String>();
                for (int i = 0; i < 5; ++i) {
                    m.put(new Integer(i), new String("map" + i));
                }
                tempRegion.putAll(m);
                if (!afterUpdate) {
                    TestCase.fail((String)"FAILED in afterupdate call back");
                }
                TestCase.assertEquals((int)tempRegion.size(), (int)afterUpdateputAllcounter);
                TestCase.assertEquals((int)tempRegion.size(), (int)beforeUpdateputAllcounter);
            }
        });
    }

    public static Object putMethod(Object ob) {
        Object obj = null;
        try {
            if (ob != null) {
                String str = "first";
                obj = region.put(ob, (Object)str);
            }
        }
        catch (Exception ex) {
            PutAllCallBkSingleVMDUnitTest.fail("Failed while region.put", ex);
        }
        return obj;
    }

    public static void putAllMethod() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        int i = 5;
        try {
            for (int cntr = 0; cntr < 21; ++cntr) {
                m.put(new Integer(i), new String("map" + i));
                ++i;
            }
            region.putAll(m);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PutAllCallBkSingleVMDUnitTest.fail((String)"Failed while region.putAll");
        }
    }

    public static void putAllAfterUpdate() {
        HashMap<String, String> m = new HashMap<String, String>();
        int cntr = 0;
        try {
            for (int i = 0; i < 5; ++i) {
                m.put("" + i, new String("map_AfterUpdate" + i));
                ++cntr;
            }
            region.putAll(m);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PutAllCallBkSingleVMDUnitTest.fail((String)"Failed while region.putAll");
        }
    }

    public static Object getMethod(Object ob) {
        Object obj = null;
        try {
            obj = region.get(ob);
        }
        catch (Exception ex) {
            PutAllCallBkSingleVMDUnitTest.fail((String)"Failed while region.get");
        }
        return obj;
    }

    public static boolean containsValueMethod(Object ob) {
        boolean flag = false;
        try {
            flag = region.containsValue(ob);
        }
        catch (Exception ex) {
            PutAllCallBkSingleVMDUnitTest.fail((String)"Failed while region.containsValueMethod");
        }
        return flag;
    }

    public static int sizeMethod() {
        int i = 0;
        try {
            i = region.size();
        }
        catch (Exception ex) {
            PutAllCallBkSingleVMDUnitTest.fail((String)"Failed while region.size");
        }
        return i;
    }

    public static void clearMethod() {
        try {
            region.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
        afterCreate = false;
        afterUpdate = false;
        putAllcounter = 0;
        afterUpdateputAllcounter = 0;
        beforeCreate = false;
        beforeUpdate = false;
        beforeCreateputAllcounter = 0;
        beforeUpdateputAllcounter = 0;
    }

    static class BeforeUpdateCallback
    extends CacheWriterAdapter {
        BeforeUpdateCallback() {
        }

        public void beforeUpdate(EntryEvent event) {
            DistributedTestCase.getLogWriter().fine("In beforeUpdate" + ++beforeUpdateputAllcounter);
            if (beforeUpdateputAllcounter == 5) {
                DistributedTestCase.getLogWriter().fine("performingtrue beforeUpdate");
                beforeUpdate = true;
            }
        }
    }

    static class BeforeCreateCallback
    extends CacheWriterAdapter {
        BeforeCreateCallback() {
        }

        public void beforeCreate(EntryEvent event) {
            DistributedTestCase.getLogWriter().fine("In beforeCreate" + ++beforeCreateputAllcounter);
            if (beforeCreateputAllcounter == 25) {
                DistributedTestCase.getLogWriter().fine("performingtrue beforeCreateputAll");
                beforeCreate = true;
            }
        }
    }

    static class AfterUpdateCallback
    extends CacheListenerAdapter {
        AfterUpdateCallback() {
        }

        public void afterUpdate(EntryEvent event) {
            DistributedTestCase.getLogWriter().fine("In afterUpdate" + ++afterUpdateputAllcounter);
            if (afterUpdateputAllcounter == 5) {
                DistributedTestCase.getLogWriter().fine("performingtrue afterUpdate");
                afterUpdate = true;
            }
        }
    }

    static class AfterCreateCallback
    extends CacheListenerAdapter {
        AfterCreateCallback() {
        }

        public void afterCreate(EntryEvent event) {
            DistributedTestCase.getLogWriter().fine("In afterCreate" + ++putAllcounter);
            if (putAllcounter == 25) {
                DistributedTestCase.getLogWriter().fine("performingtrue");
                afterCreate = true;
            }
        }
    }
}

