/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.VMCachedDeserializable;
import com.gemstone.gemfire.internal.cache.versions.VMVersionTag;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;

public class PRBucketSynchronizationDUnitTest
extends CacheTestCase {
    public static LocalRegion TestRegion;

    public PRBucketSynchronizationDUnitTest(String name) {
        super(name);
    }

    public void testThatBucketSyncOnPrimaryLoss() {
        this.doBucketsSyncOnPrimaryLoss(TestType.IN_MEMORY);
    }

    public void testThatBucketsSyncOnPrimaryLossWithPersistence() {
        this.doBucketsSyncOnPrimaryLoss(TestType.PERSISTENT);
    }

    public void testThatBucketsSyncOnPrimaryLossWithOverflow() {
        this.doBucketsSyncOnPrimaryLoss(TestType.OVERFLOW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBucketsSyncOnPrimaryLoss(TestType typeOfTest) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        HashSet<VM> verifyVMs = new HashSet<VM>();
        String name = this.getUniqueName() + "Region";
        verifyVMs.add(vm0);
        verifyVMs.add(vm1);
        verifyVMs.add(vm2);
        PRBucketSynchronizationDUnitTest.disconnectAllFromDS();
        try {
            this.createRegion(vm0, name, typeOfTest);
            this.createRegion(vm1, name, typeOfTest);
            this.createRegion(vm2, name, typeOfTest);
            this.createEntry1(vm0);
            VM primaryOwner = this.isPrimaryForBucket0(vm0) ? vm0 : (this.isPrimaryForBucket0(vm1) ? vm1 : vm2);
            verifyVMs.remove(primaryOwner);
            VM creatorVM = null;
            InternalDistributedMember primaryID = this.getID(primaryOwner);
            VersionSource primaryVersionID = this.getVersionID(primaryOwner);
            Iterator iterator = verifyVMs.iterator();
            if (iterator.hasNext()) {
                VM vm;
                creatorVM = vm = (VM)iterator.next();
                this.createEntry2(creatorVM, primaryID, primaryVersionID);
            }
            verifyVMs.remove(creatorVM);
            this.crashDistributedSystem(primaryOwner);
            for (VM vm : verifyVMs) {
                this.verifySynchronized(vm, primaryID);
            }
        }
        finally {
            PRBucketSynchronizationDUnitTest.disconnectAllFromDS();
        }
    }

    private boolean createEntry1(VM vm) {
        return (Boolean)vm.invoke(new SerializableCallable("create entry1"){

            public Object call() {
                TestRegion.create((Object)"Object1", (Object)1);
                return true;
            }
        });
    }

    private boolean isPrimaryForBucket0(VM vm) {
        return (Boolean)vm.invoke(new SerializableCallable("is primary?"){

            public Object call() {
                PartitionedRegion pr = (PartitionedRegion)TestRegion;
                return pr.getDataStore().getLocalBucketById(Integer.valueOf(0)).getBucketAdvisor().isPrimary();
            }
        });
    }

    private InternalDistributedMember getID(VM vm) {
        return (InternalDistributedMember)vm.invoke(new SerializableCallable("get dmID"){

            public Object call() {
                return TestRegion.getCache().getMyId();
            }
        });
    }

    private VersionSource getVersionID(VM vm) {
        return (VersionSource)vm.invoke(new SerializableCallable("get versionID"){

            public Object call() {
                return TestRegion.getVersionMember();
            }
        });
    }

    private boolean createEntry2(VM vm, final InternalDistributedMember primary, final VersionSource primaryVersionID) {
        return (Boolean)vm.invoke(new SerializableCallable("create entry2"){

            public Object call() {
                PartitionedRegion pr = (PartitionedRegion)TestRegion;
                BucketRegion bucket = pr.getDataStore().getLocalBucketById(Integer.valueOf(0));
                VMVersionTag tag = new VMVersionTag();
                tag.setMemberID(primaryVersionID);
                tag.setRegionVersion(2L);
                tag.setEntryVersion(1);
                tag.setIsRemoteForTesting();
                EntryEventImpl event = EntryEventImpl.create((LocalRegion)bucket, (Operation)Operation.CREATE, (Object)"Object3", (boolean)true, (DistributedMember)primary, (boolean)true, (boolean)false);
                DistributedTestCase.getLogWriter().info("applying this event to the cache: " + event);
                event.setNewValue((Object)new VMCachedDeserializable((Object)"value3", 12));
                event.setVersionTag((VersionTag)tag);
                bucket.getRegionMap().basicPut(event, System.currentTimeMillis(), true, false, null, false, false);
                event.release();
                tag = new VMVersionTag();
                tag.setMemberID(primaryVersionID);
                tag.setRegionVersion(3L);
                tag.setEntryVersion(1);
                tag.setIsRemoteForTesting();
                event = EntryEventImpl.create((LocalRegion)bucket, (Operation)Operation.CREATE, (Object)"Object5", (boolean)true, (DistributedMember)primary, (boolean)true, (boolean)false);
                event.setNewValue((Object)Token.TOMBSTONE);
                event.setVersionTag((VersionTag)tag);
                DistributedTestCase.getLogWriter().info("applying this event to the cache: " + event);
                bucket.getRegionMap().basicPut(event, System.currentTimeMillis(), true, false, null, false, false);
                event.release();
                bucket.dumpBackingMap();
                DistributedTestCase.getLogWriter().info("bucket version vector is now " + bucket.getVersionVector().fullToString());
                TestCase.assertTrue((String)"bucket should hold entry Object3 now", (boolean)bucket.containsKey((Object)"Object3"));
                return true;
            }
        });
    }

    private void verifySynchronized(VM vm, final InternalDistributedMember crashedMember) {
        vm.invoke(new SerializableCallable("check that synchronization happened"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)TestRegion;
                final BucketRegion bucket = pr.getDataStore().getLocalBucketById(Integer.valueOf(0));
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){
                    String waitingFor;
                    boolean dumped;
                    {
                        this.waitingFor = "primary is still in membership view: " + crashedMember;
                        this.dumped = false;
                    }

                    @Override
                    public boolean done() {
                        if (TestRegion.getCache().getDistributionManager().isCurrentMember(crashedMember)) {
                            DistributedTestCase.getLogWriter().info(this.waitingFor);
                            return false;
                        }
                        if (!TestRegion.containsKey((Object)"Object3")) {
                            this.waitingFor = "entry for Object3 not found";
                            DistributedTestCase.getLogWriter().info(this.waitingFor);
                            return false;
                        }
                        RegionEntry re = bucket.getRegionMap().getEntry((Object)"Object5");
                        if (re == null) {
                            if (!this.dumped) {
                                this.dumped = true;
                                bucket.dumpBackingMap();
                            }
                            this.waitingFor = "entry for Object5 not found";
                            DistributedTestCase.getLogWriter().info(this.waitingFor);
                            return false;
                        }
                        if (!re.isTombstone()) {
                            if (!this.dumped) {
                                this.dumped = true;
                                bucket.dumpBackingMap();
                            }
                            this.waitingFor = "Object5 is not a tombstone but should be: " + re;
                            DistributedTestCase.getLogWriter().info(this.waitingFor);
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public String description() {
                        return this.waitingFor;
                    }
                }, 30000L, 5000L, true);
                return null;
            }
        });
    }

    private void createRegion(VM vm, final String regionName, final TestType typeOfTest) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.PARTITION);
                af.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(2).setRedundantCopies(3).create());
                switch (typeOfTest) {
                    case IN_MEMORY: {
                        break;
                    }
                    case PERSISTENT: {
                        af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                        break;
                    }
                    case OVERFLOW: {
                        af.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)5, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                    }
                }
                TestRegion = (LocalRegion)PRBucketSynchronizationDUnitTest.this.createRootRegion(regionName, af.create());
                return null;
            }
        };
        vm.invoke(createRegion);
    }

    static enum TestType {
        IN_MEMORY,
        OVERFLOW,
        PERSISTENT;

    }
}

