/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.GlobalRegionTest;
import com.gemstone.gemfire.cache30.MultiVMRegionTestCase;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TombstoneService;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class GlobalRegionCCEDUnitTest
extends GlobalRegionTest {
    public GlobalRegionCCEDUnitTest(String name) {
        super(name);
    }

    @Override
    protected boolean supportsTransactions() {
        return true;
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties p = super.getDistributedSystemProperties();
        p.put("conserve-sockets", "false");
        if (distributedSystemID > 0) {
            p.put("distributed-system-id", "" + distributedSystemID);
        }
        return p;
    }

    @Override
    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.GLOBAL);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setConcurrencyChecksEnabled(true);
        return factory.create();
    }

    @Override
    protected RegionAttributes getRegionAttributes(String type) {
        RegionAttributes ra = this.getCache().getRegionAttributes(type);
        if (ra == null) {
            throw new IllegalStateException("The region shortcut " + type + " has been removed.");
        }
        AttributesFactory factory = new AttributesFactory(ra);
        factory.setConcurrencyChecksEnabled(true);
        factory.setScope(Scope.GLOBAL);
        return factory.create();
    }

    @Override
    public void testLocalDestroy() throws InterruptedException {
    }

    @Override
    public void testEntryTtlLocalDestroy() throws InterruptedException {
    }

    public void testGIISendsTombstones() throws Exception {
        this.versionTestGIISendsTombstones();
    }

    protected void do_version_recovery_if_necessary(VM vm0, VM vm1, VM vm2, Object[] params) {
    }

    public void testConcurrentEvents() throws Exception {
        this.versionTestConcurrentEvents();
    }

    public void testTombstones() {
        this.versionTestTombstones();
    }

    public void testTombstoneExpirationRace() {
        VM vm0 = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = GlobalRegionCCEDUnitTest.this.getCache().createRegionFactory(GlobalRegionCCEDUnitTest.this.getRegionAttributes());
                    MultiVMRegionTestCase.CCRegion = (LocalRegion)f.create(name);
                    MultiVMRegionTestCase.CCRegion.put((Object)"cckey0", (Object)"ccvalue");
                    MultiVMRegionTestCase.CCRegion.put((Object)"cckey0", (Object)"ccvalue");
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm1.invoke(new SerializableRunnable("Create local tombstone and adjust time"){

            @Override
            public void run() {
                RegionEntry entry = MultiVMRegionTestCase.CCRegion.getRegionEntry((Object)"cckey0");
                VersionTag tag = entry.getVersionStamp().asVersionTag();
                TestCase.assertTrue((tag.getEntryVersion() > 1 ? 1 : 0) != 0);
                tag.setVersionTimeStamp(System.currentTimeMillis() - TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT - 1000L);
                entry.getVersionStamp().setVersionTimeStamp(tag.getVersionTimeStamp());
                try {
                    entry.makeTombstone(MultiVMRegionTestCase.CCRegion, tag);
                }
                catch (RegionClearedException e) {
                    DistributedTestCase.fail("region was mysteriously cleared during unit testing", e);
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Locally destroy the entry and do a create that will be propagated with v1"){

            @Override
            public void run() {
                MultiVMRegionTestCase.CCRegion.getRegionMap().removeEntry((Object)"cckey0", MultiVMRegionTestCase.CCRegion.getRegionEntry((Object)"cckey0"), true);
                if (MultiVMRegionTestCase.CCRegion.getRegionEntry((Object)"ckey0") != null) {
                    TestCase.fail((String)"expected removEntry to remove the entry from the region's map");
                }
                MultiVMRegionTestCase.CCRegion.put((Object)"cckey0", (Object)"updateAfterReap");
            }
        });
        vm1.invoke(new SerializableRunnable("Check that the create() was applied"){

            @Override
            public void run() {
                RegionEntry entry = MultiVMRegionTestCase.CCRegion.getRegionEntry((Object)"cckey0");
                TestCase.assertTrue((entry.getVersionStamp().getEntryVersion() == 1 ? 1 : 0) != 0);
            }
        });
        GlobalRegionCCEDUnitTest.disconnectAllFromDS();
    }

    public void testConcurrentEventsOnEmptyRegion() {
        this.versionTestConcurrentEventsOnEmptyRegion();
    }

    public void testConcurrentEventsOnNonReplicatedRegion() {
    }

    public void testGetAllWithVersions() {
        this.versionTestGetAllWithVersions();
    }

    public void testRegionVersionVectors() throws Exception {
        this.versionTestRegionVersionVectors();
    }
}

