/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import dunit.Host;
import dunit.VM;
import hydra.ProcessMgr;
import java.io.File;
import java.util.Properties;
import junit.framework.TestCase;

public class DynamicRegionDUnitTest
extends CacheTestCase {
    private static final int OPLOG_SIZE = 1;

    public DynamicRegionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        try {
            DynamicRegionDUnitTest.disconnectAllFromDS();
        }
        finally {
            File d = new File("DynamicRegionData" + ProcessMgr.getProcessId());
            d.mkdirs();
            DynamicRegionFactory.get().open(new DynamicRegionFactory.Config(d, null));
            super.setUp();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        DynamicRegionDUnitTest.getLogWriter().info("Running tearDown in " + this);
        try {
            CacheSerializableRunnable destroyDynRegn = new CacheSerializableRunnable("Destroy Dynamic regions"){

                @Override
                public void run2() throws CacheException {
                    Region dr = DynamicRegionDUnitTest.this.getCache().getRegion("__DynamicRegions");
                    if (dr != null) {
                        dr.localDestroyRegion();
                    }
                }
            };
            this.getOtherVm().invoke(destroyDynRegn);
            Region dr = this.getCache().getRegion("__DynamicRegions");
            if (dr != null) {
                dr.localDestroyRegion();
            }
            super.tearDown2();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            DynamicRegionDUnitTest.getLogWriter().severe("tearDown in " + this + " failed due to " + t);
        }
        finally {
            try {
                DynamicRegionDUnitTest.disconnectAllFromDS();
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable t) {
                DynamicRegionDUnitTest.getLogWriter().severe("tearDown in " + this + " failed to disconnect all DS due to " + t);
            }
        }
        if (!DynamicRegionFactory.get().isClosed()) {
            DynamicRegionDUnitTest.getLogWriter().severe("DynamicRegionFactory not closed!", (Throwable)new Exception());
        }
    }

    private VM getOtherVm() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    private void doParentCreateOtherVm(final Properties p, final boolean persist) {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                File d = new File("DynamicRegionData" + ProcessMgr.getProcessId());
                d.mkdirs();
                DynamicRegionFactory.get().open(new DynamicRegionFactory.Config(d, null));
                DynamicRegionDUnitTest.this.getSystem(p);
                TestCase.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().isOpen());
                DynamicRegionDUnitTest.this.createParentRegion("parent", persist);
            }
        });
    }

    private void recreateOtherVm() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("recreate"){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.beginCacheXml();
                File d = new File("DynamicRegionData" + ProcessMgr.getProcessId());
                d.mkdirs();
                CacheCreation cc = (CacheCreation)DynamicRegionDUnitTest.this.getCache();
                cc.setDynamicRegionFactoryConfig(new DynamicRegionFactory.Config(d, null));
                DynamicRegionDUnitTest.this.createParentRegion("parent", true);
                DynamicRegionDUnitTest.this.finishCacheXml("dynamicRegionDUnitTest");
                TestCase.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().isOpen());
            }
        });
    }

    private void checkForRegionOtherVm(final String fullPath, final boolean shouldExist) {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("checkForRegion"){

            @Override
            public void run2() throws CacheException {
                Region r = DynamicRegionDUnitTest.this.getCache().getRegion(fullPath);
                if (shouldExist) {
                    if (r == null) {
                        TestCase.fail((String)("region " + fullPath + " does not exist"));
                    }
                    TestCase.assertEquals((boolean)true, (boolean)r.containsKey((Object)"key1"));
                    TestCase.assertEquals((boolean)true, (boolean)r.containsValueForKey((Object)"key1"));
                    TestCase.assertEquals((Object)"value1", (Object)r.getEntry((Object)"key1").getValue());
                } else {
                    TestCase.assertEquals(null, (Object)r);
                }
            }
        });
    }

    private void checkForSubregionOtherVm(final String fullPath, final boolean shouldExist) {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("checkForRegion"){

            @Override
            public void run2() throws CacheException {
                Region r = DynamicRegionDUnitTest.this.getCache().getRegion(fullPath);
                if (shouldExist) {
                    if (r == null) {
                        TestCase.fail((String)("region " + fullPath + " does not exist"));
                    }
                } else {
                    TestCase.assertEquals(null, (Object)r);
                }
            }
        });
    }

    protected Region createParentRegion(String name, boolean persist) throws CacheException {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        File d = new File("DynamicRegionData" + ProcessMgr.getProcessId());
        factory.setDiskStoreName(this.getCache().createDiskStoreFactory().setDiskDirs(new File[]{d}).setMaxOplogSize(1L).create("DynamicRegionDUnitTest").getName());
        if (persist) {
            factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        }
        factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
        Region r = this.createRootRegion(name, factory.create());
        return r;
    }

    public void testPeerRegion() {
        int i;
        DynamicRegionDUnitTest.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().isOpen());
        this.createParentRegion("parent", true);
        Properties p = new Properties();
        this.doParentCreateOtherVm(p, false);
        Region dr = DynamicRegionFactory.get().createDynamicRegion("parent", "dynamicRegion1");
        String drFullPath = dr.getFullPath();
        dr.put((Object)"key1", (Object)"value1");
        for (i = 0; i < 10; ++i) {
            DynamicRegionFactory.get().createDynamicRegion(drFullPath, "subregion" + i);
        }
        DynamicRegionDUnitTest.getLogWriter().info("testPeerRegion - check #1 make sure other region has new dynamic subregion");
        this.checkForRegionOtherVm(drFullPath, true);
        this.checkForSubregionOtherVm(drFullPath + "/subregion7", true);
        this.recreateOtherVm();
        DynamicRegionDUnitTest.getLogWriter().info("testPeerRegion - check #2 make sure other region has dynamic region after restarting through getInitialImage");
        this.checkForRegionOtherVm(drFullPath, true);
        DynamicRegionDUnitTest.closeCache();
        this.recreateOtherVm();
        DynamicRegionDUnitTest.getLogWriter().info("testPeerRegion - check #3 make sure dynamic region can be recovered from disk");
        this.checkForRegionOtherVm(drFullPath, true);
        for (i = 0; i < 10; ++i) {
            this.checkForSubregionOtherVm(drFullPath + "/subregion" + i, true);
        }
        DynamicRegionDUnitTest.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().isClosed());
        DynamicRegionFactory.get().open(new DynamicRegionFactory.Config());
        DynamicRegionDUnitTest.beginCacheXml();
        this.createParentRegion("parent", true);
        this.finishCacheXml("dynamicRegionCTRDUnitTest");
        DynamicRegionDUnitTest.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().isOpen());
        DynamicRegionDUnitTest.assertEquals((boolean)true, (boolean)DynamicRegionFactory.get().isActive());
        Cache c = this.getCache();
        DynamicRegionDUnitTest.assertEquals((boolean)true, (c.getRegion(drFullPath) != null ? 1 : 0) != 0);
        for (int i2 = 0; i2 < 10; ++i2) {
            String regName = drFullPath + "/subregion" + i2;
            DynamicRegionDUnitTest.assertEquals((boolean)true, (c.getRegion(regName) != null ? 1 : 0) != 0);
            DynamicRegionFactory.get().destroyDynamicRegion(regName);
            DynamicRegionDUnitTest.assertEquals(null, (Object)c.getRegion(regName));
            this.checkForSubregionOtherVm(regName, false);
        }
        c.getRegion(drFullPath).localDestroyRegion();
        this.checkForRegionOtherVm(drFullPath, true);
        DynamicRegionFactory.get().destroyDynamicRegion(drFullPath);
        DynamicRegionDUnitTest.assertEquals(null, (Object)c.getRegion(drFullPath));
        this.checkForRegionOtherVm(drFullPath, false);
    }
}

