/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.DistributedNoAckRegionTest;
import com.gemstone.gemfire.cache30.MultiVMRegionTestCase;
import com.gemstone.gemfire.distributed.internal.SerialAckedMessage;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import hydra.DistributedSystemHelper;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class DistributedNoAckRegionCCEDUnitTest
extends DistributedNoAckRegionTest {
    static volatile boolean ListenerBlocking;

    public DistributedNoAckRegionCCEDUnitTest(String name) {
        super(name);
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties p = super.getDistributedSystemProperties();
        p.put("conserve-sockets", "false");
        if (distributedSystemID > 0) {
            p.put("distributed-system-id", "" + distributedSystemID);
        }
        p.put("socket-buffer-size", "2000000");
        return p;
    }

    @Override
    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_NO_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setConcurrencyChecksEnabled(true);
        return factory.create();
    }

    @Override
    protected RegionAttributes getRegionAttributes(String type) {
        RegionAttributes ra = this.getCache().getRegionAttributes(type);
        if (ra == null) {
            throw new IllegalStateException("The region shortcut " + type + " has been removed.");
        }
        AttributesFactory factory = new AttributesFactory(ra);
        factory.setScope(Scope.DISTRIBUTED_NO_ACK);
        factory.setConcurrencyChecksEnabled(true);
        return factory.create();
    }

    @Override
    public void sendSerialMessageToAll() {
        try {
            SerialAckedMessage msg = new SerialAckedMessage();
            msg.send(DistributedSystemHelper.getMembers(), false);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to send serial message due to exception", e);
        }
    }

    @Override
    public void testLocalDestroy() throws InterruptedException {
    }

    @Override
    public void testEntryTtlLocalDestroy() throws InterruptedException {
    }

    public void testClearWithManyEventsInFlight() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String name = this.getUniqueName() + "-CC";
        this.createRegionWithAttribute(vm0, name, false);
        this.createRegionWithAttribute(vm1, name, false);
        this.createRegionWithAttribute(vm2, name, false);
        this.createRegionWithAttribute(vm3, name, false);
        vm0.invoke(DistributedNoAckRegionCCEDUnitTest.class, "addBlockingListener");
        vm1.invoke(DistributedNoAckRegionCCEDUnitTest.class, "addBlockingListener");
        vm2.invoke(DistributedNoAckRegionCCEDUnitTest.class, "addBlockingListener");
        AsyncInvocation vm0Ops = vm0.invokeAsync(DistributedNoAckRegionCCEDUnitTest.class, "doManyOps");
        AsyncInvocation vm1Ops = vm1.invokeAsync(DistributedNoAckRegionCCEDUnitTest.class, "doManyOps");
        AsyncInvocation vm2Ops = vm2.invokeAsync(DistributedNoAckRegionCCEDUnitTest.class, "doManyOps");
        DistributedNoAckRegionCCEDUnitTest.pause(5000);
        AsyncInvocation a0 = vm3.invokeAsync(DistributedNoAckRegionCCEDUnitTest.class, "clearRegion");
        vm0.invoke(DistributedNoAckRegionCCEDUnitTest.class, "unblockListener");
        vm1.invoke(DistributedNoAckRegionCCEDUnitTest.class, "unblockListener");
        vm2.invoke(DistributedNoAckRegionCCEDUnitTest.class, "unblockListener");
        this.waitForAsyncProcessing(a0, "");
        this.waitForAsyncProcessing(vm0Ops, "");
        this.waitForAsyncProcessing(vm1Ops, "");
        this.waitForAsyncProcessing(vm2Ops, "");
        Map r0Contents = (Map)vm0.invoke(this.getClass(), "getCCRegionContents");
        Map r1Contents = (Map)vm1.invoke(this.getClass(), "getCCRegionContents");
        Map r2Contents = (Map)vm2.invoke(this.getClass(), "getCCRegionContents");
        Map r3Contents = (Map)vm3.invoke(this.getClass(), "getCCRegionContents");
        for (int i = 0; i < 10; ++i) {
            String key = "cckey" + i;
            DistributedNoAckRegionCCEDUnitTest.assertEquals((String)"region contents are not consistent", r0Contents.get(key), r1Contents.get(key));
            DistributedNoAckRegionCCEDUnitTest.assertEquals((String)"region contents are not consistent", r1Contents.get(key), r2Contents.get(key));
            DistributedNoAckRegionCCEDUnitTest.assertEquals((String)"region contents are not consistent", r2Contents.get(key), r3Contents.get(key));
            for (int subi = 1; subi < 3; ++subi) {
                String subkey = key + "-" + subi;
                DistributedNoAckRegionCCEDUnitTest.assertEquals((String)"region contents are not consistent", r0Contents.get(subkey), r1Contents.get(subkey));
                DistributedNoAckRegionCCEDUnitTest.assertEquals((String)"region contents are not consistent", r1Contents.get(subkey), r2Contents.get(subkey));
                DistributedNoAckRegionCCEDUnitTest.assertEquals((String)"region contents are not consistent", r2Contents.get(subkey), r3Contents.get(subkey));
            }
        }
    }

    static void addBlockingListener() {
        ListenerBlocking = true;
        CCRegion.getAttributesMutator().addCacheListener((CacheListener)new CacheListenerAdapter(){

            public void afterCreate(EntryEvent event) {
                this.onEvent(event);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void onEvent(EntryEvent event) {
                boolean blocked = false;
                if (event.isOriginRemote()) {
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        while (ListenerBlocking) {
                            DistributedTestCase.getLogWriter().info("blocking cache operations for " + event.getDistributedMember());
                            blocked = true;
                            try {
                                ((Object)((Object)this)).wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                DistributedTestCase.getLogWriter().info("blocking cache listener interrupted");
                                return;
                            }
                        }
                    }
                    if (blocked) {
                        DistributedTestCase.getLogWriter().info("allowing cache operations for " + event.getDistributedMember());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                DistributedTestCase.getLogWriter().info("closing blocking listener");
                ListenerBlocking = false;
                1 var1_1 = this;
                synchronized (var1_1) {
                    ((Object)((Object)this)).notifyAll();
                }
            }

            public void afterUpdate(EntryEvent event) {
                this.onEvent(event);
            }

            public void afterInvalidate(EntryEvent event) {
                this.onEvent(event);
            }

            public void afterDestroy(EntryEvent event) {
                this.onEvent(event);
            }
        });
    }

    static void doManyOps() {
        DistributedNoAckRegionCCEDUnitTest.doOpsLoopNoFlush(5000, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unblockListener() {
        CacheListener listener = CCRegion.getCacheListener();
        ListenerBlocking = false;
        CacheListener cacheListener = listener;
        synchronized (cacheListener) {
            listener.notifyAll();
        }
    }

    static void clearRegion() {
        CCRegion.clear();
    }

    public void testGIISendsTombstones() throws Exception {
        this.versionTestGIISendsTombstones();
    }

    protected void do_version_recovery_if_necessary(VM vm0, VM vm1, VM vm2, Object[] params) {
    }

    public void testConcurrentEvents() throws Exception {
        this.versionTestConcurrentEvents();
    }

    public void testClearWithConcurrentEvents() throws Exception {
    }

    public void testClearWithConcurrentEventsAsync() throws Exception {
    }

    public void testClearOnNonReplicateWithConcurrentEvents() throws Exception {
    }

    public void testTombstones() {
        this.versionTestTombstones();
    }

    public void testOneHopKnownIssues() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f;
                    int vmNumber = VM.getCurrentVMNum();
                    switch (vmNumber) {
                        case 0: {
                            f = DistributedNoAckRegionCCEDUnitTest.this.getCache().createRegionFactory(DistributedNoAckRegionCCEDUnitTest.this.getRegionAttributes(RegionShortcut.REPLICATE_PROXY.toString()));
                            break;
                        }
                        case 1: {
                            f = DistributedNoAckRegionCCEDUnitTest.this.getCache().createRegionFactory(DistributedNoAckRegionCCEDUnitTest.this.getRegionAttributes(RegionShortcut.REPLICATE.toString()));
                            f.setDataPolicy(DataPolicy.NORMAL);
                            break;
                        }
                        default: {
                            f = DistributedNoAckRegionCCEDUnitTest.this.getCache().createRegionFactory(DistributedNoAckRegionCCEDUnitTest.this.getRegionAttributes());
                        }
                    }
                    MultiVMRegionTestCase.CCRegion = (LocalRegion)f.create(name);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        String invalidationKey = "invalidationKey";
        String destroyKey = "destroyKey";
        SerializableRunnable test = new SerializableRunnable("case 1: second invalidation not applied or distributed"){

            @Override
            public void run() {
                MultiVMRegionTestCase.CCRegion.put((Object)"invalidationKey", (Object)"initialValue");
                int invalidationCount = MultiVMRegionTestCase.CCRegion.getCachePerfStats().getInvalidates();
                MultiVMRegionTestCase.CCRegion.invalidate((Object)"invalidationKey");
                MultiVMRegionTestCase.CCRegion.invalidate((Object)"invalidationKey");
                TestCase.assertEquals((int)(invalidationCount + 1), (int)MultiVMRegionTestCase.CCRegion.getCachePerfStats().getInvalidates());
                int destroyCount = MultiVMRegionTestCase.CCRegion.getCachePerfStats().getDestroys();
                MultiVMRegionTestCase.CCRegion.destroy((Object)"invalidationKey");
                try {
                    MultiVMRegionTestCase.CCRegion.destroy((Object)"invalidationKey");
                    TestCase.fail((String)"expected an EntryNotFoundException");
                }
                catch (EntryNotFoundException entryNotFoundException) {
                    // empty catch block
                }
                TestCase.assertEquals((int)(destroyCount + 1), (int)MultiVMRegionTestCase.CCRegion.getCachePerfStats().getDestroys());
            }
        };
        vm0.invoke(test);
        test.setName("case 2: second invalidation not applied or distributed");
        vm1.invoke(test);
    }

    public void testConcurrentEventsOnEmptyRegion() {
        this.versionTestConcurrentEventsOnEmptyRegion();
    }

    public void testConcurrentEventsOnNonReplicatedRegion() {
        this.versionTestConcurrentEventsOnNonReplicatedRegion();
    }

    public void testGetAllWithVersions() {
        this.versionTestGetAllWithVersions();
    }

    public void testRegionVersionVectors() throws Exception {
        this.versionTestRegionVersionVectors();
    }
}

