/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.DistributedAckRegionTest;
import com.gemstone.gemfire.cache30.MultiVMRegionTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMember;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TombstoneService;
import com.gemstone.gemfire.internal.cache.UpdateOperation;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.versions.VMVersionTag;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.cache.vmotion.VMotionObserver;
import com.gemstone.gemfire.internal.cache.vmotion.VMotionObserverHolder;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;

public class DistributedAckRegionCCEDUnitTest
extends DistributedAckRegionTest {
    public DistributedAckRegionCCEDUnitTest(String name) {
        super(name);
    }

    @Override
    protected boolean supportsTransactions() {
        return true;
    }

    @Override
    public Properties getDistributedSystemProperties() {
        Properties p = super.getDistributedSystemProperties();
        p.put("conserve-sockets", "false");
        if (distributedSystemID > 0) {
            p.put("distributed-system-id", "" + distributedSystemID);
        }
        return p;
    }

    @Override
    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setConcurrencyChecksEnabled(true);
        return factory.create();
    }

    @Override
    protected RegionAttributes getRegionAttributes(String type) {
        RegionAttributes ra = this.getCache().getRegionAttributes(type);
        if (ra == null) {
            throw new IllegalStateException("The region shortcut " + type + " has been removed.");
        }
        AttributesFactory factory = new AttributesFactory(ra);
        factory.setConcurrencyChecksEnabled(true);
        return factory.create();
    }

    @Override
    public void testLocalDestroy() throws InterruptedException {
    }

    public void testRegionVersionVectors() throws Exception {
        this.versionTestRegionVersionVectors();
    }

    @Override
    public void testEntryTtlLocalDestroy() throws InterruptedException {
    }

    public void testGIISendsTombstones() throws Exception {
        this.versionTestGIISendsTombstones();
    }

    public void testConcurrentOpWithGII() {
        if (this.getClass() != DistributedAckRegionCCEDUnitTest.class) {
            return;
        }
        final String name = this.getUniqueName() + "-CC";
        String key = "mykey";
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        SerializableCallable create = new SerializableCallable("create region"){

            public Object call() {
                RegionFactory f = DistributedAckRegionCCEDUnitTest.this.getCache().createRegionFactory(DistributedAckRegionCCEDUnitTest.this.getRegionAttributes());
                MultiVMRegionTestCase.CCRegion = (LocalRegion)f.create(name);
                return MultiVMRegionTestCase.CCRegion.getDistributionManager().getDistributionManagerId();
            }
        };
        InternalDistributedMember vm1ID = (InternalDistributedMember)vm1.invoke(create);
        AsyncInvocation partialCreate = vm2.invokeAsync(new SerializableCallable("create region with stall"){

            public Object call() throws Exception {
                final GemFireCacheImpl cache = (GemFireCacheImpl)DistributedAckRegionCCEDUnitTest.this.getCache();
                RegionFactory f = cache.createRegionFactory(DistributedAckRegionCCEDUnitTest.this.getRegionAttributes());
                InitialImageOperation.VMOTION_DURING_GII = true;
                VMotionObserverHolder.setInstance((VMotionObserver)new VMotionObserver(){

                    public void vMotionBeforeCQRegistration() {
                    }

                    public void vMotionBeforeRegisterInterest() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void vMotionDuringGII(Set recipientSet, LocalRegion region) {
                        InitialImageOperation.VMOTION_DURING_GII = false;
                        int oldLevel = LocalRegion.setThreadInitLevelRequirement((int)1);
                        LocalRegion ccregion = cache.getRegionByPath("/" + name, false);
                        try {
                            while (!ccregion.isDestroyed() && ccregion.getRegionEntry((Object)"mykey") == null) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    LocalRegion.setThreadInitLevelRequirement((int)oldLevel);
                                    return;
                                }
                            }
                        }
                        finally {
                            LocalRegion.setThreadInitLevelRequirement((int)oldLevel);
                        }
                    }
                });
                try {
                    MultiVMRegionTestCase.CCRegion = (LocalRegion)f.create(name);
                    TestCase.assertFalse((String)"expected initial image transfer to destroy entry", (boolean)MultiVMRegionTestCase.CCRegion.containsKey((Object)"mykey"));
                }
                finally {
                    InitialImageOperation.VMOTION_DURING_GII = false;
                }
                return null;
            }
        });
        vm1.invoke(new SerializableRunnable("create conflicting events"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long waitEnd = System.currentTimeMillis() + 45000L;
                CacheDistributionAdvisor adv = ((DistributedRegion)MultiVMRegionTestCase.CCRegion).getCacheDistributionAdvisor();
                while (System.currentTimeMillis() < waitEnd && adv.adviseGeneric().isEmpty()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                if (adv.adviseGeneric().isEmpty()) {
                    TestCase.fail((String)"other member never came on line");
                }
                DistributedCacheOperation.LOSS_SIMULATION_RATIO = 200.0;
                try {
                    MultiVMRegionTestCase.CCRegion.put((Object)"mykey", (Object)"initialValue");
                    MultiVMRegionTestCase.CCRegion.destroy((Object)"mykey");
                }
                finally {
                    DistributedCacheOperation.LOSS_SIMULATION_RATIO = 0.0;
                }
                VersionTag tag = MultiVMRegionTestCase.CCRegion.getRegionEntry((Object)"mykey").getVersionStamp().asVersionTag();
                JGroupMember nm = MultiVMRegionTestCase.CCRegion.getDistributionManager().getDistributionManagerId().getNetMember();
                InternalDistributedMember mbr = null;
                try {
                    mbr = new InternalDistributedMember(nm.getIpAddress().getCanonicalHostName(), nm.getPort() - 1, "fake_id", "fake_id_ustring");
                    tag.setMemberID((VersionSource)mbr);
                }
                catch (UnknownHostException e) {
                    DistributedTestCase.fail("could not create member id", e);
                }
                EntryEventImpl event = EntryEventImpl.create((LocalRegion)MultiVMRegionTestCase.CCRegion, (Operation)Operation.UPDATE, (Object)"mykey", (boolean)false, (DistributedMember)mbr, (boolean)true, (boolean)false);
                event.setNewValue((Object)"newValue");
                event.setVersionTag(tag);
                UpdateOperation op = new UpdateOperation(event, tag.getVersionTimeStamp());
                op.distribute();
                event.release();
            }
        });
        try {
            partialCreate.getResult();
        }
        catch (Throwable e) {
            DistributedAckRegionCCEDUnitTest.fail("async invocation in vm2 failed", e);
        }
    }

    protected void do_version_recovery_if_necessary(VM vm0, VM vm1, VM vm2, Object[] params) {
    }

    public void testConcurrentEvents() throws Exception {
        this.versionTestConcurrentEvents();
    }

    public void testClearWithConcurrentEvents() throws Exception {
        this.z_versionTestClearWithConcurrentEvents(true);
    }

    public void testClearWithConcurrentEventsAsync() throws Exception {
        this.versionTestClearWithConcurrentEventsAsync();
    }

    public void testClearOnNonReplicateWithConcurrentEvents() throws Exception {
        this.versionTestClearOnNonReplicateWithConcurrentEvents();
    }

    public void testTombstones() {
        this.versionTestTombstones();
    }

    public void testTombstoneExpirationRace() {
        VM vm0 = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = DistributedAckRegionCCEDUnitTest.this.getCache().createRegionFactory(DistributedAckRegionCCEDUnitTest.this.getRegionAttributes());
                    MultiVMRegionTestCase.CCRegion = (LocalRegion)f.create(name);
                    MultiVMRegionTestCase.CCRegion.put((Object)"cckey0", (Object)"ccvalue");
                    MultiVMRegionTestCase.CCRegion.put((Object)"cckey0", (Object)"ccvalue");
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm1.invoke(new SerializableRunnable("Create local tombstone and adjust time"){

            @Override
            public void run() {
                RegionEntry entry = MultiVMRegionTestCase.CCRegion.getRegionEntry((Object)"cckey0");
                VersionTag tag = entry.getVersionStamp().asVersionTag();
                TestCase.assertTrue((tag.getEntryVersion() > 1 ? 1 : 0) != 0);
                tag.setVersionTimeStamp(System.currentTimeMillis() - TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT - 1000L);
                entry.getVersionStamp().setVersionTimeStamp(tag.getVersionTimeStamp());
                try {
                    entry.makeTombstone(MultiVMRegionTestCase.CCRegion, tag);
                }
                catch (RegionClearedException e) {
                    DistributedTestCase.fail("region was mysteriously cleared during unit testing", e);
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Locally destroy the entry and do a create that will be propagated with v1"){

            @Override
            public void run() {
                MultiVMRegionTestCase.CCRegion.getRegionMap().removeEntry((Object)"cckey0", MultiVMRegionTestCase.CCRegion.getRegionEntry((Object)"cckey0"), true);
                if (MultiVMRegionTestCase.CCRegion.getRegionEntry((Object)"ckey0") != null) {
                    TestCase.fail((String)"expected removEntry to remove the entry from the region's map");
                }
                MultiVMRegionTestCase.CCRegion.put((Object)"cckey0", (Object)"updateAfterReap");
            }
        });
        vm1.invoke(new SerializableRunnable("Check that the create() was applied"){

            @Override
            public void run() {
                RegionEntry entry = MultiVMRegionTestCase.CCRegion.getRegionEntry((Object)"cckey0");
                TestCase.assertTrue((entry.getVersionStamp().getEntryVersion() == 1 ? 1 : 0) != 0);
            }
        });
        DistributedAckRegionCCEDUnitTest.disconnectAllFromDS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAggressiveTombstoneReaping() {
        if (this.getClass() != DistributedAckRegionCCEDUnitTest.class) {
            return;
        }
        String name = this.getUniqueName() + "-CC";
        long saveExpiredTombstoneLimit = TombstoneService.EXPIRED_TOMBSTONE_LIMIT;
        long saveTombstoneTimeout = TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT;
        TombstoneService.EXPIRED_TOMBSTONE_LIMIT = 50L;
        TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT = 500L;
        try {
            RegionFactory f = this.getCache().createRegionFactory(this.getRegionAttributes());
            CCRegion = (LocalRegion)f.create(name);
            final long initialCount = CCRegion.getCachePerfStats().getTombstoneGCCount();
            for (int i = 0; i < 100; ++i) {
                CCRegion.put((Object)("cckey" + i), (Object)("ccvalue" + i));
                CCRegion.destroy((Object)("cckey" + i));
            }
            TombstoneService.FORCE_GC_MEMORY_EVENTS = true;
            DistributedTestCase.WaitCriterion waitForGC = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return (long)MultiVMRegionTestCase.CCRegion.getCachePerfStats().getTombstoneGCCount() > initialCount;
                }

                @Override
                public String description() {
                    return "waiting for GC to occur";
                }
            };
            DistributedAckRegionCCEDUnitTest.waitForCriterion(waitForGC, 20000L, 1000L, true);
            DistributedAckRegionCCEDUnitTest.pause(5000);
            long gcCount = CCRegion.getCachePerfStats().getTombstoneGCCount();
            DistributedAckRegionCCEDUnitTest.assertTrue((String)("expected a few GCs, but not " + (gcCount - initialCount)), (gcCount < initialCount + 20L ? 1 : 0) != 0);
        }
        catch (CacheException ex) {
            DistributedAckRegionCCEDUnitTest.fail("While creating region", ex);
        }
        finally {
            TombstoneService.EXPIRED_TOMBSTONE_LIMIT = saveExpiredTombstoneLimit;
            TombstoneService.FORCE_GC_MEMORY_EVENTS = false;
            TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT = saveTombstoneTimeout;
        }
    }

    public void testConcurrentEventsOnEmptyRegion() {
        this.versionTestConcurrentEventsOnEmptyRegion();
    }

    public void testConcurrentEventsOnNonReplicatedRegion() {
        this.versionTestConcurrentEventsOnNonReplicatedRegion();
    }

    public void testGetAllWithVersions() {
        this.versionTestGetAllWithVersions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntryVersionRollover() throws Exception {
        if (this.getClass() != DistributedAckRegionCCEDUnitTest.class) {
            return;
        }
        final String name = this.getUniqueName() + "-CC";
        boolean numEntries = true;
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = DistributedAckRegionCCEDUnitTest.this.getCache().createRegionFactory(DistributedAckRegionCCEDUnitTest.this.getRegionAttributes());
                    MultiVMRegionTestCase.CCRegion = (LocalRegion)f.create(name);
                    for (int i = 0; i < 1; ++i) {
                        MultiVMRegionTestCase.CCRegion.put((Object)("cckey" + i), (Object)"ccvalue");
                    }
                    TestCase.assertEquals((String)"expected no conflated events", (long)0L, (long)MultiVMRegionTestCase.CCRegion.getCachePerfStats().getConflatedEventsCount());
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        VM vm0 = Host.getHost(0).getVM(0);
        vm0.invoke(createRegion);
        try {
            createRegion.run();
            VMVersionTag tag = new VMVersionTag();
            tag.setEntryVersion(0xFFFFFF);
            tag.setDistributedSystemId(1);
            tag.setRegionVersion(CCRegion.getVersionVector().getNextVersion());
            EntryEventImpl holder = EntryEventImpl.createVersionTagHolder((VersionTag)tag);
            ClientProxyMembershipID id = ClientProxyMembershipID.getNewProxyMembership((DistributedSystem)CCRegion.getDistributionManager().getSystem());
            CCRegion.basicBridgePut((Object)"cckey0", (Object)"newvalue", null, true, null, id, true, false, holder);
            holder.release();
            vm0.invoke(new SerializableRunnable("check conflation count"){

                @Override
                public void run() {
                    TestCase.assertEquals((String)"expected one conflated event", (long)1L, (long)MultiVMRegionTestCase.CCRegion.getCachePerfStats().getConflatedEventsCount());
                }
            });
        }
        finally {
            DistributedAckRegionCCEDUnitTest.disconnectAllFromDS();
        }
    }
}

