/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class ClientServerCCEDUnitTest
extends CacheTestCase {
    public static LocalRegion TestRegion;

    public void setup() {
        HARegionQueue.setMessageSyncInterval((int)5);
    }

    @Override
    public void tearDown2() {
        ClientServerCCEDUnitTest.disconnectAllFromDS();
        HARegionQueue.setMessageSyncInterval((int)1);
    }

    public ClientServerCCEDUnitTest(String name) {
        super(name);
    }

    public void testClientServerRRTombstoneGC() {
        this.clientServerTombstoneGCTest(this.getUniqueName(), true);
    }

    public void testClientServerPRTombstoneGC() {
        this.clientServerTombstoneGCTest(this.getUniqueName(), false);
    }

    private void clientServerTombstoneGCTest(String uniqueName, boolean replicatedRegion) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String name = uniqueName + "Region";
        this.createServerRegion(vm0, name, replicatedRegion);
        int port = this.createServerRegion(vm1, name, replicatedRegion);
        this.createClientRegion(vm2, name, port);
        this.createClientRegion(vm3, name, port);
        this.createEntries(vm2);
        this.destroyEntries(vm3);
        this.unregisterInterest(vm3);
        this.forceGC(vm0);
        if (!replicatedRegion) {
            this.forceGC(vm1);
        }
        this.checkClientReceivedGC(vm2);
        this.checkClientDoesNotReceiveGC(vm3);
    }

    public void testClientRIGetsTombstonesRR() throws Exception {
        this.clientRIGetsTombstoneTest(this.getUniqueName(), true);
    }

    public void testClientRIGetsTombstonesPR() throws Exception {
        this.clientRIGetsTombstoneTest(this.getUniqueName(), false);
    }

    private void clientRIGetsTombstoneTest(String uniqueName, boolean replicatedRegion) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        String name = uniqueName + "Region";
        this.createServerRegion(vm0, name, replicatedRegion);
        int port = this.createServerRegion(vm1, name, replicatedRegion);
        this.createEntries(vm0);
        this.destroyEntries(vm0);
        ClientServerCCEDUnitTest.getLogWriter().info("***************** register interest on all keys");
        this.createClientRegion(vm2, name, port);
        this.registerInterest(vm2);
        this.ensureAllTombstonesPresent(vm2);
        ClientServerCCEDUnitTest.getLogWriter().info("***************** clear cache and register interest on one key, Object0");
        this.clearLocalCache(vm2);
        this.registerInterestOneKey(vm2, "Object0");
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add("Object0");
        this.ensureAllTombstonesPresent(vm2, keys);
        ClientServerCCEDUnitTest.getLogWriter().info("***************** clear cache and register interest on four keys");
        this.clearLocalCache(vm2);
        keys = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            keys.add("Object" + i);
        }
        this.registerInterest(vm2, keys);
        this.ensureAllTombstonesPresent(vm2, keys);
        ClientServerCCEDUnitTest.getLogWriter().info("***************** clear cache and register interest with regex on four keys");
        this.clearLocalCache(vm2);
        this.registerInterestRegex(vm2, "Object[0-3]");
        this.ensureAllTombstonesPresent(vm2, keys);
        ClientServerCCEDUnitTest.getLogWriter().info("***************** fetch entries with getAll()");
        this.clearLocalCache(vm2);
        this.getAll(vm2);
        this.ensureAllTombstonesPresent(vm2);
    }

    public void testClientRIGetsInvalidEntriesRR() throws Exception {
        this.clientRIGetsInvalidEntriesTest(this.getUniqueName(), true);
    }

    public void testClientRIGetsInvalidEntriesPR() throws Exception {
        this.clientRIGetsInvalidEntriesTest(this.getUniqueName(), false);
    }

    private void clientRIGetsInvalidEntriesTest(String uniqueName, boolean replicatedRegion) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        String name = uniqueName + "Region";
        this.createServerRegion(vm0, name, replicatedRegion);
        int port = this.createServerRegion(vm1, name, replicatedRegion);
        this.createEntries(vm0);
        this.invalidateEntries(vm0);
        ClientServerCCEDUnitTest.getLogWriter().info("***************** register interest on all keys");
        this.createClientRegion(vm2, name, port);
        this.registerInterest(vm2);
        this.ensureAllInvalidsPresent(vm2);
        ClientServerCCEDUnitTest.getLogWriter().info("***************** clear cache and register interest on one key, Object0");
        this.clearLocalCache(vm2);
        this.registerInterestOneKey(vm2, "Object0");
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add("Object0");
        this.ensureAllInvalidsPresent(vm2, keys);
        ClientServerCCEDUnitTest.getLogWriter().info("***************** clear cache and register interest on four keys");
        this.clearLocalCache(vm2);
        keys = new ArrayList(4);
        for (int i = 0; i < 4; ++i) {
            keys.add("Object" + i);
        }
        this.registerInterest(vm2, keys);
        this.ensureAllInvalidsPresent(vm2, keys);
        ClientServerCCEDUnitTest.getLogWriter().info("***************** clear cache and register interest with regex on four keys");
        this.clearLocalCache(vm2);
        this.registerInterestRegex(vm2, "Object[0-3]");
        this.ensureAllInvalidsPresent(vm2, keys);
        ClientServerCCEDUnitTest.getLogWriter().info("***************** fetch entries with getAll()");
        this.clearLocalCache(vm2);
        this.getAll(vm2);
        this.ensureAllInvalidsPresent(vm2);
    }

    private void registerInterest(VM vm) {
        vm.invoke(new SerializableRunnable("register interest in all keys"){

            @Override
            public void run() {
                TestRegion.registerInterestRegex(".*");
            }
        });
    }

    private void unregisterInterest(VM vm) {
        vm.invoke(new SerializableRunnable("unregister interest in all keys"){

            @Override
            public void run() {
                TestRegion.unregisterInterestRegex(".*");
            }
        });
    }

    private void registerInterest(VM vm, final List keys) {
        vm.invoke(new SerializableRunnable("register interest in key list"){

            @Override
            public void run() {
                TestRegion.registerInterest((Object)keys);
            }
        });
    }

    private void registerInterestOneKey(VM vm, final String key) {
        vm.invoke(new SerializableRunnable("register interest in " + key){

            @Override
            public void run() {
                TestRegion.registerInterest((Object)key);
            }
        });
    }

    private void registerInterestRegex(VM vm, final String pattern) {
        vm.invoke(new SerializableRunnable("register interest in key list"){

            @Override
            public void run() {
                TestRegion.registerInterestRegex(pattern);
            }
        });
    }

    private void ensureAllTombstonesPresent(VM vm) {
        vm.invoke(new SerializableCallable("check all are tombstones"){

            public Object call() {
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertTrue((String)("expected a tombstone for Object" + i), (boolean)TestRegion.containsTombstone((Object)("Object" + i)));
                }
                return null;
            }
        });
    }

    private void ensureAllTombstonesPresent(VM vm, final List keys) {
        vm.invoke(new SerializableCallable("check tombstones in list"){

            public Object call() {
                for (Object key : keys) {
                    TestCase.assertTrue((String)("expected to find a tombstone for " + key), (boolean)TestRegion.containsTombstone(key));
                }
                return null;
            }
        });
    }

    private void ensureAllInvalidsPresent(VM vm) {
        vm.invoke(new SerializableCallable("check all are tombstones"){

            public Object call() {
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertTrue((String)("expected to find an entry for Object" + i), (boolean)TestRegion.containsKey((Object)("Object" + i)));
                    TestCase.assertTrue((String)("expected to find entry invalid for Object" + i), (!TestRegion.containsValue((Object)("Object" + i)) ? 1 : 0) != 0);
                }
                return null;
            }
        });
    }

    private void ensureAllInvalidsPresent(VM vm, final List keys) {
        vm.invoke(new SerializableCallable("check tombstones in list"){

            public Object call() {
                for (Object key : keys) {
                    TestCase.assertTrue((String)("expected to find an entry for " + key), (boolean)TestRegion.containsKey(key));
                    TestCase.assertTrue((String)("expected to find entry invalid for " + key), (!TestRegion.containsValue(key) ? 1 : 0) != 0);
                }
                return null;
            }
        });
    }

    private void getAll(VM vm) {
        vm.invoke(new SerializableRunnable("getAll for all keys"){

            @Override
            public void run() {
                HashSet<String> keys = new HashSet<String>();
                for (int i = 0; i < 10; ++i) {
                    keys.add("Object" + i);
                }
                Map result = TestRegion.getAll(keys);
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertNull((String)("expected no result for Object" + i), result.get("Object" + i));
                }
            }
        });
    }

    private void clearLocalCache(VM vm) {
        vm.invoke(new SerializableRunnable("clear local cache"){

            @Override
            public void run() {
                TestRegion.localClear();
            }
        });
    }

    public void testClientServerRRQueueCleanup() {
        this.clientServerTombstoneMessageTest(true);
    }

    public void testClientServerPRQueueCleanup() {
        this.clientServerTombstoneMessageTest(false);
    }

    private void clientServerTombstoneMessageTest(boolean replicatedRegion) {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String name = this.getUniqueName() + "Region";
        int port1 = this.createServerRegion(vm0, name, replicatedRegion);
        int port2 = this.createServerRegion(vm1, name, replicatedRegion);
        this.createDurableClientRegion(vm2, name, port1, port2, true);
        this.createDurableClientRegion(vm3, name, port1, port2, true);
        this.createEntries(vm2);
        this.destroyEntries(vm3);
        this.forceGC(vm0);
        if (!replicatedRegion) {
            this.forceGC(vm1);
        }
        ClientServerCCEDUnitTest.pause(5000);
        this.checkClientReceivedGC(vm2);
        this.checkClientReceivedGC(vm3);
        this.checkServerQueuesEmpty(vm0);
        this.checkServerQueuesEmpty(vm1);
    }

    private void createEntries(VM vm) {
        vm.invoke(new SerializableCallable("create entries"){

            public Object call() {
                for (int i = 0; i < 10; ++i) {
                    TestRegion.create((Object)("Object" + i), (Object)i);
                }
                return null;
            }
        });
    }

    private void destroyEntries(VM vm) {
        vm.invoke(new SerializableCallable("destroy entries"){

            public Object call() {
                for (int i = 0; i < 10; ++i) {
                    TestRegion.destroy((Object)("Object" + i), (Object)i);
                }
                TestCase.assertEquals((int)0, (int)TestRegion.size());
                if (TestRegion.getDataPolicy().isReplicate()) {
                    TestCase.assertEquals((int)10, (int)TestRegion.getTombstoneCount());
                }
                return null;
            }
        });
    }

    private void invalidateEntries(VM vm) {
        vm.invoke(new SerializableCallable("invalidate entries"){

            public Object call() {
                for (int i = 0; i < 10; ++i) {
                    TestRegion.invalidate((Object)("Object" + i), (Object)i);
                }
                TestCase.assertEquals((int)10, (int)TestRegion.size());
                return null;
            }
        });
    }

    private void forceGC(VM vm) {
        vm.invoke(new SerializableCallable("force GC"){

            public Object call() throws Exception {
                TestRegion.getCache().getTombstoneService().forceBatchExpirationForTests(10);
                return null;
            }
        });
    }

    private void checkClientReceivedGC(VM vm) {
        vm.invoke(new SerializableCallable("check that GC happened"){

            public Object call() throws Exception {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        DistributedTestCase.getLogWriter().info("tombstone count = " + TestRegion.getTombstoneCount());
                        DistributedTestCase.getLogWriter().info("region size = " + TestRegion.size());
                        return TestRegion.getTombstoneCount() == 0 && TestRegion.size() == 0;
                    }

                    @Override
                    public String description() {
                        return "waiting for garbage collection to occur";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 60000L, 2000L, true);
                return null;
            }
        });
    }

    private void checkServerQueuesEmpty(VM vm) {
        vm.invoke(new SerializableCallable("check that client queues are properly cleared of old ClientTombstone messages"){

            public Object call() throws Exception {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        CacheClientNotifier singleton = CacheClientNotifier.getInstance();
                        Collection proxies = singleton.getClientProxies();
                        for (CacheClientProxy proxy : proxies) {
                            int size;
                            if (proxy.isPrimary() || (size = proxy.getQueueSize()) <= 0) continue;
                            DistributedTestCase.getLogWriter().info("queue size (" + size + ") is still > 0 for " + proxy.getProxyID());
                            return false;
                        }
                        int regionEntryCount = TestRegion.getRegionMap().size();
                        if (regionEntryCount > 0) {
                            DistributedTestCase.getLogWriter().info("TestRegion has unexpected entries - all should have been GC'd but we have " + regionEntryCount);
                            TestRegion.dumpBackingMap();
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public String description() {
                        return "waiting for queue removal messages to clear client queues";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 60000L, 2000L, true);
                return null;
            }
        });
    }

    private void checkClientDoesNotReceiveGC(VM vm) {
        vm.invoke(new SerializableCallable("check that GC did not happen"){

            public Object call() throws Exception {
                if (TestRegion.getTombstoneCount() == 0) {
                    DistributedTestCase.getLogWriter().warning("region has no tombstones");
                    throw new AssertionFailedError("expected to find tombstones but region is empty");
                }
                return null;
            }
        });
    }

    private int createServerRegion(VM vm, final String regionName, final boolean replicatedRegion) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                if (replicatedRegion) {
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setDataPolicy(DataPolicy.REPLICATE);
                } else {
                    af.setDataPolicy(DataPolicy.PARTITION);
                    af.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(2).create());
                }
                TestRegion = (LocalRegion)ClientServerCCEDUnitTest.this.createRootRegion(regionName, af.create());
                CacheServer server = ClientServerCCEDUnitTest.this.getCache().addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        return (Integer)vm.invoke(createRegion);
    }

    private void createClientRegion(final VM vm, final String regionName, final int port) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm.getHost()), port);
                cf.setPoolSubscriptionEnabled(true);
                cf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache cache = ClientServerCCEDUnitTest.this.getClientCache(cf);
                ClientRegionFactory crf = cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY);
                crf.setConcurrencyChecksEnabled(true);
                TestRegion = (LocalRegion)crf.create(regionName);
                TestRegion.registerInterestRegex(".*", InterestResultPolicy.KEYS_VALUES, false, true);
                return null;
            }
        };
        vm.invoke(createRegion);
    }

    private void createDurableClientRegion(final VM vm, final String regionName, final int port1, final int port2, final boolean ccEnabled) {
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                ClientCacheFactory cf = new ClientCacheFactory();
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm.getHost()), port1);
                cf.addPoolServer(DistributedTestCase.getServerHostName(vm.getHost()), port2);
                cf.setPoolSubscriptionEnabled(true);
                cf.setPoolSubscriptionRedundancy(1);
                cf.set("durable-client-id", "" + vm.getPid());
                cf.set("durable-client-timeout", "200");
                cf.set("log-level", "fine");
                ClientCache cache = ClientServerCCEDUnitTest.this.getClientCache(cf);
                ClientRegionFactory crf = cache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY);
                crf.setConcurrencyChecksEnabled(ccEnabled);
                TestRegion = (LocalRegion)crf.create(regionName);
                TestRegion.registerInterestRegex(".*", InterestResultPolicy.KEYS_VALUES, true, true);
                cache.readyForEvents();
                return null;
            }
        };
        vm.invoke(createRegion);
    }
}

