/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.Host;
import dunit.VM;

public class CachedAllEventsDUnitTest
extends CacheTestCase {
    public CachedAllEventsDUnitTest(String name) {
        super(name);
    }

    private VM getOtherVm() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    private void initOtherId() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("Connect"){

            @Override
            public void run2() throws CacheException {
                CachedAllEventsDUnitTest.this.getCache();
            }
        });
        vm.invoke(CachedAllEventsDUnitTest.class, "getVMDistributedMember");
    }

    private void doCreateOtherVm() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                Region r1 = CachedAllEventsDUnitTest.this.createRootRegion("r1", af.create());
                r1.create((Object)"key", (Object)"value");
            }
        });
    }

    public static DistributedMember getVMDistributedMember() {
        return InternalDistributedSystem.getAnyInstance().getDistributedMember();
    }

    private void remoteCreate(DataPolicy dp, InterestPolicy ip, boolean rmtCreate) throws CacheException {
        this.initOtherId();
        AttributesFactory af = new AttributesFactory();
        af.setDataPolicy(dp);
        af.setSubscriptionAttributes(new SubscriptionAttributes(ip));
        af.setScope(Scope.DISTRIBUTED_ACK);
        Region r1 = this.createRootRegion("r1", af.create());
        CachedAllEventsDUnitTest.assertEquals((boolean)false, (boolean)r1.containsKey((Object)"key"));
        this.doCreateOtherVm();
        if (rmtCreate) {
            CachedAllEventsDUnitTest.assertEquals((boolean)true, (boolean)r1.containsKey((Object)"key"));
            CachedAllEventsDUnitTest.assertEquals((Object)"value", (Object)r1.getEntry((Object)"key").getValue());
        } else {
            CachedAllEventsDUnitTest.assertEquals((boolean)false, (boolean)r1.containsKey((Object)"key"));
        }
    }

    public void testRemoteCreate_CAE() throws CacheException {
        this.remoteCreate(DataPolicy.NORMAL, InterestPolicy.ALL, true);
    }

    public void testRemoteCreate_CAER() throws CacheException {
        this.remoteCreate(DataPolicy.REPLICATE, InterestPolicy.CACHE_CONTENT, true);
    }

    public void testRemoteCreate_C() throws CacheException {
        this.remoteCreate(DataPolicy.NORMAL, InterestPolicy.CACHE_CONTENT, false);
    }
}

