/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskWriteAttributesFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheXml30Test;
import com.gemstone.gemfire.cache30.CacheXml45Test;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionCreation;
import dunit.Host;
import dunit.VM;
import junit.framework.TestCase;

public class CacheXml51Test
extends CacheXml45Test {
    public CacheXml51Test(String name) {
        super(name);
    }

    @Override
    protected String getGemFireVersion() {
        return "5_1";
    }

    @Override
    public void testPartitionedRegionXML() throws CacheException {
        this.setXmlFile(this.findFile("partitionedRegion51.xml"));
        String regionName = "pRoot";
        Cache cache = this.getCache();
        Region region = cache.getRegion("pRoot");
        CacheXml51Test.assertNotNull((Object)region);
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable init = new CacheSerializableRunnable("initUsingPartitionedRegionXML"){

            @Override
            public void run2() throws CacheException {
                Cache c;
                try {
                    CacheXml30Test.lonerDistributedSystem = false;
                    c = CacheXml51Test.this.getCache();
                }
                finally {
                    CacheXml30Test.lonerDistributedSystem = true;
                }
                Region r = c.getRegion("pRoot");
                TestCase.assertNotNull((Object)r);
                RegionAttributes attrs = r.getAttributes();
                TestCase.assertNotNull((Object)attrs.getPartitionAttributes());
                PartitionAttributes pa = attrs.getPartitionAttributes();
                TestCase.assertEquals((int)pa.getRedundantCopies(), (int)1);
                TestCase.assertEquals((int)pa.getLocalMaxMemory(), (int)32);
                TestCase.assertEquals((long)pa.getTotalMaxMemory(), (long)96L);
                TestCase.assertEquals((int)pa.getTotalNumBuckets(), (int)119);
                r = c.getRegion("bug37905");
                TestCase.assertTrue((String)"region should have been an instance of PartitionedRegion but was not", (boolean)(r instanceof PartitionedRegion));
            }
        };
        init.run2();
        vm0.invoke(init);
        vm1.invoke(init);
        vm0.invoke(new CacheSerializableRunnable("putUsingPartitionedRegionXML1"){

            @Override
            public void run2() throws CacheException {
                String val = "prValue0";
                Integer key = new Integer(10);
                Cache c = CacheXml51Test.this.getCache();
                Region r = c.getRegion("pRoot");
                TestCase.assertNotNull((Object)r);
                r.put((Object)key, (Object)"prValue0");
                TestCase.assertEquals((Object)"prValue0", (Object)r.get((Object)key));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("putUsingPartitionedRegionXML2"){

            @Override
            public void run2() throws CacheException {
                String val = "prValue1";
                Integer key = new Integer(14);
                Cache c = CacheXml51Test.this.getCache();
                Region r = c.getRegion("pRoot");
                TestCase.assertNotNull((Object)r);
                r.put((Object)key, (Object)"prValue1");
                TestCase.assertEquals((Object)"prValue1", (Object)r.get((Object)key));
            }
        });
    }

    public void testMessageSyncInterval() throws CacheException {
        CacheCreation cache = new CacheCreation();
        cache.setMessageSyncInterval(123);
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml51Test.assertNotNull((Object)c);
        CacheXml51Test.assertEquals((int)123, (int)c.getMessageSyncInterval());
    }

    public void testBridgeAttributesRelatedToClientQueuesHA() throws CacheException {
        CacheCreation cache = new CacheCreation();
        cache.setMessageSyncInterval(3445);
        BridgeServer bs = cache.addBridgeServer();
        bs.setMaximumMessageCount(12345);
        bs.setMessageTimeToLive(56789);
        bs.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
        Cache c = this.getCache();
        CacheXml51Test.assertNotNull((Object)c);
        BridgeServer server = (BridgeServer)cache.getBridgeServers().iterator().next();
        CacheXml51Test.assertNotNull((Object)server);
        CacheXml51Test.assertEquals((int)12345, (int)server.getMaximumMessageCount());
        CacheXml51Test.assertEquals((int)56789, (int)server.getMessageTimeToLive());
    }

    @Override
    public void testPartitionedRegionInstantiation() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setLocalMaxMemory(4).setTotalNumBuckets(17).setTotalMaxMemory(8L);
        attrs.setPartitionAttributes(paf.create());
        cache.createRegion("pRoot", (RegionAttributes)attrs);
    }

    public void testBridgeMaxThreads() throws CacheException {
        CacheCreation cache = new CacheCreation();
        BridgeServer bs = cache.addBridgeServer();
        bs.setMaxThreads(37);
        bs.setMaxConnections(999);
        bs.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setDataPolicy(DataPolicy.NORMAL);
        cache.createVMRegion("rootNORMAL", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testRegionMulticastSetViaCacheXml() throws CacheException {
        String rNameBase = this.getUniqueName();
        String r1 = rNameBase + "1";
        String r2 = rNameBase + "2";
        String r3 = rNameBase + "3";
        CacheCreation creation = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(creation);
        attrs.setScope(Scope.LOCAL);
        attrs.setEarlyAck(false);
        attrs.setMulticastEnabled(true);
        creation.createRegion(r1, (RegionAttributes)attrs);
        String attrId = "region_attrs_with_multicast";
        attrs = new RegionAttributesCreation(creation);
        attrs.setId("region_attrs_with_multicast");
        attrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        attrs.setEarlyAck(false);
        attrs.setMulticastEnabled(true);
        creation.setRegionAttributes(attrs.getId(), (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(creation);
        attrs.setRefid("region_attrs_with_multicast");
        creation.createRegion(r3, (RegionAttributes)attrs);
        this.testXml(creation);
        creation = new CacheCreation();
        attrs = new RegionAttributesCreation(creation);
        attrs.setScope(Scope.DISTRIBUTED_ACK);
        attrs.setEarlyAck(false);
        attrs.setMulticastEnabled(true);
        creation.createRegion(r2, (RegionAttributes)attrs);
        Cache c = this.getCache();
        CacheXml51Test.assertTrue((boolean)(c instanceof GemFireCacheImpl));
        c.loadCacheXml(this.generate(creation));
        Region reg1 = c.getRegion(r1);
        CacheXml51Test.assertNotNull((Object)reg1);
        CacheXml51Test.assertEquals((Object)Scope.LOCAL, (Object)reg1.getAttributes().getScope());
        CacheXml51Test.assertFalse((boolean)reg1.getAttributes().getEarlyAck());
        CacheXml51Test.assertTrue((boolean)reg1.getAttributes().getMulticastEnabled());
        Region reg2 = c.getRegion(r2);
        CacheXml51Test.assertNotNull((Object)reg2);
        CacheXml51Test.assertEquals((Object)Scope.DISTRIBUTED_ACK, (Object)reg2.getAttributes().getScope());
        CacheXml51Test.assertFalse((boolean)reg2.getAttributes().getEarlyAck());
        CacheXml51Test.assertTrue((boolean)reg2.getAttributes().getMulticastEnabled());
        Region reg3 = c.getRegion(r3);
        CacheXml51Test.assertNotNull((Object)reg3);
        CacheXml51Test.assertEquals((Object)Scope.DISTRIBUTED_NO_ACK, (Object)reg3.getAttributes().getScope());
        CacheXml51Test.assertFalse((boolean)reg3.getAttributes().getEarlyAck());
        CacheXml51Test.assertTrue((boolean)reg3.getAttributes().getMulticastEnabled());
    }

    public void testRollOplogs() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        RegionCreation root = (RegionCreation)cache.createRegion("root", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        DiskWriteAttributesFactory dwaf = new DiskWriteAttributesFactory();
        dwaf.setSynchronous(true);
        dwaf.setRollOplogs(true);
        attrs.setDiskWriteAttributes(dwaf.create());
        root.createSubregion("sync", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        dwaf = new DiskWriteAttributesFactory();
        dwaf.setTimeInterval(123L);
        dwaf.setBytesThreshold(456L);
        dwaf.setRollOplogs(false);
        attrs.setDiskWriteAttributes(dwaf.create());
        root.createSubregion("async", (RegionAttributes)attrs);
        this.testXml(cache);
    }

    public void testMaxOplogSize() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        RegionCreation root = (RegionCreation)cache.createRegion("root", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        DiskWriteAttributesFactory dwaf = new DiskWriteAttributesFactory();
        dwaf.setSynchronous(true);
        dwaf.setMaxOplogSize(1);
        attrs.setDiskWriteAttributes(dwaf.create());
        root.createSubregion("sync", (RegionAttributes)attrs);
        attrs = new RegionAttributesCreation(cache);
        dwaf = new DiskWriteAttributesFactory();
        dwaf.setTimeInterval(123L);
        dwaf.setBytesThreshold(456L);
        dwaf.setMaxOplogSize(1);
        attrs.setDiskWriteAttributes(dwaf.create());
        root.createSubregion("async", (RegionAttributes)attrs);
        this.testXml(cache);
    }
}

