/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.CacheXml30Test;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheTransactionManagerCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;

public class CacheXml40Test
extends CacheXml30Test {
    public CacheXml40Test(String name) {
        super(name);
    }

    @Override
    protected String getGemFireVersion() {
        return "4_0";
    }

    public void testServer() {
        CacheCreation cache = new CacheCreation();
        cache.setIsServer(true);
        CacheXml40Test.assertTrue((boolean)cache.isServer());
        this.testXml(cache);
    }

    public void testBridgeServers() {
        CacheCreation cache = new CacheCreation();
        BridgeServer bridge1 = cache.addBridgeServer();
        this.setBridgeAttributes(bridge1);
        BridgeServer bridge2 = cache.addBridgeServer();
        bridge2.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
        this.testXml(cache);
    }

    public void setBridgeAttributes(BridgeServer bridge1) {
        bridge1.setPort(AvailablePortHelper.getRandomAvailableTCPPort());
    }

    public void testIsLockGrantorAttribute() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setLockGrantor(true);
        attrs.setScope(Scope.GLOBAL);
        attrs.setMirrorType(MirrorType.KEYS_VALUES);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
        CacheXml40Test.assertEquals((boolean)true, (boolean)cache.getRegion("root").getAttributes().isLockGrantor());
    }

    public void testTransactionListener() {
        CacheCreation cache = new CacheCreation();
        CacheTransactionManagerCreation txMgrCreation = new CacheTransactionManagerCreation();
        txMgrCreation.setListener((TransactionListener)new CacheXml30Test.MyTestTransactionListener());
        cache.addCacheTransactionManagerCreation(txMgrCreation);
        this.testXml(cache);
    }

    public void testCacheTransactionManager() {
        CacheCreation cache = new CacheCreation();
        CacheTransactionManagerCreation txMgrCreation = new CacheTransactionManagerCreation();
        cache.addCacheTransactionManagerCreation(txMgrCreation);
        this.testXml(cache);
    }

    public void testConstrainedValues() throws CacheException {
        CacheCreation cache = new CacheCreation();
        RegionAttributesCreation attrs = new RegionAttributesCreation(cache);
        attrs.setValueConstraint(String.class);
        cache.createRegion("root", (RegionAttributes)attrs);
        this.testXml(cache);
    }
}

