/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheExistsException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.distributed.internal.HighPriorityAckedMessage;
import com.gemstone.gemfire.distributed.internal.SerialAckedMessage;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegionHelper;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import distcache.gemfire.GemFireCacheTestImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.DistributedSystemHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;

public abstract class CacheTestCase
extends DistributedTestCase {
    protected static Cache cache;

    public CacheTestCase(String name) {
        super(name);
    }

    private void createCache() {
        this.createCache(false);
    }

    private void createCache(boolean client) {
        this.createCache(client, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCache(boolean client, CacheFactory cf) {
        Class<CacheTestCase> clazz = CacheTestCase.class;
        synchronized (CacheTestCase.class) {
            try {
                Cache c;
                System.setProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE", "true");
                if (client) {
                    c = (Cache)new ClientCacheFactory(this.getSystem().getProperties()).create();
                } else if (cf == null) {
                    c = CacheFactory.create((DistributedSystem)this.getSystem());
                } else {
                    Properties props = this.getSystem().getProperties();
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        cf.set((String)entry.getKey(), (String)entry.getValue());
                    }
                    c = cf.create();
                }
                cache = c;
            }
            catch (CacheExistsException e) {
                CacheTestCase.fail("the cache already exists", e);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                CacheTestCase.fail("Checked exception while initializing cache??", ex);
            }
            finally {
                System.clearProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache createLonerCache() {
        Class<CacheTestCase> clazz = CacheTestCase.class;
        synchronized (CacheTestCase.class) {
            try {
                Cache c;
                System.setProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE", "true");
                cache = c = CacheFactory.create((DistributedSystem)this.getLonerSystem());
            }
            catch (CacheExistsException e) {
                CacheTestCase.fail("the cache already exists", e);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                CacheTestCase.fail("Checked exception while initializing cache??", ex);
            }
            finally {
                System.clearProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache createMcastCache() {
        Class<CacheTestCase> clazz = CacheTestCase.class;
        synchronized (CacheTestCase.class) {
            try {
                Cache c;
                System.setProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE", "true");
                cache = c = CacheFactory.create((DistributedSystem)this.getMcastSystem());
            }
            catch (CacheExistsException e) {
                CacheTestCase.fail("the cache already exists", e);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                CacheTestCase.fail("Checked exception while initializing cache??", ex);
            }
            finally {
                System.clearProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache createMcastCache(int jgroupsPort) {
        Class<CacheTestCase> clazz = CacheTestCase.class;
        synchronized (CacheTestCase.class) {
            try {
                Cache c;
                System.setProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE", "true");
                cache = c = CacheFactory.create((DistributedSystem)this.getMcastSystem(jgroupsPort));
            }
            catch (CacheExistsException e) {
                CacheTestCase.fail("the cache already exists", e);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                CacheTestCase.fail("Checked exception while initializing cache??", ex);
            }
            finally {
                System.clearProperty("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cache;
        }
    }

    public static synchronized void beginCacheXml() {
        CacheTestCase.closeCache();
        cache = new TestCacheCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishCacheXml(String name) {
        Class<CacheTestCase> clazz = CacheTestCase.class;
        synchronized (CacheTestCase.class) {
            File file = new File(name + "-cache.xml");
            try {
                PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
                CacheXmlGenerator.generate((Cache)cache, (PrintWriter)pw);
                pw.close();
            }
            catch (IOException ex) {
                CacheTestCase.fail("IOException during cache.xml generation to " + file, ex);
            }
            cache = null;
            GemFireCacheImpl.testCacheXml = file;
            try {
                this.createCache();
            }
            finally {
                GemFireCacheImpl.testCacheXml = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishCacheXml(String name, String xmlVersion) {
        Class<CacheTestCase> clazz = CacheTestCase.class;
        synchronized (CacheTestCase.class) {
            File dir = new File("XML_" + xmlVersion);
            dir.mkdirs();
            File file = new File(dir, name + ".xml");
            try {
                PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
                CacheXmlGenerator.generate((Cache)cache, (PrintWriter)pw, (boolean)false, (String)xmlVersion);
                pw.close();
            }
            catch (IOException ex) {
                CacheTestCase.fail("IOException during cache.xml generation to " + file, ex);
            }
            cache = null;
            GemFireCacheImpl.testCacheXml = file;
            try {
                this.createCache();
            }
            finally {
                GemFireCacheImpl.testCacheXml = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public final Cache getCache() {
        return this.getCache(false);
    }

    public final Cache getCache(CacheFactory cf) {
        return this.getCache(false, cf);
    }

    public final Cache getCache(boolean client) {
        return this.getCache(client, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Cache getCache(boolean client, CacheFactory cf) {
        Class<CacheTestCase> clazz = CacheTestCase.class;
        synchronized (CacheTestCase.class) {
            final GemFireCacheImpl gfCache = GemFireCacheImpl.getInstance();
            if (gfCache != null && !gfCache.isClosed() && gfCache.getCancelCriterion().cancelInProgress() != null) {
                CacheTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return gfCache.isClosed();
                    }

                    @Override
                    public String description() {
                        return "waiting for cache to close";
                    }
                }, 30000L, 300L, true);
            }
            if (cache == null || cache.isClosed()) {
                cache = null;
                this.createCache(client, cf);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ClientCache getClientCache(ClientCacheFactory factory) {
        Class<CacheTestCase> clazz = CacheTestCase.class;
        synchronized (CacheTestCase.class) {
            final GemFireCacheImpl gfCache = GemFireCacheImpl.getInstance();
            if (gfCache != null && !gfCache.isClosed() && gfCache.getCancelCriterion().cancelInProgress() != null) {
                CacheTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return gfCache.isClosed();
                    }

                    @Override
                    public String description() {
                        return "waiting for cache to close";
                    }
                }, 30000L, 300L, true);
            }
            if (cache == null || cache.isClosed()) {
                cache = null;
                CacheTestCase.disconnectFromDS();
                cache = (Cache)factory.create();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (ClientCache)cache;
        }
    }

    public final GemFireCacheImpl getGemfireCache() {
        return (GemFireCacheImpl)this.getCache();
    }

    public static final synchronized boolean hasCache() {
        return cache != null;
    }

    public static final synchronized Cache basicGetCache() {
        return cache;
    }

    public static synchronized void disconnectFromDS() {
        CacheTestCase.closeCache();
        DistributedTestCase.disconnectFromDS();
    }

    public static synchronized void closeCache() {
        block13: {
            if (cache == null) {
                cache = GemFireCacheImpl.getInstance();
            }
            if (cache != null) {
                try {
                    TXManagerImpl txMgr;
                    if (cache.isClosed()) break block13;
                    if (cache instanceof GemFireCacheImpl && (txMgr = ((GemFireCacheImpl)cache).getTxManager()) != null && txMgr.exists()) {
                        try {
                            txMgr.rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        cache.close();
                    }
                    catch (VirtualMachineError e) {
                        SystemFailure.initiateFailure((Error)e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                    }
                }
                finally {
                    cache = null;
                }
            }
        }
    }

    protected void closeAllCache() {
        CacheTestCase.closeCache();
        CacheTestCase.invokeInEveryVM(CacheTestCase.class, "closeCache");
    }

    @Override
    public void tearDown2() throws Exception {
        CacheTestCase.remoteTearDown();
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(CacheTestCase.class, "remoteTearDown");
            }
        }
        super.tearDown2();
    }

    protected static synchronized void remoteTearDown() {
        try {
            DistributionMessageObserver.setInstance(null);
            if (cache != null && !cache.isClosed()) {
                for (Region root : cache.rootRegions()) {
                    if (root.isDestroyed() || root instanceof HARegion || root instanceof PartitionedRegion) continue;
                    try {
                        root.localDestroyRegion((Object)"teardown");
                    }
                    catch (VirtualMachineError e) {
                        SystemFailure.initiateFailure((Error)e);
                        throw e;
                    }
                    catch (Throwable t) {
                        CacheTestCase.getLogWriter().error(t);
                    }
                }
            }
        }
        finally {
            try {
                CacheTestCase.closeCache();
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure((Error)e);
                throw e;
            }
            catch (Throwable t) {
                CacheTestCase.getLogWriter().error("Error in closing the cache ", t);
            }
        }
        try {
            CacheTestCase.cleanDiskDirs();
        }
        catch (IOException e) {
            CacheTestCase.getLogWriter().error("Error cleaning disk dirs", (Throwable)e);
        }
    }

    public final Region createRegion(String name, RegionAttributes attrs) throws CacheException {
        return this.createRegion(name, "root", attrs);
    }

    public InternalRegionArguments getInternalRegionArguments() {
        return null;
    }

    public final Region createRegion(String name, String rootName, RegionAttributes attrs) throws CacheException {
        Region root = this.getRootRegion(rootName);
        if (root == null) {
            RegionAttributes rootAttrs = attrs;
            AttributesFactory fac = new AttributesFactory(attrs);
            ExpirationAttributes expiration = ExpirationAttributes.DEFAULT;
            fac.setCacheLoader(null);
            fac.setCacheWriter(null);
            fac.setPoolName(null);
            fac.setPartitionAttributes(null);
            fac.setRegionTimeToLive(expiration);
            fac.setEntryTimeToLive(expiration);
            fac.setRegionIdleTimeout(expiration);
            fac.setEntryIdleTimeout(expiration);
            rootAttrs = fac.create();
            root = this.createRootRegion(rootName, rootAttrs);
        }
        return LocalRegionHelper.createSubregion(root, name, attrs, this.getInternalRegionArguments());
    }

    public final Region getRootRegion() {
        return this.getRootRegion("root");
    }

    public final Region getRootRegion(String rootName) {
        return this.getCache().getRegion(rootName);
    }

    protected final Region createRootRegion(RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        return this.createRootRegion("root", attrs);
    }

    public final Region createRootRegion(String rootName, RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        return this.getCache().createRegion(rootName, attrs);
    }

    public void sendUnorderedMessageToAll() {
        try {
            HighPriorityAckedMessage msg = new HighPriorityAckedMessage();
            msg.send(DistributedSystemHelper.getMembers(), false);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to send unordered message due to exception", e);
        }
    }

    public void sendSerialMessageToAll() {
        if (this.getCache() instanceof GemFireCacheTestImpl) {
            try {
                SerialAckedMessage msg = new SerialAckedMessage();
                msg.send(DistributedSystemHelper.getMembers(), false);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to send serial message due to exception", e);
            }
        }
    }

    protected CacheSerializableRunnable addExceptionTag1(final String expectedException) {
        CacheSerializableRunnable addExceptionTag = new CacheSerializableRunnable("addExceptionTag"){

            @Override
            public void run2() {
                CacheTestCase.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedException + "</ExpectedException>");
            }
        };
        return addExceptionTag;
    }

    protected CacheSerializableRunnable removeExceptionTag1(final String expectedException) {
        CacheSerializableRunnable removeExceptionTag = new CacheSerializableRunnable("removeExceptionTag"){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedException + "</ExpectedException>");
            }
        };
        return removeExceptionTag;
    }

    private static File getDiskDir() {
        int vmNum = VM.getCurrentVMNum();
        File dir = new File("diskDir", "disk" + String.valueOf(vmNum)).getAbsoluteFile();
        dir.mkdirs();
        return dir;
    }

    public static File[] getDiskDirs() {
        return new File[]{CacheTestCase.getDiskDir()};
    }

    public static void cleanDiskDirs() throws IOException {
        File[] defaultStoreFiles;
        FileUtil.delete((File)CacheTestCase.getDiskDir());
        for (File file : defaultStoreFiles = new File(".").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("BACKUPDiskStore-" + System.getProperty("vmid"));
            }
        })) {
            FileUtil.delete((File)file);
        }
    }

    static class TestCacheCreation
    extends CacheCreation {
        private boolean closed = false;

        TestCacheCreation() {
        }

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

