/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.snapshot;

import com.examples.snapshot.MyObject;
import com.examples.snapshot.MyPdxSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.snapshot.RegionGenerator;
import com.gemstone.gemfire.cache.snapshot.SnapshotDUnitTest;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.pdx.PdxSerializer;
import dunit.SerializableCallable;
import java.io.File;
import java.util.HashMap;

public class SnapshotPerformanceDUnitTest
extends CacheTestCase {
    public SnapshotPerformanceDUnitTest(String name) {
        super(name);
    }

    public void testPerformance() throws Exception {
        int iterations = 5;
        int dataCount = 10000;
        this.execute(iterations, dataCount);
    }

    private void execute(int iterations, int dataCount) throws Exception {
        RegionGenerator.RegionType[] rts = new RegionGenerator.RegionType[]{RegionGenerator.RegionType.REPLICATE, RegionGenerator.RegionType.PARTITION};
        RegionGenerator.SerializationType[] sts = new RegionGenerator.SerializationType[]{RegionGenerator.SerializationType.DATA_SERIALIZABLE, RegionGenerator.SerializationType.PDX};
        for (RegionGenerator.RegionType rt : rts) {
            for (RegionGenerator.SerializationType st : sts) {
                for (int i = 0; i < iterations; ++i) {
                    Region<Integer, MyObject> region = this.createRegion(rt, st);
                    SnapshotPerformanceDUnitTest.getLogWriter().info("SNP: Testing region " + region.getName() + ", iteration = " + i);
                    this.loadData(region, st, dataCount);
                    this.doExport(region);
                    region = this.createRegion(rt, st);
                    this.doImport(region);
                }
            }
        }
    }

    private void doExport(Region<Integer, MyObject> region) throws Exception {
        File f = new File(SnapshotPerformanceDUnitTest.getDiskDirs()[0], region.getName());
        long start = System.currentTimeMillis();
        region.getSnapshotService().save(f, SnapshotOptions.SnapshotFormat.GEMFIRE);
        long elapsed = System.currentTimeMillis() - start;
        int size = region.size();
        long bytes = f.length();
        double eps = 1000.0 * (double)size / (double)elapsed;
        double mbps = 1000.0 * (double)bytes / (double)elapsed / 1048576.0;
        SnapshotPerformanceDUnitTest.getLogWriter().info("SNP: Exported " + size + " entries (" + bytes + " bytes) in " + elapsed + " ms");
        SnapshotPerformanceDUnitTest.getLogWriter().info("SNP: Export entry rate: " + eps + " entries / sec");
        SnapshotPerformanceDUnitTest.getLogWriter().info("SNP: Export data rate: " + mbps + " MB / sec");
    }

    private void doImport(Region<Integer, MyObject> region) throws Exception {
        File f = new File(SnapshotPerformanceDUnitTest.getDiskDirs()[0], region.getName());
        long start = System.currentTimeMillis();
        region.getSnapshotService().load(f, SnapshotOptions.SnapshotFormat.GEMFIRE);
        long elapsed = System.currentTimeMillis() - start;
        int size = region.size();
        long bytes = f.length();
        double eps = 1000.0 * (double)size / (double)elapsed;
        double mbps = 1000.0 * (double)bytes / (double)elapsed / 1048576.0;
        SnapshotPerformanceDUnitTest.getLogWriter().info("SNP: Imported " + size + " entries (" + bytes + " bytes) in " + elapsed + " ms");
        SnapshotPerformanceDUnitTest.getLogWriter().info("SNP: Import entry rate: " + eps + " entries / sec");
        SnapshotPerformanceDUnitTest.getLogWriter().info("SNP: Import data rate: " + mbps + " MB / sec");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createCache();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    private void createCache() throws Exception {
        SerializableCallable setup = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory().setPdxSerializer((PdxSerializer)new MyPdxSerializer());
                SnapshotPerformanceDUnitTest.this.getCache(cf);
                return null;
            }
        };
        SnapshotDUnitTest.forEachVm(setup, true);
    }

    private Region<Integer, MyObject> createRegion(final RegionGenerator.RegionType rt, RegionGenerator.SerializationType st) throws Exception {
        final String name = "snapshot-" + rt.name() + "-" + st.name();
        Region region = this.getCache().getRegion(name);
        if (region != null) {
            region.destroyRegion();
        }
        SerializableCallable setup = new SerializableCallable(){

            public Object call() throws Exception {
                Cache cache = SnapshotPerformanceDUnitTest.this.getCache();
                new RegionGenerator().createRegion(cache, null, rt, name);
                return null;
            }
        };
        SnapshotDUnitTest.forEachVm(setup, true);
        return this.getCache().getRegion(name);
    }

    private void loadData(Region<Integer, MyObject> region, RegionGenerator.SerializationType st, int count) {
        RegionGenerator rgen = new RegionGenerator();
        int bufferSize = 1000;
        HashMap<Integer, MyObject> buffer = new HashMap<Integer, MyObject>(bufferSize);
        long start = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            buffer.put(i, rgen.createData(st, i, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris at sapien lectus. Nam ullamcorper blandit tempus. Morbi accumsan ornare erat eget lobortis. Mauris laoreet auctor purus et vehicula. Cras hendrerit consectetur odio, in placerat orci vehicula a. Ut laoreet consectetur quam, at pellentesque felis sollicitudin sed. Aliquam imperdiet, augue at vehicula placerat, quam mi feugiat mi, non semper elit diam vitae lectus. Fusce vestibulum erat vitae dui scelerisque aliquet. Nam magna sapien, scelerisque id tincidunt non, dapibus quis ipsum."));
            if (buffer.size() != bufferSize) continue;
            region.putAll(buffer);
            buffer.clear();
        }
        if (!buffer.isEmpty()) {
            region.putAll(buffer);
        }
        long elapsed = System.currentTimeMillis() - start;
        SnapshotPerformanceDUnitTest.getLogWriter().info("SNP: loaded " + count + " entries in " + elapsed + " ms");
        SnapshotPerformanceDUnitTest.assertEquals((int)count, (int)region.size());
    }
}

