/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.snapshot;

import com.examples.snapshot.MyPdxSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.snapshot.RegionGenerator;
import com.gemstone.gemfire.cache.snapshot.SnapshotDUnitTest;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.pdx.PdxSerializer;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import java.io.File;

public class SnapshotByteArrayDUnitTest
extends CacheTestCase {
    private final File snap = new File("snapshot-ops");

    public SnapshotByteArrayDUnitTest(String name) {
        super(name);
    }

    public void testImportByteArray() throws Exception {
        SerializableCallable load = new SerializableCallable(){

            public Object call() throws Exception {
                Region region = SnapshotByteArrayDUnitTest.this.getCache().getRegion("snapshot-ops");
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)i, (Object)new byte[]{15});
                }
                region.getSnapshotService().save(SnapshotByteArrayDUnitTest.this.snap, SnapshotOptions.SnapshotFormat.GEMFIRE);
                region.getSnapshotService().load(SnapshotByteArrayDUnitTest.this.snap, SnapshotOptions.SnapshotFormat.GEMFIRE);
                return null;
            }
        };
        Host.getHost(0).getVM(1).invoke(load);
        SerializableCallable callback = new SerializableCallable(){

            public Object call() throws Exception {
                Region region = SnapshotByteArrayDUnitTest.this.getCache().getRegion("snapshot-ops");
                region.getAttributesMutator().addCacheListener((CacheListener)new CacheListenerAdapter<Integer, Object>(){

                    public void afterUpdate(EntryEvent<Integer, Object> event) {
                        this.dump(event);
                    }

                    public void afterInvalidate(EntryEvent<Integer, Object> event) {
                        this.dump(event);
                    }

                    public void afterDestroy(EntryEvent<Integer, Object> event) {
                        this.dump(event);
                    }

                    public void afterCreate(EntryEvent<Integer, Object> event) {
                    }

                    private void dump(EntryEvent<Integer, Object> event) {
                        if (DistributedTestCase.getLogWriter().fineEnabled()) {
                            DistributedTestCase.getLogWriter().fine("op = " + event.getOperation());
                            Object obj1 = event.getNewValue();
                            DistributedTestCase.getLogWriter().fine("new = " + obj1);
                            Object obj2 = event.getOldValue();
                            DistributedTestCase.getLogWriter().fine("old = " + obj2);
                        }
                    }
                });
                return null;
            }
        };
        SnapshotDUnitTest.forEachVm(callback, true);
        Region region = this.getCache().getRegion("snapshot-ops");
        for (int i = 0; i < 1000; ++i) {
            region.put((Object)i, (Object)new byte[]{0, 1, 3});
            region.invalidate((Object)i);
            region.destroy((Object)i);
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.loadCache();
    }

    @Override
    public void tearDown2() throws Exception {
        if (this.snap.exists()) {
            this.snap.delete();
        }
        super.tearDown2();
    }

    public void loadCache() throws Exception {
        SerializableCallable setup = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory().setPdxSerializer((PdxSerializer)new MyPdxSerializer()).setPdxPersistent(true);
                Cache cache = SnapshotByteArrayDUnitTest.this.getCache(cf);
                RegionGenerator rgen = new RegionGenerator();
                rgen.createRegion(cache, null, RegionGenerator.RegionType.REPLICATE, "snapshot-ops");
                return null;
            }
        };
        SnapshotDUnitTest.forEachVm(setup, true);
    }
}

