/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.partitioned;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionQueryEvaluator;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class PRQueryDUnitTest
extends PartitionedRegionDUnitTestCase {
    static Properties props = new Properties();
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    int totalNumBuckets = 100;
    int totalDataSize = 90;
    int cnt = 0;
    int stepSize = 20;
    final String name = "Portfolios";
    final String localName = "LocalPortfolios";
    final int i = 0;
    final int redundancy = 0;

    public PRQueryDUnitTest(String name) {
        super(name);
    }

    public void testPRDAckCreationAndQuerying() throws Exception {
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Querying PR Test with DACK Started*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating PR's on VM0, VM1 , VM2 , VM3");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created PR's on VM0, VM1 , VM2 , VM3");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating Local region on VM0 to compare result Sets");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfolioData(this.cnt, this.totalDataSize);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, this.stepSize));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, this.stepSize, 2 * this.stepSize));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 2 * this.stepSize, 3 * this.stepSize));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 3 * this.stepSize, this.totalDataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, this.totalDataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data over Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("Portfolios", "LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : *Querying PR's with DACK Test ENDED*****");
    }

    public void testPRDAckCreationAndQueryingFull() throws Exception {
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Querying PR Test with DACK Started*****");
        Class<Portfolio> valueConstraint = Portfolio.class;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating PR's on VM0, VM1 , VM2 , VM3");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created PR's on VM0, VM1 , VM2 , VM3");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating Local region on VM0 to compare result Sets");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios", valueConstraint));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created Local Region on VM0");
        Object[] portfoliosAndPositions = this.PRQHelp.createPortfoliosAndPositions(this.totalDataSize);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfoliosAndPositions, 0, this.stepSize));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfoliosAndPositions, this.stepSize, 2 * this.stepSize));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfoliosAndPositions, 2 * this.stepSize, 3 * this.stepSize));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfoliosAndPositions, 3 * this.stepSize, this.totalDataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfoliosAndPositions, 0, this.totalDataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data over Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("Portfolios", "LocalPortfolios", true));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : *Querying PR's with DACK Test ENDED*****");
    }

    public void testPRDAckCreationAndQueryingWithConstants() throws Exception {
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQueryingWithConstants : Querying PR Test with DACK Started*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQueryingWithConstants : Creating PR's on VM0, VM1 , VM2 , VM3");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQueryingWithConstants : Successfully Created PR's on VM0, VM1 , VM2 , VM3");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQueryingWithConstants : Creating Local region on VM0 to compare result Sets");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQueryingWithConstants : Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfolioData(this.cnt, this.totalDataSize);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, this.stepSize));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, this.stepSize, 2 * this.stepSize));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 2 * this.stepSize, 3 * this.stepSize));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 3 * this.stepSize, this.totalDataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQueryingWithConstants : Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, this.totalDataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQueryingWithConstants : Inserted Portfolio data over Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRQueryWithConstantsAndComparingResults("Portfolios", "LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQueryingWithConstants : *Querying PR's with DACK Test ENDED*****");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataLossDuringQueryProcessor() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        final VM datastore1 = host.getVM(2);
        final VM datastore2 = host.getVM(3);
        int totalBuckets = 11;
        boolean redCop = false;
        CacheSerializableRunnable createPR = new CacheSerializableRunnable("Create PR"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory attr = new AttributesFactory();
                attr.setValueConstraint(String.class);
                PartitionAttributes prAttr = new PartitionAttributesFactory().setRedundantCopies(0).setTotalNumBuckets(11).create();
                attr.setPartitionAttributes(prAttr);
                PRQueryDUnitTest.this.getCache().createRegion(rName, attr.create());
            }
        };
        datastore1.invoke(createPR);
        datastore2.invoke(createPR);
        AttributesFactory attr = new AttributesFactory();
        attr.setValueConstraint(String.class);
        PartitionAttributes prAttr = new PartitionAttributesFactory().setRedundantCopies(0).setTotalNumBuckets(11).setLocalMaxMemory(0).create();
        attr.setPartitionAttributes(prAttr);
        PartitionedRegion pr = (PartitionedRegion)this.getCache().createRegion(rName, attr.create());
        pr.put((Object)new Integer(0), (Object)"zero");
        pr.put((Object)new Integer(1), (Object)"one");
        pr.put((Object)new Integer(2), (Object)"two");
        class MyTestHook
        implements PartitionedRegionQueryEvaluator.TestHook {
            public boolean done = false;

            MyTestHook() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void hook(int spot) throws RuntimeException {
                if (spot == 4) {
                    MyTestHook myTestHook = this;
                    synchronized (myTestHook) {
                        if (this.done) {
                            return;
                        }
                        this.done = true;
                    }
                    datastore1.invoke(PRQueryDUnitTest.this.disconnectVM());
                    datastore2.invoke(PRQueryDUnitTest.this.disconnectVM());
                }
            }
        }
        MyTestHook th = new MyTestHook();
        DistributedTestCase.ExpectedException ex = PRQueryDUnitTest.addExpectedException("Data loss detected");
        try {
            Object[] params = new Object[]{};
            DefaultQuery query = (DefaultQuery)this.getCache().getQueryService().newQuery("select distinct * from " + pr.getFullPath());
            SelectResults results = query.getSimpleSelect().getEmptyResultSet(params, this.getCache());
            HashSet<Integer> buckets = new HashSet<Integer>();
            for (int i = 0; i < 3; ++i) {
                buckets.add(new Integer(i));
            }
            PartitionedRegionQueryEvaluator qe = new PartitionedRegionQueryEvaluator(pr.getSystem(), pr, query, params, results, buckets);
            qe.queryBuckets((PartitionedRegionQueryEvaluator.TestHook)th);
            PRQueryDUnitTest.assertTrue((boolean)th.done);
            PRQueryDUnitTest.assertTrue((boolean)false);
        }
        catch (QueryException expected) {
            PRQueryDUnitTest.assertTrue((boolean)th.done);
        }
        finally {
            ex.remove();
            this.getCache().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryResultsFromMembers() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore1 = host.getVM(2);
        VM datastore2 = host.getVM(3);
        int totalBuckets = 10;
        boolean redCop = false;
        CacheSerializableRunnable createPR = new CacheSerializableRunnable("Create PR"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributes prAttr = new PartitionAttributesFactory().setRedundantCopies(0).setTotalNumBuckets(10).create();
                attr.setPartitionAttributes(prAttr);
                PRQueryDUnitTest.this.getCache().createRegion(rName, attr.create());
            }
        };
        datastore1.invoke(createPR);
        datastore2.invoke(createPR);
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributes prAttr = new PartitionAttributesFactory().setRedundantCopies(0).setTotalNumBuckets(10).create();
        attr.setPartitionAttributes(prAttr);
        PartitionedRegion pr = (PartitionedRegion)this.getCache().createRegion(rName, attr.create());
        int numEntries = 100;
        for (int i = 1; i <= numEntries; ++i) {
            pr.put((Object)new Integer(i), (Object)new Portfolio(i));
        }
        int[] limit = new int[]{10, 15, 30, 0, 1, 9};
        String[] queries = new String[]{"select * from " + pr.getFullPath() + " LIMIT " + limit[0], "select * from " + pr.getFullPath() + " LIMIT " + limit[1], "select * from " + pr.getFullPath() + " LIMIT " + limit[2], "select * from " + pr.getFullPath() + " LIMIT " + limit[3], "select * from " + pr.getFullPath() + " LIMIT " + limit[4], "select * from " + pr.getFullPath() + " where ID > 10 LIMIT " + limit[5]};
        try {
            for (int q = 0; q < queries.length; ++q) {
                Object[] params = new Object[]{};
                DefaultQuery query = (DefaultQuery)this.getCache().getQueryService().newQuery(queries[q]);
                SelectResults results = query.getSimpleSelect().getEmptyResultSet(params, this.getCache());
                HashSet<Integer> buckets = new HashSet<Integer>();
                for (int i = 0; i < 10; ++i) {
                    buckets.add(new Integer(i));
                }
                final PartitionedRegionQueryEvaluator qe = new PartitionedRegionQueryEvaluator(pr.getSystem(), pr, query, params, results, buckets);
                class MyTestHook
                implements PartitionedRegionQueryEvaluator.TestHook {
                    public HashMap resultsPerMember = new HashMap();

                    MyTestHook() {
                    }

                    public void hook(int spot) throws RuntimeException {
                        boolean size = false;
                        if (spot == 3) {
                            Iterator iterator = qe.getResultsPerMember().entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry mr;
                                Map.Entry e = mr = iterator.next();
                                Collection results = (Collection)e.getValue();
                                for (Collection r : results) {
                                    if (this.resultsPerMember.containsKey(e.getKey())) {
                                        this.resultsPerMember.put(e.getKey(), new Integer(r.size() + (Integer)this.resultsPerMember.get(e.getKey())));
                                        continue;
                                    }
                                    this.resultsPerMember.put(e.getKey(), new Integer(r.size()));
                                }
                            }
                        }
                    }
                }
                MyTestHook th = new MyTestHook();
                qe.queryBuckets((PartitionedRegionQueryEvaluator.TestHook)th);
                Iterator iterator = th.resultsPerMember.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry r;
                    Map.Entry e = r = iterator.next();
                    Integer res = (Integer)e.getValue();
                    PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testQueryResultsFromMembers : \nQuery [" + queries[q] + "] Member : " + e.getKey() + " results size :" + res);
                    PRQueryDUnitTest.assertEquals((String)("Query [" + queries[q] + "]: The results returned by the member does not match the query limit size : Member : " + e.getKey()), (int)limit[q], (int)res);
                }
            }
        }
        finally {
            this.getCache().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryResultsFromMembersWithAccessor() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore1 = host.getVM(2);
        VM datastore2 = host.getVM(3);
        int totalBuckets = 20;
        boolean redCop = false;
        CacheSerializableRunnable createPR = new CacheSerializableRunnable("Create PR"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributes prAttr = new PartitionAttributesFactory().setRedundantCopies(0).setTotalNumBuckets(20).create();
                attr.setPartitionAttributes(prAttr);
                PRQueryDUnitTest.this.getCache().createRegion(rName, attr.create());
            }
        };
        datastore1.invoke(createPR);
        datastore2.invoke(createPR);
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributes prAttr = new PartitionAttributesFactory().setRedundantCopies(0).setTotalNumBuckets(20).setLocalMaxMemory(0).create();
        attr.setPartitionAttributes(prAttr);
        PartitionedRegion pr = (PartitionedRegion)this.getCache().createRegion(rName, attr.create());
        int numEntries = 100;
        for (int i = 1; i <= numEntries; ++i) {
            pr.put((Object)new Integer(i), (Object)new Portfolio(i));
        }
        int[] limit = new int[]{10, 15, 30, 0, 1, 9};
        String[] queries = new String[]{"select * from " + pr.getFullPath() + " LIMIT " + limit[0], "select * from " + pr.getFullPath() + " LIMIT " + limit[1], "select * from " + pr.getFullPath() + " LIMIT " + limit[2], "select * from " + pr.getFullPath() + " LIMIT " + limit[3], "select * from " + pr.getFullPath() + " LIMIT " + limit[4], "select * from " + pr.getFullPath() + " where ID > 10 LIMIT " + limit[5]};
        try {
            for (int q = 0; q < queries.length; ++q) {
                Object[] params = new Object[]{};
                DefaultQuery query = (DefaultQuery)this.getCache().getQueryService().newQuery(queries[q]);
                SelectResults results = query.getSimpleSelect().getEmptyResultSet(params, this.getCache());
                HashSet<Integer> buckets = new HashSet<Integer>();
                for (int b = 0; b < 20; ++b) {
                    buckets.add(b);
                }
                final PartitionedRegionQueryEvaluator qe = new PartitionedRegionQueryEvaluator(pr.getSystem(), pr, query, params, results, buckets);
                class MyTestHook
                implements PartitionedRegionQueryEvaluator.TestHook {
                    public HashMap resultsPerMember = new HashMap();

                    MyTestHook() {
                    }

                    public void hook(int spot) throws RuntimeException {
                        if (spot == 3) {
                            Iterator iterator = qe.getResultsPerMember().entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry mr;
                                Map.Entry e = mr = iterator.next();
                                Collection results = (Collection)e.getValue();
                                for (Collection r : results) {
                                    if (this.resultsPerMember.containsKey(e.getKey())) {
                                        this.resultsPerMember.put(e.getKey(), new Integer(r.size() + (Integer)this.resultsPerMember.get(e.getKey())));
                                        continue;
                                    }
                                    this.resultsPerMember.put(e.getKey(), new Integer(r.size()));
                                }
                            }
                        }
                    }
                }
                MyTestHook th = new MyTestHook();
                qe.queryBuckets((PartitionedRegionQueryEvaluator.TestHook)th);
                Iterator iterator = th.resultsPerMember.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry r;
                    Map.Entry e = r = iterator.next();
                    Integer res = (Integer)e.getValue();
                    PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testQueryResultsFromMembers : \nQuery [" + queries[q] + "] Member : " + e.getKey() + " results size :" + res);
                    if (res == 0 && res == limit[q]) continue;
                    PRQueryDUnitTest.assertEquals((String)("Query [" + queries[q] + "]: The results returned by the member does not match the query limit size : Member : " + e.getKey()), (int)limit[q], (int)res);
                }
            }
        }
        finally {
            this.getCache().close();
        }
    }

    public void testSimulatedDataLossBeforeQueryProcessor() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(1);
        VM datastore1 = host.getVM(2);
        VM datastore2 = host.getVM(3);
        int totalBuckets = 11;
        CacheSerializableRunnable createPR = new CacheSerializableRunnable("Create PR"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory attr = new AttributesFactory();
                attr.setValueConstraint(String.class);
                PartitionAttributes prAttr = new PartitionAttributesFactory().setRedundantCopies(1).setTotalNumBuckets(11).create();
                attr.setPartitionAttributes(prAttr);
                PRQueryDUnitTest.this.getCache().createRegion(rName, attr.create());
            }
        };
        datastore1.invoke(createPR);
        datastore2.invoke(createPR);
        accessor.invoke(new CacheSerializableRunnable("Create accessor PR"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory attr = new AttributesFactory();
                attr.setValueConstraint(String.class);
                PartitionAttributes prAttr = new PartitionAttributesFactory().setRedundantCopies(1).setTotalNumBuckets(11).setLocalMaxMemory(0).create();
                attr.setPartitionAttributes(prAttr);
                PRQueryDUnitTest.this.getCache().createRegion(rName, attr.create());
            }
        });
        DistributedTestCase.ExpectedException ex = PRQueryDUnitTest.addExpectedException("Data loss detected", accessor);
        accessor.invoke(new SerializableCallable("Create bucket and test dataloss query"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)PRQueryDUnitTest.this.getCache().getRegion(rName);
                pr.put((Object)new Integer(1), (Object)"one");
                Object[] params = new Object[]{};
                DefaultQuery query = (DefaultQuery)PRQueryDUnitTest.this.getCache().getQueryService().newQuery("select distinct * from " + pr.getFullPath());
                SelectResults results = query.getSimpleSelect().getEmptyResultSet(params, PRQueryDUnitTest.this.getCache());
                HashSet<Integer> buckets = new HashSet<Integer>();
                for (int i = 0; i < 3; ++i) {
                    buckets.add(new Integer(i));
                }
                try {
                    PartitionedRegionQueryEvaluator qe = new PartitionedRegionQueryEvaluator(pr.getSystem(), pr, query, params, results, buckets);
                    qe.queryBuckets(null);
                    TestCase.assertTrue((boolean)false);
                }
                catch (QueryException queryException) {
                    // empty catch block
                }
                return Boolean.TRUE;
            }
        });
        ex.remove();
    }

    public void testPRAccessorCreationAndQuerying() throws Exception {
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Querying PR Test with DACK Started*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Creating the Accessor node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", 0));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Successfully created the Accessor node in the PR");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Creating the Datastore node in the PR");
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Successfully Created the Datastore node in the PR");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfolioData(this.cnt, this.totalDataSize);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, this.stepSize));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, this.stepSize, 2 * this.stepSize));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 2 * this.stepSize, 3 * this.stepSize));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 3 * this.stepSize, this.totalDataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, this.totalDataSize));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("Portfolios", "LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Querying PR's Test ENDED*****");
    }

    public void testPRDAckCreationAndQueryingWithOrderBy() throws Exception {
        int dataSize = 10;
        int step = 2;
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Querying PR Test with DACK Started*****");
        Class<Portfolio> valueConstraint = Portfolio.class;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating PR's on VM0, VM1 , VM2 , VM3");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created PR's on VM0, VM1 , VM2 , VM3");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating Local region on VM0 to compare result Sets");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios", valueConstraint));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created Local Region on VM0");
        Object[] portfoliosAndPositions = this.PRQHelp.createPortfoliosAndPositions(this.totalDataSize);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, 0, step));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, step, 2 * step));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, 2 * step, 3 * step));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, 3 * step, dataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("LocalPortfolios", portfoliosAndPositions, 0, dataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data over Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPROrderByQueryAndCompareResults("Portfolios", "LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : *Querying PR's with DACK Test ENDED*****");
    }

    public void testPRDAckCreationAndQueryingWithOrderByVerifyOrder() throws Exception {
        int dataSize = 10;
        int step = 2;
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Querying PR Test with DACK Started*****");
        Class<Portfolio> valueConstraint = Portfolio.class;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating PR's on VM0, VM1 , VM2 , VM3");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created PR's on VM0, VM1 , VM2 , VM3");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating Local region on VM0 to compare result Sets");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios", valueConstraint));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created Local Region on VM0");
        Object[] portfoliosAndPositions = this.PRQHelp.createPortfoliosAndPositions(this.totalDataSize);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, 0, step));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, step, 2 * step));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, 2 * step, 3 * step));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, 3 * step, dataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("LocalPortfolios", portfoliosAndPositions, 0, dataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data over Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPROrderByQueryAndVerifyOrder("Portfolios", "LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : *Querying PR's with DACK Test ENDED*****");
    }

    public void testPRAccessorCreationAndQueryWithOrderBy() throws Exception {
        int dataSize = 10;
        int step = 2;
        Class<Portfolio> valueConstraint = Portfolio.class;
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Querying PR Test with DACK Started*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Creating the Accessor node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", 0, valueConstraint));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Successfully created the Accessor node in the PR");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Creating the Datastore node in the PR");
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Successfully Created the Datastore node in the PR");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios", valueConstraint));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Successfully Created Local Region on VM0");
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(this.totalDataSize);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfolio, 0, step));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfolio, step, 2 * step));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfolio, 2 * step, 3 * step));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfolio, 3 * step, dataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("LocalPortfolios", portfolio, 0, dataSize));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPROrderByQueryAndCompareResults("Portfolios", "LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQuerying : Querying PR's Test ENDED*****");
    }

    public void testPRDAckCreationAndQueryingWithOrderByLimit() throws Exception {
        int dataSize = 10;
        int step = 2;
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Querying PR Test with DACK Started*****");
        Class<Portfolio> valueConstraint = Portfolio.class;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating PR's on VM0, VM1 , VM2 , VM3");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, valueConstraint));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created PR's on VM0, VM1 , VM2 , VM3");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Creating Local region on VM0 to compare result Sets");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios", valueConstraint));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Successfully Created Local Region on VM0");
        Object[] portfoliosAndPositions = this.PRQHelp.createPortfoliosAndPositions(this.totalDataSize);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, 0, step));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, step, 2 * step));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, 2 * step, 3 * step));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("Portfolios", portfoliosAndPositions, 3 * step, dataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("LocalPortfolios", portfoliosAndPositions, 0, dataSize));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : Inserted Portfolio data over Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPROrderByQueryWithLimit("Portfolios", "LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRDAckCreationAndQuerying : *Querying PR's with DACK Test ENDED*****");
    }

    public void testPRAccessorCreationAndQueryingWithNoData() throws Exception {
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQueryingWithNoData : Querying PR Test with No Data  Started*****");
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQueryingWithNoData : Creating the Accessor node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", 0));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQueryingWithNoData : Successfully created the Accessor node in the PR");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQueryingWithNoData : Creating the Datastore node in the PR");
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        vm3.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQueryingWithNoData : Successfully Created the Datastore node in the PR");
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQueryingWithNoData : Successfully Created PR's across all VM's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQueryingWithNoData : Successfully Created Local Region on VM0");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("Portfolios", "LocalPortfolios"));
        PRQueryDUnitTest.getLogWriter().info("PRQueryDUnitTest#testPRAccessorCreationAndQueryingWithNoData : Querying PR's Test No Data ENDED*****");
    }
}

