/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.data.PortfolioData;
import com.gemstone.gemfire.cache.query.data.Position;
import com.gemstone.gemfire.cache.query.functional.QueryREUpdateInProgressJUnitTest;
import com.gemstone.gemfire.cache.query.functional.StructSetOrResultsSet;
import com.gemstone.gemfire.cache.query.internal.index.PartitionedIndex;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryPerfDUnitTest;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import parReg.query.NewPortfolio;
import util.TestException;

public class PRQueryDUnitHelper
extends PartitionedRegionDUnitTestCase {
    final Class valueConstraint = PortfolioData.class;

    public PRQueryDUnitHelper(String name) {
        super(name);
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForLocalRegionCreation(String regionName) {
        return this.getCacheSerializableRunnableForLocalRegionCreation(regionName, this.valueConstraint);
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForLocalRegionCreation(final String regionName, final Class constraint) {
        CacheSerializableRunnable createPrRegion = new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region localRegion = null;
                try {
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(constraint);
                    attr.setScope(Scope.LOCAL);
                    localRegion = cache.createRegion(regionName, attr.create());
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Partitioned Region " + regionName + " not in cache"), (Object)cache.getRegion(regionName));
                TestCase.assertNotNull((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Partitioned Region ref null", (Object)localRegion);
                TestCase.assertTrue((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Partitioned Region ref claims to be destroyed", (!localRegion.isDestroyed() ? 1 : 0) != 0);
            }
        };
        return createPrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForLocalRegionWithAsyncIndexCreation(final String regionName, final Class constraint) {
        CacheSerializableRunnable createPrRegion = new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region localRegion = null;
                try {
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(constraint);
                    attr.setScope(Scope.LOCAL);
                    attr.setIndexMaintenanceSynchronous(false);
                    localRegion = cache.createRegion(regionName, attr.create());
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Partitioned Region " + regionName + " not in cache"), (Object)cache.getRegion(regionName));
                TestCase.assertNotNull((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Partitioned Region ref null", (Object)localRegion);
                TestCase.assertTrue((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Partitioned Region ref claims to be destroyed", (!localRegion.isDestroyed() ? 1 : 0) != 0);
            }
        };
        return createPrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForReplicatedRegionCreation(String regionName) {
        return this.getCacheSerializableRunnableForLocalRegionCreation(regionName, this.valueConstraint);
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForReplicatedRegionCreation(final String regionName, Class constraint) {
        CacheSerializableRunnable createPrRegion = new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region localRegion = null;
                try {
                    localRegion = cache.createRegionFactory(RegionShortcut.REPLICATE).create(regionName);
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Partitioned Region " + regionName + " not in cache"), (Object)cache.getRegion(regionName));
                TestCase.assertNotNull((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Partitioned Region ref null", (Object)localRegion);
                TestCase.assertTrue((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreate: Partitioned Region ref claims to be destroyed", (!localRegion.isDestroyed() ? 1 : 0) != 0);
            }
        };
        return createPrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRCreate(String regionName, int redundancy) {
        return this.getCacheSerializableRunnableForPRCreate(regionName, redundancy, this.valueConstraint);
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRCreate(final String regionName, final int redundancy, final Class constraint) {
        CacheSerializableRunnable createPrRegion = new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.disconnectFromDS();
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region partitionedregion = null;
                try {
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(constraint);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).create();
                    attr.setPartitionAttributes(prAttr);
                    partitionedregion = cache.createRegion(regionName, attr.create());
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region " + regionName + " not in cache"), (Object)cache.getRegion(regionName));
                TestCase.assertNotNull((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region ref null", partitionedregion);
                TestCase.assertTrue((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
            }
        };
        return createPrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRCreateLimitedBuckets(final String regionName, final int redundancy, final int buckets) {
        CacheSerializableRunnable createPrRegion = new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.disconnectFromDS();
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region partitionedregion = null;
                try {
                    AttributesFactory attr = new AttributesFactory();
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).setTotalNumBuckets(buckets).create();
                    attr.setPartitionAttributes(prAttr);
                    partitionedregion = cache.createRegion(regionName, attr.create());
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region " + regionName + " not in cache"), (Object)cache.getRegion(regionName));
                TestCase.assertNotNull((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region ref null", partitionedregion);
                TestCase.assertTrue((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
            }
        };
        return createPrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPersistentPRCreate(final String regionName, final int redundancy, final Class constraint) {
        CacheSerializableRunnable createPrRegion = new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.disconnectFromDS();
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region partitionedregion = null;
                try {
                    cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("diskstore");
                    AttributesFactory attr = new AttributesFactory();
                    attr.setValueConstraint(constraint);
                    attr.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    attr.setDiskStoreName("diskstore");
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).create();
                    attr.setPartitionAttributes(prAttr);
                    partitionedregion = cache.createRegion(regionName, attr.create());
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region " + regionName + " not in cache"), (Object)cache.getRegion(regionName));
                TestCase.assertNotNull((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region ref null", partitionedregion);
                TestCase.assertTrue((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
            }
        };
        return createPrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRColocatedCreate(final String regionName, final int redundancy, final String coloRegionName) {
        CacheSerializableRunnable createPrRegion = new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region partitionedregion = null;
                try {
                    Region colocatedRegion = cache.getRegion(coloRegionName);
                    TestCase.assertNotNull((Object)colocatedRegion);
                    AttributesFactory attr = new AttributesFactory();
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).setColocatedWith(colocatedRegion.getFullPath()).create();
                    attr.setPartitionAttributes(prAttr);
                    partitionedregion = cache.createRegion(regionName, attr.create());
                }
                catch (IllegalStateException ex) {
                    DistributedTestCase.getLogWriter().warning("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Creation caught IllegalStateException", (Throwable)ex);
                }
                TestCase.assertNotNull((String)("PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region " + regionName + " not in cache"), (Object)cache.getRegion(regionName));
                TestCase.assertNotNull((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region ref null", partitionedregion);
                TestCase.assertTrue((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRCreateWithRedundancy: Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
            }
        };
        return createPrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRPuts(final String regionName, final Object[] portfolio, final int from, final int to) {
        CacheSerializableRunnable prPuts = new CacheSerializableRunnable("PRPuts"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region region = cache.getRegion(regionName);
                for (int j = from; j < to; ++j) {
                    region.put((Object)new Integer(j), portfolio[j]);
                }
            }
        };
        return prPuts;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRRandomOps(final String regionName, final int from, final int to) {
        CacheSerializableRunnable prPuts = new CacheSerializableRunnable("PRPuts"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region region = cache.getRegion(regionName);
                for (int i = 0; i < 3; ++i) {
                    for (int j = from; j < to; ++j) {
                        int op = new Random().nextInt(4);
                        try {
                            switch (op) {
                                case 0: {
                                    region.put((Object)new Integer(j), (Object)new Portfolio(j));
                                    break;
                                }
                                case 1: {
                                    if (!region.containsKey((Object)new Integer(j))) break;
                                    region.invalidate((Object)new Integer(j));
                                    break;
                                }
                                case 2: {
                                    if (!region.containsKey((Object)new Integer(j))) break;
                                    region.destroy((Object)new Integer(j));
                                    break;
                                }
                                case 3: {
                                    if (region.containsKey((Object)new Integer(j))) break;
                                    region.create((Object)new Integer(j), null);
                                    break;
                                }
                            }
                            continue;
                        }
                        catch (EntryExistsException e) {
                            DistributedTestCase.getLogWriter().info("EntryExistsException was thrown for key " + j);
                            continue;
                        }
                        catch (EntryNotFoundException e) {
                            DistributedTestCase.getLogWriter().info("EntryNotFoundException was thrown for key " + j);
                        }
                    }
                }
            }
        };
        return prPuts;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRPutsAndDestroy(final String regionName, final int from, final int to) {
        CacheSerializableRunnable prPuts = new CacheSerializableRunnable("PRPuts"){

            @Override
            public void run2() throws CacheException {
                int j;
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region region = cache.getRegion(regionName);
                for (j = from; j < to; ++j) {
                    region.put((Object)new Integer(j), (Object)new Portfolio(j));
                }
                for (j = from; j < to; ++j) {
                    region.destroy((Object)new Integer(j));
                }
            }
        };
        return prPuts;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRDuplicatePuts(final String regionName, final Object[] portfolio, final int from, final int to) {
        CacheSerializableRunnable prPuts = new CacheSerializableRunnable("PRPuts"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region region = cache.getRegion(regionName);
                int j = from;
                int i = to;
                while (j < to) {
                    region.put((Object)new Integer(i), portfolio[j]);
                    ++j;
                    ++i;
                }
            }
        };
        return prPuts;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRPutsKeyValue(final String regionName, final Object[] portfolio, final int from, final int to) {
        CacheSerializableRunnable prPuts = new CacheSerializableRunnable("PRPuts"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region region = cache.getRegion(regionName);
                for (int j = from; j < to; ++j) {
                    region.put((Object)new Portfolio(j), portfolio[j]);
                }
            }
        };
        return prPuts;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRQueryAndCompareResults(String regionName, String localRegion) {
        return this.getCacheSerializableRunnableForPRQueryAndCompareResults(regionName, localRegion, false);
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRQueryAndCompareResults(final String regionName, final String localRegion, final boolean fullQueryOnPortfolioPositions) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRQuery"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String[] queries = fullQueryOnPortfolioPositions ? new String[]{"import com.gemstone.gemfire.cache.\"query\".data.Position;select distinct r.ID, status, mktValue from $1 r, r.positions.values pVal TYPE Position where r.status = 'active' AND pVal.mktValue >= 25.00", "import com.gemstone.gemfire.cache.\"query\".data.Position;select distinct * from $1 r, r.positions.values pVal TYPE Position where r.status = 'active' AND pVal.mktValue >= 25.00", "import com.gemstone.gemfire.cache.\"query\".data.Position;select distinct ID from $1 r, r.positions.values pVal TYPE Position where r.status = 'active' AND pVal.mktValue >= 25.00", "select distinct * from $1 where status = 'active'", "import com.gemstone.gemfire.cache.\"query\".data.Position;select distinct r from $1 r, r.positions.values pVal TYPE Position where pVal.mktValue < $2", "select p.positions.get('acc') from $1 p"} : new String[]{"ID = 0 OR ID = 1", "ID > 4 AND ID < 9", "ID = 5", "ID < 5 ", "ID <= 5"};
                Object[][] r = new Object[queries.length][2];
                Region local = cache.getRegion(localRegion);
                Region region = cache.getRegion(regionName);
                TestCase.assertNotNull((Object)region);
                String[] expectedExceptions = new String[]{RegionDestroyedException.class.getName(), ReplyException.class.getName(), CacheClosedException.class.getName(), ForceReattemptException.class.getName(), QueryInvocationTargetException.class.getName()};
                for (int i = 0; i < expectedExceptions.length; ++i) {
                    PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions[i] + "</ExpectedException>");
                }
                QueryService qs = PRQueryDUnitHelper.this.getCache().getQueryService();
                try {
                    for (int j = 0; j < queries.length; ++j) {
                        Region region2 = region;
                        synchronized (region2) {
                            Object[] params;
                            if (fullQueryOnPortfolioPositions) {
                                params = new Object[]{local, new Double((double)(j % 25) * 1.0 + 1.0)};
                                r[j][0] = qs.newQuery(queries[j]).execute(params);
                            } else {
                                r[j][0] = local.query(queries[j]);
                            }
                            if (fullQueryOnPortfolioPositions) {
                                params = new Object[]{region, new Double((double)(j % 25) * 1.0 + 1.0)};
                                r[j][1] = qs.newQuery(queries[j]).execute(params);
                            } else {
                                r[j][1] = region.query(queries[j]);
                            }
                            continue;
                        }
                    }
                    PRQueryDUnitHelper.this.compareTwoQueryResults(r, queries.length);
                }
                catch (QueryInvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof RegionDestroyedException)) {
                        throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                    }
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught QueryException while querying" + (Object)((Object)e), (Throwable)e);
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (RegionDestroyedException rde) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a RegionDestroyedException while querying as expected ", (Throwable)rde);
                }
                catch (CancelException cce) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a CancelException while querying as expected ", (Throwable)cce);
                }
                finally {
                    for (int i = 0; i < expectedExceptions.length; ++i) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions[i] + "</ExpectedException>");
                    }
                }
            }
        };
        return PrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPROrderByQueryAndCompareResults(final String regionName, final String localRegion) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRQuery"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String[] queries = new String[]{"p.status from /REGION_NAME p order by p.status", "* from /REGION_NAME order by status, ID desc", "status, ID from /REGION_NAME order by status", "p.status, p.ID from /REGION_NAME p order by p.status", "p.position1.secId, p.ID from /REGION_NAME p order by p.position1.secId", "key from /REGION_NAME.keys key order by key.status", "key.ID from /REGION_NAME.keys key order by key.ID", "key.ID, key.status from /REGION_NAME.keys key order by key.status", "key.ID, key.status from /REGION_NAME.keys key order by key.status, key.ID", "key.ID, key.status from /REGION_NAME.keys key order by key.status desc, key.ID", "key.ID, key.status from /REGION_NAME.keys key order by key.status, key.ID desc", "p.status, p.ID from /REGION_NAME p order by p.status asc, p.ID", "* from /REGION_NAME p order by p.status, p.ID", "p.ID from /REGION_NAME p, p.positions.values order by p.ID", "* from /REGION_NAME p, p.positions.values order by p.ID", "p.ID, p.status from /REGION_NAME p, p.positions.values order by p.status", "pos.secId from /REGION_NAME p, p.positions.values pos order by pos.secId", "p.ID, pos.secId from /REGION_NAME p, p.positions.values pos order by pos.secId", "* from /REGION_NAME p order by p.iD", "p.iD from /REGION_NAME p order by p.iD", "p.iD, p.status from /REGION_NAME p order by p.iD", "iD, status from /REGION_NAME order by iD", "* from /REGION_NAME p order by p.getID()", "p.getID() from /REGION_NAME p order by p.getID()", "* from /REGION_NAME p order by p.names[1]", "* from /REGION_NAME p order by p.getP1().secId", "* from /REGION_NAME p order by p.getP1().getSecId()", "* from /REGION_NAME p order by p.position1.secId", "p.ID, p.position1.secId from /REGION_NAME p order by p.position1.secId", "p.position1.secId, p.ID from /REGION_NAME p order by p.position1.secId", "e.key.ID from /REGION_NAME.entries e order by e.key.ID", "e.key.ID, e.value.status from /REGION_NAME.entries e order by e.key.ID", "e.key.ID, e.value.status from /REGION_NAME.entrySet e order by e.key.ID, e.value.status desc", "e.key, e.value from /REGION_NAME.entrySet e order by e.key.ID, e.value.status desc", "e.key from /REGION_NAME.entrySet e order by e.key.ID, e.key.pkid desc", "p, pos from /REGION_NAME p, p.positions.values pos order by p.ID", "p, pos from /REGION_NAME p, p.positions.values pos order by pos.secId", "p, pos from /REGION_NAME p, p.positions.values pos order by p.ID, pos.secId"};
                Object[][] r = new Object[queries.length][2];
                Region local = cache.getRegion(localRegion);
                Region region = cache.getRegion(regionName);
                TestCase.assertNotNull((Object)region);
                String[] expectedExceptions = new String[]{RegionDestroyedException.class.getName(), ReplyException.class.getName(), CacheClosedException.class.getName(), ForceReattemptException.class.getName(), QueryInvocationTargetException.class.getName()};
                for (int i = 0; i < expectedExceptions.length; ++i) {
                    PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions[i] + "</ExpectedException>");
                }
                String distinct = "SELECT DISTINCT ";
                QueryService qs = PRQueryDUnitHelper.this.getCache().getQueryService();
                try {
                    for (int j = 0; j < queries.length; ++j) {
                        String qStr = null;
                        Region region2 = region;
                        synchronized (region2) {
                            qStr = distinct + queries[j].replace("REGION_NAME", localRegion);
                            r[j][0] = qs.newQuery(qStr).execute();
                            qStr = distinct + queries[j].replace("REGION_NAME", regionName);
                            r[j][1] = qs.newQuery(qStr).execute();
                            continue;
                        }
                    }
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Queries Executed successfully on Local region & PR Region");
                    StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                    ssORrs.CompareQueryResultsWithoutAndWithIndexes(r, queries.length, queries);
                }
                catch (QueryInvocationTargetException e) {
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught QueryException while querying" + (Object)((Object)e), (Throwable)e);
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (RegionDestroyedException rde) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a RegionDestroyedException while querying as expected ", (Throwable)rde);
                }
                catch (CancelException cce) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a CancelException while querying as expected ", (Throwable)cce);
                }
                finally {
                    for (int i = 0; i < expectedExceptions.length; ++i) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions[i] + "</ExpectedException>");
                    }
                }
            }
        };
        return PrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPROrderByQueryAndVerifyOrder(final String regionName, final String localRegion) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRQuery"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String[] queries = new String[]{"p.status from /REGION_NAME p order by p.status", "status, ID from /REGION_NAME order by status, ID", "p.status, p.ID from /REGION_NAME p order by p.status, p.ID", "key.ID from /REGION_NAME.keys key order by key.ID", "key.ID, key.status from /REGION_NAME.keys key order by key.status, key.ID", "key.ID, key.status from /REGION_NAME.keys key order by key.status desc, key.ID", "key.ID, key.status from /REGION_NAME.keys key order by key.status, key.ID desc", "p.status, p.ID from /REGION_NAME p order by p.status asc, p.ID", "p.ID, p.status from /REGION_NAME p order by p.ID desc, p.status asc", "p.ID from /REGION_NAME p, p.positions.values order by p.ID", "p.ID, p.status from /REGION_NAME p, p.positions.values order by p.status, p.ID", "pos.secId from /REGION_NAME p, p.positions.values pos order by pos.secId", "p.ID, pos.secId from /REGION_NAME p, p.positions.values pos order by pos.secId, p.ID", "p.iD from /REGION_NAME p order by p.iD", "p.iD, p.status from /REGION_NAME p order by p.iD", "iD, status from /REGION_NAME order by iD", "p.getID() from /REGION_NAME p order by p.getID()", "p.names[1] from /REGION_NAME p order by p.names[1]", "p.position1.secId, p.ID from /REGION_NAME p order by p.position1.secId desc, p.ID", "p.ID, p.position1.secId from /REGION_NAME p order by p.position1.secId, p.ID", "e.key.ID from /REGION_NAME.entries e order by e.key.ID", "e.key.ID, e.value.status from /REGION_NAME.entries e order by e.key.ID", "e.key.ID, e.value.status from /REGION_NAME.entrySet e order by e.key.ID desc , e.value.status desc", "e.key, e.value from /REGION_NAME.entrySet e order by e.key.ID, e.value.status desc", "e.key from /REGION_NAME.entrySet e order by e.key.ID desc, e.key.pkid desc", "p.ID, pos.secId from /REGION_NAME p, p.positions.values pos order by p.ID, pos.secId", "p.ID, pos.secId from /REGION_NAME p, p.positions.values pos order by p.ID desc, pos.secId desc", "p.ID, pos.secId from /REGION_NAME p, p.positions.values pos order by p.ID desc, pos.secId"};
                Object[][] r = new Object[1][2];
                Region local = cache.getRegion(localRegion);
                Region region = cache.getRegion(regionName);
                TestCase.assertNotNull((Object)region);
                String[] expectedExceptions = new String[]{RegionDestroyedException.class.getName(), ReplyException.class.getName(), CacheClosedException.class.getName(), ForceReattemptException.class.getName(), QueryInvocationTargetException.class.getName()};
                for (int i = 0; i < expectedExceptions.length; ++i) {
                    PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions[i] + "</ExpectedException>");
                }
                String distinct = "SELECT DISTINCT ";
                QueryService qs = PRQueryDUnitHelper.this.getCache().getQueryService();
                StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                try {
                    for (int j = 0; j < queries.length; ++j) {
                        String qStr = null;
                        Region region2 = region;
                        synchronized (region2) {
                            qStr = distinct + queries[j].replace("REGION_NAME", localRegion);
                            r[0][0] = qs.newQuery(qStr).execute();
                            qStr = distinct + queries[j].replace("REGION_NAME", regionName);
                            r[0][1] = qs.newQuery(qStr).execute();
                            ssORrs.CompareQueryResultsWithoutAndWithIndexes(r, 1, true, queries);
                            continue;
                        }
                    }
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Queries Executed successfully on Local region & PR Region");
                }
                catch (QueryInvocationTargetException e) {
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught QueryException while querying" + (Object)((Object)e), (Throwable)e);
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (RegionDestroyedException rde) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a RegionDestroyedException while querying as expected ", (Throwable)rde);
                }
                catch (CancelException cce) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a CancelException while querying as expected ", (Throwable)cce);
                }
                finally {
                    for (int i = 0; i < expectedExceptions.length; ++i) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions[i] + "</ExpectedException>");
                    }
                }
            }
        };
        return PrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPROrderByQueryWithLimit(final String regionName, final String localRegion) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRQuery"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String[] queries = new String[]{"status as st from /REGION_NAME order by status", "p.status from /REGION_NAME p order by p.status", "p.position1.secId, p.ID from /REGION_NAME p order by p.position1.secId, p.ID desc", "key from /REGION_NAME.keys key order by key.status, key.ID", "key.ID from /REGION_NAME.keys key order by key.ID", "key.ID, key.status from /REGION_NAME.keys key order by key.status, key.ID asc", "key.ID, key.status from /REGION_NAME.keys key order by key.status desc, key.ID", "p.status, p.ID from /REGION_NAME p order by p.status asc, p.ID", "p.ID from /REGION_NAME p, p.positions.values order by p.ID", "* from /REGION_NAME p, p.positions.values val order by p.ID, val.secId", "p.iD, p.status from /REGION_NAME p order by p.iD", "iD, status from /REGION_NAME order by iD", "* from /REGION_NAME p order by p.getID()", "* from /REGION_NAME p order by p.getP1().secId, p.ID desc, p.ID", " p.position1.secId , p.ID as st from /REGION_NAME p order by p.position1.secId, p.ID", "e.key.ID, e.value.status from /REGION_NAME.entrySet e order by e.key.ID, e.value.status desc", "e.key from /REGION_NAME.entrySet e order by e.key.ID, e.key.pkid desc", "p, pos from /REGION_NAME p, p.positions.values pos order by p.ID, pos.secId desc", "p, pos from /REGION_NAME p, p.positions.values pos order by pos.secId, p.ID", "status , ID as ied from /REGION_NAME where ID > 0 order by status, ID desc", "p.status as st, p.ID as id from /REGION_NAME p where ID > 0 and status = 'inactive' order by p.status, p.ID desc", "p.position1.secId as st, p.ID as ied from /REGION_NAME p where p.ID > 0 and p.position1.secId != 'IBM' order by p.position1.secId, p.ID", " key.status as st, key.ID from /REGION_NAME.keys key where key.ID > 5 order by key.status, key.ID desc", " key.ID, key.status as st from /REGION_NAME.keys key where key.status = 'inactive' order by key.status desc, key.ID"};
                Object[][] r = new Object[queries.length][2];
                Region local = cache.getRegion(localRegion);
                Region region = cache.getRegion(regionName);
                TestCase.assertNotNull((Object)region);
                String[] expectedExceptions = new String[]{RegionDestroyedException.class.getName(), ReplyException.class.getName(), CacheClosedException.class.getName(), ForceReattemptException.class.getName(), QueryInvocationTargetException.class.getName()};
                for (int i = 0; i < expectedExceptions.length; ++i) {
                    PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions[i] + "</ExpectedException>");
                }
                String distinct = "SELECT DISTINCT ";
                QueryService qs = PRQueryDUnitHelper.this.getCache().getQueryService();
                try {
                    for (int l = 1; l <= 3; ++l) {
                        for (int j = 0; j < queries.length; ++j) {
                            String qStr = null;
                            Region region2 = region;
                            synchronized (region2) {
                                qStr = distinct + queries[j].replace("REGION_NAME", localRegion);
                                qStr = qStr + " LIMIT " + l * l;
                                SelectResults sr = (SelectResults)qs.newQuery(qStr).execute();
                                r[j][0] = sr;
                                if (sr.asList().size() > l * l) {
                                    TestCase.fail((String)("The resultset size exceeds limit size. Limit size=" + l * l + ", result size =" + sr.asList().size()));
                                }
                                qStr = distinct + queries[j].replace("REGION_NAME", regionName);
                                qStr = qStr + " LIMIT " + l * l;
                                SelectResults srr = (SelectResults)qs.newQuery(qStr).execute();
                                r[j][1] = srr;
                                if (srr.size() > l * l) {
                                    TestCase.fail((String)("The resultset size exceeds limit size. Limit size=" + l * l + ", result size =" + srr.asList().size()));
                                }
                                continue;
                            }
                        }
                    }
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Queries Executed successfully on Local region & PR Region");
                    StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                    ssORrs.CompareQueryResultsWithoutAndWithIndexes(r, queries.length, true, queries);
                }
                catch (QueryInvocationTargetException e) {
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught QueryException while querying" + (Object)((Object)e), (Throwable)e);
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (RegionDestroyedException rde) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a RegionDestroyedException while querying as expected ", (Throwable)rde);
                }
                catch (CancelException cce) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a CancelException while querying as expected ", (Throwable)cce);
                }
                finally {
                    for (int i = 0; i < expectedExceptions.length; ++i) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions[i] + "</ExpectedException>");
                    }
                }
            }
        };
        return PrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRCountStarQueries(final String regionName, final String localRegion) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRCountStarQuery"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String[] queries = new String[]{"select COUNT(*) from /" + regionName, "select COUNT(*) from /" + regionName + " where ID > 0", "select COUNT(*) from /" + regionName + " where ID > 0 AND status='active'", "select COUNT(*) from /" + regionName + " where ID > 0 OR status='active'", "select COUNT(*) from /" + regionName + " where ID > 0 AND status LIKE 'act%'", "select COUNT(*) from /" + regionName + " where ID > 0 OR status LIKE 'ina%'", "select COUNT(*) from /" + regionName + " where ID IN SET(1, 2, 3, 4, 5)", "select COUNT(*) from /" + regionName + " where NOT (ID > 5)", "select DISTINCT COUNT(*) from /" + regionName + " where ID > 0", "select DISTINCT COUNT(*) from /" + regionName + " where ID > 0 AND status='active'", "select DISTINCT COUNT(*) from /" + regionName + " where ID > 0 OR status='active'", "select DISTINCT COUNT(*) from /" + regionName + " where ID > 0 AND status LIKE 'act%'", "select DISTINCT COUNT(*) from /" + regionName + " where ID > 0 OR status LIKE 'ina%'", "select DISTINCT COUNT(*) from /" + regionName + " where ID IN SET(1, 2, 3, 4, 5)", "select DISTINCT COUNT(*) from /" + regionName + " where NOT (ID > 5)", "select COUNT(*) from /" + regionName + " p, p.positions.values pos where p.ID > 0 AND pos.secId = 'IBM'", "select DISTINCT COUNT(*) from /" + regionName + " p, p.positions.values pos where p.ID > 0 AND pos.secId = 'IBM'", "select COUNT(*) from /" + regionName + " p, p.positions.values pos where p.ID > 0 AND pos.secId = 'IBM' LIMIT 5", "select DISTINCT COUNT(*) from /" + regionName + " p, p.positions.values pos where p.ID > 0 AND pos.secId = 'IBM' ORDER BY p.ID", "select COUNT(*) from /" + regionName + " p, p.positions.values pos where p.ID > 0 AND p.status = 'active' AND pos.secId = 'IBM'", "select COUNT(*) from /" + regionName + " p, p.positions.values pos where p.ID > 0 AND p.status = 'active' OR pos.secId = 'IBM'", "select COUNT(*) from /" + regionName + " p, p.positions.values pos where p.ID > 0 OR p.status = 'active' OR pos.secId = 'IBM'", "select COUNT(*) from /" + regionName + " p, p.positions.values pos where p.ID > 0 OR p.status = 'active' OR pos.secId = 'IBM' LIMIT 150"};
                Object[][] r = new Object[queries.length][2];
                Region local = cache.getRegion(localRegion);
                Region region = cache.getRegion(regionName);
                TestCase.assertNotNull((Object)region);
                String[] expectedExceptions = new String[]{RegionDestroyedException.class.getName(), ReplyException.class.getName(), CacheClosedException.class.getName(), ForceReattemptException.class.getName(), QueryInvocationTargetException.class.getName()};
                for (int i = 0; i < expectedExceptions.length; ++i) {
                    PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions[i] + "</ExpectedException>");
                }
                QueryService qs = PRQueryDUnitHelper.this.getCache().getQueryService();
                try {
                    for (int j = 0; j < queries.length; ++j) {
                        String qStr = null;
                        Region region2 = region;
                        synchronized (region2) {
                            qStr = queries[j];
                            SelectResults sr = (SelectResults)qs.newQuery(qStr).execute();
                            r[j][0] = sr;
                            qStr = queries[j];
                            SelectResults srr = (SelectResults)qs.newQuery(qStr.replace(regionName, localRegion)).execute();
                            r[j][1] = srr;
                            continue;
                        }
                    }
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Queries Executed successfully on Local region & PR Region");
                    StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                    ssORrs.CompareCountStarQueryResultsWithoutAndWithIndexes(r, queries.length, true, queries);
                }
                catch (QueryInvocationTargetException e) {
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught QueryException while querying" + (Object)((Object)e), (Throwable)e);
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (RegionDestroyedException rde) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a RegionDestroyedException while querying as expected ", (Throwable)rde);
                }
                catch (CancelException cce) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a CancelException while querying as expected ", (Throwable)cce);
                }
                finally {
                    for (int i = 0; i < expectedExceptions.length; ++i) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions[i] + "</ExpectedException>");
                    }
                }
            }
        };
        return PrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForIndexUsageCheck(String name) {
        CacheSerializableRunnable PrIndexCheck = new CacheSerializableRunnable("PrIndexCheck"){

            @Override
            public void run2() {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                QueryService qs = cache.getQueryService();
                LogWriter logger = cache.getLogger();
                Collection indexes = qs.getIndexes();
                for (PartitionedIndex ind : indexes) {
                    int indexUsageWithSizeEstimation = 3;
                    logger.info("index uses for " + ind.getNumberOfIndexedBuckets() + " index " + ind.getName() + ": " + ind.getStatistics().getTotalUses());
                    TestCase.assertEquals((long)(6 * ind.getNumberOfIndexedBuckets()), (long)ind.getStatistics().getTotalUses());
                }
            }
        };
        return PrIndexCheck;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRQueryWithConstantsAndComparingResults(final String regionName, final String localRegion) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRQuery"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String[] query = new String[]{"TRUE", "FALSE", "UNDEFINED", "NULL"};
                Object[][] r = new Object[query.length][2];
                Region local = cache.getRegion(localRegion);
                Region region = cache.getRegion(regionName);
                try {
                    for (int j = 0; j < query.length; ++j) {
                        r[j][0] = local.query(query[j]);
                        r[j][1] = region.query(query[j]);
                    }
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryWithConstantsAndComparingResults: Queries Executed successfully on Local region & PR Region");
                    PRQueryDUnitHelper.this.compareTwoQueryResults(r, query.length);
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryWithConstantsAndComparingResults: Caught an Exception while querying Constants" + (Object)((Object)e), (Throwable)e);
                    TestCase.fail((String)("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryWithConstantsAndComparingResults: Caught Exception while querying Constants. Exception is " + (Object)((Object)e)));
                }
            }
        };
        return PrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRAccessorCreate(final String regionName, final int redundancy, final Class constraint) {
        CacheSerializableRunnable createPrRegion = new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region partitionedregion = null;
                int maxMem = 0;
                AttributesFactory attr = new AttributesFactory();
                attr.setValueConstraint(constraint);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                PartitionAttributes prAttr = paf.setLocalMaxMemory(maxMem).setRedundantCopies(redundancy).create();
                attr.setPartitionAttributes(prAttr);
                partitionedregion = cache.createRegion(regionName, attr.create());
                TestCase.assertNotNull((String)("PRQueryDUnitHelper#getCacheSerializableRunnableForPRAccessorCreate: Partitioned Region " + regionName + " not in cache"), (Object)cache.getRegion(regionName));
                TestCase.assertNotNull((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRAccessorCreate: Partitioned Region ref null", (Object)partitionedregion);
                TestCase.assertTrue((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRAccessorCreate: Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
            }
        };
        return createPrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRAccessorCreate(final String regionName, final int redundancy) {
        CacheSerializableRunnable createPrRegion = new CacheSerializableRunnable(regionName){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region partitionedregion = null;
                int maxMem = 0;
                AttributesFactory attr = new AttributesFactory();
                attr.setValueConstraint(PRQueryDUnitHelper.this.valueConstraint);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                PartitionAttributes prAttr = paf.setLocalMaxMemory(maxMem).setRedundantCopies(redundancy).create();
                attr.setPartitionAttributes(prAttr);
                partitionedregion = cache.createRegion(regionName, attr.create());
                TestCase.assertNotNull((String)("PRQueryDUnitHelper#getCacheSerializableRunnableForPRAccessorCreate: Partitioned Region " + regionName + " not in cache"), (Object)cache.getRegion(regionName));
                TestCase.assertNotNull((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRAccessorCreate: Partitioned Region ref null", (Object)partitionedregion);
                TestCase.assertTrue((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRAccessorCreate: Partitioned Region ref claims to be destroyed", (!partitionedregion.isDestroyed() ? 1 : 0) != 0);
            }
        };
        return createPrRegion;
    }

    public void compareTwoQueryResults(Object[][] r, int len) {
        Set set1 = null;
        Set set2 = null;
        for (int j = 0; j < len; ++j) {
            if (r[j][0] == null || r[j][1] == null) continue;
            ObjectType type1 = ((SelectResults)r[j][0]).getCollectionType().getElementType();
            PRQueryDUnitHelper.assertNotNull((String)("PRQueryDUnitHelper#compareTwoQueryResults: Type 1 is NULL " + type1), (Object)type1);
            ObjectType type2 = ((SelectResults)r[j][1]).getCollectionType().getElementType();
            PRQueryDUnitHelper.assertNotNull((String)("PRQueryDUnitHelper#compareTwoQueryResults: Type 2 is NULL " + type2), (Object)type2);
            if (type1.getClass().getName().equals(type2.getClass().getName())) {
                PRQueryDUnitHelper.getLogWriter().info("PRQueryDUnitHelper#compareTwoQueryResults: Both Search Results are of the same Type i.e.--> " + ((SelectResults)r[j][0]).getCollectionType().getElementType());
            } else {
                PRQueryDUnitHelper.getLogWriter().error("PRQueryDUnitHelper#compareTwoQueryResults: Classes are : " + type1.getClass().getName() + " " + type2.getClass().getName());
                PRQueryDUnitHelper.fail((String)"PRQueryDUnitHelper#compareTwoQueryResults: FAILED:Search result Type is different in both the cases");
            }
            int size0 = ((SelectResults)r[j][0]).size();
            int size1 = ((SelectResults)r[j][1]).size();
            if (size0 == size1) {
                PRQueryDUnitHelper.getLogWriter().info("PRQueryDUnitHelper#compareTwoQueryResults: Both Search Results are non-zero and are of Same Size i.e.  Size= " + size1 + ";j=" + j);
            } else {
                PRQueryDUnitHelper.getLogWriter().error("PRQueryDUnitHelper#compareTwoQueryResults: FAILED:Search resultSet size are different in both cases; size0=" + size0 + ";size1=" + size1 + ";j=" + j);
                PRQueryDUnitHelper.fail((String)("PRQueryDUnitHelper#compareTwoQueryResults: FAILED:Search resultSet size are different in both cases; size0=" + size0 + ";size1=" + size1 + ";j=" + j));
            }
            set2 = ((SelectResults)r[j][1]).asSet();
            set1 = ((SelectResults)r[j][0]).asSet();
            PRQueryDUnitHelper.assertEquals((String)"PRQueryDUnitHelper#compareTwoQueryResults: FAILED: result contents are not equal, ", (Object)set1, (Object)set2);
        }
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRInvalidQuery(final String regionName, String invalidQuery) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRQuery"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String query = "INVALID QUERY";
                Region region = cache.getRegion(regionName);
                try {
                    region.query(query);
                    TestCase.fail((String)"PRQueryDUnitHelper#getCacheSerializableRunnableForPRInvalidQuery: InvalidQueryException expected");
                }
                catch (QueryInvalidException queryInvalidException) {
                }
                catch (QueryException qe) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRInvalidQuery: Caught another Exception while querying , Exception is " + (Object)((Object)qe), (Throwable)qe);
                    TestCase.fail((String)("PRQueryDUnitHelper#getCacheSerializableRunnableForPRInvalidQuery: Caught another Exception while querying , Exception is " + (Object)((Object)qe)));
                }
            }
        };
        return PrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForRegionClose(final String regionName, final int redundancy) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("regionClose"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String expectedRegionDestroyedException = RegionDestroyedException.class.getName();
                String expectedReplyException = ReplyException.class.getName();
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedRegionDestroyedException + "</ExpectedException>");
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedReplyException + "</ExpectedException>");
                Region region = cache.getRegion(regionName);
                DistributedTestCase.getLogWriter().info("PROperationWithQueryDUnitTest#getCacheSerializableRunnableForRegionClose: Closing region");
                region.close();
                DistributedTestCase.getLogWriter().info("PROperationWithQueryDUnitTest#getCacheSerializableRunnableForRegionClose: Region Closed on VM ");
                AttributesFactory attr = new AttributesFactory();
                attr.setValueConstraint(PortfolioData.class);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).create();
                attr.setPartitionAttributes(prAttr);
                cache.createRegion(regionName, attr.create());
                DistributedTestCase.getLogWriter().info("PROperationWithQueryDUnitTest#getCacheSerializableRunnableForRegionClose: Region Recreated on VM ");
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedReplyException + "</ExpectedException>");
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedRegionDestroyedException + "</ExpectedException>");
            }
        };
        return PrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForCacheClose(final String regionName, final int redundancy) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("cacheClose"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String expectedCacheClosedException = CacheClosedException.class.getName();
                String expectedReplyException = ReplyException.class.getName();
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedCacheClosedException + "</ExpectedException>");
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedReplyException + "</ExpectedException>");
                DistributedTestCase.getLogWriter().info("PROperationWithQueryDUnitTest#getCacheSerializableRunnableForCacheClose: Closing cache");
                CacheTestCase.closeCache();
                DistributedTestCase.getLogWriter().info("PROperationWithQueryDUnitTest#getCacheSerializableRunnableForCacheClose: cache Closed on VM ");
                cache = PRQueryDUnitHelper.this.getCache();
                DistributedTestCase.getLogWriter().info("PROperationWithQueryDUnitTest#getCacheSerializableRunnableForCacheClose: Recreating the cache ");
                AttributesFactory attr = new AttributesFactory();
                attr.setValueConstraint(PortfolioData.class);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).create();
                attr.setPartitionAttributes(prAttr);
                final CountDownLatch cdl = new CountDownLatch(1);
                InternalResourceManager.ResourceObserverAdapter observer = new InternalResourceManager.ResourceObserverAdapter(){

                    public void recoveryFinished(Region region) {
                        cdl.countDown();
                    }
                };
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)observer);
                try {
                    cache.createRegion(regionName, attr.create());
                    cdl.await();
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interupted", e);
                }
                finally {
                    InternalResourceManager.setResourceObserver(null);
                }
                DistributedTestCase.getLogWriter().info("PROperationWithQueryDUnitTest#getCacheSerializableRunnableForCacheClose: cache Recreated on VM ");
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedReplyException + "</ExpectedException>");
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedCacheClosedException + "</ExpectedException>");
            }
        };
        return PrRegion;
    }

    public PortfolioData[] createPortfolioData(int cnt, int cntDest) {
        PortfolioData[] portfolio = new PortfolioData[cntDest];
        for (int k = cnt; k < cntDest; ++k) {
            portfolio[k] = new PortfolioData(k);
        }
        return portfolio;
    }

    public Portfolio[] createPortfoliosAndPositions(int count) {
        return QueryREUpdateInProgressJUnitTest.createPortfoliosAndPositions((int)count);
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForRegionDestroy(final String regionName, int redundancy) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("regionDestroy"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String expectedRegionDestroyedException = RegionDestroyedException.class.getName();
                String expectedReplyException = ReplyException.class.getName();
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedRegionDestroyedException + "</ExpectedException>");
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedReplyException + "</ExpectedException>");
                Region region = cache.getRegion(regionName);
                DistributedTestCase.getLogWriter().info("PRQueryRegionDestroyedDUnitTest#getCacheSerializableRunnableForRegionClose: Destroying region " + region);
                region.destroyRegion();
                TestCase.assertTrue((String)"Region destroy failed", (boolean)region.isDestroyed());
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedReplyException + "</ExpectedException>");
                PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedRegionDestroyedException + "</ExpectedException>");
            }
        };
        return PrRegion;
    }

    public CacheSerializableRunnable PRQueryingVsLocalQuerying(final String regionName, final String localRegion, final PRQueryPerfDUnitTest.ResultsObject perfR) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRvsLocal"){

            @Override
            public void run2() throws CacheException {
                PerfResultsObject prfRObject = new PerfResultsObject(perfR);
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String[] query = new String[]{"ID = 0 OR ID = 1", "ID > 4 AND ID < 9", "ID = 5", "ID < 5 ", "ID <= 5", "ID > 7 AND status ='active'"};
                Object[][] r = new Object[query.length][2];
                Region local = cache.getRegion(localRegion);
                Region region = cache.getRegion(regionName);
                TestCase.assertEquals((Object)local.values(), (Object)region.values());
                long startTimeLocal = System.currentTimeMillis();
                try {
                    for (int j = 0; j < query.length; ++j) {
                        r[j][0] = local.query(query[j]);
                    }
                    long endTimeLocal = System.currentTimeMillis();
                    long queryTimeLocal = endTimeLocal - startTimeLocal;
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#PRQueryingVsLocalQuerying: Time to Query Local cache " + queryTimeLocal + " ms");
                    long startTimePR = System.currentTimeMillis();
                    for (int k = 0; k < query.length; ++k) {
                        r[k][1] = region.query(query[k]);
                    }
                    long endTimePR = System.currentTimeMillis();
                    long queryTimePR = endTimePR - startTimePR;
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#PRQueryingVsLocalQuerying: Time to Query PR " + queryTimePR + " ms");
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#PRQueryingVsLocalQuerying: Queries Executed successfully on Local region & PR Region");
                    prfRObject.QueryingTimeLocal = queryTimeLocal;
                    prfRObject.QueryingTimePR = queryTimePR;
                    prfRObject.displayResults();
                    PRQueryDUnitHelper.this.compareTwoQueryResults(r, query.length);
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#PRQueryingVsLocalQuerying: Caught QueryException while querying" + (Object)((Object)e), (Throwable)e);
                    TestCase.fail((String)("PRQueryDUnitHelper#PRQueryingVsLocalQuerying: Caught unexpected query exception. Exception is " + (Object)((Object)e)));
                }
            }
        };
        return PrRegion;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRIndexCreate(final String prRegionName, final String indexName, final String indexedExpression, final String fromClause, final String alias) {
        CacheSerializableRunnable prIndexCreator = new CacheSerializableRunnable("PartitionedIndexCreator"){

            @Override
            public void run2() {
                try {
                    Cache cache = PRQueryDUnitHelper.this.getCache();
                    QueryService qs = cache.getQueryService();
                    Region region = cache.getRegion(prRegionName);
                    LogWriter logger = cache.getLogger();
                    if (null != fromClause) {
                        logger.info("Test Creating index with Name : [ " + indexName + " ] IndexedExpression : [ " + indexedExpression + " ] Alias : [ " + alias + " ] FromClause : [ " + fromClause + " " + alias + " ] ");
                        Index parIndex = qs.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause);
                        logger.info("Index creted on partitioned region : " + parIndex);
                    } else {
                        logger.info("Test Creating index with Name : [ " + indexName + " ] IndexedExpression : [ " + indexedExpression + " ] Alias : [ " + alias + " ] FromClause : [ " + region.getFullPath() + " " + alias + " ] ");
                        Index parIndex = qs.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, region.getFullPath() + " " + alias);
                        logger.info("Index creted on partitioned region : " + parIndex);
                        logger.info("Number of buckets indexed in the partitioned region locally : " + ((PartitionedIndex)parIndex).getNumberOfIndexedBuckets() + " and remote buckets indexed : " + ((PartitionedIndex)parIndex).getNumRemoteBucketsIndexed());
                    }
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("Creating Index in this vm failed : ", ex);
                }
            }
        };
        return prIndexCreator;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForRRIndexCreate(final String rrRegionName, final String indexName, final String indexedExpression, final String fromClause, final String alias) {
        CacheSerializableRunnable prIndexCreator = new CacheSerializableRunnable("ReplicatedRegionIndexCreator"){

            @Override
            public void run2() {
                try {
                    Cache cache = PRQueryDUnitHelper.this.getCache();
                    QueryService qs = cache.getQueryService();
                    Region region = cache.getRegion(rrRegionName);
                    LogWriter logger = cache.getLogger();
                    if (null != fromClause) {
                        logger.info("Test Creating index with Name : [ " + indexName + " ] IndexedExpression : [ " + indexedExpression + " ] Alias : [ " + alias + " ] FromClause : [ " + fromClause + " " + alias + " ] ");
                        Index parIndex = qs.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause);
                        logger.info("Index creted on replicated region : " + parIndex);
                    } else {
                        logger.info("Test Creating index with Name : [ " + indexName + " ] IndexedExpression : [ " + indexedExpression + " ] Alias : [ " + alias + " ] FromClause : [ " + region.getFullPath() + " " + alias + " ] ");
                        Index parIndex = qs.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, region.getFullPath() + " " + alias);
                        logger.info("Index creted on replicated region : " + parIndex);
                    }
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("Creating Index in this vm failed : ", ex);
                }
            }
        };
        return prIndexCreator;
    }

    public CacheSerializableRunnable getCacheSerializableForPrXmlFileGenerator(final String regionName, int redundancy, final String fileName) {
        CacheSerializableRunnable prXMLFileCreator = new CacheSerializableRunnable("prXmlFileCreator"){

            @Override
            public void run2() {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                Region partitionedregion = cache.getRegion(regionName);
                cache.getLogger().info("the index created : " + ((PartitionedRegion)partitionedregion).getIndex());
                PRQueryDUnitHelper.this.writeCacheXml(fileName, cache);
            }
        };
        return prXMLFileCreator;
    }

    public void writeCacheXml(String name, Cache cache) {
        File file = new File(name + "-cache.xml");
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(file), true);
            CacheXmlGenerator.generate((Cache)cache, (PrintWriter)pw);
            pw.close();
        }
        catch (IOException ex) {
            PRQueryDUnitHelper.fail("IOException during cache.xml generation to " + file, ex);
        }
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForPRCreateThrougXML(final String regionName, final String xmlFileName) {
        CacheSerializableRunnable prIndexCreator = new CacheSerializableRunnable("PrRegionCreator"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() {
                InternalDistributedSystem sys = null;
                try {
                    File file;
                    CacheTestCase.closeCache();
                    GemFireCacheImpl.testCacheXml = file = PRQueryDUnitHelper.this.findFile(xmlFileName);
                    sys = PRQueryDUnitHelper.this.getSystem();
                    sys.getLogWriter().info("<ExpectedException action=add>" + IndexNameConflictException.class.getName() + "</ExpectedException>");
                    Cache cache = PRQueryDUnitHelper.this.getCache();
                    LogWriter logger = cache.getLogger();
                    PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                    Map indexMap = region.getIndex();
                    Set indexSet = indexMap.entrySet();
                    for (Map.Entry entry : indexSet) {
                        Index index = (Index)entry.getValue();
                        logger.info("The partitioned index created on this region  " + index);
                        logger.info("Current number of buckets indexed : " + ((PartitionedIndex)index).getNumberOfIndexedBuckets());
                    }
                }
                finally {
                    if (sys != null) {
                        sys.getLogWriter().info("<ExpectedException action=remove>" + IndexNameConflictException.class.getName() + "</ExpectedException>");
                    }
                    GemFireCacheImpl.testCacheXml = null;
                }
            }
        };
        return prIndexCreator;
    }

    protected File findFile(String fileName) {
        File dir = new File(System.getProperty("JTESTS"));
        if (!dir.exists()) {
            String s = "Could not find JTESTS";
            throw new IllegalStateException(s);
        }
        String[] subdirs = new String[]{"com", "gemstone", "gemfire", "cache", "query", "partitioned"};
        for (int i = 0; i < subdirs.length; ++i) {
            if ((dir = new File(dir, subdirs[i])).exists()) continue;
            String s = "Could not find " + dir;
            throw new IllegalStateException(s);
        }
        File file = new File(dir, fileName);
        return file;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForIndexCreationCheck(final String name) {
        CacheSerializableRunnable prIndexCheck = new CacheSerializableRunnable("PrIndexCreationCheck"){

            @Override
            public void run2() {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                LogWriter logger = cache.getLogger();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(name);
                Map indexMap = region.getIndex();
                Set indexSet = indexMap.entrySet();
                for (Map.Entry entry : indexSet) {
                    Index index = (Index)entry.getValue();
                    logger.info("the partitioned index created on this region  " + index);
                    logger.info("Current number of buckets indexed : " + ((PartitionedIndex)index).getNumberOfIndexedBuckets());
                }
                CacheTestCase.closeCache();
                CacheTestCase.disconnectFromDS();
            }
        };
        return prIndexCheck;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForDuplicatePRIndexCreate(final String prRegionName, final String indexName, final String indexedExpression, final String fromClause, final String alias) {
        CacheSerializableRunnable prIndexCreator = new CacheSerializableRunnable("DuplicatePartitionedIndexCreator"){

            @Override
            public void run2() {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                LogWriter logger = cache.getLogger();
                QueryService qs = cache.getQueryService();
                Region region = cache.getRegion(prRegionName);
                try {
                    if (null != fromClause) {
                        qs.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause);
                        throw new RuntimeException("Should throw an exception because the index with name : " + indexName + " should already exists");
                    }
                    qs.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, region.getFullPath() + " " + alias);
                    throw new RuntimeException("Should throw an exception because the index with name : " + indexName + " should already exists");
                }
                catch (IndexExistsException e) {
                    logger.info("Index Exists Excetpiont righteously throw ", (Throwable)e);
                }
                catch (IndexNameConflictException ex) {
                    logger.info("Gott the right exception");
                }
                catch (RegionNotFoundException exx) {
                    DistributedTestCase.fail("Region Not found in this vm ", exx);
                }
            }
        };
        return prIndexCreator;
    }

    public CacheSerializableRunnable getCacheSerializableRunnableForRemoveIndex(final String name, final boolean random) {
        CacheSerializableRunnable prRemoveIndex = new CacheSerializableRunnable("PrRemoveIndex"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                LogWriter logger = cache.getLogger();
                logger.info("Got the following cache : " + cache);
                Region parRegion = cache.getRegion(name);
                QueryService qs = cache.getQueryService();
                if (!random) {
                    Collection indexes = qs.getIndexes();
                    TestCase.assertEquals((int)3, (int)indexes.size());
                    Iterator it = indexes.iterator();
                    while (it.hasNext()) {
                        logger.info("Following indexes found : " + it.next());
                    }
                    qs.removeIndexes(parRegion);
                    logger.info("Removed all the index on this paritioned regions : " + parRegion);
                    indexes = qs.getIndexes();
                    TestCase.assertEquals((int)0, (int)((LocalRegion)parRegion).getIndexManager().getIndexes().size());
                    TestCase.assertEquals((int)0, (int)indexes.size());
                    qs.removeIndexes(parRegion);
                } else {
                    Collection indexes = qs.getIndexes(parRegion);
                    TestCase.assertEquals((int)3, (int)indexes.size());
                    TestCase.assertEquals((int)3, (int)((LocalRegion)parRegion).getIndexManager().getIndexes().size());
                    Collection collection = indexes;
                    synchronized (collection) {
                        for (Index in : indexes) {
                            qs.removeIndex(in);
                        }
                    }
                    indexes = qs.getIndexes(parRegion);
                    TestCase.assertEquals((int)0, (int)indexes.size());
                    TestCase.assertEquals((int)0, (int)((LocalRegion)parRegion).getIndexManager().getIndexes().size());
                }
            }
        };
        return prRemoveIndex;
    }

    public Runnable getCacheSerializableRunnableForPRColocatedDataSetQueryAndCompareResults(final String name, final String coloName, final String localName, final String coloLocalName) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRQuery"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String[] queries = new String[]{"r1.ID = r2.id", "r1.ID = r2.id AND r1.ID > 5", "r1.ID = r2.id AND r1.status = 'active'", "r1.ID = r2.id ORDER BY r1.ID", "r1.ID = r2.id ORDER BY r2.id", "r1.ID = r2.id ORDER BY r2.status", "r1.ID = r2.id AND r1.status != r2.status", "r1.ID = r2.id AND r1.status = r2.status", "r1.ID = r2.id AND r1.positions.size = r2.positions.size", "r1.ID = r2.id AND r1.positions.size > r2.positions.size", "r1.ID = r2.id AND r1.positions.size < r2.positions.size", "r1.ID = r2.id AND r1.positions.size = r2.positions.size AND r2.positions.size > 0", "r1.ID = r2.id AND (r1.positions.size > r2.positions.size OR r2.positions.size > 0)", "r1.ID = r2.id AND (r1.positions.size < r2.positions.size OR r1.positions.size > 0)"};
                Object[][] r = new Object[queries.length][2];
                Region region = null;
                region = cache.getRegion(name);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(coloName);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(localName);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(coloLocalName);
                TestCase.assertNotNull((Object)region);
                String[] expectedExceptions = new String[]{RegionDestroyedException.class.getName(), ReplyException.class.getName(), CacheClosedException.class.getName(), ForceReattemptException.class.getName(), QueryInvocationTargetException.class.getName()};
                for (int i = 0; i < expectedExceptions.length; ++i) {
                    PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions[i] + "</ExpectedException>");
                }
                QueryService qs = PRQueryDUnitHelper.this.getCache().getQueryService();
                try {
                    for (int j = 0; j < queries.length; ++j) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("About to execute local query: " + queries[j]);
                        TestQueryFunction func = new TestQueryFunction("testfunction");
                        Object funcResult = FunctionService.onRegion((Region)(PRQueryDUnitHelper.this.getCache().getRegion(name) instanceof PartitionedRegion ? PRQueryDUnitHelper.this.getCache().getRegion(name) : PRQueryDUnitHelper.this.getCache().getRegion(coloName))).withArgs((Object)("<trace> Select " + (queries[j].contains("ORDER BY") ? "DISTINCT" : "") + " * from /" + name + " r1, /" + coloName + " r2 where " + queries[j])).execute((Function)func).getResult();
                        r[j][0] = ((ArrayList)funcResult).get(0);
                        PRQueryDUnitHelper.this.getCache().getLogger().info("About to execute local query: " + queries[j]);
                        SelectResults r2 = (SelectResults)qs.newQuery("Select " + (queries[j].contains("ORDER BY") ? "DISTINCT" : "") + " * from /" + localName + " r1, /" + coloLocalName + " r2 where " + queries[j]).execute();
                        r[j][1] = r2.asList();
                    }
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Queries Executed successfully on Local region & PR Region");
                    StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                    ssORrs.CompareQueryResultsAsListWithoutAndWithIndexes(r, queries.length, false, false, queries);
                }
                catch (QueryInvocationTargetException e) {
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught QueryException while querying" + (Object)((Object)e), (Throwable)e);
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (RegionDestroyedException rde) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a RegionDestroyedException while querying as expected ", (Throwable)rde);
                }
                catch (CancelException cce) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a CancelException while querying as expected ", (Throwable)cce);
                }
                finally {
                    for (int i = 0; i < expectedExceptions.length; ++i) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions[i] + "</ExpectedException>");
                    }
                }
            }
        };
        return PrRegion;
    }

    public Runnable getCacheSerializableRunnableForPRAndRRQueryAndCompareResults(final String name, final String coloName, final String localName, final String coloLocalName) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRQuery"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String[] queries = new String[]{"r1.ID = r2.id", "r1.ID = r2.id AND r1.ID > 5", "r1.ID = r2.id AND r1.status = 'active'", "r1.ID = r2.id ORDER BY r1.ID", "r1.ID = r2.id ORDER BY r2.id", "r1.ID = r2.id ORDER BY r2.status", "r1.ID = r2.id AND r1.status != r2.status", "r1.ID = r2.id AND r1.status = r2.status", "r1.ID = r2.id AND r1.positions.size = r2.positions.size", "r1.ID = r2.id AND r1.positions.size > r2.positions.size", "r1.ID = r2.id AND r1.positions.size < r2.positions.size", "r1.ID = r2.id AND r1.positions.size = r2.positions.size AND r2.positions.size > 0", "r1.ID = r2.id AND (r1.positions.size > r2.positions.size OR r2.positions.size > 0)", "r1.ID = r2.id AND (r1.positions.size < r2.positions.size OR r1.positions.size > 0)"};
                Object[][] r = new Object[queries.length][2];
                Region region = null;
                region = cache.getRegion(name);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(coloName);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(localName);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(coloLocalName);
                TestCase.assertNotNull((Object)region);
                String[] expectedExceptions = new String[]{RegionDestroyedException.class.getName(), ReplyException.class.getName(), CacheClosedException.class.getName(), ForceReattemptException.class.getName(), QueryInvocationTargetException.class.getName()};
                for (int i = 0; i < expectedExceptions.length; ++i) {
                    PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions[i] + "</ExpectedException>");
                }
                QueryService qs = PRQueryDUnitHelper.this.getCache().getQueryService();
                try {
                    for (int j = 0; j < queries.length; ++j) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("About to execute local query: " + queries[j]);
                        TestQueryFunction func = new TestQueryFunction("testfunction");
                        Object funcResult = FunctionService.onRegion((Region)(PRQueryDUnitHelper.this.getCache().getRegion(name) instanceof PartitionedRegion ? PRQueryDUnitHelper.this.getCache().getRegion(name) : PRQueryDUnitHelper.this.getCache().getRegion(coloName))).withArgs((Object)("<trace> Select " + (queries[j].contains("ORDER BY") ? "DISTINCT" : "") + " * from /" + name + " r1, /" + coloName + " r2, r2.positions.values pos2 where " + queries[j])).execute((Function)func).getResult();
                        r[j][0] = ((ArrayList)funcResult).get(0);
                        PRQueryDUnitHelper.this.getCache().getLogger().info("About to execute local query: " + queries[j]);
                        SelectResults r2 = (SelectResults)qs.newQuery("Select " + (queries[j].contains("ORDER BY") ? "DISTINCT" : "") + " * from /" + localName + " r1, /" + coloLocalName + " r2, r2.positions.values pos2 where " + queries[j]).execute();
                        r[j][1] = r2.asList();
                    }
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Queries Executed successfully on Local region & PR Region");
                    StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                    ssORrs.CompareQueryResultsAsListWithoutAndWithIndexes(r, queries.length, false, false, queries);
                }
                catch (QueryInvocationTargetException e) {
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught QueryException while querying" + (Object)((Object)e), (Throwable)e);
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (RegionDestroyedException rde) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a RegionDestroyedException while querying as expected ", (Throwable)rde);
                }
                catch (CancelException cce) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a CancelException while querying as expected ", (Throwable)cce);
                }
                finally {
                    for (int i = 0; i < expectedExceptions.length; ++i) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions[i] + "</ExpectedException>");
                    }
                }
            }
        };
        return PrRegion;
    }

    public Runnable getCacheSerializableRunnableForPRAndRRQueryWithCompactAndRangeIndexAndCompareResults(final String name, final String coloName, final String localName, final String coloLocalName) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRQuery"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String[] queries = new String[]{"r1.ID = pos2.id", "r1.ID = pos2.id AND r1.ID > 5", "r1.ID = pos2.id AND r1.status = 'active'", "r1.ID = pos2.id ORDER BY r1.ID", "r1.ID = pos2.id ORDER BY pos2.id", "r1.ID = pos2.id ORDER BY r2.status", "r1.ID = pos2.id AND r1.status != r2.status", "r1.ID = pos2.id AND r1.status = r2.status", "r1.ID = pos2.id AND r1.positions.size = r2.positions.size", "r1.ID = pos2.id AND r1.positions.size > r2.positions.size", "r1.ID = pos2.id AND r1.positions.size < r2.positions.size", "r1.ID = pos2.id AND r1.positions.size = r2.positions.size AND r2.positions.size > 0", "r1.ID = pos2.id AND (r1.positions.size > r2.positions.size OR r2.positions.size > 0)", "r1.ID = pos2.id AND (r1.positions.size < r2.positions.size OR r1.positions.size > 0)"};
                Object[][] r = new Object[queries.length][2];
                Region region = null;
                region = cache.getRegion(name);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(coloName);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(localName);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(coloLocalName);
                TestCase.assertNotNull((Object)region);
                String[] expectedExceptions = new String[]{RegionDestroyedException.class.getName(), ReplyException.class.getName(), CacheClosedException.class.getName(), ForceReattemptException.class.getName(), QueryInvocationTargetException.class.getName()};
                for (int i = 0; i < expectedExceptions.length; ++i) {
                    PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions[i] + "</ExpectedException>");
                }
                QueryService qs = PRQueryDUnitHelper.this.getCache().getQueryService();
                try {
                    for (int j = 0; j < queries.length; ++j) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("About to execute local query: " + queries[j]);
                        TestQueryFunction func = new TestQueryFunction("testfunction");
                        Object funcResult = FunctionService.onRegion((Region)(PRQueryDUnitHelper.this.getCache().getRegion(name) instanceof PartitionedRegion ? PRQueryDUnitHelper.this.getCache().getRegion(name) : PRQueryDUnitHelper.this.getCache().getRegion(coloName))).withArgs((Object)("<trace> Select " + (queries[j].contains("ORDER BY") ? "DISTINCT" : "") + " * from /" + name + " r1, /" + coloName + " r2, r2.positions.values pos2 where " + queries[j])).execute((Function)func).getResult();
                        r[j][0] = ((ArrayList)funcResult).get(0);
                        PRQueryDUnitHelper.this.getCache().getLogger().info("About to execute local query: " + queries[j]);
                        SelectResults r2 = (SelectResults)qs.newQuery("Select " + (queries[j].contains("ORDER BY") ? "DISTINCT" : "") + " * from /" + localName + " r1, /" + coloLocalName + " r2, r2.positions.values pos2 where " + queries[j]).execute();
                        r[j][1] = r2.asList();
                    }
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Queries Executed successfully on Local region & PR Region");
                    StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                    ssORrs.CompareQueryResultsAsListWithoutAndWithIndexes(r, queries.length, false, false, queries);
                }
                catch (QueryInvocationTargetException e) {
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught QueryException while querying" + (Object)((Object)e), (Throwable)e);
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (RegionDestroyedException rde) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a RegionDestroyedException while querying as expected ", (Throwable)rde);
                }
                catch (CancelException cce) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a CancelException while querying as expected ", (Throwable)cce);
                }
                finally {
                    for (int i = 0; i < expectedExceptions.length; ++i) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions[i] + "</ExpectedException>");
                    }
                }
            }
        };
        return PrRegion;
    }

    public Runnable getCacheSerializableRunnableForRRAndPRQueryAndCompareResults(final String name, final String coloName, final String localName, final String coloLocalName) {
        CacheSerializableRunnable PrRegion = new CacheSerializableRunnable("PRQuery"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Cache cache = PRQueryDUnitHelper.this.getCache();
                String[] queries = new String[]{"r1.ID = r2.id", "r1.ID = r2.id AND r1.ID > 5", "r1.ID = r2.id AND r1.status = 'active'", "r1.ID = r2.id ORDER BY r1.ID", "r1.ID = r2.id ORDER BY r2.id", "r1.ID = r2.id ORDER BY r2.status", "r1.ID = r2.id AND r1.status != r2.status", "r1.ID = r2.id AND r1.status = r2.status", "r1.ID = r2.id AND r1.positions.size = r2.positions.size", "r1.ID = r2.id AND r1.positions.size > r2.positions.size", "r1.ID = r2.id AND r1.positions.size < r2.positions.size", "r1.ID = r2.id AND r1.positions.size = r2.positions.size AND r2.positions.size > 0", "r1.ID = r2.id AND (r1.positions.size > r2.positions.size OR r2.positions.size > 0)", "r1.ID = r2.id AND (r1.positions.size < r2.positions.size OR r1.positions.size > 0)"};
                Object[][] r = new Object[queries.length][2];
                Region region = null;
                region = cache.getRegion(name);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(coloName);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(localName);
                TestCase.assertNotNull((Object)region);
                region = cache.getRegion(coloLocalName);
                TestCase.assertNotNull((Object)region);
                String[] expectedExceptions = new String[]{RegionDestroyedException.class.getName(), ReplyException.class.getName(), CacheClosedException.class.getName(), ForceReattemptException.class.getName(), QueryInvocationTargetException.class.getName()};
                for (int i = 0; i < expectedExceptions.length; ++i) {
                    PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions[i] + "</ExpectedException>");
                }
                QueryService qs = PRQueryDUnitHelper.this.getCache().getQueryService();
                try {
                    for (int j = 0; j < queries.length; ++j) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("About to execute local query: " + queries[j]);
                        TestQueryFunction func = new TestQueryFunction("testfunction");
                        Object funcResult = FunctionService.onRegion((Region)(PRQueryDUnitHelper.this.getCache().getRegion(name) instanceof PartitionedRegion ? PRQueryDUnitHelper.this.getCache().getRegion(name) : PRQueryDUnitHelper.this.getCache().getRegion(coloName))).withArgs((Object)("<trace> Select " + (queries[j].contains("ORDER BY") ? "DISTINCT" : "") + " * from /" + name + " r1, r1.positions.values pos1, /" + coloName + " r2 where " + queries[j])).execute((Function)func).getResult();
                        r[j][0] = ((ArrayList)funcResult).get(0);
                        PRQueryDUnitHelper.this.getCache().getLogger().info("About to execute local query: " + queries[j]);
                        SelectResults r2 = (SelectResults)qs.newQuery("Select " + (queries[j].contains("ORDER BY") ? "DISTINCT" : "") + " * from /" + localName + " r1, r1.positions.values pos1, /" + coloLocalName + " r2 where " + queries[j]).execute();
                        r[j][1] = r2.asList();
                    }
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Queries Executed successfully on Local region & PR Region");
                    StructSetOrResultsSet ssORrs = new StructSetOrResultsSet();
                    ssORrs.CompareQueryResultsAsListWithoutAndWithIndexes(r, queries.length, false, false, queries);
                }
                catch (QueryInvocationTargetException e) {
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (QueryException e) {
                    DistributedTestCase.getLogWriter().error("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught QueryException while querying" + (Object)((Object)e), (Throwable)e);
                    throw new TestException("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught unexpected query exception", e);
                }
                catch (RegionDestroyedException rde) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a RegionDestroyedException while querying as expected ", (Throwable)rde);
                }
                catch (CancelException cce) {
                    DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper#getCacheSerializableRunnableForPRQueryAndCompareResults: Caught a CancelException while querying as expected ", (Throwable)cce);
                }
                finally {
                    for (int i = 0; i < expectedExceptions.length; ++i) {
                        PRQueryDUnitHelper.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions[i] + "</ExpectedException>");
                    }
                }
            }
        };
        return PrRegion;
    }

    public SerializableRunnable getCacheSerializableRunnableForCloseCache() {
        return new SerializableRunnable(){

            @Override
            public void run() {
                CacheTestCase.closeCache();
            }
        };
    }

    public NewPortfolio[] createNewPortfoliosAndPositions(int count) {
        Position.cnt = 0;
        NewPortfolio[] portfolios = new NewPortfolio[count];
        for (int i = 0; i < count; ++i) {
            portfolios[i] = new NewPortfolio("" + i, i);
        }
        return portfolios;
    }

    final class TestQueryFunction
    extends FunctionAdapter {
        private final String id;

        public boolean hasResult() {
            return true;
        }

        public boolean isHA() {
            return false;
        }

        public TestQueryFunction(String id) {
            this.id = id;
        }

        public void execute(FunctionContext context) {
            Cache cache = CacheFactory.getAnyInstance();
            QueryService queryService = cache.getQueryService();
            ArrayList allQueryResults = new ArrayList();
            String qstr = (String)context.getArguments();
            try {
                Query query = queryService.newQuery(qstr);
                context.getResultSender().sendResult((Object)((ArrayList)((SelectResults)query.execute((RegionFunctionContext)context)).asList()));
                context.getResultSender().lastResult(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FunctionException((Throwable)e);
            }
        }

        public String getId() {
            return this.id;
        }
    }

    class PerfResultsObject
    implements Serializable {
        String OperationDescription;
        String Scope = null;
        long QueryingTimeLocal;
        long QueryingTimePR;
        int NumberOfDataStores = 0;
        int NumberOfAccessors = 0;
        int redundancy = 0;

        public PerfResultsObject(PRQueryPerfDUnitTest.ResultsObject prfR) {
            this.OperationDescription = prfR.OperationDescription;
            this.redundancy = prfR.redundancy;
            this.NumberOfAccessors = prfR.NumberOfAccessors;
            this.NumberOfDataStores = prfR.NumberOfDataStores;
        }

        public void displayResults() {
            try {
                DistributedTestCase.getLogWriter().info("PRQueryDUnitHelper:PerfResultsObject#displayResults");
                BufferedWriter out = new BufferedWriter(new FileWriter("PRQueryPerfDUnitTest.txt", true));
                DistributedTestCase.getLogWriter().info("~~~~~~~~~~~~~~~~~~~~~~~PR Querying Performance Results~~~~~~~~~~~~~~~~~~~~~~~");
                out.write("~~~~~~~~~~~~~~~~~~~~~~~PR Querying Performance Results~~~~~~~~~~~~~~~~~~~~~~~\n\n");
                DistributedTestCase.getLogWriter().info(this.OperationDescription);
                out.write("\t" + this.OperationDescription + "\n\n");
                DistributedTestCase.getLogWriter().info("Scope                    : " + this.Scope);
                out.write("Scope                    : " + this.Scope + "\n\n");
                DistributedTestCase.getLogWriter().info("Redundancy Level         : " + this.redundancy);
                out.write("Redundancy Level         : " + this.redundancy + "\n\n");
                DistributedTestCase.getLogWriter().info("Number of Accessor       : " + this.NumberOfAccessors);
                out.write("Number of Accessor       : " + this.NumberOfAccessors + "\n\n");
                DistributedTestCase.getLogWriter().info("Number of Datastore/s    : " + this.NumberOfDataStores);
                out.write("Number of Datastore/s    : " + this.NumberOfDataStores + "\n\n");
                DistributedTestCase.getLogWriter().info("QueryingTime Local       : " + this.QueryingTimeLocal + " ms");
                out.write("QueryingTime Local       : " + this.QueryingTimeLocal + " ms\n\n");
                DistributedTestCase.getLogWriter().info("QueryingTime PR          : " + this.QueryingTimePR + " ms");
                out.write("QueryingTime PR          : " + this.QueryingTimePR + " ms\n");
                DistributedTestCase.getLogWriter().info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                out.write("\n\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n");
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

