/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.partitioned;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.Host;
import dunit.VM;
import junit.framework.TestCase;

public class PRBasicQueryDUnitTest
extends PartitionedRegionDUnitTestCase {
    int totalNumBuckets = 100;
    int queryTestCycle = 10;
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    final String name = "Portfolios";
    final String localName = "LocalPortfolios";
    final int cnt = 0;
    final int cntDest = 50;
    final int redundancy = 0;

    public PRBasicQueryDUnitTest(String name) {
        super(name);
    }

    public void testPRBasicQuerying() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR Test with DACK Started");
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Creating the Accessor node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", 0));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully created the Accessor node in the PR");
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest:testPRBasicQuerying ----- Creating the Datastore node in the PR");
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0));
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created the Datastore node in the PR");
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Successfully Created PR's across all VM's");
        Object[] portfolio = this.PRQHelp.createPortfolioData(0, 50);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 50));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRDuplicatePuts("Portfolios", portfolio, 0, 50));
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 50));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRDuplicatePuts("LocalPortfolios", portfolio, 0, 50));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRQueryAndCompareResults("Portfolios", "LocalPortfolios"));
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRBasicQuerying: Querying PR's Test ENDED");
    }

    public void testPRCountStarQuery() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRCountStarQuery: Querying PR Test with DACK Started");
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRCountStarQuery: Creating the Accessor node in the PR");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", 0, Portfolio.class));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios", Portfolio.class));
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRCountStarQuery: Successfully created the Accessor node in the PR");
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest:testPRCountStarQuery ----- Creating the Datastore node in the PR");
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, Portfolio.class));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, Portfolio.class));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios", Portfolio.class));
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRCountStarQuery: Successfully Created the Datastore node in the PR");
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRCountStarQuery: Successfully Created PR's across all VM's");
        Object[] portfolio = this.PRQHelp.createPortfoliosAndPositions(150);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("Portfolios", portfolio, 0, 150));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRDuplicatePuts("Portfolios", portfolio, 0, 150));
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRCountStarQuery: Inserted Portfolio data across PR's");
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 150));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRDuplicatePuts("LocalPortfolios", portfolio, 0, 150));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPuts("LocalPortfolios", portfolio, 0, 150));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRDuplicatePuts("LocalPortfolios", portfolio, 0, 150));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCountStarQueries("Portfolios", "LocalPortfolios"));
        vm2.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCountStarQueries("Portfolios", "LocalPortfolios"));
        PRBasicQueryDUnitTest.getLogWriter().info("PRQBasicQueryDUnitTest#testPRCountStarQuery: Querying PR's Test ENDED");
    }

    public void testPROrderBy() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRAccessorCreate("Portfolios", 0));
        vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForLocalRegionCreation("LocalPortfolios"));
        vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreate("Portfolios", 0, Portfolio.class));
        vm1.invoke(new CacheSerializableRunnable("Adding portfolios"){

            @Override
            public void run2() {
                Cache cache = PRBasicQueryDUnitTest.this.getCache();
                Region region = cache.getRegion("Portfolios");
                for (int j = 0; j < 100; ++j) {
                    region.put((Object)new Integer(j), (Object)new Portfolio(j));
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Running Query"){

            @Override
            public void run2() {
                try {
                    QueryService qs = null;
                    qs = PRBasicQueryDUnitTest.this.getCache().getQueryService();
                    Index d = qs.createIndex("index", IndexType.FUNCTIONAL, "ID", "/Portfolios");
                    for (int i = 0; i < 100; ++i) {
                        Query query = qs.newQuery("SELECT DISTINCT * FROM /Portfolios WHERE ID >= " + i + " ORDER BY ID asc LIMIT 1");
                        SelectResults results = (SelectResults)query.execute();
                        int expectedValue = i;
                        for (Object o : results) {
                            Portfolio p = (Portfolio)o;
                            assert (p.getID() == expectedValue++);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestCase.fail((String)("exception:" + e));
                }
            }
        });
    }
}

