/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.partitioned;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.index.IndexUtils;
import com.gemstone.gemfire.cache.query.partitioned.PRQueryDUnitHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.io.File;

public class PRBasicIndexCreationDeadlockDUnitTest
extends PartitionedRegionDUnitTestCase {
    int queryTestCycle = 10;
    PRQueryDUnitHelper PRQHelp = new PRQueryDUnitHelper("");
    final String name = "PartionedPortfolios";
    final String localName = "LocalPortfolios";
    final int cnt = 0;
    final int cntDest = 1003;
    final int redundancy = 0;
    public static volatile boolean hook_vm1;
    public static volatile boolean hook_vm2;

    public PRBasicIndexCreationDeadlockDUnitTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexCreationMessageDiskRecoveryDeadLock() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        Class<Portfolio> valueConstraint = Portfolio.class;
        String fileName1 = "PRPersistentIndexCreation_1.xml";
        String fileName2 = "PRPersistentIndexCreation_2.xml";
        final File dir1 = new File("overflowData1");
        final File dir2 = new File("overflowData2");
        AsyncInvocation[] asyns = new AsyncInvocation[3];
        try {
            vm0.invoke(new CacheSerializableRunnable("Create disk store directories"){

                @Override
                public void run2() throws CacheException {
                    boolean success = dir1.mkdir();
                    success = dir2.mkdir();
                }
            });
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateThrougXML("PartionedPortfolios", "PRPersistentIndexCreation_1.xml"));
            vm1.invoke(this.PRQHelp.getCacheSerializableRunnableForPRCreateThrougXML("PartionedPortfolios", "PRPersistentIndexCreation_2.xml"));
            Object[] portfoliosAndPositions = this.PRQHelp.createPortfoliosAndPositions(100);
            vm0.invoke(this.PRQHelp.getCacheSerializableRunnableForPRPutsKeyValue("PartionedPortfolios", portfoliosAndPositions, 0, 100));
            vm0.invoke(new CacheSerializableRunnable("Close VM0 cache"){

                @Override
                public void run2() throws CacheException {
                    GemFireCacheImpl.getInstance().close();
                }
            });
            vm1.invoke(new CacheSerializableRunnable("Close VM1 cache"){

                @Override
                public void run2() throws CacheException {
                    GemFireCacheImpl.getInstance().close();
                }
            });
            asyns[0] = vm0.invokeAsync(new CacheSerializableRunnable("Restart VM0 cache"){

                @Override
                public void run2() throws CacheException {
                    GemFireCacheImpl.testCacheXml = PRBasicIndexCreationDeadlockDUnitTest.this.PRQHelp.findFile("PRPersistentIndexCreation_1.xml");
                    IndexUtils.testHook = new IndexUtilTestHook();
                    PRBasicIndexCreationDeadlockDUnitTest.this.PRQHelp.getCache();
                }
            });
            vm0.invoke(new CacheSerializableRunnable("Checking hook in VM0 cache"){

                @Override
                public void run2() throws CacheException {
                    IndexUtilTestHook hook = (IndexUtilTestHook)IndexUtils.testHook;
                    while (hook == null) {
                        hook = (IndexUtilTestHook)IndexUtils.testHook;
                        DistributedTestCase.pause(20);
                    }
                    while (!hook.isHooked()) {
                        DistributedTestCase.pause(30);
                    }
                    hook.setHooked(false);
                    hook_vm1 = true;
                }
            });
            asyns[1] = vm1.invokeAsync(new CacheSerializableRunnable("Restart VM1 cache"){

                @Override
                public void run2() throws CacheException {
                    GemFireCacheImpl.testCacheXml = PRBasicIndexCreationDeadlockDUnitTest.this.PRQHelp.findFile("PRPersistentIndexCreation_2.xml");
                    PRBasicIndexCreationDeadlockDUnitTest.this.PRQHelp.getCache();
                }
            });
            asyns[2] = vm0.invokeAsync(new CacheSerializableRunnable("Checking hook in VM0 cache again"){

                @Override
                public void run2() throws CacheException {
                    IndexUtilTestHook hook = (IndexUtilTestHook)IndexUtils.testHook;
                    while (hook == null || !hook_vm1) {
                        hook = (IndexUtilTestHook)IndexUtils.testHook;
                        DistributedTestCase.pause(20);
                    }
                    while (!hook.isHooked()) {
                        DistributedTestCase.pause(30);
                    }
                    if (hook.isHooked() && hook_vm1) {
                        hook.setHooked(false);
                        hook_vm2 = true;
                    }
                }
            });
            AsyncInvocation[] asyncInvocationArray = asyns;
            int n = asyncInvocationArray.length;
            for (int i = 0; i < n; ++i) {
                AsyncInvocation async = asyncInvocationArray[i];
                DistributedTestCase.join(async, 10000L, null);
            }
            vm0.invoke(new CacheSerializableRunnable("Close VM0 cache", dir1, dir2){
                final /* synthetic */ File val$dir1;
                final /* synthetic */ File val$dir2;
                {
                    this.val$dir1 = file;
                    this.val$dir2 = file2;
                    super(name);
                }

                @Override
                public void run2() throws CacheException {
                    this.val$dir1.delete();
                    this.val$dir2.delete();
                    IndexUtils.testHook = null;
                }
            });
        }
        catch (Throwable throwable) {
            vm0.invoke(new /* invalid duplicate definition of identical inner class */);
            for (AsyncInvocation async : asyns) {
                DistributedTestCase.join(async, 10000L, null);
            }
            for (AsyncInvocation async : asyns) {
                if (!async.exceptionOccurred()) continue;
                PRBasicIndexCreationDeadlockDUnitTest.fail((String)("Exception occured: " + async.getException()));
            }
            throw throwable;
        }
        for (AsyncInvocation async : asyns) {
            DistributedTestCase.join(async, 10000L, null);
        }
        for (AsyncInvocation async : asyns) {
            if (!async.exceptionOccurred()) continue;
            PRBasicIndexCreationDeadlockDUnitTest.fail((String)("Exception occured: " + async.getException()));
        }
    }

    public class IndexUtilTestHook
    implements IndexManager.TestHook {
        private boolean hooked = false;

        public void setHooked(boolean hooked) {
            this.hooked = hooked;
        }

        public boolean isHooked() {
            return this.hooked;
        }

        public synchronized void hook(int spot) throws RuntimeException {
            GemFireCacheImpl.getInstance().getLogger().fine("IndexUtilTestHook is set");
            switch (spot) {
                case 0: {
                    this.hooked = true;
                    while (this.hooked) {
                        DistributedTestCase.pause(300);
                    }
                    DistributedTestCase.pause(1000);
                    break;
                }
            }
        }
    }
}

