/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.dunit;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryExecutionTimeoutException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryDUnitTest;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public class QueryMonitorDUnitTest
extends CacheTestCase {
    private static int bridgeServerPort;
    private final String exampleRegionName = "exampleRegion";
    private final String exampleRegionName2 = "exampleRegion2";
    private final String poolName = "serverConnectionPool";
    String[] queryStr = new String[]{"SELECT ID FROM /root/exampleRegion p WHERE  p.ID > 100", "SELECT * FROM /root/exampleRegion WHERE  ID > 100 and status = 'active'", "SELECT DISTINCT * FROM /root/exampleRegion p, (SELECT DISTINCT pos FROM /root/exampleRegion x, x.positions.values pos WHERE  x.ID = p.ID) as itrX", "SELECT DISTINCT * FROM /root/exampleRegion p, /root/exampleRegion2 p2 WHERE  p.status = 'active'", "SELECT p.ID FROM /root/exampleRegion p, /root/exampleRegion2 p2 WHERE  p.ID = p2.ID and p.status = 'active' and p2.status = 'active'", "SELECT DISTINCT p.ID FROM /root/exampleRegion p, /root/exampleRegion2 p2 WHERE  p.ID = p2.ID and p.ID > 100 and p2.ID < 100000", "SELECT p.ID FROM /root/exampleRegion p, /root/exampleRegion2 p2 WHERE  p.ID = p2.ID and p.ID > 100 and p2.ID < 100000 or p.status = 'active'", "SELECT DISTINCT * FROM /root/exampleRegion p, p.positions.values outerPos, (SELECT DISTINCT key: key, sos: pos.sharesOutstanding FROM /root/exampleRegion.entries pf, pf.value.positions.values pos where outerPos.secId != 'IBM' AND pf.key IN (SELECT DISTINCT * FROM pf.value.collectionHolderMap['0'].arr)) structset where structset.sos > 2000"};
    String[] prQueryStr = new String[]{"SELECT ID FROM /root/exampleRegion p WHERE  p.ID > 100 and p.status = 'active'", "SELECT * FROM /root/exampleRegion WHERE  ID > 100 and status = 'active'", "SELECT DISTINCT * FROM /root/exampleRegion p WHERE   p.ID > 100 and p.status = 'active' and p.ID < 100000", "SELECT DISTINCT p.ID FROM /root/exampleRegion p WHERE p.ID > 100 and p.ID < 100000 and p.status = 'active'", "SELECT DISTINCT * FROM /root/exampleRegion p, positions.values pos WHERE (p.ID > 1 or p.status = 'active') or (pos.secId != 'IBM')"};
    protected CqQueryDUnitTest cqDUnitTest = new CqQueryDUnitTest("CqDataDUnitTest");

    public QueryMonitorDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        QueryMonitorDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                QueryMonitorDUnitTest.this.getSystem();
            }
        });
    }

    public void createRegion(VM vm) {
        this.createRegion(vm, false, null);
    }

    public void createRegion(VM vm, final boolean eviction, final String dirName) {
        vm.invoke(new CacheSerializableRunnable("Create Regions"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                factory.setDataPolicy(DataPolicy.REPLICATE);
                if (eviction) {
                    File[] f = new File[]{new File(dirName)};
                    f[0].mkdir();
                    DiskStoreFactory dsf = GemFireCacheImpl.getInstance().createDiskStoreFactory();
                    DiskStore ds1 = dsf.setDiskDirs(f).create("ds1");
                    factory.setDiskStoreName("ds1");
                    EvictionAttributes evictAttrs = EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
                    factory.setEvictionAttributes(evictAttrs);
                }
                QueryMonitorDUnitTest.this.createRegion("exampleRegion", factory.create());
                QueryMonitorDUnitTest.this.createRegion("exampleRegion2", factory.create());
            }
        });
    }

    public void createPRRegion(VM vm) {
        vm.invoke(new CacheSerializableRunnable("Create Regions"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(8).create());
                QueryMonitorDUnitTest.this.createRegion("exampleRegion", factory.create());
                QueryMonitorDUnitTest.this.createRegion("exampleRegion2", factory.create());
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                exampleRegion.getCache().getLogger().fine("#### CREATING PR REGION....");
            }
        });
    }

    public void configServer(VM server, final int queryMonitorTime, final String testName) {
        CacheSerializableRunnable initServer = new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                try {
                    QueryMonitorDUnitTest.this.startBridgeServer(0, false);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
                DistributedTestCase.pause(1000);
                Cache cache = QueryMonitorDUnitTest.this.getCache();
                GemFireCacheImpl.getInstance().TEST_MAX_QUERY_EXECUTION_TIME = queryMonitorTime;
                cache.getLogger().fine("#### RUNNING TEST : " + testName);
                DefaultQuery.testHook = new QueryTimeoutHook(queryMonitorTime);
                System.out.println("MAX_QUERY_EXECUTION_TIME is set to: " + ((GemFireCacheImpl)cache).TEST_MAX_QUERY_EXECUTION_TIME);
            }
        };
        server.invoke(initServer);
    }

    public void stopServer(VM server) {
        SerializableRunnable stopServer = new SerializableRunnable("Stop CacheServer"){

            @Override
            public void run() {
                Cache cache = QueryMonitorDUnitTest.this.getCache();
                DefaultQuery.testHook = null;
                GemFireCacheImpl.getInstance().TEST_MAX_QUERY_EXECUTION_TIME = -1;
                QueryMonitorDUnitTest.this.stopBridgeServer(QueryMonitorDUnitTest.this.getCache());
                System.out.println("MAX_QUERY_EXECUTION_TIME is set to: " + ((GemFireCacheImpl)cache).TEST_MAX_QUERY_EXECUTION_TIME);
            }
        };
        server.invoke(stopServer);
    }

    public void configClient(VM client, VM[] server) {
        final int[] port = new int[server.length];
        for (int i = 0; i < server.length; ++i) {
            port[i] = server[i].invokeInt(QueryMonitorDUnitTest.class, "getCacheServerPort");
        }
        final String host0 = QueryMonitorDUnitTest.getServerHostName(server[0].getHost());
        CacheSerializableRunnable initClient = new CacheSerializableRunnable("Init client"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.LOCAL);
                PoolFactory poolFactory = PoolManager.createFactory();
                poolFactory.setReadTimeout(600000);
                BridgeTestCase.configureConnectionPoolWithNameAndFactory(factory, host0, port, true, -1, -1, null, "serverConnectionPool", poolFactory);
            }
        };
        client.invoke(initClient);
    }

    public void verifyException(Exception e) {
        e.printStackTrace();
        String error = e.getMessage();
        if (e.getCause() != null) {
            error = e.getCause().getMessage();
        }
        if (error.contains("Query execution cancelled after exceeding max execution time") || error.contains("The Query completed sucessfully before it got canceled") || error.contains("The QueryMonitor thread may be sleeping longer than the set sleep time")) {
            return;
        }
        System.out.println("UnExpected exception:");
        if (e.getCause() != null) {
            e.getCause().printStackTrace();
        } else {
            e.printStackTrace();
        }
        QueryMonitorDUnitTest.fail((String)("Expected exception Not found. Expected exception with message: \n\"Query execution taking more than the max execution time\"\n Found \n" + error));
    }

    public void testQueryMonitorClientServer() throws CacheException {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        VM client3 = host.getVM(3);
        int numberOfEntries = 800;
        this.configServer(server, 40, "testQueryMonitorClientServer");
        this.createRegion(server);
        server.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (i = 101; i <= 900; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
                for (i = 101; i <= 200; ++i) {
                    exampleRegion2.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        this.configClient(client1, new VM[]{server});
        this.createRegion(client1);
        this.configClient(client2, new VM[]{server});
        this.createRegion(client2);
        this.configClient(client3, new VM[]{server});
        this.createRegion(client3);
        CacheSerializableRunnable executeQuery = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                try {
                    Pool pool = PoolManager.find((String)"serverConnectionPool");
                    QueryService queryService = pool.getQueryService();
                    for (int k = 0; k < QueryMonitorDUnitTest.this.queryStr.length; ++k) {
                        String qStr = QueryMonitorDUnitTest.this.queryStr[k];
                        try {
                            GemFireCacheImpl.getInstance().getLogger().fine("Executing query :" + qStr);
                            Query query = queryService.newQuery(qStr);
                            query.execute();
                            TestCase.fail((String)("The query should have been canceled by the QueryMonitor. Query: " + qStr));
                            continue;
                        }
                        catch (Exception e) {
                            QueryMonitorDUnitTest.this.verifyException(e);
                        }
                    }
                }
                catch (Exception ex) {
                    GemFireCacheImpl.getInstance().getLogger().fine("Exception creating the query service", (Throwable)ex);
                }
            }
        };
        client1.invoke(executeQuery);
        client2.invoke(executeQuery);
        client3.invoke(executeQuery);
        this.stopServer(server);
    }

    public void testQueryMonitorMultiClientMultiServer() throws CacheException {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        int numberOfEntries = 800;
        this.configServer(server1, 40, "testQueryMonitorMultiClientMultiServer");
        this.createRegion(server1);
        this.configServer(server2, 40, "testQueryMonitorMultiClientMultiServer");
        this.createRegion(server2);
        server1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (i = 101; i <= 900; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
                for (i = 101; i <= 200; ++i) {
                    exampleRegion2.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (i = 101; i <= 900; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
                for (i = 101; i <= 200; ++i) {
                    exampleRegion2.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        this.configClient(client1, new VM[]{server1, server2});
        this.createRegion(client1);
        this.configClient(client2, new VM[]{server1, server2});
        this.createRegion(client2);
        CacheSerializableRunnable executeQuery = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                try {
                    Pool pool = PoolManager.find((String)"serverConnectionPool");
                    QueryService queryService = pool.getQueryService();
                    for (int k = 0; k < QueryMonitorDUnitTest.this.queryStr.length; ++k) {
                        String qStr = QueryMonitorDUnitTest.this.queryStr[k];
                        try {
                            GemFireCacheImpl.getInstance().getLogger().fine("Executing query :" + qStr);
                            Query query = queryService.newQuery(qStr);
                            query.execute();
                            TestCase.fail((String)("The query should have been canceled by the QueryMonitor. Query: " + qStr));
                            continue;
                        }
                        catch (Exception e) {
                            QueryMonitorDUnitTest.this.verifyException(e);
                        }
                    }
                }
                catch (Exception ex) {
                    GemFireCacheImpl.getInstance().getLogger().fine("Exception creating the query service", (Throwable)ex);
                }
            }
        };
        client1.invoke(executeQuery);
        client2.invoke(executeQuery);
        this.stopServer(server1);
        this.stopServer(server2);
    }

    public void testQueryExecutionLocally() throws CacheException {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        int numberOfEntries = 800;
        this.configServer(server1, 40, "testQueryExecutionLocally");
        this.createRegion(server1);
        this.configServer(server2, 40, "testQueryExecutionLocally");
        this.createRegion(server2);
        server1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (i = 101; i <= 900; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
                for (i = 101; i <= 200; ++i) {
                    exampleRegion2.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (i = 101; i <= 900; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
                for (i = 101; i <= 200; ++i) {
                    exampleRegion2.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        CacheSerializableRunnable executeQuery = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                try {
                    QueryService queryService = GemFireCacheImpl.getInstance().getQueryService();
                    for (int k = 0; k < QueryMonitorDUnitTest.this.queryStr.length; ++k) {
                        String qStr = QueryMonitorDUnitTest.this.queryStr[k];
                        try {
                            GemFireCacheImpl.getInstance().getLogger().fine("Executing query :" + qStr);
                            Query query = queryService.newQuery(qStr);
                            query.execute();
                            TestCase.fail((String)("The query should have been canceled by the QueryMonitor. Query: " + qStr));
                            continue;
                        }
                        catch (Exception e) {
                            QueryMonitorDUnitTest.this.verifyException(e);
                        }
                    }
                }
                catch (Exception ex) {
                    GemFireCacheImpl.getInstance().getLogger().fine("Exception creating the query service", (Throwable)ex);
                }
            }
        };
        server1.invoke(executeQuery);
        server2.invoke(executeQuery);
        this.stopServer(server1);
        this.stopServer(server2);
    }

    public void testQueryExecutionLocallyAndCacheOp() throws CacheException {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        int numberOfEntries = 8000;
        this.configServer(server1, 40, "testQueryExecutionLocally");
        this.createRegion(server1);
        this.configServer(server2, 40, "testQueryExecutionLocally");
        this.createRegion(server2);
        server1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (i = 101; i <= 8100; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
                for (i = 101; i <= 200; ++i) {
                    exampleRegion2.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (i = 101; i <= 8100; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
                for (i = 101; i <= 200; ++i) {
                    exampleRegion2.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        CacheSerializableRunnable executeQuery = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                try {
                    QueryService queryService = GemFireCacheImpl.getInstance().getQueryService();
                    String qStr = "SELECT DISTINCT * FROM /root/exampleRegion p, (SELECT DISTINCT pos FROM /root/exampleRegion x, x.positions.values pos WHERE  x.ID = p.ID) as itrX";
                    try {
                        GemFireCacheImpl.getInstance().getLogger().fine("Executing query :" + qStr);
                        Query query = queryService.newQuery(qStr);
                        query.execute();
                        TestCase.fail((String)("The query should have been canceled by the QueryMonitor. Query: " + qStr));
                    }
                    catch (Exception e) {
                        QueryMonitorDUnitTest.this.verifyException(e);
                    }
                    queryService.createIndex("idIndex", IndexType.FUNCTIONAL, "ID", "/root/exampleRegion");
                    queryService.createIndex("statusIndex", IndexType.FUNCTIONAL, "status", "/root/exampleRegion");
                    Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                    for (int i = 101; i <= 8200; ++i) {
                        exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                    }
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("Exception creating the query service", ex);
                }
            }
        };
        server1.invoke(executeQuery);
        server2.invoke(executeQuery);
        this.stopServer(server1);
        this.stopServer(server2);
    }

    public void testQueryMonitorOnPR() throws CacheException {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        int numberOfEntries = 800;
        this.configServer(server1, 200, "testQueryMonitorMultiClientMultiServerOnPR");
        this.createPRRegion(server1);
        this.configServer(server2, 50, "testQueryMonitorMultiClientMultiServerOnPR");
        this.createPRRegion(server2);
        QueryMonitorDUnitTest.pause(1000);
        server1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (int i = 101; i <= 900; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (int i = 900; i <= 1700; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        this.configClient(client1, new VM[]{server1});
        this.createRegion(client1);
        this.configClient(client2, new VM[]{server2});
        this.createRegion(client2);
        CacheSerializableRunnable executeQuery = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                try {
                    Pool pool = PoolManager.find((String)"serverConnectionPool");
                    QueryService queryService = pool.getQueryService();
                    for (int k = 0; k < QueryMonitorDUnitTest.this.prQueryStr.length; ++k) {
                        String qStr = QueryMonitorDUnitTest.this.prQueryStr[k];
                        try {
                            GemFireCacheImpl.getInstance().getLogger().fine("Executing query :" + qStr);
                            Query query = queryService.newQuery(qStr);
                            query.execute();
                            TestCase.fail((String)("The query should have been canceled by the QueryMonitor. Query: " + qStr));
                            continue;
                        }
                        catch (Exception e) {
                            QueryMonitorDUnitTest.this.verifyException(e);
                        }
                    }
                }
                catch (Exception ex) {
                    GemFireCacheImpl.getInstance().getLogger().fine("Exception creating the query service", (Throwable)ex);
                }
            }
        };
        client1.invoke(executeQuery);
        client2.invoke(executeQuery);
        this.stopServer(server1);
        this.stopServer(server2);
    }

    public void testQueryMonitorWithLocalQueryOnPR() throws CacheException {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        int numberOfEntries = 800;
        this.configServer(server1, 200, "testQueryMonitorMultiClientMultiServerOnPR");
        this.createPRRegion(server1);
        this.configServer(server2, 50, "testQueryMonitorMultiClientMultiServerOnPR");
        this.createPRRegion(server2);
        QueryMonitorDUnitTest.pause(1000);
        server1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (int i = 101; i <= 900; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (int i = 900; i <= 1700; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        CacheSerializableRunnable executeQuery = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                try {
                    QueryService queryService = GemFireCacheImpl.getInstance().getQueryService();
                    for (int k = 0; k < QueryMonitorDUnitTest.this.prQueryStr.length; ++k) {
                        String qStr = QueryMonitorDUnitTest.this.prQueryStr[k];
                        try {
                            GemFireCacheImpl.getInstance().getLogger().fine("Executing query :" + qStr);
                            Query query = queryService.newQuery(qStr);
                            query.execute();
                            TestCase.fail((String)("The query should have been canceled by the QueryMonitor. Query: " + qStr));
                            continue;
                        }
                        catch (Exception e) {
                            QueryMonitorDUnitTest.this.verifyException(e);
                        }
                    }
                }
                catch (Exception ex) {
                    GemFireCacheImpl.getInstance().getLogger().fine("Exception creating the query service", (Throwable)ex);
                }
            }
        };
        server1.invoke(executeQuery);
        server2.invoke(executeQuery);
        this.stopServer(server1);
        this.stopServer(server2);
    }

    public void BUG46770WORKAROUNDtestQueryMonitorRegionWithEviction() throws CacheException {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        int numberOfEntries = 800;
        this.configServer(server1, 5000, "testQueryMonitorRegionWithEviction");
        this.createRegion(server1, true, "server1_testQueryMonitorRegionWithEviction");
        this.configServer(server2, 5000, "testQueryMonitorRegionWithEviction");
        this.createRegion(server2, true, "server2_testQueryMonitorRegionWithEviction");
        QueryMonitorDUnitTest.pause(1000);
        server1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (int i = 101; i <= 900; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                for (int i = 900; i <= 1700; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        this.configClient(client1, new VM[]{server1});
        this.createRegion(client1);
        this.configClient(client2, new VM[]{server2});
        this.createRegion(client2);
        CacheSerializableRunnable executeQuery = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                try {
                    Pool pool = PoolManager.find((String)"serverConnectionPool");
                    QueryService queryService = pool.getQueryService();
                    for (int k = 0; k < QueryMonitorDUnitTest.this.prQueryStr.length; ++k) {
                        String qStr = QueryMonitorDUnitTest.this.prQueryStr[k];
                        try {
                            GemFireCacheImpl.getInstance().getLogger().fine("Executing query :" + qStr);
                            Query query = queryService.newQuery(qStr);
                            query.execute();
                            TestCase.fail((String)("The query should have been canceled by the QueryMonitor. Query: " + qStr));
                            continue;
                        }
                        catch (Exception e) {
                            QueryMonitorDUnitTest.this.verifyException(e);
                        }
                    }
                }
                catch (Exception ex) {
                    GemFireCacheImpl.getInstance().getLogger().fine("Exception creating the query service", (Throwable)ex);
                }
            }
        };
        client1.invoke(executeQuery);
        client2.invoke(executeQuery);
        this.stopServer(server1);
        this.stopServer(server2);
    }

    public void testQueryMonitorRegionWithIndex() throws CacheException {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        int numberOfEntries = 800;
        this.configServer(server1, 40, "testQueryMonitorRegionWithIndex");
        this.createRegion(server1);
        this.configServer(server2, 40, "testQueryMonitorRegionWithIndex");
        this.createRegion(server2);
        QueryMonitorDUnitTest.pause(1000);
        server1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                try {
                    QueryService cacheQS = GemFireCacheImpl.getInstance().getQueryService();
                    cacheQS.createIndex("idIndex", IndexType.FUNCTIONAL, "p.ID", "/root/exampleRegion p");
                    cacheQS.createIndex("statusIndex", IndexType.FUNCTIONAL, "p.status", "/root/exampleRegion p");
                    cacheQS.createIndex("secIdIndex", IndexType.FUNCTIONAL, "pos.secId", "/root/exampleRegion p, p.positions.values pos");
                    cacheQS.createIndex("posIdIndex", IndexType.FUNCTIONAL, "pos.Id", "/root/exampleRegion p, p.positions.values pos");
                    cacheQS.createIndex("pkIndex", IndexType.PRIMARY_KEY, "pk", "/root/exampleRegion");
                    cacheQS.createIndex("pkidIndex", IndexType.PRIMARY_KEY, "pkid", "/root/exampleRegion");
                    cacheQS.createIndex("idIndex2", IndexType.FUNCTIONAL, "p2.ID", "/root/exampleRegion2 p2");
                    cacheQS.createIndex("statusIndex2", IndexType.FUNCTIONAL, "p2.status", "/root/exampleRegion2 p2");
                    cacheQS.createIndex("secIdIndex2", IndexType.FUNCTIONAL, "pos.secId", "/root/exampleRegion2 p2, p2.positions.values pos");
                    cacheQS.createIndex("posIdIndex2", IndexType.FUNCTIONAL, "pos.Id", "/root/exampleRegion2 p2, p2.positions.values pos");
                    cacheQS.createIndex("pkIndex2", IndexType.PRIMARY_KEY, "pk", "/root/exampleRegion2");
                    cacheQS.createIndex("pkidIndex2", IndexType.PRIMARY_KEY, "pkid", "/root/exampleRegion2");
                }
                catch (Exception cacheQS) {
                    // empty catch block
                }
                for (i = 101; i <= 900; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
                for (i = 101; i <= 300; ++i) {
                    exampleRegion2.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        server2.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                Region exampleRegion2 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion2");
                try {
                    QueryService cacheQS = GemFireCacheImpl.getInstance().getQueryService();
                    cacheQS.createIndex("idIndex", IndexType.FUNCTIONAL, "p.ID", "/root/exampleRegion p");
                    cacheQS.createIndex("statusIndex", IndexType.FUNCTIONAL, "p.status", "/root/exampleRegion p");
                    cacheQS.createIndex("secIdIndex", IndexType.FUNCTIONAL, "pos.secId", "/root/exampleRegion p, p.positions.values pos");
                    cacheQS.createIndex("posIdIndex", IndexType.FUNCTIONAL, "pos.Id", "/root/exampleRegion p, p.positions.values pos");
                    cacheQS.createIndex("pkIndex", IndexType.PRIMARY_KEY, "pk", "/root/exampleRegion");
                    cacheQS.createIndex("pkidIndex", IndexType.PRIMARY_KEY, "pkid", "/root/exampleRegion");
                    cacheQS.createIndex("idIndex2", IndexType.FUNCTIONAL, "p2.ID", "/root/exampleRegion2 p2");
                    cacheQS.createIndex("statusIndex2", IndexType.FUNCTIONAL, "p2.status", "/root/exampleRegion2 p2");
                    cacheQS.createIndex("secIdIndex2", IndexType.FUNCTIONAL, "pos.secId", "/root/exampleRegion2 p2, p2.positions.values pos");
                    cacheQS.createIndex("posIdIndex2", IndexType.FUNCTIONAL, "pos.Id", "/root/exampleRegion2 p2, p2.positions.values pos");
                    cacheQS.createIndex("pkIndex2", IndexType.PRIMARY_KEY, "pk", "/root/exampleRegion2");
                    cacheQS.createIndex("pkidIndex2", IndexType.PRIMARY_KEY, "pkid", "/root/exampleRegion2");
                }
                catch (Exception cacheQS) {
                    // empty catch block
                }
                for (i = 101; i <= 900; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
                for (i = 101; i <= 300; ++i) {
                    exampleRegion2.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        this.configClient(client1, new VM[]{server1});
        this.createRegion(client1);
        this.configClient(client2, new VM[]{server2});
        this.createRegion(client2);
        CacheSerializableRunnable executeQuery = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                try {
                    Pool pool = PoolManager.find((String)"serverConnectionPool");
                    QueryService queryService = pool.getQueryService();
                    for (int k = 0; k < QueryMonitorDUnitTest.this.queryStr.length; ++k) {
                        String qStr = QueryMonitorDUnitTest.this.queryStr[k];
                        try {
                            GemFireCacheImpl.getInstance().getLogger().fine("Executing query :" + qStr);
                            Query query = queryService.newQuery(qStr);
                            query.execute();
                            TestCase.fail((String)("The query should have been canceled by the QueryMonitor. Query: " + qStr));
                            continue;
                        }
                        catch (Exception e) {
                            QueryMonitorDUnitTest.this.verifyException(e);
                        }
                    }
                }
                catch (Exception ex) {
                    GemFireCacheImpl.getInstance().getLogger().fine("Exception creating the query service", (Throwable)ex);
                }
            }
        };
        client1.invoke(executeQuery);
        client2.invoke(executeQuery);
        this.stopServer(server1);
        this.stopServer(server2);
    }

    public void testCQWithDestroysAndInvalidates() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        VM producer = host.getVM(2);
        this.cqDUnitTest.createServer(server, 0, true);
        int port = server.invokeInt(CqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = QueryMonitorDUnitTest.getServerHostName(server.getHost());
        this.cqDUnitTest.createClient(client, port, host0);
        this.cqDUnitTest.createClient(producer, port, host0);
        int size = 10;
        String name = "testQuery_4";
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 10);
        this.cqDUnitTest.createCQ(client, "testQuery_4", this.cqDUnitTest.cqs[4]);
        this.cqDUnitTest.executeCQ(client, "testQuery_4", true, null);
        server.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Cache cache = QueryMonitorDUnitTest.this.getCache();
                System.out.println("TEST CQ MAX_QUERY_EXECUTION_TIME is set to: " + ((GemFireCacheImpl)cache).TEST_MAX_QUERY_EXECUTION_TIME);
                Region region1 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion(QueryMonitorDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 5; ++i) {
                    region1.destroy((Object)("key-" + i));
                }
            }
        });
        for (i = 1; i <= 5; ++i) {
            this.cqDUnitTest.waitForDestroyed(client, "testQuery_4", "key-" + i);
        }
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 5);
        for (i = 1; i <= 5; ++i) {
            this.cqDUnitTest.waitForCreated(client, "testQuery_4", "key-" + i);
        }
        this.cqDUnitTest.createValues(server, this.cqDUnitTest.regions[0], 10);
        server.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Cache cache = QueryMonitorDUnitTest.this.getCache();
                System.out.println("TEST CQ MAX_QUERY_EXECUTION_TIME is set to: " + ((GemFireCacheImpl)cache).TEST_MAX_QUERY_EXECUTION_TIME);
                Region region1 = QueryMonitorDUnitTest.this.getRootRegion().getSubregion(QueryMonitorDUnitTest.this.cqDUnitTest.regions[0]);
                for (int i = 1; i <= 5; ++i) {
                    region1.invalidate((Object)("key-" + i));
                }
            }
        });
        for (i = 1; i <= 5; ++i) {
            this.cqDUnitTest.waitForInvalidated(client, "testQuery_4", "key-" + i);
        }
        this.cqDUnitTest.closeClient(client);
        this.cqDUnitTest.closeServer(server);
    }

    public void testCacheOpAfterQueryCancel() throws CacheException {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM server4 = host.getVM(3);
        int numberOfEntries = 8000;
        this.configServer(server1, 5, "testQueryExecutionLocally");
        this.createPRRegion(server1);
        this.configServer(server2, 5, "testQueryExecutionLocally");
        this.createPRRegion(server2);
        this.configServer(server3, 5, "testQueryExecutionLocally");
        this.createPRRegion(server3);
        this.configServer(server4, 5, "testQueryExecutionLocally");
        this.createPRRegion(server4);
        server1.invoke(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                try {
                    QueryService queryService = GemFireCacheImpl.getInstance().getQueryService();
                    queryService.createIndex("statusIndex", IndexType.FUNCTIONAL, "status", "/root/exampleRegion");
                    queryService.createIndex("secIdIndex", IndexType.FUNCTIONAL, "pos.secId", "/root/exampleRegion p, p.positions.values pos");
                }
                catch (Exception ex) {
                    TestCase.fail((String)"Failed to create index.");
                }
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                for (int i = 100; i <= 8000; ++i) {
                    exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                }
            }
        });
        AsyncInvocation ai1 = server1.invokeAsync(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                for (int j = 0; j < 5; ++j) {
                    for (int i = 1; i <= 9000; ++i) {
                        exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                    }
                }
                DistributedTestCase.getLogWriter().info("### Completed updates in server1 in testCacheOpAfterQueryCancel");
            }
        });
        AsyncInvocation ai2 = server2.invokeAsync(new CacheSerializableRunnable("Create Bridge Server"){

            @Override
            public void run2() throws CacheException {
                Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                for (int j = 0; j < 5; ++j) {
                    for (int i = 1001; i <= 10000; ++i) {
                        exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                    }
                }
                DistributedTestCase.getLogWriter().info("### Completed updates in server2 in testCacheOpAfterQueryCancel");
            }
        });
        CacheSerializableRunnable executeQuery = new CacheSerializableRunnable("Execute queries"){

            @Override
            public void run2() throws CacheException {
                try {
                    Region exampleRegion = QueryMonitorDUnitTest.this.getRootRegion().getSubregion("exampleRegion");
                    QueryService queryService = GemFireCacheImpl.getInstance().getQueryService();
                    String qStr = "SELECT DISTINCT * FROM /root/exampleRegion p, p.positions.values pos1, p.positions.values pos where p.ID < pos.sharesOutstanding OR p.ID > 0 OR p.position1.mktValue > 0  OR pos.secId in SET ('SUN', 'IBM', 'YHOO', 'GOOG', 'MSFT',  'AOL', 'APPL', 'ORCL', 'SAP', 'DELL', 'RHAT', 'NOVL', 'HP') order by p.status, p.ID desc";
                    for (int i = 0; i < 500; ++i) {
                        try {
                            GemFireCacheImpl.getInstance().getLogger().info("Executing query :" + qStr);
                            Query query = queryService.newQuery(qStr);
                            query.execute();
                            continue;
                        }
                        catch (QueryExecutionTimeoutException qet) {
                            DistributedTestCase.getLogWriter().info("### Got Expected QueryExecutionTimeout exception. " + qet.getMessage());
                            if (!qet.getMessage().contains("cancelled after exceeding max execution")) continue;
                            DistributedTestCase.getLogWriter().info("### Doing a put operation");
                            exampleRegion.put((Object)("" + i), (Object)new Portfolio(i));
                            continue;
                        }
                        catch (Exception e) {
                            TestCase.fail((String)("Exception executing query." + e.getMessage()));
                        }
                    }
                    DistributedTestCase.getLogWriter().info("### Completed Executing queries in testCacheOpAfterQueryCancel");
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("Exception creating the query service", ex);
                }
            }
        };
        AsyncInvocation ai3 = server3.invokeAsync(executeQuery);
        AsyncInvocation ai4 = server4.invokeAsync(executeQuery);
        QueryMonitorDUnitTest.getLogWriter().info("### Waiting for async threads to join in testCacheOpAfterQueryCancel");
        try {
            DistributedTestCase.join(ai1, 300000L, null);
            DistributedTestCase.join(ai2, 300000L, null);
            DistributedTestCase.join(ai3, 300000L, null);
            DistributedTestCase.join(ai4, 300000L, null);
        }
        catch (Exception ex) {
            QueryMonitorDUnitTest.fail((String)"Async thread join failure");
        }
        QueryMonitorDUnitTest.getLogWriter().info("### DONE Waiting for async threads to join in testCacheOpAfterQueryCancel");
        this.validateQueryMonitorThreadCnt(server1, 0, 1000);
        this.validateQueryMonitorThreadCnt(server2, 0, 1000);
        this.validateQueryMonitorThreadCnt(server3, 0, 1000);
        this.validateQueryMonitorThreadCnt(server4, 0, 1000);
        QueryMonitorDUnitTest.getLogWriter().info("### DONE validating query monitor threads testCacheOpAfterQueryCancel");
        this.stopServer(server1);
        this.stopServer(server2);
        this.stopServer(server3);
        this.stopServer(server4);
    }

    public void validateQueryMonitorThreadCnt(VM vm, final int threadCount, final int waitTime) {
        CacheSerializableRunnable validateThreadCnt = new CacheSerializableRunnable("validateQueryMonitorThreadCnt"){

            @Override
            public void run2() throws CacheException {
                Cache cache = QueryMonitorDUnitTest.this.getCache();
                QueryMonitor qm = ((GemFireCacheImpl)cache).getQueryMonitor();
                if (qm == null) {
                    TestCase.fail((String)"Didn't found query monitor.");
                }
                int waited = 0;
                while (qm.getQueryMonitorThreadCount() != threadCount) {
                    if (waited <= waitTime) {
                        DistributedTestCase.pause(10);
                        waited += 10;
                        continue;
                    }
                    TestCase.fail((String)("Didn't found expected monitoring thread. Expected: " + threadCount + " found :" + qm.getQueryMonitorThreadCount()));
                    break;
                }
            }
        };
        vm.invoke(validateThreadCnt);
    }

    protected void startBridgeServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = this.getCache();
        BridgeServer bridge = cache.addBridgeServer();
        bridge.setPort(port);
        bridge.setNotifyBySubscription(notifyBySubscription);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    protected void stopBridgeServer(Cache cache) {
        BridgeServer bridge = (BridgeServer)cache.getBridgeServers().iterator().next();
        bridge.stop();
        QueryMonitorDUnitTest.assertFalse((boolean)bridge.isRunning());
    }

    private static int getCacheServerPort() {
        return bridgeServerPort;
    }

    private class QueryTimeoutHook
    implements DefaultQuery.TestHook {
        long timeout;

        public QueryTimeoutHook(long timeout) {
            this.timeout = timeout;
        }

        public void doTestHook(int spot) {
            if (spot == 6) {
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

