/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.cq.dunit;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryDUnitTest;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.io.IOException;
import java.util.HashSet;
import junit.framework.TestCase;

public class PartitionedRegionCqQueryDUnitTest
extends CacheTestCase {
    public static final String[] regions = new String[]{"regionA", "regionB"};
    public static final String KEY = "key-";
    private final CqQueryDUnitTest cqHelper = new CqQueryDUnitTest("HelperPartitonedRegionCqTest");
    public final String[] cqs = new String[]{"SELECT ALL * FROM /root/" + regions[0] + " p where p.ID > 0", "SELECT ALL * FROM /root/" + regions[0] + " p where p.ID = 2 and p.status='active'", "SELECT ALL * FROM /root/" + regions[1] + " p where p.ID < 5 and p.status='active'", "SELECT * FROM /root/" + regions[0] + " ;", "SELECT ALL * FROM /root/" + regions[0], "import com.gemstone.gemfire.cache.\"query\".data.Portfolio; SELECT ALL * FROM /root/" + regions[0] + " TYPE Portfolio", "import com.gemstone.gemfire.cache.\"query\".data.Portfolio; SELECT ALL * FROM /root/" + regions[0] + " p TYPE Portfolio", "SELECT ALL * FROM /root/" + regions[1] + " p where p.ID < 5 and p.status='active';", "SELECT ALL * FROM /root/" + regions[0] + "  ;", "SELECT ALL * FROM /root/" + regions[0] + " p where p.description = NULL", "SELECT ALL * FROM /root/" + regions[1] + " p where p.ID > 0"};
    public final String[] cqsWithoutRoot = new String[]{"SELECT ALL * FROM /" + regions[0] + " p where p.ID > 0"};
    private static int bridgeServerPort;

    public PartitionedRegionCqQueryDUnitTest(String name) {
        super(name);
    }

    public void testCQAndPartitionedRegion() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1);
        this.createServer(server2);
        int port = server1.invokeInt(PartitionedRegionCqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PartitionedRegionCqQueryDUnitTest.getServerHostName(server1.getHost());
        this.createClient(client, port, host0);
        this.createCQ(client, "testCQEvents_0", this.cqs[0]);
        this.cqHelper.executeCQ(client, "testCQEvents_0", false, null);
        PartitionedRegionCqQueryDUnitTest.pause(2000);
        int size = 40;
        this.createValues(server1, regions[0], size);
        this.cqHelper.waitForCreated(client, "testCQEvents_0", KEY + size);
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, size, 0, 0, size, 0, 0, size);
        this.createValues(server1, regions[0], size);
        this.cqHelper.waitForUpdated(client, "testCQEvents_0", KEY + size);
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, size, size, 0, size, size, 0, size + size);
        int numDestroys = size;
        this.cqHelper.deleteValues(server2, regions[0], numDestroys);
        this.cqHelper.waitForDestroyed(client, "testCQEvents_0", KEY + numDestroys);
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, size, size, numDestroys, size, size, numDestroys, size + size + numDestroys);
        this.cqHelper.closeClient(client);
        this.cqHelper.closeServer(server2);
        this.cqHelper.closeServer(server1);
    }

    public void testPartitionedCqOnAccessorBridgeServer() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1, true);
        this.createServer(server2);
        int port = server1.invokeInt(PartitionedRegionCqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PartitionedRegionCqQueryDUnitTest.getServerHostName(server1.getHost());
        this.createClient(client, port, host0);
        this.createCQ(client, "testCQEvents_0", this.cqs[0]);
        this.cqHelper.executeCQ(client, "testCQEvents_0", false, null);
        int size = 1000;
        this.createValues(server1, regions[0], 1000);
        for (i = 1; i <= 1000; ++i) {
            this.cqHelper.waitForCreated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 1000, 0, 0, 1000, 0, 0, 1000);
        this.createValues(server1, regions[0], 1000);
        for (i = 1; i <= 1000; ++i) {
            this.cqHelper.waitForUpdated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 1000, 1000, 0, 1000, 1000, 0, 2000);
        int numDestroys = 1000;
        this.cqHelper.deleteValues(server2, regions[0], numDestroys);
        for (int i2 = 1; i2 <= numDestroys; ++i2) {
            this.cqHelper.waitForDestroyed(client, "testCQEvents_0", KEY + i2);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 1000, 1000, numDestroys, 1000, 1000, numDestroys, 2000 + numDestroys);
        this.cqHelper.closeClient(client);
        this.cqHelper.closeServer(server2);
        this.cqHelper.closeServer(server1);
    }

    public void testPartitionedCqOnSingleBridgeServer() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM client = host.getVM(2);
        this.createServer(server1);
        int port = server1.invokeInt(PartitionedRegionCqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PartitionedRegionCqQueryDUnitTest.getServerHostName(server1.getHost());
        this.createClient(client, port, host0);
        this.createCQ(client, "testCQEvents_0", this.cqs[0]);
        this.cqHelper.executeCQ(client, "testCQEvents_0", false, null);
        int size = 400;
        this.createValues(server1, regions[0], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForCreated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 0, 0, 400, 0, 0, 400);
        this.createValues(server1, regions[0], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForUpdated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, 0, 400, 400, 0, 800);
        int numDestroys = 400;
        this.cqHelper.deleteValues(server1, regions[0], numDestroys);
        for (int i2 = 1; i2 <= numDestroys; ++i2) {
            this.cqHelper.waitForDestroyed(client, "testCQEvents_0", KEY + i2);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, numDestroys, 400, 400, numDestroys, 800 + numDestroys);
        this.cqHelper.closeClient(client);
        this.cqHelper.closeServer(server1);
    }

    public void testPRCqOnSingleBridgeServerUpdatesOriginatingAtAccessor() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1, true);
        this.assertLocalMaxMemory(server1);
        this.createServer(server2);
        int port = server2.invokeInt(PartitionedRegionCqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PartitionedRegionCqQueryDUnitTest.getServerHostName(server2.getHost());
        this.createClient(client, port, host0);
        this.createCQ(client, "testCQEvents_0", this.cqs[0]);
        this.cqHelper.executeCQ(client, "testCQEvents_0", false, null);
        int size = 400;
        this.createValues(server1, regions[0], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForCreated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 0, 0, 400, 0, 0, 400);
        this.createValues(server1, regions[0], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForUpdated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, 0, 400, 400, 0, 800);
        int numDestroys = 400;
        this.cqHelper.deleteValues(server1, regions[0], numDestroys);
        for (int i2 = 1; i2 <= numDestroys; ++i2) {
            this.cqHelper.waitForDestroyed(client, "testCQEvents_0", KEY + i2);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, numDestroys, 400, 400, numDestroys, 800 + numDestroys);
        this.cqHelper.closeClient(client);
        this.cqHelper.closeServer(server2);
        this.cqHelper.closeServer(server1);
    }

    public void testPRCqWithInvalidatesOnBridgeServer() {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1);
        this.createServer(server2);
        int port = server1.invokeInt(PartitionedRegionCqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PartitionedRegionCqQueryDUnitTest.getServerHostName(server1.getHost());
        this.createClient(client, port, host0);
        this.createCQ(client, "testCQEvents_0", this.cqs[0]);
        this.cqHelper.executeCQ(client, "testCQEvents_0", false, null);
        int size = 400;
        this.createValues(server1, regions[0], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForCreated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 0, 0, 400, 0, 0, 400);
        this.createValues(server1, regions[0], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForUpdated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, 0, 400, 400, 0, 800);
        int numInvalidates = 400;
        this.cqHelper.invalidateValues(server2, regions[0], numInvalidates);
        for (int i2 = 1; i2 <= numInvalidates; ++i2) {
            this.cqHelper.waitForInvalidated(client, "testCQEvents_0", KEY + i2);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, numInvalidates, 400, 400, numInvalidates, 800 + numInvalidates);
        this.cqHelper.closeClient(client);
        this.cqHelper.closeServer(server2);
        this.cqHelper.closeServer(server1);
    }

    public void testPRCqWithInvalidatesOnAccessorBridgeServer() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1, true);
        this.createServer(server2);
        int port = server1.invokeInt(PartitionedRegionCqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PartitionedRegionCqQueryDUnitTest.getServerHostName(server1.getHost());
        this.createClient(client, port, host0);
        this.createCQ(client, "testCQEvents_0", this.cqs[0]);
        this.cqHelper.executeCQ(client, "testCQEvents_0", false, null);
        int size = 400;
        this.createValues(server1, regions[0], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForCreated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 0, 0, 400, 0, 0, 400);
        this.createValues(server1, regions[0], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForUpdated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, 0, 400, 400, 0, 800);
        int numInvalidates = 400;
        this.cqHelper.invalidateValues(server1, regions[0], numInvalidates);
        for (int i2 = 1; i2 <= numInvalidates; ++i2) {
            this.cqHelper.waitForInvalidated(client, "testCQEvents_0", KEY + i2);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, numInvalidates, 400, 400, numInvalidates, 800 + numInvalidates);
        this.cqHelper.closeClient(client);
        this.cqHelper.closeServer(server2);
        this.cqHelper.closeServer(server1);
    }

    public void testPRCqWithUpdatesFromClients() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        VM client2 = host.getVM(3);
        this.createServer(server1, false, 1);
        this.createServer(server2, false, 1);
        int port = server1.invokeInt(PartitionedRegionCqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PartitionedRegionCqQueryDUnitTest.getServerHostName(server1.getHost());
        this.createClient(client, port, host0);
        this.createClient(client2, port, host0);
        this.createCQ(client, "testCQEvents_0", this.cqs[0]);
        this.cqHelper.executeCQ(client, "testCQEvents_0", false, null);
        int size = 400;
        this.createValues(client2, regions[0], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForCreated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 0, 0, 400, 0, 0, 400);
        this.createValues(client2, regions[0], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForUpdated(client, "testCQEvents_0", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, 0, 400, 400, 0, 800);
        int numDelets = 400;
        this.cqHelper.deleteValues(client2, regions[0], numDelets);
        for (int i2 = 1; i2 <= numDelets; ++i2) {
            this.cqHelper.waitForDestroyed(client, "testCQEvents_0", KEY + i2);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, numDelets, 400, 400, numDelets, 800 + numDelets);
        this.cqHelper.closeClient(client);
        this.cqHelper.closeClient(client2);
        this.cqHelper.closeServer(server2);
        this.cqHelper.closeServer(server1);
    }

    public void testPRCqWithMultipleRegionsOnServer() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        VM client2 = host.getVM(3);
        this.createServer(server1, false, 1);
        this.createServer(server2, false, 1);
        PartitionedRegionCqQueryDUnitTest.pause(2000);
        int port = server1.invokeInt(PartitionedRegionCqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PartitionedRegionCqQueryDUnitTest.getServerHostName(server1.getHost());
        this.createClient(client, port, host0);
        this.createClient(client2, port, host0);
        this.createCQ(client, "testCQEvents_0", this.cqs[0]);
        this.createCQ(client, "testCQEvents_1", this.cqs[10]);
        this.cqHelper.executeCQ(client, "testCQEvents_0", false, null);
        this.cqHelper.executeCQ(client, "testCQEvents_1", false, null);
        int size = 400;
        this.createValues(client2, regions[0], 400);
        this.createValues(client2, regions[1], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForCreated(client, "testCQEvents_0", KEY + i);
            this.cqHelper.waitForCreated(client, "testCQEvents_1", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 0, 0, 400, 0, 0, 400);
        this.cqHelper.validateCQ(client, "testCQEvents_1", CqQueryDUnitTest.noTest, 400, 0, 0, 400, 0, 0, 400);
        this.createValues(client2, regions[0], 400);
        this.createValues(client2, regions[1], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForUpdated(client, "testCQEvents_0", KEY + i);
            this.cqHelper.waitForUpdated(client, "testCQEvents_1", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, 0, 400, 400, 0, 800);
        this.cqHelper.validateCQ(client, "testCQEvents_1", CqQueryDUnitTest.noTest, 400, 400, 0, 400, 400, 0, 800);
        int numInvalidates = 400;
        this.cqHelper.deleteValues(client2, regions[0], numInvalidates);
        this.cqHelper.deleteValues(client2, regions[1], numInvalidates);
        for (int i2 = 1; i2 <= numInvalidates; ++i2) {
            this.cqHelper.waitForDestroyed(client, "testCQEvents_0", KEY + i2);
            this.cqHelper.waitForDestroyed(client, "testCQEvents_1", KEY + i2);
        }
        this.cqHelper.validateCQ(client, "testCQEvents_0", CqQueryDUnitTest.noTest, 400, 400, numInvalidates, 400, 400, numInvalidates, 800 + numInvalidates);
        this.cqHelper.validateCQ(client, "testCQEvents_1", CqQueryDUnitTest.noTest, 400, 400, numInvalidates, 400, 400, numInvalidates, 800 + numInvalidates);
        this.cqHelper.closeClient(client);
        this.cqHelper.closeClient(client2);
        this.cqHelper.closeServer(server2);
        this.cqHelper.closeServer(server1);
    }

    public void testPRWithCQsAndProfileUpdates() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        VM client2 = host.getVM(3);
        this.createServer(server1, false, 1);
        this.createServer(server2, false, 1);
        int port = server1.invokeInt(PartitionedRegionCqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PartitionedRegionCqQueryDUnitTest.getServerHostName(server1.getHost());
        this.createClient(client, port, host0);
        this.createClient(client2, port, host0);
        this.createCQ(client, "testPRWithCQsAndProfileUpdates_0", this.cqs[0]);
        this.createCQ(client, "testPRWithCQsAndProfileUpdates_1", this.cqs[0]);
        this.cqHelper.executeCQ(client, "testPRWithCQsAndProfileUpdates_0", false, null);
        this.cqHelper.executeCQ(client, "testPRWithCQsAndProfileUpdates_1", false, null);
        int size = 400;
        this.createValues(client2, regions[0], 400);
        this.createValues(client2, regions[1], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForCreated(client, "testPRWithCQsAndProfileUpdates_0", KEY + i);
            this.cqHelper.waitForCreated(client, "testPRWithCQsAndProfileUpdates_1", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testPRWithCQsAndProfileUpdates_0", CqQueryDUnitTest.noTest, 400, 0, 0, 400, 0, 0, 400);
        this.cqHelper.validateCQ(client, "testPRWithCQsAndProfileUpdates_1", CqQueryDUnitTest.noTest, 400, 0, 0, 400, 0, 0, 400);
        this.createValues(client2, regions[0], 400);
        this.createValues(client2, regions[1], 400);
        for (i = 1; i <= 400; ++i) {
            this.cqHelper.waitForUpdated(client, "testPRWithCQsAndProfileUpdates_0", KEY + i);
            this.cqHelper.waitForUpdated(client, "testPRWithCQsAndProfileUpdates_1", KEY + i);
        }
        this.cqHelper.validateCQ(client, "testPRWithCQsAndProfileUpdates_0", CqQueryDUnitTest.noTest, 400, 400, 0, 400, 400, 0, 800);
        this.cqHelper.validateCQ(client, "testPRWithCQsAndProfileUpdates_1", CqQueryDUnitTest.noTest, 400, 400, 0, 400, 400, 0, 800);
        int numInvalidates = 400;
        this.cqHelper.deleteValues(client2, regions[0], numInvalidates);
        this.cqHelper.deleteValues(client2, regions[1], numInvalidates);
        for (int i2 = 1; i2 <= numInvalidates; ++i2) {
            this.cqHelper.waitForDestroyed(client, "testPRWithCQsAndProfileUpdates_0", KEY + i2);
            this.cqHelper.waitForDestroyed(client, "testPRWithCQsAndProfileUpdates_1", KEY + i2);
        }
        this.cqHelper.validateCQ(client, "testPRWithCQsAndProfileUpdates_0", CqQueryDUnitTest.noTest, 400, 400, numInvalidates, 400, 400, numInvalidates, 800 + numInvalidates);
        this.cqHelper.validateCQ(client, "testPRWithCQsAndProfileUpdates_1", CqQueryDUnitTest.noTest, 400, 400, numInvalidates, 400, 400, numInvalidates, 800 + numInvalidates);
        this.cqHelper.closeCQ(client, "testPRWithCQsAndProfileUpdates_0");
        this.cqHelper.closeCQ(client, "testPRWithCQsAndProfileUpdates_1");
        this.cqHelper.closeClient(client);
        this.cqHelper.closeClient(client2);
        this.cqHelper.closeServer(server2);
        this.cqHelper.closeServer(server1);
    }

    public void testEventsDuringQueryExecution() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        String cqName = "testEventsDuringQueryExecution_0";
        this.createServer(server1);
        this.createServer(server2);
        int port = server1.invokeInt(PartitionedRegionCqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PartitionedRegionCqQueryDUnitTest.getServerHostName(server1.getHost());
        this.createClient(client, port, host0);
        this.createCQ(client, "testEventsDuringQueryExecution_0", this.cqs[0]);
        int numObjects = 200;
        int totalObjects = 500;
        server1.invoke(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = PartitionedRegionCqQueryDUnitTest.this.getCache().getRegion("/root/" + regions[0]);
                for (int i = 1; i <= 200; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        server1.invokeAsync(new CacheSerializableRunnable("Update Region"){

            @Override
            public void run2() throws CacheException {
                Region region = PartitionedRegionCqQueryDUnitTest.this.getCache().getRegion("/root/" + regions[0]);
                for (int i = 201; i <= 500; ++i) {
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("" + i), (Object)p);
                }
            }
        });
        client.invoke(new CacheSerializableRunnable("Execute CQ"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = PartitionedRegionCqQueryDUnitTest.this.getCache().getQueryService();
                CqQuery cq1 = cqService.getCq("testEventsDuringQueryExecution_0");
                if (cq1 == null) {
                    TestCase.fail((String)"Failed to get CQ testEventsDuringQueryExecution_0");
                }
                CqResults cqResults = null;
                try {
                    cqResults = cq1.executeWithInitialResults();
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)"Failed to execute  CQ testEventsDuringQueryExecution_0");
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
                CqQueryTestListener cqListener = (CqQueryTestListener)cq1.getCqAttributes().getCqListener();
                for (int i = 0; i < 4; ++i) {
                    try {
                        cqListener.waitForCreated("500");
                        break;
                    }
                    catch (CacheException ex) {
                        if (i != 3) continue;
                        throw ex;
                    }
                }
                int oldId = 0;
                for (Object cqEvent : cqListener.events.toArray()) {
                    int newId = new Integer(cqEvent.toString());
                    if (oldId > newId) {
                        TestCase.fail((String)"Queued events for CQ Listener during execution with Initial results is not in the order in which they are created.");
                    }
                    oldId = newId;
                }
                HashSet<Object> ids = new HashSet<Object>(cqListener.events);
                for (Object o : cqResults.asList()) {
                    Struct s = (Struct)o;
                    ids.add(s.get("key"));
                }
                HashSet<String> missingIds = new HashSet<String>();
                String key = "";
                for (int i = 1; i <= 500; ++i) {
                    key = "" + i;
                    if (ids.contains(key)) continue;
                    missingIds.add(key);
                }
                if (!missingIds.isEmpty()) {
                    TestCase.fail((String)("Missing Keys in either ResultSet or the Cq Event list.  Missing keys : [size : " + missingIds.size() + "]" + missingIds + " Ids in ResultSet and CQ Events :" + ids));
                }
            }
        });
        this.cqHelper.closeClient(client);
        this.cqHelper.closeServer(server2);
        this.cqHelper.closeServer(server1);
    }

    public void testDestroyRegionEventOnClientsWithCQRegistered() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        String cqName = "testDestroyEventOnClientsWithCQRegistered_0";
        this.createServerWithoutRootRegion(server, 0, false, 0);
        int port = server.invokeInt(PartitionedRegionCqQueryDUnitTest.class, "getCacheServerPort");
        String host0 = PartitionedRegionCqQueryDUnitTest.getServerHostName(server.getHost());
        this.createCacheClient(client1, port, host0);
        this.createCacheClient(client2, port, host0);
        this.createCQ(client1, "testDestroyEventOnClientsWithCQRegistered_0", this.cqsWithoutRoot[0]);
        this.cqHelper.executeCQ(client1, "testDestroyEventOnClientsWithCQRegistered_0", false, null);
        int numObjects = 10;
        client1.invoke(new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Region region = PartitionedRegionCqQueryDUnitTest.this.getCache().getRegion("/" + regions[0]);
                for (int i = 1; i <= 10; ++i) {
                    PartitionedRegionCqQueryDUnitTest.this.getCache().getLogger().fine("### DOING PUT with key: " + "KEY-" + i);
                    Portfolio p = new Portfolio(i);
                    region.put((Object)("KEY-" + i), (Object)p);
                }
            }
        });
        client1.invokeAsync(new CacheSerializableRunnable("Wait for CqEvent"){

            @Override
            public void run2() throws CacheException {
                Region localRegion = PartitionedRegionCqQueryDUnitTest.this.getCache().getRegion("/" + regions[0]);
                TestCase.assertNotNull((Object)localRegion);
                CqQueryTestListener cqListener = (CqQueryTestListener)PartitionedRegionCqQueryDUnitTest.this.getCache().getQueryService().getCq("testDestroyEventOnClientsWithCQRegistered_0").getCqAttributes().getCqListener();
                TestCase.assertNotNull((Object)cqListener);
                cqListener.waitForTotalEvents(11);
            }
        });
        client2.invoke(new CacheSerializableRunnable("Destroy region on server"){

            @Override
            public void run2() throws CacheException {
                Region localRegion = PartitionedRegionCqQueryDUnitTest.this.getCache().getRegion("/" + regions[0]);
                TestCase.assertNotNull((Object)localRegion);
                localRegion.destroyRegion();
            }
        });
        client1.invoke(new CacheSerializableRunnable("Check for destroyed region and closed CQ"){

            @Override
            public void run2() throws CacheException {
                Region localRegion = PartitionedRegionCqQueryDUnitTest.this.getCache().getRegion("/" + regions[0]);
                if (localRegion != null) {
                    Log.getLogWriter().info("Local region is NOT null in client 1");
                    DistributedTestCase.pause(5000);
                    CqQuery[] cqs = PartitionedRegionCqQueryDUnitTest.this.getCache().getQueryService().getCqs();
                    if (cqs != null && cqs.length > 0) {
                        TestCase.assertTrue((boolean)cqs[0].isClosed());
                    }
                    TestCase.assertNull((String)"Region is still available on client1 even after performing destroyRegion from client2 on server.Client1 must have received destroyRegion message from server with CQ parts in it.", (Object)PartitionedRegionCqQueryDUnitTest.this.getCache().getRegion("/" + regions[0]));
                }
            }
        });
        this.cqHelper.closeServer(server);
    }

    public void createServer(VM server) {
        this.createServer(server, 0, false, 0);
    }

    public void createServer(VM server, boolean accessor) {
        this.createServer(server, 0, accessor, 0);
    }

    public void createServer(VM server, boolean accessor, int redundantCopies) {
        this.createServer(server, 0, accessor, redundantCopies);
    }

    public void createServer(VM server, final int port, final boolean isAccessor, final int redundantCopies) {
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Cache Server. ###");
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                if (isAccessor) {
                    paf.setLocalMaxMemory(0);
                }
                PartitionAttributes prAttr = paf.setTotalNumBuckets(197).setRedundantCopies(redundantCopies).create();
                attr.setPartitionAttributes(prAttr);
                TestCase.assertFalse((boolean)PartitionedRegionCqQueryDUnitTest.this.getSystem().isLoner());
                for (int i = 0; i < regions.length; ++i) {
                    Region r = PartitionedRegionCqQueryDUnitTest.this.createRegion(regions[i], attr.create());
                    DistributedTestCase.getLogWriter().info("Server created the region: " + r);
                }
                try {
                    PartitionedRegionCqQueryDUnitTest.this.startBridgeServer(port, true);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        server.invoke(createServer);
    }

    public void createServerWithoutRootRegion(VM server, final int port, final boolean isAccessor, final int redundantCopies) {
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Cache Server. ###");
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                if (isAccessor) {
                    paf.setLocalMaxMemory(0);
                }
                PartitionAttributes prAttr = paf.setTotalNumBuckets(1).setRedundantCopies(redundantCopies).create();
                attr.setPartitionAttributes(prAttr);
                TestCase.assertFalse((boolean)PartitionedRegionCqQueryDUnitTest.this.getSystem().isLoner());
                for (int i = 0; i < regions.length; ++i) {
                    Region r = this.createRegionWithoutRoot(regions[i], attr.create());
                    DistributedTestCase.getLogWriter().info("Server created the region: " + r);
                }
                try {
                    PartitionedRegionCqQueryDUnitTest.this.startBridgeServer(port, true);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }

            private Region createRegionWithoutRoot(String regionName, RegionAttributes create) {
                PartitionedRegionCqQueryDUnitTest.this.getCache().createRegion(regionName, create);
                return null;
            }
        };
        server.invoke(createServer);
    }

    protected void startBridgeServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = this.getCache();
        BridgeServer bridge = cache.addBridgeServer();
        bridge.setPort(port);
        bridge.setNotifyBySubscription(notifyBySubscription);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    public void createClient(VM client, int serverPort, String serverHost) {
        int[] serverPorts = new int[]{serverPort};
        this.createClient(client, serverPorts, serverHost, null);
    }

    public void createClient(VM client, final int[] serverPorts, final String serverHost, final String redundancyLevel) {
        CacheSerializableRunnable createQService = new CacheSerializableRunnable("Create Client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Client. ###");
                DistributedTestCase.getLogWriter().info("Will connect to server at por: " + serverPorts[0] + " and at host : " + serverHost);
                try {
                    PartitionedRegionCqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                if (redundancyLevel != null) {
                    BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts[0], -1, true, Integer.parseInt(redundancyLevel), -1, null);
                } else {
                    BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts[0], -1, true, -1, -1, null);
                }
                for (int i = 0; i < regions.length; ++i) {
                    Region clientRegion = PartitionedRegionCqQueryDUnitTest.this.createRegion(regions[i], regionFactory.createRegionAttributes());
                    DistributedTestCase.getLogWriter().info("### Successfully Created Region on Client :" + clientRegion);
                }
            }
        };
        client.invoke(createQService);
    }

    public void createCQ(VM vm, final String cqName, final String queryStr) {
        vm.invoke(new CacheSerializableRunnable("Create CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create CQ. ###" + cqName);
                QueryService cqService = null;
                try {
                    cqService = PartitionedRegionCqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                CqAttributesFactory cqf = new CqAttributesFactory();
                CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(DistributedTestCase.getLogWriter())};
                ((CqQueryTestListener)cqListeners[0]).cqName = cqName;
                cqf.initCqListeners(cqListeners);
                CqAttributes cqa = cqf.create();
                try {
                    CqQuery cq1 = cqService.newCq(cqName, queryStr, cqa);
                    TestCase.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                    DistributedTestCase.getLogWriter().info("Created a new CqQuery : " + cq1);
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)("Failed to create CQ " + cqName + " . "));
                    ((Throwable)((Object)err)).initCause(ex);
                    DistributedTestCase.getLogWriter().info("CqService is :" + cqService, (Throwable)((Object)err));
                    throw err;
                }
            }
        });
    }

    private static int getCacheServerPort() {
        return bridgeServerPort;
    }

    public void createValues(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values for region : " + regionName){

            @Override
            public void run2() throws CacheException {
                Region region1 = PartitionedRegionCqQueryDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 1; i <= size; ++i) {
                    region1.put((Object)(PartitionedRegionCqQueryDUnitTest.KEY + i), (Object)new Portfolio(i));
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        });
    }

    private void assertLocalMaxMemory(VM vm) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                for (int i = 0; i < regions.length; ++i) {
                    Region region = PartitionedRegionCqQueryDUnitTest.this.getRootRegion().getSubregion(regions[i]);
                    TestCase.assertEquals((String)("The region should be configure with local max memory zero : " + region), (int)region.getAttributes().getPartitionAttributes().getLocalMaxMemory(), (int)0);
                }
            }
        });
    }

    public void createCacheClient(VM client, int serverPort, String serverHost) {
        this.createCacheClient(client, new String[]{serverHost}, new int[]{serverPort}, null);
    }

    public void createCacheClient(VM vm, final String[] serverHosts, final int[] serverPorts, final String redundancyLevel) {
        vm.invoke(new CacheSerializableRunnable("createCacheClient"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("Will connect to server at por: " + serverPorts[0] + " and at host : " + serverHosts[0]);
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolServer(serverHosts[0], serverPorts[0]);
                ccf.setPoolSubscriptionEnabled(true);
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                PartitionedRegionCqQueryDUnitTest.this.getClientCache(ccf);
                try {
                    PartitionedRegionCqQueryDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    cqe.printStackTrace();
                    TestCase.fail((String)"Failed to getCQService.");
                }
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                if (redundancyLevel != null) {
                    BridgeTestCase.configureConnectionPool(regionFactory, serverHosts[0], serverPorts[0], -1, true, Integer.parseInt(redundancyLevel), -1, null);
                } else {
                    BridgeTestCase.configureConnectionPool(regionFactory, serverHosts[0], serverPorts[0], -1, true, -1, -1, null);
                }
                for (int i = 0; i < regions.length; ++i) {
                    Region clientRegion = ((ClientCache)PartitionedRegionCqQueryDUnitTest.this.getCache()).createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create(regions[i]);
                    DistributedTestCase.getLogWriter().info("### Successfully Created Region on Client :" + clientRegion);
                }
            }
        });
    }
}

