/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.cq.dunit;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqAttributesMutator;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.cq.dunit.CqQueryTestListener;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.CqStateImpl;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.BridgeTestCase;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.CertifiableTestCacheListener;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;

public class CqQueryUsingPoolDUnitTest
extends CacheTestCase {
    private static int bridgeServerPort;
    protected static int port;
    protected static int port2;
    public static int noTest;
    public final String[] regions = new String[]{"regionA", "regionB"};
    private static final int CREATE = 0;
    private static final int UPDATE = 1;
    private static final int DESTROY = 2;
    private static final int INVALIDATE = 3;
    private static final int CLOSE = 4;
    private static final int REGION_CLEAR = 5;
    private static final int REGION_INVALIDATE = 6;
    public static final String KEY = "key-";
    private static final String WAIT_PROPERTY = "CqQueryTest.maxWaitTime";
    private static final int WAIT_DEFAULT = 20000;
    public static final long MAX_TIME;
    public final String[] cqs = new String[]{"SELECT ALL * FROM /root/" + this.regions[0] + " p where p.ID > 0", "SELECT ALL * FROM /root/" + this.regions[0] + " p where p.ID = 2 and p.status='active'", "SELECT ALL * FROM /root/" + this.regions[1] + " p where p.ID < 5 and p.status='active'", "SELECT * FROM /root/" + this.regions[0] + " ;", "SELECT ALL * FROM /root/" + this.regions[0], "import com.gemstone.gemfire.cache.\"query\".data.Portfolio; SELECT ALL * FROM /root/" + this.regions[0] + " TYPE Portfolio", "import com.gemstone.gemfire.cache.\"query\".data.Portfolio; SELECT ALL * FROM /root/" + this.regions[0] + " p TYPE Portfolio", "SELECT ALL * FROM /root/" + this.regions[1] + " p where p.ID < 5 and p.status='active';", "SELECT ALL * FROM /root/" + this.regions[0] + "  ;", "SELECT ALL * FROM /root/" + this.regions[0] + " p where p.description = NULL", "SELECT ALL * FROM /root/" + this.regions[0] + " p where p.ID > 0 and p.status='active'", "SELECT ALL * FROM /root/" + this.regions[0] + " where ID > 0"};
    private String[] invalidCQs = new String[]{"SELECT ALL * FROM /root/invalidRegion p where p.ID > 0"};

    public CqQueryUsingPoolDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getSystem();
        CqQueryUsingPoolDUnitTest.invokeInEveryVM(new SerializableRunnable("getSystem"){

            @Override
            public void run() {
                CqQueryUsingPoolDUnitTest.this.getSystem();
            }
        });
    }

    static int getCacheServerPort() {
        return bridgeServerPort;
    }

    public void createServer(VM server) {
        this.createServer(server, 0);
    }

    public void createServer(VM server, int p) {
        this.createServer(server, p, false);
    }

    public void createServer(VM server, int thePort, boolean eviction) {
        MirrorType mirrorType = MirrorType.KEYS_VALUES;
        this.createServer(server, thePort, eviction, mirrorType);
    }

    public void createServer(VM server, final int thePort, final boolean eviction, final MirrorType mirrorType) {
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Cache Server. ###");
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setMirrorType(mirrorType);
                if (eviction) {
                    EvictionAttributes evictAttrs = EvictionAttributes.createLRUEntryAttributes((int)100000, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK);
                    factory.setEvictionAttributes(evictAttrs);
                }
                for (int i = 0; i < CqQueryUsingPoolDUnitTest.this.regions.length; ++i) {
                    CqQueryUsingPoolDUnitTest.this.createRegion(CqQueryUsingPoolDUnitTest.this.regions[i], factory.createRegionAttributes());
                }
                try {
                    CqQueryUsingPoolDUnitTest.this.startBridgeServer(thePort, true);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        server.invoke(createServer);
    }

    public void createServerWithPR(VM server, final int port, final boolean isAccessor, final int redundantCopies) {
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Cache Server. ###");
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                if (isAccessor) {
                    paf.setLocalMaxMemory(0);
                }
                PartitionAttributes prAttr = paf.setTotalNumBuckets(197).setRedundantCopies(redundantCopies).create();
                attr.setPartitionAttributes(prAttr);
                TestCase.assertFalse((boolean)CqQueryUsingPoolDUnitTest.this.getSystem().isLoner());
                for (int i = 0; i < CqQueryUsingPoolDUnitTest.this.regions.length; ++i) {
                    Region r = CqQueryUsingPoolDUnitTest.this.createRegion(CqQueryUsingPoolDUnitTest.this.regions[i], attr.create());
                    DistributedTestCase.getLogWriter().info("Server created the region: " + r);
                }
                try {
                    CqQueryUsingPoolDUnitTest.this.startBridgeServer(port, true);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
            }
        };
        server.invoke(createServer);
    }

    public void closeServer(VM server) {
        server.invoke(new SerializableRunnable("Close CacheServer"){

            @Override
            public void run() {
                DistributedTestCase.getLogWriter().info("### Close CacheServer. ###");
                CqQueryUsingPoolDUnitTest.this.stopBridgeServer(CqQueryUsingPoolDUnitTest.this.getCache());
            }
        });
    }

    public void createClient(VM client, int serverPort, String serverHost) {
        int[] serverPorts = new int[]{serverPort};
        this.createClient(client, serverPorts, serverHost, null, null);
    }

    public void createClient(VM client, final int[] serverPorts, final String serverHost, final String redundancyLevel, final String poolName) {
        CacheSerializableRunnable createQService = new CacheSerializableRunnable("Create Client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Client. ###");
                try {
                    CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                if (poolName != null) {
                    regionFactory.setPoolName(poolName);
                } else if (redundancyLevel != null) {
                    BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts, true, Integer.parseInt(redundancyLevel), -1, null);
                } else {
                    BridgeTestCase.configureConnectionPool(regionFactory, serverHost, serverPorts, true, -1, -1, null);
                }
                for (int i = 0; i < CqQueryUsingPoolDUnitTest.this.regions.length; ++i) {
                    CqQueryUsingPoolDUnitTest.this.createRegion(CqQueryUsingPoolDUnitTest.this.regions[i], regionFactory.createRegionAttributes());
                    DistributedTestCase.getLogWriter().info("### Successfully Created Region on Client :" + CqQueryUsingPoolDUnitTest.this.regions[i]);
                }
            }
        };
        client.invoke(createQService);
    }

    public void closeClient(VM client) {
        CacheSerializableRunnable closeCQService = new CacheSerializableRunnable("Close Client"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Close Client. ###");
                try {
                    ((DefaultQueryService)CqQueryUsingPoolDUnitTest.this.getCache().getQueryService()).closeCqService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("### Failed to get CqService during ClientClose() ###");
                }
            }
        };
        client.invoke(closeCQService);
        CqQueryUsingPoolDUnitTest.pause(1000);
    }

    public void createFunctionalIndex(VM vm, final String indexName, final String indexedExpression, final String fromClause) {
        vm.invoke(new CacheSerializableRunnable("Create Functional Index"){

            @Override
            public void run2() throws CacheException {
                QueryService qs = null;
                try {
                    qs = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("### Failed to get CqService during ClientClose() ###");
                }
                try {
                    qs.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause);
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("### Failed to create Index :" + indexName);
                }
            }
        });
    }

    public void createValues(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 1; i <= size; ++i) {
                    region1.put((Object)(CqQueryUsingPoolDUnitTest.KEY + i), (Object)new Portfolio(i, i));
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        });
    }

    public void createValuesWithTime(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 1; i <= size; ++i) {
                    Portfolio portfolio = new Portfolio(i);
                    portfolio.createTime = System.currentTimeMillis();
                    region1.put((Object)(CqQueryUsingPoolDUnitTest.KEY + i), (Object)portfolio);
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries in Region :" + region1.keys().size());
            }
        });
    }

    public void deleteValues(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 1; i <= size; ++i) {
                    region1.destroy((Object)(CqQueryUsingPoolDUnitTest.KEY + i));
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries In Region after Delete :" + region1.keys().size());
            }
        });
    }

    public void invalidateValues(VM vm, final String regionName, final int size) {
        vm.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(regionName);
                for (int i = 1; i <= size; ++i) {
                    region1.invalidate((Object)(CqQueryUsingPoolDUnitTest.KEY + i));
                }
                DistributedTestCase.getLogWriter().info("### Number of Entries In Region after Delete :" + region1.keys().size());
            }
        });
    }

    public void createPool(VM vm, String poolName, String server, int port) {
        this.createPool(vm, poolName, new String[]{server}, new int[]{port});
    }

    public void createPool(VM vm, String poolName, String[] servers, int[] ports) {
        this.createPool(vm, poolName, servers, ports, null);
    }

    public void createPool(VM vm, final String poolName, final String[] servers, final int[] ports, final String redundancyLevel) {
        vm.invoke(new CacheSerializableRunnable("createPool :" + poolName){

            @Override
            public void run2() throws CacheException {
                CqQueryUsingPoolDUnitTest.this.getCache();
                PoolFactory cpf = PoolManager.createFactory();
                cpf.setSubscriptionEnabled(true);
                if (redundancyLevel != null) {
                    int redundancy = Integer.parseInt(redundancyLevel);
                    cpf.setSubscriptionRedundancy(redundancy);
                }
                for (int i = 0; i < servers.length; ++i) {
                    DistributedTestCase.getLogWriter().info("### Adding to Pool. ### Server : " + servers[i] + " Port : " + ports[i]);
                    cpf.addServer(servers[i], ports[i]);
                }
                cpf.create(poolName);
            }
        });
    }

    public void createCQ(VM vm, final String poolName, final String cqName, final String queryStr) {
        vm.invoke(new CacheSerializableRunnable("Create CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create CQ. ###" + cqName);
                QueryService qService = null;
                try {
                    qService = PoolManager.find((String)poolName).getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqAttributesFactory cqf = new CqAttributesFactory();
                CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(DistributedTestCase.getLogWriter())};
                ((CqQueryTestListener)cqListeners[0]).cqName = cqName;
                cqf.initCqListeners(cqListeners);
                CqAttributes cqa = cqf.create();
                try {
                    CqQuery cq1 = qService.newCq(cqName, queryStr, cqa);
                    TestCase.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)("Failed to create CQ " + cqName + " . "));
                    ((Throwable)((Object)err)).initCause(ex);
                    DistributedTestCase.getLogWriter().info("QueryService is :" + qService, (Throwable)((Object)err));
                    throw err;
                }
            }
        });
    }

    public void createCQ(VM vm, final String cqName, final String queryStr) {
        vm.invoke(new CacheSerializableRunnable("Create CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create CQ. ###" + cqName);
                QueryService qService = null;
                try {
                    qService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqAttributesFactory cqf = new CqAttributesFactory();
                CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(DistributedTestCase.getLogWriter())};
                ((CqQueryTestListener)cqListeners[0]).cqName = cqName;
                cqf.initCqListeners(cqListeners);
                CqAttributes cqa = cqf.create();
                try {
                    CqQuery cq1 = qService.newCq(cqName, queryStr, cqa);
                    TestCase.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)("Failed to create CQ " + cqName + " . "));
                    ((Throwable)((Object)err)).initCause(ex);
                    DistributedTestCase.getLogWriter().info("QueryService is :" + qService, (Throwable)((Object)err));
                    throw err;
                }
            }
        });
    }

    public void createAndExecCQNoName(VM vm, final String poolName, final String queryStr) {
        vm.invoke(new CacheSerializableRunnable("Create CQ with no name:"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### DEBUG CREATE CQ START ####");
                DistributedTestCase.getLogWriter().info("### Create CQ with no name. ###");
                QueryService qService = null;
                CqQuery cq1 = null;
                String cqName = null;
                try {
                    qService = PoolManager.find((String)poolName).getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqResults cqResults = null;
                for (int i = 0; i < 20; ++i) {
                    CqAttributesFactory cqf = new CqAttributesFactory();
                    CqListener[] cqListeners = new CqListener[]{new CqQueryTestListener(DistributedTestCase.getLogWriter())};
                    cqf.initCqListeners(cqListeners);
                    CqAttributes cqa = cqf.create();
                    try {
                        cq1 = qService.newCq(queryStr, cqa);
                        ((CqQueryTestListener)cqListeners[0]).cqName = cq1.getName();
                    }
                    catch (Exception ex) {
                        DistributedTestCase.getLogWriter().info("CQService is :" + qService);
                        DistributedTestCase.fail("Failed to create CQ with no name . ", ex);
                    }
                    if (cq1 == null) {
                        DistributedTestCase.getLogWriter().info("Failed to get CqQuery object for CQ with no name.");
                    } else {
                        cqName = cq1.getName();
                        DistributedTestCase.getLogWriter().info("Created CQ with no name, generated CQ name: " + cqName + " CQ state:" + cq1.getState());
                        TestCase.assertTrue((String)"Create CQ with no name illegal state", (boolean)cq1.getState().isStopped());
                    }
                    if (i % 2 == 0) {
                        try {
                            cqResults = cq1.executeWithInitialResults();
                        }
                        catch (Exception ex) {
                            DistributedTestCase.getLogWriter().info("CqService is :" + qService);
                            DistributedTestCase.fail("Failed to execute CQ with initial results, cq name: " + cqName + " . ", ex);
                        }
                        DistributedTestCase.getLogWriter().info("initial result size = " + cqResults.size());
                        DistributedTestCase.getLogWriter().info("CQ state after execute with initial results = " + cq1.getState());
                        TestCase.assertTrue((String)"executeWithInitialResults() state mismatch", (boolean)cq1.getState().isRunning());
                    } else {
                        try {
                            cq1.execute();
                        }
                        catch (Exception ex) {
                            DistributedTestCase.getLogWriter().info("CQService is :" + qService);
                            DistributedTestCase.fail("Failed to execute CQ " + cqName + " . ", ex);
                        }
                        DistributedTestCase.getLogWriter().info("CQ state after execute = " + cq1.getState());
                        TestCase.assertTrue((String)"execute() state mismatch", (boolean)cq1.getState().isRunning());
                    }
                    try {
                        cq1.close();
                    }
                    catch (Exception ex) {
                        DistributedTestCase.getLogWriter().info("CqService is :" + qService);
                        DistributedTestCase.fail("Failed to close CQ " + cqName + " . ", ex);
                    }
                    TestCase.assertTrue((String)"closeCq() state mismatch", (boolean)cq1.getState().isClosed());
                }
            }
        });
    }

    public void executeCQ(VM vm, String cqName, boolean initialResults, String expectedErr) {
        this.executeCQ(vm, cqName, initialResults, noTest, null, expectedErr);
    }

    public void executeCQ(VM vm, final String cqName, final boolean initialResults, final int expectedResultsSize, final String[] expectedKeys, final String expectedErr) {
        vm.invoke(new CacheSerializableRunnable("Execute CQ :" + cqName){

            private void work() throws CacheException {
                DistributedTestCase.getLogWriter().info("### DEBUG EXECUTE CQ START ####");
                QueryService cqService = null;
                CqQuery cq1 = null;
                cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                try {
                    cq1 = cqService.getCq(cqName);
                    if (cq1 == null) {
                        DistributedTestCase.getLogWriter().info("Failed to get CqQuery object for CQ name: " + cqName);
                        TestCase.fail((String)("Failed to get CQ " + cqName));
                    } else {
                        DistributedTestCase.getLogWriter().info("Obtained CQ, CQ name: " + cq1.getName());
                        TestCase.assertTrue((String)"newCq() state mismatch", (boolean)cq1.getState().isStopped());
                    }
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("CqService is :" + cqService);
                    DistributedTestCase.getLogWriter().error((Throwable)ex);
                    AssertionError err = new AssertionError((Object)("Failed to execute  CQ " + cqName));
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
                if (initialResults) {
                    CqResults cqResults = null;
                    try {
                        cqResults = cq1.executeWithInitialResults();
                    }
                    catch (Exception ex) {
                        DistributedTestCase.getLogWriter().info("CqService is :" + cqService);
                        ex.printStackTrace();
                        AssertionError err = new AssertionError((Object)("Failed to execute  CQ " + cqName));
                        ((Throwable)((Object)err)).initCause(ex);
                        throw err;
                    }
                    DistributedTestCase.getLogWriter().info("initial result size = " + cqResults.size());
                    TestCase.assertTrue((String)"executeWithInitialResults() state mismatch", (boolean)cq1.getState().isRunning());
                    if (expectedResultsSize >= 0) {
                        TestCase.assertEquals((String)("Unexpected results size for CQ: " + cqName + " CQ Query :" + cq1.getQueryString()), (int)expectedResultsSize, (int)cqResults.size());
                    }
                    if (expectedKeys != null) {
                        HashSet<Object> resultKeys = new HashSet<Object>();
                        for (Object o : cqResults.asList()) {
                            Struct s = (Struct)o;
                            resultKeys.add(s.get("key"));
                        }
                        for (int i = 0; i < expectedKeys.length; ++i) {
                            TestCase.assertTrue((String)("Expected key :" + expectedKeys[i] + " Not found in CqResults for CQ: " + cqName + " CQ Query :" + cq1.getQueryString() + " Keys in CqResults :" + resultKeys), (boolean)resultKeys.contains(expectedKeys[i]));
                        }
                    }
                } else {
                    try {
                        cq1.execute();
                    }
                    catch (Exception ex) {
                        AssertionError err = new AssertionError((Object)("Failed to execute  CQ " + cqName));
                        ((Throwable)((Object)err)).initCause(ex);
                        if (expectedErr == null) {
                            DistributedTestCase.getLogWriter().info("CqService is :" + cqService, (Throwable)((Object)err));
                        }
                        throw err;
                    }
                    TestCase.assertTrue((String)"execute() state mismatch", (boolean)cq1.getState().isRunning());
                }
            }

            @Override
            public void run2() throws CacheException {
                if (expectedErr != null) {
                    CqQueryUsingPoolDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedErr + "</ExpectedException>");
                }
                try {
                    this.work();
                }
                finally {
                    if (expectedErr != null) {
                        CqQueryUsingPoolDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedErr + "</ExpectedException>");
                    }
                }
            }
        });
    }

    public void stopCQ(VM vm, final String cqName) throws Exception {
        vm.invoke(new CacheSerializableRunnable("Stop CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Stop CQ. ###" + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqQuery cq1 = null;
                try {
                    cq1 = cqService.getCq(cqName);
                    cq1.stop();
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("Failed to stop CQ " + cqName + " . ", ex);
                }
                TestCase.assertTrue((String)"Stop CQ state mismatch", (boolean)cq1.getState().isStopped());
            }
        });
    }

    private void stopExecCQ(VM vm, final String cqName, final int count) throws Exception {
        vm.invoke(new CacheSerializableRunnable("Stop CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                CqQuery cq1 = null;
                DistributedTestCase.getLogWriter().info("### Stop and Exec CQ. ###" + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCqService.", cqe);
                }
                try {
                    cq1 = cqService.getCq(cqName);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("Failed to get CQ " + cqName + " . ", ex);
                }
                for (int i = 0; i < count; ++i) {
                    try {
                        cq1.stop();
                    }
                    catch (Exception ex) {
                        DistributedTestCase.fail("Count = " + i + "Failed to stop CQ " + cqName + " . ", ex);
                    }
                    TestCase.assertTrue((String)("Stop CQ state mismatch, count = " + i), (boolean)cq1.getState().isStopped());
                    DistributedTestCase.getLogWriter().info("After stop in Stop and Execute loop, ran successfully, loop count: " + i);
                    DistributedTestCase.getLogWriter().info("CQ state: " + cq1.getState());
                    try {
                        cq1.execute();
                    }
                    catch (Exception ex) {
                        DistributedTestCase.fail("Count = " + i + "Failed to execute CQ " + cqName + " . ", ex);
                    }
                    TestCase.assertTrue((String)("Execute CQ state mismatch, count = " + i), (boolean)cq1.getState().isRunning());
                    DistributedTestCase.getLogWriter().info("After execute in Stop and Execute loop, ran successfully, loop count: " + i);
                    DistributedTestCase.getLogWriter().info("CQ state: " + cq1.getState());
                }
            }
        });
    }

    public void closeCQ(VM vm, final String cqName) throws Exception {
        vm.invoke(new CacheSerializableRunnable("Close CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Close CQ. ###" + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCqService.", cqe);
                }
                CqQuery cq1 = null;
                try {
                    cq1 = cqService.getCq(cqName);
                    cq1.close();
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("Failed to close CQ " + cqName + " . ", ex);
                }
                TestCase.assertTrue((String)"Close CQ state mismatch", (boolean)cq1.getState().isClosed());
            }
        });
    }

    public void registerInterestListCQ(VM vm, final String regionName, final int keySize, final boolean all) {
        vm.invoke(new CacheSerializableRunnable("Register InterestList and CQ"){

            @Override
            public void run2() throws CacheException {
                Region region = null;
                try {
                    region = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(regionName);
                    region.getAttributesMutator().setCacheListener((CacheListener)new CertifiableTestCacheListener(DistributedTestCase.getLogWriter()));
                }
                catch (Exception cqe) {
                    AssertionError err = new AssertionError((Object)"Failed to get Region.");
                    ((Throwable)((Object)err)).initCause(cqe);
                    throw err;
                }
                try {
                    if (all) {
                        region.registerInterest((Object)"ALL_KEYS");
                    } else {
                        ArrayList<String> list = new ArrayList<String>();
                        for (int i = 1; i <= keySize; ++i) {
                            list.add(CqQueryUsingPoolDUnitTest.KEY + i);
                        }
                        region.registerInterest(list);
                    }
                }
                catch (Exception ex) {
                    AssertionError err = new AssertionError((Object)"Failed to Register InterestList");
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
            }
        });
    }

    public void validateCQCount(VM vm, final int cqCnt) throws Exception {
        vm.invoke(new CacheSerializableRunnable("validate cq count"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                int numCqs = 0;
                try {
                    numCqs = cqService.getCqs().length;
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("Failed to get the CQ Count.", ex);
                }
                TestCase.assertEquals((String)"Number of cqs mismatch.", (int)cqCnt, (int)numCqs);
            }
        });
    }

    private void failIfCQExists(VM vm, final String cqName) {
        vm.invoke(new CacheSerializableRunnable("Fail if CQ exists"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Fail if CQ Exists. ### " + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery != null) {
                    TestCase.fail((String)("Unexpectedly found CqQuery for CQ : " + cqName));
                }
            }
        });
    }

    private void validateCQError(VM vm, final String cqName, final int numError) {
        vm.invoke(new CacheSerializableRunnable("Validate CQs"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Validating CQ. ### " + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener cqListener = cqAttr.getCqListener();
                CqQueryTestListener listener = (CqQueryTestListener)cqListener;
                listener.printInfo(false);
                if (numError != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Total Event Count mismatch", (int)numError, (int)listener.getErrorEventCount());
                }
            }
        });
    }

    public void validateCQ(VM vm, String cqName, int resultSize, int creates, int updates, int deletes) {
        this.validateCQ(vm, cqName, resultSize, creates, updates, deletes, noTest, noTest, noTest, noTest);
    }

    public void validateCQ(VM vm, final String cqName, final int resultSize, final int creates, final int updates, final int deletes, final int queryInserts, final int queryUpdates, final int queryDeletes, final int totalEvents) {
        vm.invoke(new CacheSerializableRunnable("Validate CQs"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Validating CQ. ### " + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener[] cqListeners = cqAttr.getCqListeners();
                CqQueryTestListener listener = (CqQueryTestListener)cqListeners[0];
                listener.printInfo(false);
                if (totalEvents != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Total Event Count mismatch", (int)totalEvents, (int)listener.getTotalEventCount());
                }
                if (resultSize != noTest) {
                    TestCase.fail((String)"test for event counts instead of results size");
                }
                if (creates != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Create Event mismatch", (int)creates, (int)listener.getCreateEventCount());
                }
                if (updates != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Update Event mismatch", (int)updates, (int)listener.getUpdateEventCount());
                }
                if (deletes != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Delete Event mismatch", (int)deletes, (int)listener.getDeleteEventCount());
                }
                if (queryInserts != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Query Insert Event mismatch", (int)queryInserts, (int)listener.getQueryInsertEventCount());
                }
                if (queryUpdates != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Query Update Event mismatch", (int)queryUpdates, (int)listener.getQueryUpdateEventCount());
                }
                if (queryDeletes != noTest) {
                    listener.printInfo(true);
                    TestCase.assertEquals((String)"Query Delete Event mismatch", (int)queryDeletes, (int)listener.getQueryDeleteEventCount());
                }
            }
        });
    }

    public void waitForCreated(VM vm, String cqName, String key) {
        this.waitForEvent(vm, 0, cqName, key);
    }

    public void waitForUpdated(VM vm, String cqName, String key) {
        this.waitForEvent(vm, 1, cqName, key);
    }

    public void waitForDestroyed(VM vm, String cqName, String key) {
        this.waitForEvent(vm, 2, cqName, key);
    }

    public void waitForInvalidated(VM vm, String cqName, String key) {
        this.waitForEvent(vm, 3, cqName, key);
    }

    public void waitForClose(VM vm, String cqName) {
        this.waitForEvent(vm, 4, cqName, null);
    }

    public void waitForRegionClear(VM vm, String cqName) {
        this.waitForEvent(vm, 5, cqName, null);
    }

    public void waitForRegionInvalidate(VM vm, String cqName) {
        this.waitForEvent(vm, 6, cqName, null);
    }

    private void waitForEvent(VM vm, final int event, final String cqName, final String key) {
        vm.invoke(new CacheSerializableRunnable("validate cq count"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener[] cqListener = cqAttr.getCqListeners();
                CqQueryTestListener listener = (CqQueryTestListener)cqListener[0];
                switch (event) {
                    case 0: {
                        listener.waitForCreated(key);
                        break;
                    }
                    case 1: {
                        listener.waitForUpdated(key);
                        break;
                    }
                    case 2: {
                        listener.waitForDestroyed(key);
                        break;
                    }
                    case 3: {
                        listener.waitForInvalidated(key);
                        break;
                    }
                    case 4: {
                        listener.waitForClose();
                        break;
                    }
                    case 5: {
                        listener.waitForRegionClear();
                        break;
                    }
                    case 6: {
                        listener.waitForRegionInvalidate();
                    }
                }
            }
        });
    }

    public void waitForCqState(VM vm, final String cqName, final int state) {
        vm.invoke(new CacheSerializableRunnable("Wait For cq State"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqStateImpl cqState = (CqStateImpl)cQuery.getState();
                long start = System.currentTimeMillis();
                while (cqState.getState() != state) {
                    Assert.assertTrue((String)("Waited over " + MAX_TIME + "ms for Cq State to be changed to " + state + "; consider raising " + CqQueryUsingPoolDUnitTest.WAIT_PROPERTY), (System.currentTimeMillis() - start < MAX_TIME ? 1 : 0) != 0);
                    DistributedTestCase.pause(100);
                }
            }
        });
    }

    public void clearCQListenerEvents(VM vm, final String cqName) {
        vm.invoke(new CacheSerializableRunnable("validate cq count"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                CqQuery cQuery = cqService.getCq(cqName);
                if (cQuery == null) {
                    TestCase.fail((String)("Failed to get CqQuery for CQ : " + cqName));
                }
                CqAttributes cqAttr = cQuery.getCqAttributes();
                CqListener cqListener = cqAttr.getCqListener();
                CqQueryTestListener listener = (CqQueryTestListener)cqListener;
                listener.getEventHistory();
            }
        });
    }

    public void validateQuery(VM vm, final String query, final int resultSize) {
        vm.invoke(new CacheSerializableRunnable("Validate Query"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Validating Query. ###");
                QueryService qs = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                Query q = qs.newQuery(query);
                try {
                    Object r = q.execute();
                    if (r instanceof Collection) {
                        int rSize = ((Collection)r).size();
                        DistributedTestCase.getLogWriter().info("### Result Size is :" + rSize);
                        TestCase.assertEquals((int)rSize, (int)resultSize);
                    }
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Failed to execute the query.", e);
                }
            }
        });
    }

    private Properties getConnectionProps(String[] hosts, int[] ports, Properties newProps) {
        Properties props = new Properties();
        String endPoints = "";
        String host = hosts[0];
        for (int i = 0; i < ports.length; ++i) {
            if (hosts.length > 1) {
                host = hosts[i];
            }
            endPoints = endPoints + "server" + i + "=" + host + ":" + ports[i];
            if (ports.length <= i + 1) continue;
            endPoints = endPoints + ",";
        }
        props.setProperty("endpoints", endPoints);
        props.setProperty("retryAttempts", "1");
        if (newProps != null) {
            Enumeration<Object> e = newProps.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                props.setProperty(key, newProps.getProperty(key));
            }
        }
        return props;
    }

    private void mutateCQAttributes(VM vm, final String cqName, final int mutator_function) throws Exception {
        vm.invoke(new CacheSerializableRunnable("Stop CQ :" + cqName){

            @Override
            public void run2() throws CacheException {
                CqQuery cq1 = null;
                DistributedTestCase.getLogWriter().info("### CQ attributes mutator for ###" + cqName);
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                try {
                    cq1 = cqService.getCq(cqName);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("Failed to get CQ " + cqName + " . ", ex);
                }
                CqAttributesMutator cqAttrMutator = cq1.getCqAttributesMutator();
                CqAttributes cqAttr = cq1.getCqAttributes();
                switch (mutator_function) {
                    case 0: {
                        CqListener[] cqListenersArray = new CqListener[]{new CqQueryTestListener(CqQueryUsingPoolDUnitTest.this.getCache().getLogger()), new CqQueryTestListener(CqQueryUsingPoolDUnitTest.this.getCache().getLogger())};
                        cqAttrMutator.initCqListeners(cqListenersArray);
                        CqListener[] cqListeners = cqAttr.getCqListeners();
                        TestCase.assertEquals((String)"CqListener count mismatch", (int)cqListeners.length, (int)2);
                        break;
                    }
                    case 1: {
                        CqQueryTestListener newListener1 = new CqQueryTestListener(CqQueryUsingPoolDUnitTest.this.getCache().getLogger());
                        CqQueryTestListener newListener2 = new CqQueryTestListener(CqQueryUsingPoolDUnitTest.this.getCache().getLogger());
                        cqAttrMutator.addCqListener((CqListener)newListener1);
                        cqAttrMutator.addCqListener((CqListener)newListener2);
                        CqListener[] cqListeners = cqAttr.getCqListeners();
                        TestCase.assertEquals((String)"CqListener count mismatch", (int)cqListeners.length, (int)3);
                        break;
                    }
                    case 2: {
                        CqListener[] cqListeners = cqAttr.getCqListeners();
                        cqAttrMutator.removeCqListener(cqListeners[0]);
                        cqListeners = cqAttr.getCqListeners();
                        TestCase.assertEquals((String)"CqListener count mismatch", (int)cqListeners.length, (int)2);
                        cqAttrMutator.removeCqListener(cqListeners[0]);
                        cqListeners = cqAttr.getCqListeners();
                        TestCase.assertEquals((String)"CqListener count mismatch", (int)cqListeners.length, (int)1);
                    }
                }
            }
        });
    }

    public void testInterestListAndCQs() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testInterestListAndCQs";
        this.createPool(client, poolName, host0, thePort);
        this.createClient(client, thePort, host0);
        this.createCQ(client, poolName, "testInterestListAndCQs_0", this.cqs[0]);
        this.validateCQCount(client, 1);
        int size = 10;
        this.executeCQ(client, "testInterestListAndCQs_0", false, null);
        this.registerInterestListCQ(client, this.regions[0], 10, false);
        this.createValues(server, this.regions[0], 10);
        for (i = 1; i <= 10; ++i) {
            this.waitForCreated(client, "testInterestListAndCQs_0", KEY + i);
        }
        CqQueryUsingPoolDUnitTest.pause(5000);
        this.validateCQ(client, "testInterestListAndCQs_0", noTest, 10, noTest, noTest, 10, 0, 0, 10);
        client.invoke(new CacheSerializableRunnable("validate updates"){

            @Override
            public void run2() throws CacheException {
                final Region region = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                TestCase.assertNotNull((Object)region);
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        int sz = region.entrySet().size();
                        if (sz == 10) {
                            return true;
                        }
                        this.excuse = "Mismatch, number of keys (" + sz + ") in local region is not equal to the interest list size (" + 10 + ")";
                        return false;
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 1; i <= 10; ++i) {
                    ctl.waitForCreated(CqQueryUsingPoolDUnitTest.KEY + i);
                    TestCase.assertNotNull((Object)region.getEntry((Object)(CqQueryUsingPoolDUnitTest.KEY + i)));
                }
            }
        });
        this.createValues(server, this.regions[0], 10);
        for (i = 1; i <= 10; ++i) {
            this.waitForUpdated(client, "testInterestListAndCQs_0", KEY + i);
        }
        client.invoke(new CacheSerializableRunnable("validate updates"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                TestCase.assertNotNull((Object)region);
                Set keys = region.entrySet();
                TestCase.assertEquals((String)"Mismatch, number of keys in local region is not equal to the interest list size", (int)10, (int)keys.size());
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 1; i <= 10; ++i) {
                    ctl.waitForUpdated(CqQueryUsingPoolDUnitTest.KEY + i);
                    TestCase.assertNotNull((Object)region.getEntry((Object)(CqQueryUsingPoolDUnitTest.KEY + i)));
                }
            }
        });
        server.invoke(new CacheSerializableRunnable("Invalidate values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                for (int i = 1; i <= 10; ++i) {
                    region1.invalidate((Object)(CqQueryUsingPoolDUnitTest.KEY + i));
                }
            }
        });
        this.waitForInvalidated(client, "testInterestListAndCQs_0", "key-10");
        client.invoke(new CacheSerializableRunnable("validate invalidates"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                TestCase.assertNotNull((Object)region);
                Set keys = region.entrySet();
                TestCase.assertEquals((String)"Mismatch, number of keys in local region is not equal to the interest list size", (int)10, (int)keys.size());
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 1; i <= 10; ++i) {
                    ctl.waitForInvalidated(CqQueryUsingPoolDUnitTest.KEY + i);
                    TestCase.assertNotNull((Object)region.getEntry((Object)(CqQueryUsingPoolDUnitTest.KEY + i)));
                }
            }
        });
        this.validateCQ(client, "testInterestListAndCQs_0", noTest, 10, 10, noTest, 10, 10, 10, 30);
        server.invoke(new CacheSerializableRunnable("Invalidate values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                for (int i = 1; i <= 10; ++i) {
                    region1.destroy((Object)(CqQueryUsingPoolDUnitTest.KEY + i));
                }
            }
        });
        client.invoke(new CacheSerializableRunnable("validate destroys"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                TestCase.assertNotNull((Object)region);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 1; i <= 10; ++i) {
                    ctl.waitForDestroyed(CqQueryUsingPoolDUnitTest.KEY + i);
                }
            }
        });
        this.validateCQ(client, "testInterestListAndCQs_0", noTest, 10, 10, noTest, 10, 10, 10, 30);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQStopExecute() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCQStopExecute";
        this.createPool(client, poolName, host0, thePort);
        this.createCQ(client, poolName, "testCQStopExecute_0", this.cqs[0]);
        this.validateCQCount(client, 1);
        this.executeCQ(client, "testCQStopExecute_0", false, null);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        this.waitForCreated(client, "testCQStopExecute_0", KEY + size);
        this.validateQuery(server, this.cqs[0], 10);
        this.validateCQ(client, "testCQStopExecute_0", noTest, size, 0, 0, size, 0, 0, size);
        this.stopCQ(client, "testCQStopExecute_0");
        this.executeCQ(client, "testCQStopExecute_0", false, null);
        this.createValues(server, this.regions[0], 20);
        this.waitForCreated(client, "testCQStopExecute_0", "key-20");
        size = 30;
        this.validateQuery(server, this.cqs[0], 20);
        this.validateCQ(client, "testCQStopExecute_0", noTest, 20, 10, 0, 20, 10, 0, size);
        this.stopExecCQ(client, "testCQStopExecute_0", 20);
        this.closeCQ(client, "testCQStopExecute_0");
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQAttributesMutator() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCQAttributesMutator";
        this.createPool(client, poolName, host0, thePort);
        String cqName = new String("testCQAttributesMutator_0");
        this.createCQ(client, poolName, cqName, this.cqs[0]);
        this.validateCQCount(client, 1);
        this.executeCQ(client, cqName, false, null);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        this.waitForCreated(client, cqName, KEY + size);
        this.validateCQ(client, cqName, noTest, size, 0, 0, size, 0, 0, size);
        this.mutateCQAttributes(client, cqName, 1);
        this.createValues(server, this.regions[0], size * 2);
        this.waitForCreated(client, cqName, KEY + size * 2);
        this.validateCQ(client, cqName, noTest, 20, 10, 0, 20, 10, 0, 30);
        this.mutateCQAttributes(client, cqName, 2);
        this.validateCQ(client, cqName, noTest, 10, 10, 0, 10, 10, 0, 20);
        this.mutateCQAttributes(client, cqName, 0);
        this.deleteValues(server, this.regions[0], 20);
        this.waitForDestroyed(client, cqName, KEY + size * 2);
        this.validateCQ(client, cqName, noTest, 0, 0, 20, 0, 0, 20, 20);
        this.closeCQ(client, cqName);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQCreateClose() throws Exception {
        Throwable causeCause;
        Throwable cause;
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCQCreateClose";
        System.out.println("##### Pool Name :" + poolName + " host :" + host0 + " port :" + thePort);
        this.createPool(client, poolName, host0, thePort);
        this.createCQ(client, poolName, "testCQCreateClose_0", this.cqs[0]);
        this.validateCQCount(client, 1);
        this.executeCQ(client, "testCQCreateClose_0", false, null);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        this.waitForCreated(client, "testCQCreateClose_0", KEY + size);
        this.validateQuery(server, this.cqs[0], 10);
        this.validateCQ(client, "testCQCreateClose_0", noTest, size, 0, 0, size, 0, 0, size);
        this.stopCQ(client, "testCQCreateClose_0");
        this.executeCQ(client, "testCQCreateClose_0", false, null);
        this.closeCQ(client, "testCQCreateClose_0");
        this.createAndExecCQNoName(client, poolName, this.cqs[0]);
        this.failIfCQExists(client, "testCQCreateClose_0");
        this.createCQ(client, poolName, "testCQCreateClose_0", this.cqs[0]);
        this.validateCQCount(client, 1);
        try {
            this.createCQ(client, poolName, "testCQCreateClose_0", this.cqs[0]);
            CqQueryUsingPoolDUnitTest.fail((String)"Trying to create CQ with same name. Should have thrown CQExistsException");
        }
        catch (RMIException rmiExc) {
            cause = rmiExc.getCause();
            CqQueryUsingPoolDUnitTest.assertTrue((String)("unexpected cause: " + cause.getClass().getName()), (boolean)(cause instanceof AssertionError));
            causeCause = cause.getCause();
            CqQueryUsingPoolDUnitTest.assertTrue((String)("Got wrong exception: " + causeCause.getClass().getName()), (boolean)(causeCause instanceof CqExistsException));
        }
        this.failIfCQExists(client, "testCQCreateClose_NO");
        try {
            this.createCQ(server, "testCQCreateClose_1", this.cqs[0]);
            CqQueryUsingPoolDUnitTest.fail((String)"Trying to create CQ on Cache Server. Should have thrown Exception.");
        }
        catch (RMIException rmiExc) {
            cause = rmiExc.getCause();
            CqQueryUsingPoolDUnitTest.assertTrue((String)("unexpected cause: " + cause.getClass().getName()), (boolean)(cause instanceof AssertionError));
            causeCause = cause.getCause();
            CqQueryUsingPoolDUnitTest.assertTrue((String)("Got wrong exception: " + causeCause.getClass().getName()), (boolean)(causeCause instanceof IllegalStateException));
        }
        this.validateCQCount(client, 1);
        this.createCQ(client, poolName, "testCQCreateClose_3", this.cqs[2]);
        this.validateCQCount(client, 2);
        client.invoke(new CacheSerializableRunnable("CloseAll CQ :"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Close All CQ. ###");
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.getLogWriter().info("Failed to getCQService.", (Throwable)cqe);
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                try {
                    cqService.closeCqs();
                }
                catch (Exception ex) {
                    DistributedTestCase.getLogWriter().info("Failed to close All CQ.", (Throwable)ex);
                    DistributedTestCase.fail("Failed to close All CQ. ", ex);
                }
            }
        });
        this.validateCQCount(client, 0);
        this.createCQ(client, poolName, "testCQCreateClose_2", this.cqs[1]);
        this.createCQ(client, poolName, "testCQCreateClose_4", this.cqs[1]);
        this.createCQ(client, poolName, "testCQCreateClose_5", this.cqs[1]);
        this.executeCQ(client, "testCQCreateClose_4", false, null);
        this.executeCQ(client, "testCQCreateClose_5", false, null);
        client.invoke(new CacheSerializableRunnable("CloseAll CQ 2 :"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Close All CQ 2. ###");
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
                try {
                    cqService.closeCqs();
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("Failed to close All CQ  . ", ex);
                }
            }
        });
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testRegionDestroy() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testRegionDestroy";
        this.createPool(client, poolName, host0, thePort);
        this.createClient(client, thePort, host0);
        this.createCQ(client, poolName, "testRegionDestroy_0", this.cqs[0]);
        this.createCQ(client, poolName, "testRegionDestroy_1", this.cqs[0]);
        this.createCQ(client, poolName, "testRegionDestroy_2", this.cqs[0]);
        this.executeCQ(client, "testRegionDestroy_0", false, null);
        this.executeCQ(client, "testRegionDestroy_1", false, null);
        this.executeCQ(client, "testRegionDestroy_2", false, null);
        int size = 10;
        this.registerInterestListCQ(client, this.regions[0], 10, false);
        this.createValues(server, this.regions[0], 10);
        this.waitForCreated(client, "testRegionDestroy_0", "key-10");
        this.validateCQ(client, "testRegionDestroy_0", noTest, 10, noTest, noTest, 10, 0, 0, 10);
        client.invoke(new CacheSerializableRunnable("validate updates"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
                    String excuse;

                    @Override
                    public boolean done() {
                        Region region = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                        if (region == null) {
                            this.excuse = "Can't find region";
                            return false;
                        }
                        int sz = region.entrySet().size();
                        if (sz != 10) {
                            this.excuse = "Region is of size " + sz + ", expected " + 10;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public String description() {
                        return this.excuse;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 30000L, 250L, true);
                Region region = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                TestCase.assertNotNull((Object)region);
                CertifiableTestCacheListener ctl = (CertifiableTestCacheListener)region.getAttributes().getCacheListener();
                for (int i = 1; i <= 10; ++i) {
                    ctl.waitForCreated(CqQueryUsingPoolDUnitTest.KEY + i);
                    TestCase.assertNotNull((Object)region.getEntry((Object)(CqQueryUsingPoolDUnitTest.KEY + i)));
                }
            }
        });
        server.invoke(new CacheSerializableRunnable("Destroy Region"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                region1.destroyRegion();
            }
        });
        CqQueryUsingPoolDUnitTest.pause(2000);
        this.validateCQCount(client, 0);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQWithMultipleClients() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client1 = host.getVM(1);
        VM client2 = host.getVM(2);
        VM client3 = host.getVM(3);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName1 = "testCQWithMultipleClients1";
        String poolName2 = "testCQWithMultipleClients2";
        String poolName3 = "testCQWithMultipleClients3";
        this.createPool(client1, poolName1, host0, thePort);
        this.createPool(client2, poolName2, host0, thePort);
        this.createCQ(client1, poolName1, "testCQWithMultipleClients_0", this.cqs[0]);
        this.executeCQ(client1, "testCQWithMultipleClients_0", false, null);
        this.createCQ(client2, poolName2, "testCQWithMultipleClients_0", this.cqs[0]);
        this.executeCQ(client2, "testCQWithMultipleClients_0", false, null);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        this.waitForCreated(client1, "testCQWithMultipleClients_0", "key-10");
        this.validateCQ(client1, "testCQWithMultipleClients_0", noTest, size, 0, 0, size, 0, 0, size);
        this.waitForCreated(client2, "testCQWithMultipleClients_0", "key-10");
        this.validateCQ(client2, "testCQWithMultipleClients_0", noTest, size, 0, 0, size, 0, 0, size);
        this.closeCQ(client1, "testCQWithMultipleClients_0");
        this.validateCQ(client2, "testCQWithMultipleClients_0", noTest, size, 0, 0, size, 0, 0, size);
        this.createPool(client3, poolName3, host0, thePort);
        this.createCQ(client3, poolName3, "testCQWithMultipleClients_0", this.cqs[0]);
        this.createCQ(client3, poolName3, "testCQWithMultipleClients_1", this.cqs[1]);
        this.executeCQ(client3, "testCQWithMultipleClients_0", false, null);
        this.executeCQ(client3, "testCQWithMultipleClients_1", false, null);
        this.createValues(server, this.regions[0], size);
        this.waitForUpdated(client3, "testCQWithMultipleClients_0", "key-10");
        this.validateCQ(client3, "testCQWithMultipleClients_0", noTest, 0, size, 0, 0, size, 0, size);
        this.validateCQ(client3, "testCQWithMultipleClients_1", noTest, 0, 1, 0, 0, 1, 0, 1);
        this.validateCQCount(client1, 0);
        this.validateCQCount(client2, 1);
        this.validateCQCount(client3, 2);
        this.closeClient(client1);
        this.clearCQListenerEvents(client2, "testCQWithMultipleClients_0");
        this.clearCQListenerEvents(client3, "testCQWithMultipleClients_1");
        this.createValues(server, this.regions[0], size);
        this.waitForUpdated(client2, "testCQWithMultipleClients_0", "key-10");
        this.validateCQ(client2, "testCQWithMultipleClients_0", noTest, size, size * 2, 0, size, size * 2, 0, size * 3);
        this.waitForUpdated(client3, "testCQWithMultipleClients_1", "key-2");
        this.validateCQ(client3, "testCQWithMultipleClients_1", noTest, 0, 2, 0, 0, 2, 0, 2);
        this.closeClient(client2);
        this.closeClient(client3);
        this.closeServer(server);
    }

    public void testCQResultSet() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCQResultSet";
        this.createPool(client, poolName, host0, thePort);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        CqQueryUsingPoolDUnitTest.pause(500);
        this.createCQ(client, poolName, "testCQResultSet_0", this.cqs[0]);
        this.executeCQ(client, "testCQResultSet_0", true, 10, null, null);
        this.createCQ(client, poolName, "testCQResultSet_1", this.cqs[2]);
        this.executeCQ(client, "testCQResultSet_1", true, 0, null, null);
        this.stopCQ(client, "testCQResultSet_1");
        this.createValues(server, this.regions[1], 5);
        this.validateQuery(server, this.cqs[2], 2);
        this.executeCQ(client, "testCQResultSet_1", true, 2, null, null);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQEvents() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCQEvents";
        this.createPool(client, poolName, host0, thePort);
        this.createCQ(client, poolName, "testCQEvents_0", this.cqs[0]);
        this.executeCQ(client, "testCQEvents_0", false, null);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        this.waitForCreated(client, "testCQEvents_0", KEY + size);
        this.validateCQ(client, "testCQEvents_0", noTest, size, 0, 0, size, 0, 0, size);
        this.createValues(server, this.regions[0], 5);
        this.createValues(server, this.regions[0], 10);
        this.waitForUpdated(client, "testCQEvents_0", KEY + size);
        this.validateCQ(client, "testCQEvents_0", noTest, size, 15, 0, size, 15, 0, size + 15);
        this.deleteValues(server, this.regions[0], 5);
        this.waitForDestroyed(client, "testCQEvents_0", "key-5");
        this.validateCQ(client, "testCQEvents_0", noTest, size, 15, 5, size, 15, 5, size + 15 + 5);
        server.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                for (int i = -1; i >= -5; --i) {
                    region1.put((Object)(CqQueryUsingPoolDUnitTest.KEY + i), (Object)(CqQueryUsingPoolDUnitTest.KEY + i));
                }
            }
        });
        CqQueryUsingPoolDUnitTest.pause(1000);
        this.validateCQ(client, "testCQEvents_0", noTest, size, 15, 5, size, 15, 5, size + 15 + 5);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCqEventsWithoutAlias() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testCQEvents";
        this.createPool(client, poolName, host0, thePort);
        this.createCQ(client, poolName, "testCQEvents_0", this.cqs[11]);
        this.executeCQ(client, "testCQEvents_0", false, null);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        this.waitForCreated(client, "testCQEvents_0", KEY + size);
        this.validateCQ(client, "testCQEvents_0", noTest, size, 0, 0, size, 0, 0, size);
        this.createValues(server, this.regions[0], 5);
        this.createValues(server, this.regions[0], 10);
        this.waitForUpdated(client, "testCQEvents_0", KEY + size);
        this.validateCQ(client, "testCQEvents_0", noTest, size, 15, 0, size, 15, 0, size + 15);
        this.deleteValues(server, this.regions[0], 5);
        this.waitForDestroyed(client, "testCQEvents_0", "key-5");
        this.validateCQ(client, "testCQEvents_0", noTest, size, 15, 5, size, 15, 5, size + 15 + 5);
        server.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                for (int i = -1; i >= -5; --i) {
                    region1.put((Object)(CqQueryUsingPoolDUnitTest.KEY + i), (Object)(CqQueryUsingPoolDUnitTest.KEY + i));
                }
            }
        });
        CqQueryUsingPoolDUnitTest.pause(1000);
        this.validateCQ(client, "testCQEvents_0", noTest, size, 15, 5, size, 15, 5, size + 15 + 5);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testEnableDisableCQ() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testEnableDisableCQ";
        this.createPool(client, poolName, host0, thePort);
        this.createCQ(client, poolName, "testEnableDisable_0", this.cqs[0]);
        this.executeCQ(client, "testEnableDisable_0", false, null);
        client.invoke(new CacheSerializableRunnable("Client disableCQs()"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                    cqService.stopCqs();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
            }
        });
        CqQueryUsingPoolDUnitTest.pause(1000);
        int size = 10;
        this.createValues(server, this.regions[0], size);
        CqQueryUsingPoolDUnitTest.pause(500);
        this.validateCQ(client, "testEnableDisable_0", noTest, 0, 0, 0, 0, 0, 0, 0);
        client.invoke(new CacheSerializableRunnable("Client enableCQs()"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                    cqService.executeCqs();
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
            }
        });
        CqQueryUsingPoolDUnitTest.pause(1000);
        this.createValues(server, this.regions[0], size);
        this.waitForUpdated(client, "testEnableDisable_0", KEY + size);
        this.validateCQ(client, "testEnableDisable_0", noTest, 0, size, 0, 0, size, 0, size);
        client.invoke(new CacheSerializableRunnable("Client disableCQs()"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                    cqService.stopCqs("/root/" + CqQueryUsingPoolDUnitTest.this.regions[0]);
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
            }
        });
        CqQueryUsingPoolDUnitTest.pause(2000);
        this.deleteValues(server, this.regions[0], size / 2);
        CqQueryUsingPoolDUnitTest.pause(500);
        this.validateCQ(client, "testEnableDisable_0", noTest, 0, size, 0, 0, size, 0, size);
        client.invoke(new CacheSerializableRunnable("Client enableCQs()"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                    cqService.executeCqs("/root/" + CqQueryUsingPoolDUnitTest.this.regions[0]);
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService.", cqe);
                }
            }
        });
        CqQueryUsingPoolDUnitTest.pause(1000);
        this.createValues(server, this.regions[0], size / 2);
        this.waitForCreated(client, "testEnableDisable_0", KEY + size / 2);
        this.validateCQ(client, "testEnableDisable_0", noTest, size / 2, size, 0, size / 2, size, 0, size * 3 / 2);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testQuery() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testQuery";
        this.createPool(client, poolName, host0, thePort);
        this.createClient(client, thePort, host0);
        this.createCQ(client, poolName, "testQuery_3", this.cqs[3]);
        this.executeCQ(client, "testQuery_3", true, null);
        this.createCQ(client, poolName, "testQuery_4", this.cqs[4]);
        this.executeCQ(client, "testQuery_4", true, null);
        this.createCQ(client, poolName, "testQuery_5", this.cqs[5]);
        this.executeCQ(client, "testQuery_5", true, null);
        this.createCQ(client, poolName, "testQuery_6", this.cqs[6]);
        this.executeCQ(client, "testQuery_6", true, null);
        this.createCQ(client, poolName, "testQuery_7", this.cqs[7]);
        this.executeCQ(client, "testQuery_7", true, null);
        this.createCQ(client, poolName, "testQuery_8", this.cqs[8]);
        this.executeCQ(client, "testQuery_8", true, null);
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testCQFailOver() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1);
        int port1 = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        String poolName = "testCQFailOver";
        this.createPool(client, poolName, new String[]{host0, host0}, new int[]{port1, ports[0]});
        int numCQs = 1;
        for (int i2 = 0; i2 < numCQs; ++i2) {
            this.createCQ(client, poolName, "testCQFailOver_" + i2, this.cqs[i2]);
            this.executeCQ(client, "testCQFailOver_" + i2, false, null);
        }
        CqQueryUsingPoolDUnitTest.pause(1000);
        this.createValues(server1, this.regions[0], 10);
        this.createValues(server1, this.regions[1], 10);
        this.waitForCreated(client, "testCQFailOver_0", "key-10");
        CqQueryUsingPoolDUnitTest.pause(1000);
        this.createServer(server2, ports[0]);
        int thePort2 = server2.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        System.out.println("### Port on which server1 running : " + port1 + " Server2 running : " + thePort2);
        CqQueryUsingPoolDUnitTest.pause(3000);
        CqQueryUsingPoolDUnitTest.pause(5000);
        this.createValues(server1, this.regions[0], 10);
        this.createValues(server1, this.regions[1], 10);
        this.waitForUpdated(client, "testCQFailOver_0", "key-10");
        int[] resultsCnt = new int[]{10, 1, 2};
        for (i = 0; i < numCQs; ++i) {
            this.validateCQ(client, "testCQFailOver_" + i, noTest, resultsCnt[i], resultsCnt[i], noTest);
        }
        this.closeServer(server1);
        CqQueryUsingPoolDUnitTest.pause(3000);
        for (i = 0; i < numCQs; ++i) {
            this.validateCQ(client, "testCQFailOver_" + i, noTest, resultsCnt[i], resultsCnt[i], noTest);
        }
        this.clearCQListenerEvents(client, "testCQFailOver_0");
        this.createValues(server2, this.regions[0], 10);
        this.createValues(server2, this.regions[1], 10);
        for (i = 1; i <= 10; ++i) {
            this.waitForUpdated(client, "testCQFailOver_0", KEY + i);
        }
        for (i = 0; i < numCQs; ++i) {
            this.validateCQ(client, "testCQFailOver_" + i, noTest, resultsCnt[i], resultsCnt[i] * 2, noTest);
        }
        this.closeClient(client);
        this.closeServer(server2);
    }

    public void testCQHA() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM client = host.getVM(3);
        this.createServer(server1);
        int port1 = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server1.getHost());
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        this.createServer(server2, ports[0]);
        int thePort2 = server2.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        this.createServer(server3, ports[1]);
        int port3 = server3.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        System.out.println("### Port on which server1 running : " + port1 + " server2 running : " + thePort2 + " Server3 running : " + port3);
        String poolName = "testCQStopExecute";
        this.createPool(client, poolName, new String[]{host0, host0, host0}, new int[]{port1, thePort2, port3});
        int numCQs = 1;
        for (int i2 = 0; i2 < numCQs; ++i2) {
            this.createCQ(client, poolName, "testCQHA_" + i2, this.cqs[i2]);
            this.executeCQ(client, "testCQHA_" + i2, false, null);
        }
        CqQueryUsingPoolDUnitTest.pause(1000);
        this.createValues(server1, this.regions[0], 10);
        this.createValues(server1, this.regions[1], 10);
        this.waitForCreated(client, "testCQHA_0", "key-10");
        int[] resultsCnt = new int[]{10, 1, 2};
        this.closeServer(server1);
        CqQueryUsingPoolDUnitTest.pause(3000);
        this.createValues(server2, this.regions[0], 10);
        this.createValues(server2, this.regions[1], 10);
        this.waitForUpdated(client, "testCQHA_0", "key-10");
        for (i = 0; i < numCQs; ++i) {
            this.validateCQ(client, "testCQHA_" + i, noTest, resultsCnt[i], resultsCnt[i], noTest);
        }
        this.closeServer(server2);
        CqQueryUsingPoolDUnitTest.pause(2000);
        this.clearCQListenerEvents(client, "testCQHA_0");
        this.createValues(server3, this.regions[0], 10);
        this.createValues(server3, this.regions[1], 10);
        this.waitForUpdated(client, "testCQHA_0", "key-10");
        for (i = 0; i < numCQs; ++i) {
            this.validateCQ(client, "testCQHA_" + i, noTest, resultsCnt[i], resultsCnt[i] * 2, noTest);
        }
        this.closeClient(client);
        this.closeServer(server3);
    }

    public void testFilterRegistrationDuringGII() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client1 = host.getVM(2);
        VM client2 = host.getVM(3);
        this.createServer(server1);
        int port1 = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server1.getHost());
        final int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        String poolName = "testFilterRegistrationDuringGII";
        this.createPool(client1, poolName, new String[]{host0, host0}, new int[]{port1, ports[0]}, "-1");
        this.createPool(client2, poolName, new String[]{host0, host0}, new int[]{port1, ports[0]}, "-1");
        this.createClient(client1, new int[]{port1, ports[0]}, host0, "-1", poolName);
        this.createClient(client2, new int[]{port1, ports[0]}, host0, "-1", poolName);
        int numCQs = 2;
        for (int i = 0; i < 2; ++i) {
            this.createCQ(client1, poolName, "client1_" + i, this.cqs[i]);
            this.executeCQ(client1, "client1_" + i, false, null);
            this.createCQ(client2, poolName, "client2_" + i, this.cqs[i]);
            this.executeCQ(client2, "client2_" + i, false, null);
        }
        int interestSize = 20;
        this.registerInterestListCQ(client1, this.regions[0], 20, false);
        this.registerInterestListCQ(client2, this.regions[0], 0, true);
        CqQueryUsingPoolDUnitTest.pause(1000);
        this.createValues(server1, this.regions[0], 100);
        this.createValues(server1, this.regions[1], 10);
        this.waitForCreated(client1, "client1_0", "key-10");
        server2.invoke(new CacheSerializableRunnable("Create Cache Server"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Cache Server. ###");
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setMirrorType(MirrorType.KEYS_VALUES);
                for (int i = 0; i < CqQueryUsingPoolDUnitTest.this.regions.length; ++i) {
                    CqQueryUsingPoolDUnitTest.this.createRegion(CqQueryUsingPoolDUnitTest.this.regions[i], factory.createRegionAttributes());
                }
                InitialImageOperation.slowImageProcessing = 100;
                try {
                    try {
                        CqQueryUsingPoolDUnitTest.this.startBridgeServer(ports[0], true);
                    }
                    catch (Exception ex) {
                        DistributedTestCase.fail("While starting CacheServer", ex);
                    }
                    while (true) {
                        if (InitialImageOperation.slowImageSleeps > 0) {
                            LocalRegion region1 = (LocalRegion)CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                            for (int i = 90; i <= 120; ++i) {
                                region1.put((Object)(CqQueryUsingPoolDUnitTest.KEY + i), (Object)new Portfolio(i, i));
                            }
                            break;
                        }
                        DistributedTestCase.pause(20);
                    }
                }
                finally {
                    InitialImageOperation.slowImageProcessing = 0;
                }
            }
        });
        CqQueryUsingPoolDUnitTest.pause(3000);
        server2.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                DefaultQueryService qs = (DefaultQueryService)CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                Collection proxies = CacheClientNotifier.getInstance().getClientProxies();
                Iterator iter = proxies.iterator();
                try {
                    for (CacheClientProxy p : proxies) {
                        ClientProxyMembershipID clientId = p.getProxyID();
                        List cqs = qs.getCqService().getAllClientCqs(clientId);
                        CqQueryUsingPoolDUnitTest.this.getCache().getLogger().fine("Number of CQs found for client :" + clientId + " are :" + cqs.size());
                        if (cqs.size() != 2) {
                            TestCase.fail((String)("Number of CQs registerted by the client is :" + cqs.size() + " less than expected : " + 2));
                        }
                        CqQuery cq = (CqQuery)cqs.get(0);
                        LocalRegion region1 = (LocalRegion)CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                        if (cq.getName().startsWith("client1_")) {
                            if (region1.getFilterProfile().getKeysOfInterest((Object)clientId) != null && region1.getFilterProfile().getKeysOfInterest((Object)clientId).size() == 20) continue;
                            TestCase.fail((String)"Interest registartion during Secondary HARegion creation has failed.");
                            continue;
                        }
                        if (region1.getFilterProfile().isInterestedInAllKeys((Object)clientId)) continue;
                        TestCase.fail((String)"Interest registartion during Secondary HARegion creation has failed.");
                    }
                }
                catch (Exception ex) {
                    TestCase.fail((String)("Exception while validating filter count. " + ex.getMessage()));
                }
            }
        });
        this.closeClient(client1);
        this.closeClient(client2);
        this.closeServer(server1);
        this.closeServer(server2);
    }

    public void testWithoutCQs() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        this.createServer(server1);
        this.createServer(server2);
        final int port1 = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        final String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server1.getHost());
        final int thePort2 = server2.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        CacheSerializableRunnable createConnectionPool = new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                CqQueryUsingPoolDUnitTest.this.getCache();
                AttributesFactory regionFactory = new AttributesFactory();
                regionFactory.setScope(Scope.LOCAL);
                BridgeTestCase.configureConnectionPool(regionFactory, host0, port1, thePort2, true, -1, -1, null);
                CqQueryUsingPoolDUnitTest.this.createRegion(CqQueryUsingPoolDUnitTest.this.regions[0], regionFactory.createRegionAttributes());
            }
        };
        client.invoke(createConnectionPool);
        server1.invoke(new CacheSerializableRunnable("Create values"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                for (int i = 0; i < 20; ++i) {
                    region1.put((Object)("key-string-" + i), (Object)("value-" + i));
                }
            }
        });
        client.invoke(new CacheSerializableRunnable("Put values client"){

            @Override
            public void run2() throws CacheException {
                Region region1 = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(CqQueryUsingPoolDUnitTest.this.regions[0]);
                for (int i = 0; i < 10; ++i) {
                    region1.put((Object)("key-string-" + i), (Object)("client-value-" + i));
                }
            }
        });
        CqQueryUsingPoolDUnitTest.pause(2000);
        this.closeServer(server1);
        this.closeServer(server2);
    }

    public void testGetCQsForARegionName() throws Exception {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testGetCQsForARegionName";
        this.createPool(client, poolName, host0, thePort);
        this.createCQ(client, poolName, "testQuery_3", this.cqs[3]);
        this.executeCQ(client, "testQuery_3", true, null);
        this.createCQ(client, poolName, "testQuery_4", this.cqs[4]);
        this.executeCQ(client, "testQuery_4", true, null);
        this.createCQ(client, poolName, "testQuery_5", this.cqs[5]);
        this.executeCQ(client, "testQuery_5", true, null);
        this.createCQ(client, poolName, "testQuery_6", this.cqs[6]);
        this.executeCQ(client, "testQuery_6", true, null);
        this.createCQ(client, poolName, "testQuery_7", this.cqs[7]);
        this.executeCQ(client, "testQuery_7", true, null);
        this.createCQ(client, poolName, "testQuery_8", this.cqs[8]);
        this.executeCQ(client, "testQuery_8", true, null);
        client.invoke(new CacheSerializableRunnable("Client disableCQs()"){

            @Override
            public void run2() throws CacheException {
                QueryService cqService = null;
                try {
                    cqService = CqQueryUsingPoolDUnitTest.this.getCache().getQueryService();
                    CqQuery[] cq = cqService.getCqs("/root/" + CqQueryUsingPoolDUnitTest.this.regions[0]);
                    TestCase.assertNotNull((String)("CQservice should not return null for cqs on this region : /root/" + CqQueryUsingPoolDUnitTest.this.regions[0]), (Object)cq);
                    CqQueryUsingPoolDUnitTest.this.getCache().getLogger().info("cqs for region: /root/" + CqQueryUsingPoolDUnitTest.this.regions[0] + " : " + cq.length);
                    cq[0].close();
                    cq = cqService.getCqs("/root/" + CqQueryUsingPoolDUnitTest.this.regions[0]);
                    TestCase.assertNotNull((String)("CQservice should not return null for cqs on this region : /root/" + CqQueryUsingPoolDUnitTest.this.regions[0]), (Object)cq);
                    CqQueryUsingPoolDUnitTest.this.getCache().getLogger().info("cqs for region: /root/" + CqQueryUsingPoolDUnitTest.this.regions[0] + " after closeing one of the cqs : " + cq.length);
                    cq = cqService.getCqs("/root/" + CqQueryUsingPoolDUnitTest.this.regions[1]);
                    CqQueryUsingPoolDUnitTest.this.getCache().getLogger().info("cqs for region: /root/" + CqQueryUsingPoolDUnitTest.this.regions[1] + " : " + cq.length);
                    TestCase.assertNotNull((String)("CQservice should not return null for cqs on this region : /root/" + CqQueryUsingPoolDUnitTest.this.regions[1]), (Object)cq);
                }
                catch (Exception cqe) {
                    DistributedTestCase.fail("Failed to getCQService", cqe);
                }
            }
        });
        this.closeClient(client);
        this.closeServer(server);
    }

    public void testQueryWithNULLInWhereClause() throws Exception {
        int i;
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        VM producer = host.getVM(2);
        this.createServer(server);
        int thePort = server.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server.getHost());
        String poolName = "testQueryWithNULLInWhereClause";
        this.createPool(client, poolName, host0, thePort);
        this.createClient(producer, thePort, host0);
        int size = 50;
        this.createValues(producer, this.regions[0], 50);
        this.createCQ(client, poolName, "testQuery_9", this.cqs[9]);
        this.executeCQ(client, "testQuery_9", true, null);
        this.createValues(producer, this.regions[0], 100);
        for (i = 1; i <= 50; ++i) {
            if (i % 2 != 0) continue;
            this.waitForUpdated(client, "testQuery_9", KEY + i);
        }
        for (i = 51; i <= 100; ++i) {
            if (i % 2 != 0) continue;
            this.waitForCreated(client, "testQuery_9", KEY + i);
        }
        this.validateCQ(client, "testQuery_9", noTest, 25, 25, noTest);
        this.closeClient(client);
        this.closeServer(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testForSupportedRegionAttributes() throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM client = host.getVM(2);
        CacheSerializableRunnable createServer = new CacheSerializableRunnable("Create Cache Server"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.getLogWriter().info("### Create Cache Server. ###");
                AttributesFactory factory1 = new AttributesFactory();
                factory1.setScope(Scope.GLOBAL);
                factory1.setMirrorType(MirrorType.KEYS_VALUES);
                CqQueryUsingPoolDUnitTest.this.createRegion(CqQueryUsingPoolDUnitTest.this.regions[0], factory1.createRegionAttributes());
                AttributesFactory factory2 = new AttributesFactory();
                factory2.setScope(Scope.DISTRIBUTED_NO_ACK);
                factory2.setMirrorType(MirrorType.KEYS_VALUES);
                CqQueryUsingPoolDUnitTest.this.createRegion(CqQueryUsingPoolDUnitTest.this.regions[1], factory2.createRegionAttributes());
                DistributedTestCase.pause(2000);
                try {
                    CqQueryUsingPoolDUnitTest.this.startBridgeServer(port, true);
                }
                catch (Exception ex) {
                    DistributedTestCase.fail("While starting CacheServer", ex);
                }
                DistributedTestCase.pause(2000);
            }
        };
        server1.invoke(createServer);
        server2.invoke(createServer);
        int port1 = server1.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String host0 = CqQueryUsingPoolDUnitTest.getServerHostName(server1.getHost());
        int thePort2 = server2.invokeInt(CqQueryUsingPoolDUnitTest.class, "getCacheServerPort");
        String poolName = "testForSupportedRegionAttributes";
        this.createPool(client, poolName, new String[]{host0, host0}, new int[]{port1, thePort2});
        this.createCQ(client, poolName, "testForSupportedRegionAttributes_0", this.cqs[0]);
        this.executeCQ(client, "testForSupportedRegionAttributes_0", false, null);
        int size = 5;
        this.createValues(server1, this.regions[0], size);
        for (int i = 1; i <= size; ++i) {
            this.waitForCreated(client, "testForSupportedRegionAttributes_0", KEY + i);
        }
        this.createCQ(client, poolName, "testForSupportedRegionAttributes_1", this.cqs[2]);
        String errMsg = "The replicated region  specified in CQ creation does not have scope supported by CQ. The CQ supported scopes are DISTRIBUTED_ACK and GLOBAL.";
        String expectedErr = "Cq not registered on primary";
        client.invoke(new CacheSerializableRunnable("Set expect"){

            @Override
            public void run2() {
                CqQueryUsingPoolDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>Cq not registered on primary</ExpectedException>");
            }
        });
        try {
            this.executeCQ(client, "testForSupportedRegionAttributes_1", false, "CqException");
            CqQueryUsingPoolDUnitTest.fail((String)("The test should have failed with exception, " + errMsg));
            client.invoke(new CacheSerializableRunnable("Remove expect"){

                @Override
                public void run2() {
                    CqQueryUsingPoolDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>Cq not registered on primary</ExpectedException>");
                }
            });
        }
        catch (Exception exception) {
            client.invoke(new /* invalid duplicate definition of identical inner class */);
            catch (Throwable throwable) {
                client.invoke(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
        this.closeClient(client);
        this.closeServer(server1);
        this.closeServer(server2);
    }

    private void validateServerClientRegionEntries(VM server, VM client, final String regionName) {
        server.invoke(new CacheSerializableRunnable("Server Region Entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(regionName);
                DistributedTestCase.getLogWriter().info("### Entries in Server :" + region.keys().size());
            }
        });
        client.invoke(new CacheSerializableRunnable("Client Region Entries"){

            @Override
            public void run2() throws CacheException {
                Region region = CqQueryUsingPoolDUnitTest.this.getRootRegion().getSubregion(regionName);
                DistributedTestCase.getLogWriter().info("### Entries in Client :" + region.keys().size());
            }
        });
    }

    public void startBridgeServer(int port) throws IOException {
        this.startBridgeServer(port, true);
    }

    public void startBridgeServer(int port, boolean notifyBySubscription) throws IOException {
        Cache cache = this.getCache();
        BridgeServer bridge = cache.addBridgeServer();
        bridge.setPort(port);
        bridge.setNotifyBySubscription(notifyBySubscription);
        bridge.start();
        bridgeServerPort = bridge.getPort();
    }

    protected void stopBridgeServer(Cache cache) {
        BridgeServer bridge = (BridgeServer)cache.getBridgeServers().iterator().next();
        bridge.stop();
        CqQueryUsingPoolDUnitTest.assertFalse((boolean)bridge.isRunning());
    }

    private void stopBridgeServers(Cache cache) {
        BridgeServer bridge2 = null;
        for (BridgeServer bridge2 : cache.getBridgeServers()) {
            bridge2.stop();
            CqQueryUsingPoolDUnitTest.assertFalse((boolean)bridge2.isRunning());
        }
    }

    private void restartBridgeServers(Cache cache) throws IOException {
        BridgeServer bridge2 = null;
        for (BridgeServer bridge2 : cache.getBridgeServers()) {
            bridge2.start();
            CqQueryUsingPoolDUnitTest.assertTrue((boolean)bridge2.isRunning());
        }
    }

    private InternalDistributedSystem createLonerDS() {
        CqQueryUsingPoolDUnitTest.disconnectFromDS();
        Properties lonerProps = new Properties();
        lonerProps.setProperty("mcast-port", "0");
        lonerProps.setProperty("locators", "");
        InternalDistributedSystem ds = this.getSystem(lonerProps);
        CqQueryUsingPoolDUnitTest.assertEquals((int)0, (int)ds.getDistributionManager().getOtherDistributionManagerIds().size());
        return ds;
    }

    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        return factory.createRegionAttributes();
    }

    static {
        port = 0;
        port2 = 0;
        noTest = -1;
        MAX_TIME = Integer.getInteger(WAIT_PROPERTY, 20000).intValue();
    }
}

