/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.QueryStatistics;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import com.gemstone.gemfire.cache.query.internal.ResultsSet;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.NanoTimer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;

public class PerfQuery {
    private static int NUM_ITERATIONS = 20000;
    private static final int HAND_CODED = 0;
    private static final int BRUTE_FORCE = 1;
    private static final int INDEXED = 2;
    private static final int INDEX_CREATE = 3;
    private static final String[] execTypeStrings = new String[]{"hand-coded", "brute force", "indexed", "index-create"};
    private static final int[] DATA_SET_SIZES = new int[]{100, 1000, 10000, 20000};
    private DistributedSystem ds;
    private Region region = null;
    private RegionAttributes regionAttributes;
    private QueryService qs;
    protected Cache cache;
    private final FloatArrayList[] results = new FloatArrayList[4];

    public PerfQuery() {
        this.results[1] = new FloatArrayList();
        this.results[0] = new FloatArrayList();
        this.results[2] = new FloatArrayList();
        this.results[3] = new FloatArrayList();
    }

    public void run() throws Exception {
        Date startTime = new Date();
        this.setUp();
        DateFormat formatter = DateFormat.getDateTimeInstance();
        System.out.println("Test started at: " + formatter.format(startTime));
        this.runQueries();
        this.printSummary();
        this.tearDown();
        Date endTime = new Date();
        System.out.println("Test ended at: " + formatter.format(endTime));
        long durationMs = endTime.getTime() - startTime.getTime();
        long durationS = durationMs / 1000L;
        long durationM = durationS / 60L;
        long durationMM = durationM % 60L;
        long durationH = durationM / 60L;
        System.out.println("Test took " + durationH + "hrs, " + durationMM + "min.");
    }

    private void printSummary() {
        System.out.println("Query Execution Performance Results Summary");
        System.out.println("num iterations = " + NUM_ITERATIONS);
        System.out.println();
        System.out.println("Average query execution time in ms");
        System.out.println();
        String[] setNames = new String[]{"33% Retrieval", "0% Retrieval"};
        for (int setI = 0; setI < setNames.length; ++setI) {
            String setName = setNames[setI];
            System.out.println(setName + ":");
            System.out.println("dataset size,hand-coded,brute-force,indexed,[index-create-time]");
            for (int szi = 0; szi < DATA_SET_SIZES.length; ++szi) {
                System.out.print(DATA_SET_SIZES[szi]);
                System.out.print(',');
                for (int ti = 0; ti <= 3; ++ti) {
                    int ix = (setI + 1) * DATA_SET_SIZES.length + szi;
                    System.out.print(this.results[ti].get(ix));
                    if (ti >= 3) continue;
                    System.out.print(',');
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    private void runQueries() throws Exception {
        System.out.println("WARMING UP...");
        String queryString = "select distinct * from /portfolios where type = 'type1'";
        Query query = this.qs.newQuery(queryString);
        this.runQuery(this.getType1HandQuery(queryString), 0);
        this.runQuery(query, 1);
        this.runQuery(query, 2);
        this.warmUpIndexCreation();
        System.out.println("END WARM UP");
        queryString = "select distinct * from /portfolios where type = 'type1'";
        query = this.qs.newQuery(queryString);
        this.runQuery(this.getType1HandQuery(queryString), 0);
        this.runQuery(query, 1);
        this.runQuery(query, 2);
        queryString = "select distinct * from /portfolios where type = 'miss'";
        query = this.qs.newQuery(queryString);
        this.runQuery(this.getMissHandQuery(queryString), 0);
        this.runQuery(query, 1);
        this.runQuery(query, 2);
    }

    private void runQuery(Query query, int execType) throws Exception {
        System.out.println("Executing Query: " + query.getQueryString());
        System.out.println("Num iterations=" + NUM_ITERATIONS);
        System.out.println();
        boolean indexed = execType == 2;
        for (int i = 0; i < DATA_SET_SIZES.length; ++i) {
            int num = DATA_SET_SIZES[i];
            this.populate(num, indexed);
            System.out.println("Executing (" + execTypeStrings[execType] + ")...");
            long startTime = NanoTimer.getTime();
            SelectResults results = null;
            for (int j = 0; j < NUM_ITERATIONS; ++j) {
                results = (SelectResults)query.execute();
            }
            long totalTime = NanoTimer.getTime() - startTime;
            System.out.println("results size =" + results.size());
            float aveTime = (float)(totalTime / (long)NUM_ITERATIONS) / 1000000.0f;
            System.out.println("ave execution time=" + aveTime + " ms");
            this.results[execType].add(aveTime);
            System.out.println();
        }
        System.out.println("--------------------------------------------");
    }

    private Query getType1HandQuery(String queryString) {
        return new HandQuery(queryString){

            @Override
            public Object execute() {
                Region region = PerfQuery.this.cache.getRegion("/portfolios");
                ResultsSet results = new ResultsSet();
                for (Portfolio ptflo : region.values()) {
                    if (!"type1".equals(ptflo.getType())) continue;
                    results.add((Object)ptflo);
                }
                return results;
            }
        };
    }

    private Query getMissHandQuery(String queryString) {
        return new HandQuery(queryString){

            @Override
            public Object execute() {
                Region region = PerfQuery.this.cache.getRegion("/portfolios");
                ResultsSet results = new ResultsSet();
                for (Portfolio ptflo : region.values()) {
                    if (!"miss".equals(ptflo.getType())) continue;
                    results.add((Object)ptflo);
                }
                return results;
            }
        };
    }

    private void setUp() throws CacheException {
        this.ds = DistributedSystem.connect((Properties)new Properties());
        this.cache = CacheFactory.create((DistributedSystem)this.ds);
        AttributesFactory attributesFactory = new AttributesFactory();
        attributesFactory.setValueConstraint(Portfolio.class);
        this.regionAttributes = attributesFactory.create();
        this.qs = this.cache.getQueryService();
    }

    private void tearDown() {
        this.ds.disconnect();
    }

    private void populate(int numPortfolios, boolean indexed) throws CacheException, QueryException {
        System.out.println("Populating Cache with " + numPortfolios + " Portfolios");
        if (this.region != null) {
            this.region.localDestroyRegion();
        }
        this.region = this.cache.createRegion("portfolios", this.regionAttributes);
        for (int i = 0; i < numPortfolios; ++i) {
            this.region.put((Object)String.valueOf(i), (Object)new Portfolio(i));
        }
        if (indexed) {
            System.out.println("Creating index...");
            long startNanos = NanoTimer.getTime();
            this.qs.createIndex("portfolios", IndexType.FUNCTIONAL, "type", "/portfolios");
            float createTime = (float)(NanoTimer.getTime() - startNanos) / 1000000.0f;
            System.out.println("Index created in " + createTime + " ms.");
            this.results[3].add(createTime);
        }
    }

    private void warmUpIndexCreation() throws CacheException, QueryException {
        int i;
        System.out.println("Populating Cache with 1000 Portfolios");
        if (this.region != null) {
            this.region.localDestroyRegion();
        }
        this.region = this.cache.createRegion("portfolios", this.regionAttributes);
        for (i = 0; i < 1000; ++i) {
            this.region.put((Object)String.valueOf(i), (Object)new Portfolio(i));
        }
        System.out.println("Warming up index creation...");
        for (i = 0; i < 20000; ++i) {
            Index index = this.qs.createIndex("portfolios", IndexType.FUNCTIONAL, "type", "/portfolios");
            this.qs.removeIndex(index);
        }
    }

    public static void main(String[] args) throws Exception {
        new PerfQuery().run();
    }

    abstract class HandQuery
    implements Query {
        private final String queryString;

        HandQuery(String queryString) {
            this.queryString = queryString;
        }

        public abstract Object execute() throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException;

        public void compile() throws TypeMismatchException, NameResolutionException {
        }

        public boolean isCompiled() {
            return true;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public Object execute(Object[] params) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            throw new UnsupportedOperationException();
        }

        public QueryStatistics getStatistics() {
            throw new UnsupportedOperationException();
        }

        public Set getRegionsInQuery() {
            throw new UnsupportedOperationException();
        }

        public Object execute(RegionFunctionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            throw new UnsupportedOperationException();
        }

        public Object execute(RegionFunctionContext context, Object[] params) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            throw new UnsupportedOperationException();
        }
    }
}

