/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.hdfs.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueStats;
import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.UnsortedHoplogPersistedEvent;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogSetReader;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.SequenceFileHoplog;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogStatistics;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import dunit.AsyncInvocation;
import dunit.DUnitEnv;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public abstract class RegionWithHDFSTestBase
extends CacheTestCase {
    protected String tmpDir;

    protected abstract void checkWithGetAll(String var1, ArrayList var2);

    protected abstract void checkWithGet(String var1, int var2, int var3, boolean var4);

    protected abstract void doDestroys(String var1, int var2, int var3);

    protected abstract void doPutAll(String var1, Map var2);

    protected abstract void doPuts(String var1, int var2, int var3);

    protected abstract SerializableCallable getCreateRegionCallable(int var1, int var2, int var3, String var4, String var5, int var6, boolean var7, boolean var8, long var9, long var11);

    protected abstract void verifyHDFSData(VM var1, String var2) throws Exception;

    protected abstract AsyncInvocation doAsyncPuts(VM var1, String var2, int var3, int var4, String var5) throws Exception;

    public RegionWithHDFSTestBase(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        FileUtil.delete((File)new File(this.tmpDir));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.tmpDir = "RegionWithHDFSBasicDUnitTest_" + System.nanoTime();
    }

    int createServerRegion(VM vm, int totalnumOfBuckets, int batchSize, int maximumEntries, String folderPath, String uniqueName, int batchInterval) {
        return this.createServerRegion(vm, totalnumOfBuckets, batchSize, maximumEntries, folderPath, uniqueName, batchInterval, false, false);
    }

    protected int createServerRegion(VM vm, int totalnumOfBuckets, int batchSizeMB, int maximumEntries, String folderPath, String uniqueName, int batchInterval, boolean writeonly, boolean queuePersistent) {
        return this.createServerRegion(vm, totalnumOfBuckets, batchSizeMB, maximumEntries, folderPath, uniqueName, batchInterval, writeonly, queuePersistent, -1L, -1L);
    }

    protected int createServerRegion(VM vm, int totalnumOfBuckets, int batchSizeMB, int maximumEntries, String folderPath, String uniqueName, int batchInterval, boolean writeonly, boolean queuePersistent, long timeForRollover, long maxFileSize) {
        SerializableCallable createRegion = this.getCreateRegionCallable(totalnumOfBuckets, batchSizeMB, maximumEntries, folderPath, uniqueName, batchInterval, queuePersistent, writeonly, timeForRollover, maxFileSize);
        return (Integer)vm.invoke(createRegion);
    }

    protected AsyncInvocation createServerRegionAsync(VM vm, int totalnumOfBuckets, int batchSizeMB, int maximumEntries, String folderPath, String uniqueName, int batchInterval, boolean writeonly, boolean queuePersistent) {
        SerializableCallable createRegion = this.getCreateRegionCallable(totalnumOfBuckets, batchSizeMB, maximumEntries, folderPath, uniqueName, batchInterval, queuePersistent, writeonly, -1L, -1L);
        return vm.invokeAsync(createRegion);
    }

    protected AsyncInvocation createServerRegionAsync(VM vm, int totalnumOfBuckets, int batchSizeMB, int maximumEntries, String folderPath, String uniqueName, int batchInterval, boolean writeonly, boolean queuePersistent, long timeForRollover, long maxFileSize) {
        SerializableCallable createRegion = this.getCreateRegionCallable(totalnumOfBuckets, batchSizeMB, maximumEntries, folderPath, uniqueName, batchInterval, queuePersistent, writeonly, timeForRollover, maxFileSize);
        return vm.invokeAsync(createRegion);
    }

    public void testGetFromHDFS() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String uniqueName = this.getName();
        this.createServerRegion(vm0, 7, 1, 50, "./testGetFromHDFS", uniqueName, 50, false, true);
        this.createServerRegion(vm1, 7, 1, 50, "./testGetFromHDFS", uniqueName, 50, false, true);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 0, 40);
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 40, 50);
                RegionWithHDFSTestBase.this.doDestroys(uniqueName, 40, 50);
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 50, 100);
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 30, 40);
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 80, 90);
                RegionWithHDFSTestBase.this.doDestroys(uniqueName, 80, 90);
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 110, 200);
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 90, 110);
                return null;
            }
        });
        SerializableCallable checkData = new SerializableCallable(){

            public Object call() throws Exception {
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 0, 40, true);
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 40, 50, false);
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 50, 80, true);
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 80, 90, false);
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 90, 200, true);
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 200, 201, false);
                ArrayList<String> arrayl = new ArrayList<String>();
                for (int i = 0; i < 200; ++i) {
                    String k = "K" + i;
                    if (40 <= i && i < 50 || 80 <= i && i < 90) continue;
                    arrayl.add(k);
                }
                RegionWithHDFSTestBase.this.checkWithGetAll(uniqueName, arrayl);
                return null;
            }
        };
        vm1.invoke(checkData);
        this.closeCache(vm0);
        this.closeCache(vm1);
        AsyncInvocation async0 = this.createServerRegionAsync(vm0, 7, 1, 50, "./testGetFromHDFS", uniqueName, 50, false, true);
        AsyncInvocation async1 = this.createServerRegionAsync(vm1, 7, 1, 50, "./testGetFromHDFS", uniqueName, 50, false, true);
        async0.getResult();
        async1.getResult();
        vm1.invoke(checkData);
        this.dumpFiles(vm1, uniqueName);
    }

    public void testGetForAsyncQueue() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String uniqueName = this.getName();
        this.createServerRegion(vm0, 2, 5, 1, "./testGetForAsyncQueue", uniqueName, 10000);
        this.createServerRegion(vm1, 2, 5, 1, "./testGetForAsyncQueue", uniqueName, 10000);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 0, 4);
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 0, 2);
                RegionWithHDFSTestBase.this.doDestroys(uniqueName, 2, 3);
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 3, 7);
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 0, 2, true);
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 2, 3, false);
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 3, 7, true);
                return null;
            }
        });
    }

    public void testGetAllForAsyncQueue() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String uniqueName = this.getName();
        this.createServerRegion(vm0, 2, 5, 2, uniqueName, uniqueName, 10000);
        this.createServerRegion(vm1, 2, 5, 2, uniqueName, uniqueName, 10000);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 0, 4);
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RegionWithHDFSTestBase.this.doPuts(uniqueName, 1, 5);
                ArrayList<String> arrayl = new ArrayList<String>();
                for (int i = 0; i < 5; ++i) {
                    String k = "K" + i;
                    arrayl.add(k);
                }
                RegionWithHDFSTestBase.this.checkWithGetAll(uniqueName, arrayl);
                return null;
            }
        });
    }

    public void testPutAllForAsyncQueue() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String uniqueName = this.getName();
        this.createServerRegion(vm0, 2, 5, 2, "./testPutAllForAsyncQueue", uniqueName, 10000);
        this.createServerRegion(vm1, 2, 5, 2, "./testPutAllForAsyncQueue", uniqueName, 10000);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                HashMap<String, String> putAllmap = new HashMap<String, String>();
                for (int i = 0; i < 4; ++i) {
                    putAllmap.put("K" + i, "V" + i);
                }
                RegionWithHDFSTestBase.this.doPutAll(uniqueName, putAllmap);
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                HashMap<String, String> putAllmap = new HashMap<String, String>();
                for (int i = 1; i < 5; ++i) {
                    putAllmap.put("K" + i, "V" + i);
                }
                RegionWithHDFSTestBase.this.doPutAll(uniqueName, putAllmap);
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 0, 5, true);
                return null;
            }
        });
    }

    public void testPutAllAndGetFromHDFS() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String uniqueName = this.getName();
        this.createServerRegion(vm0, 7, 1, 500, "./testPutAllAndGetFromHDFS", uniqueName, 500);
        this.createServerRegion(vm1, 7, 1, 500, "./testPutAllAndGetFromHDFS", uniqueName, 500);
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                HashMap<String, String> putAllmap = new HashMap<String, String>();
                for (int i = 0; i < 500; ++i) {
                    putAllmap.put("K" + i, "V" + i);
                }
                RegionWithHDFSTestBase.this.doPutAll(uniqueName, putAllmap);
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                HashMap<String, String> putAllmap = new HashMap<String, String>();
                for (int i = 500; i < 1000; ++i) {
                    putAllmap.put("K" + i, "V" + i);
                }
                RegionWithHDFSTestBase.this.doPutAll(uniqueName, putAllmap);
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                int i;
                HashMap<String, String> putAllmap = new HashMap<String, String>();
                for (i = 1100; i < 2000; ++i) {
                    putAllmap.put("K" + i, "V" + i);
                }
                RegionWithHDFSTestBase.this.doPutAll(uniqueName, putAllmap);
                putAllmap = new HashMap();
                for (i = 900; i < 1100; ++i) {
                    putAllmap.put("K" + i, "V" + i);
                }
                RegionWithHDFSTestBase.this.doPutAll(uniqueName, putAllmap);
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 0, 2000, true);
                RegionWithHDFSTestBase.this.checkWithGet(uniqueName, 2000, 2001, false);
                ArrayList<String> arrayl = new ArrayList<String>();
                for (int i = 0; i < 2000; ++i) {
                    String k = "K" + i;
                    arrayl.add(k);
                }
                RegionWithHDFSTestBase.this.checkWithGetAll(uniqueName, arrayl);
                return null;
            }
        });
    }

    public void testWObasicClose() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String homeDir = "./testWObasicClose";
        String uniqueName = this.getName();
        this.createServerRegion(vm0, 11, 1, 500, homeDir, uniqueName, 500, true, false);
        this.createServerRegion(vm1, 11, 1, 500, homeDir, uniqueName, 500, true, false);
        this.createServerRegion(vm2, 11, 1, 500, homeDir, uniqueName, 500, true, false);
        this.createServerRegion(vm3, 11, 1, 500, homeDir, uniqueName, 500, true, false);
        AsyncInvocation a1 = this.doAsyncPuts(vm0, uniqueName, 1, 50, "vm0");
        AsyncInvocation a2 = this.doAsyncPuts(vm1, uniqueName, 40, 100, "vm1");
        AsyncInvocation a3 = this.doAsyncPuts(vm2, uniqueName, 40, 100, "vm2");
        AsyncInvocation a4 = this.doAsyncPuts(vm3, uniqueName, 90, 150, "vm3");
        a1.join();
        a2.join();
        a3.join();
        a4.join();
        Thread.sleep(5000L);
        this.cacheClose(vm0, false);
        this.cacheClose(vm1, false);
        this.cacheClose(vm2, false);
        this.cacheClose(vm3, false);
        AsyncInvocation async1 = this.createServerRegionAsync(vm0, 11, 1, 500, homeDir, uniqueName, 500, true, false);
        AsyncInvocation async2 = this.createServerRegionAsync(vm1, 11, 1, 500, homeDir, uniqueName, 500, true, false);
        AsyncInvocation async3 = this.createServerRegionAsync(vm2, 11, 1, 500, homeDir, uniqueName, 500, true, false);
        AsyncInvocation async4 = this.createServerRegionAsync(vm3, 11, 1, 500, homeDir, uniqueName, 500, true, false);
        async1.getResult();
        async2.getResult();
        async3.getResult();
        async4.getResult();
        this.verifyHDFSData(vm0, uniqueName);
        this.cacheClose(vm0, false);
        this.cacheClose(vm1, false);
        this.cacheClose(vm2, false);
        this.cacheClose(vm3, false);
    }

    protected void cacheClose(VM vm, final boolean sleep) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                if (sleep) {
                    Thread.sleep(2000L);
                }
                RegionWithHDFSTestBase.this.getCache().getLogger().info("Cache close in progress ");
                RegionWithHDFSTestBase.this.getCache().close();
                RegionWithHDFSTestBase.this.getCache().getLogger().info("Cache closed");
                return null;
            }
        });
    }

    protected void verifyInEntriesMap(HashMap<String, String> entriesMap, int start, int end, String suffix) {
        for (int i = start; i < end; ++i) {
            String k = "K" + i;
            String v = "V" + i + suffix;
            String s = entriesMap.get(v);
            RegionWithHDFSTestBase.assertTrue((String)("The expected key " + k + " didn't match the received value " + s + ". value: " + v), (boolean)k.equals(s));
        }
    }

    protected HashMap<String, HashMap<String, String>> createFilesAndEntriesMap(VM vm0, final String uniqueName, final String regionName) throws Exception {
        HashMap entriesToFileMap = (HashMap)vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                HashMap<String, HashMap<String, String>> entriesToFileMap = new HashMap<String, HashMap<String, String>>();
                HDFSStoreImpl hdfsStore = (HDFSStoreImpl)RegionWithHDFSTestBase.this.getCache().findHDFSStore(uniqueName);
                FileSystem fs = hdfsStore.getFileSystem();
                System.err.println("dumping file names in HDFS directory: " + hdfsStore.getHomeDir());
                try {
                    Path basePath = new Path(hdfsStore.getHomeDir());
                    Path regionPath = new Path(basePath, regionName);
                    RemoteIterator files = fs.listFiles(regionPath, true);
                    while (files.hasNext()) {
                        HashMap<String, String> entriesMap = new HashMap<String, String>();
                        LocatedFileStatus next = (LocatedFileStatus)files.next();
                        System.err.println(DUnitEnv.get().getPid() + " - " + next.getPath());
                        this.readSequenceFile(fs, next.getPath(), entriesMap);
                        entriesToFileMap.put(next.getPath().getName(), entriesMap);
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return entriesToFileMap;
            }

            public void readSequenceFile(FileSystem inputFS, Path sequenceFileName, HashMap<String, String> entriesMap) throws IOException {
                SequenceFileHoplog hoplog = new SequenceFileHoplog(inputFS, sequenceFileName, null);
                HoplogSetReader.HoplogIterator iter = hoplog.getReader().scan();
                try {
                    while (iter.hasNext()) {
                        iter.next();
                        UnsortedHoplogPersistedEvent te = UnsortedHoplogPersistedEvent.fromBytes((byte[])((byte[])iter.getValue()));
                        String stringkey = (String)CacheServerHelper.deserialize((byte[])((byte[])iter.getKey()));
                        String value = (String)te.getDeserializedValue();
                        entriesMap.put(value, stringkey);
                        if (!RegionWithHDFSTestBase.this.getCache().getLoggerI18n().fineEnabled()) continue;
                        RegionWithHDFSTestBase.this.getCache().getLoggerI18n().fine("Key: " + stringkey + " value: " + value + " path " + sequenceFileName.getName());
                    }
                }
                catch (Exception e) {
                    TestCase.assertTrue((String)e.toString(), (boolean)false);
                }
                iter.close();
                hoplog.close();
            }
        });
        return entriesToFileMap;
    }

    protected SerializableCallable validateEmpty(VM vm0, final int numEntries, final String uniqueName) {
        SerializableCallable validateEmpty = new SerializableCallable("validate"){

            public Object call() throws Exception {
                Region r = RegionWithHDFSTestBase.this.getRootRegion(uniqueName);
                TestCase.assertTrue((boolean)r.isEmpty());
                TestCase.assertFalse((boolean)r.entrySet().iterator().hasNext());
                for (int i = 0; i < numEntries; ++i) {
                    TestCase.assertEquals((String)("failure on key K" + i), null, (Object)r.get((Object)("K" + i)));
                }
                return null;
            }
        };
        vm0.invoke(validateEmpty);
        return validateEmpty;
    }

    protected void closeCache(VM vm0) {
        SerializableRunnable closeCache = new SerializableRunnable("close cache"){

            @Override
            public void run() {
                RegionWithHDFSTestBase.this.getCache().close();
                CacheTestCase.disconnectFromDS();
            }
        };
        vm0.invoke(closeCache);
    }

    protected void verifyDataInHDFS(VM vm0, final String uniqueName, final boolean shouldHaveData, boolean wait, final boolean waitForQueueToDrain, int numEntries) {
        vm0.invoke(new SerializableCallable("check for data in hdfs"){

            public Object call() throws Exception {
                HDFSRegionDirector director = HDFSRegionDirector.getInstance();
                final SortedOplogStatistics stats = director.getInstance().getHdfsRegionStats("/" + uniqueName);
                long end = System.nanoTime() + TimeUnit.SECONDS.toNanos(120L);
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return stats.getActiveFileCount() > 0L == shouldHaveData;
                    }

                    @Override
                    public String description() {
                        return "Waiting for active file count to be greater than 0: " + stats.getActiveFileCount() + " stats=" + System.identityHashCode(stats);
                    }
                }, 30000L, 100L, true);
                if (waitForQueueToDrain) {
                    PartitionedRegion region = (PartitionedRegion)RegionWithHDFSTestBase.this.getCache().getRegion(uniqueName);
                    final AsyncEventQueueStats queueStats = region.getHDFSEventQueueStats();
                    DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return queueStats.getEventQueueSize() <= 0;
                        }

                        @Override
                        public String description() {
                            return "Waiting for queue stats to reach 0: " + queueStats.getEventQueueSize();
                        }
                    }, 30000L, 100L, true);
                }
                return null;
            }
        });
    }

    protected void doPuts(VM vm0, final String uniqueName, final int numEntries) {
        vm0.invoke(new SerializableCallable("do puts"){

            public Object call() throws Exception {
                Region r = RegionWithHDFSTestBase.this.getRootRegion(uniqueName);
                for (int i = 0; i < numEntries; ++i) {
                    r.put((Object)("K" + i), (Object)("V" + i));
                }
                return null;
            }
        });
    }

    protected void validate(VM vm1, final String uniqueName, final int numEntries) {
        SerializableCallable validate = new SerializableCallable("validate"){

            public Object call() throws Exception {
                Region r = RegionWithHDFSTestBase.this.getRootRegion(uniqueName);
                for (int i = 0; i < numEntries; ++i) {
                    TestCase.assertEquals((String)("failure on key K" + i), (Object)("V" + i), (Object)r.get((Object)("K" + i)));
                }
                return null;
            }
        };
        vm1.invoke(validate);
    }

    protected void dumpFiles(VM vm0, final String uniqueName) {
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                FileSystem fs;
                HDFSStoreImpl hdfsStore = (HDFSStoreImpl)RegionWithHDFSTestBase.this.getCache().findHDFSStore(uniqueName);
                try {
                    fs = hdfsStore.getFileSystem();
                }
                catch (IOException e1) {
                    throw new HDFSIOException(e1.getMessage(), (Throwable)e1);
                }
                System.err.println("dumping file names in HDFS directory: " + hdfsStore.getHomeDir());
                try {
                    RemoteIterator files = fs.listFiles(new Path(hdfsStore.getHomeDir()), true);
                    while (files.hasNext()) {
                        LocatedFileStatus next = (LocatedFileStatus)files.next();
                        System.err.println(DUnitEnv.get().getPid() + " - " + next.getPath());
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

